/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.common;

import com.cisco.dcbu.lib.jnm.SnmpFcAddressId;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.mds.zm.ZoneMember;
import com.cisco.dcbu.lib.mds.zm.ZoneMemberFormat;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.DeviceAlias;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.EnforcedZoneMember;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.common.IvrDeviceAlias;
import java.util.ArrayList;

public class SmZoneMember
extends ZoneMember {
    private Vsan _vsan;
    public static final int DEV_TYPE_VALUE_HOST = 1;
    public static final int DEV_TYPE_VALUE_STORAGE = 2;
    public static final int DEV_TYPE_VALUE_BOTH = 3;
    public static final String[] DEVICE_TYPES = new String[]{"Host", "Storage", "Both"};

    public SmZoneMember(Vsan vsan, int vsanId, int index, int parType, int parentId, int format, byte[] id, byte[] lunId, int ivrFaIndex, int ivrVsanIndex) {
        super(vsanId, index, parType, parentId, format, id, lunId, ivrFaIndex, ivrVsanIndex, -1);
        this._vsan = vsan;
        this.displayName = SmZoneMember.getZoneMemberName(this._vsan, this.zoneVsanId, this.memFormat, this.memId, this.memLunId).toString();
    }

    public SmZoneMember(Vsan vsan, int vsanId, int index, int parType, int parentId, int format, byte[] id, byte[] lunId, int ivrFaIndex, int ivrVsanIndex, int devType) {
        super(vsanId, index, parType, parentId, format, id, lunId, ivrFaIndex, ivrVsanIndex, devType);
        this._vsan = vsan;
        this.displayName = SmZoneMember.getZoneMemberName(this._vsan, this.zoneVsanId, this.memFormat, this.memId, this.memLunId).toString();
    }

    public static boolean isMemberEndPort(EndPort port, ArrayList members, int memType) {
        for (int i = 0; i < members.size(); ++i) {
            SmZoneMember mem;
            if (!(members.get(i) instanceof SmZoneMember) || memType != (mem = (SmZoneMember)members.get(i)).getMemFormat() || mem.getEndPort() != port || mem.hasLun()) continue;
            return true;
        }
        return false;
    }

    public static boolean isMemberDeviceAlias(IvrDeviceAlias port, ArrayList members, int memType) {
        for (int i = 0; i < members.size(); ++i) {
            SmZoneMember mem;
            if (!(members.get(i) instanceof SmZoneMember) || memType != (mem = (SmZoneMember)members.get(i)).getMemFormat() || !mem.toString().equals(port.getDeviceAlias().getAlias())) continue;
            return true;
        }
        return false;
    }

    public ArrayList getAttachedEndPorts() {
        return EnforcedZoneMember.getAttachedEndPorts(this.memFormat, this.memId, this._vsan);
    }

    public String getFcid(EndPort endPort) {
        if (endPort == null && this.getMemFormat() == 10) {
            Fabric fa = ClientController.getInstance().getFabric();
            DeviceAlias da = EnforcedZoneMember.getDeviceAlias(this.getMemFormat(), this.getMemId(), fa);
            if (da != null) {
                EndPort epp = da.getEndPortFromCache();
                return epp != null && epp.isPresent() && (this.zoneVsanId == -1 || epp.isMemberOfVsan(this.zoneVsanId)) ? EnforcedZoneMember.getFcid(epp, ZoneMemberFormat.translateToSnmpFormat(this.memFormat, this.zoneVsanId), this.memId, this.zoneVsanId == -1 ? this.ivrVsanIndex : this.zoneVsanId) : null;
            }
            return null;
        }
        return EnforcedZoneMember.getFcid(endPort, ZoneMemberFormat.translateToSnmpFormat(this.memFormat, this.zoneVsanId), this.memId, this.zoneVsanId == -1 ? this.ivrVsanIndex : this.zoneVsanId);
    }

    public String getSwitchPort(EndPort endPort) {
        Vsan prtVsan;
        Vsan vsan = prtVsan = this._vsan == null ? this.getIvrVsan(endPort) : this._vsan;
        if (endPort == null && this.getMemFormat() == 10) {
            Fabric fa = ClientController.getInstance().getFabric();
            DeviceAlias da = EnforcedZoneMember.getDeviceAlias(this.getMemFormat(), this.getMemId(), fa);
            if (da != null) {
                EndPort epp = da.getEndPortFromCache();
                prtVsan = this._vsan == null ? this.getIvrVsan(epp) : this._vsan;
                return epp != null && epp.isPresent() ? EnforcedZoneMember.getSwitchPort(epp, this.memFormat, this.memId, this._vsan) : null;
            }
            return null;
        }
        return EnforcedZoneMember.getSwitchPort(endPort, this.memFormat, this.memId, prtVsan);
    }

    private Vsan getIvrVsan(EndPort endPort) {
        Vsan prtVsan = this._vsan;
        if (this._vsan == null && endPort != null && endPort.getSwitch() != null) {
            prtVsan = endPort.getSwitch().getVsan((short)this.ivrVsanIndex);
            if (prtVsan == null) {
                prtVsan = endPort.getFirstVsan();
            }
        } else if (this._vsan == null && endPort != null) {
            prtVsan = endPort.getFirstVsan();
        }
        return prtVsan;
    }

    public EndPort getEndPort() {
        if (this.memFormat != 4 && this.memFormat != 6 && this.memFormat != 7 && this.memFormat != 2) {
            if (this.memFormat == 8 && this.memId.length == 8 || this.memFormat == 9 && this.memId.length == 20) {
                return null;
            }
            EndPort ep = EnforcedZoneMember.getEndPort(ZoneMemberFormat.translateToSnmpFormat(this.memFormat, this.zoneVsanId), this.memId, this._vsan, this._vsan == null ? ClientController.getInstance().getFabric() : this._vsan.getFabric());
            return ep != null ? ep : null;
        }
        return null;
    }

    public DeviceAlias getDeviceAlias() {
        if (this.memFormat == 10) {
            return EnforcedZoneMember.getDeviceAlias(ZoneMemberFormat.translateToSnmpFormat(this.memFormat, this.zoneVsanId), this.memId, this._vsan == null ? ClientController.getInstance().getFabric() : this._vsan.getFabric());
        }
        return null;
    }

    public Wwn getPortWwn(EndPort ep) {
        if (ep == null && this.getMemFormat() == 10) {
            DeviceAlias da = EnforcedZoneMember.getDeviceAlias(this.getMemFormat(), this.getMemId(), ClientController.getInstance().getFabric());
            return da != null ? da.getPWwn() : null;
        }
        return EnforcedZoneMember.getPortWWN(ep, ZoneMemberFormat.translateToSnmpFormat(this.memFormat, this.zoneVsanId), this.memId);
    }

    public static StringBuffer getZoneMemberName(Vsan vsan, int vsanId, int format, byte[] id, byte[] lunId) {
        if (vsan == null && vsanId != -1) {
            vsan = ClientController.getInstance().getFabric().findVsanById(vsanId);
        }
        Fabric fa = vsan != null ? vsan.getFabric() : ClientController.getInstance().getFabric();
        StringBuffer sb = new StringBuffer();
        SnmpString memberId = new SnmpString(id);
        switch (format) {
            case 1: 
            case 11: {
                EndPort p;
                if (8 != id.length) {
                    sb.append(memberId);
                    return sb;
                }
                Wwn memWwn = new Wwn(memberId);
                EndPort endPort = p = vsan != null ? fa.findEndPortByWwnFromCache(new Wwn(memberId), vsan) : fa.findEndPortByWwn(memWwn, true);
                if (p != null) {
                    sb.append(p.getName());
                    break;
                }
                DeviceAlias da = fa.findDeviceAliasByWwn(memWwn);
                sb.append(da != null ? da.getAlias() : WwnDictionary.getWwnAlias(id));
                break;
            }
            case 3: 
            case 12: {
                EndPort p;
                EndPort endPort = p = fa != null ? fa.findEndPortByVsanFcId((int)vsan.getId(), id) : null;
                if (p != null) {
                    sb.append(p.getName());
                    break;
                }
                sb.append(SnmpFcAddressId.toHexString(id));
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                sb.append(EnforcedZoneMember.getSwitchPort(null, format, id, vsan));
                break;
            }
            case 5: {
                EndPort p;
                EndPort endPort = p = fa != null ? fa.findEndPortByIscsiName(memberId.toString()) : null;
                if (p != null) {
                    sb.append(p.getSymNodeName());
                    break;
                }
                sb.append(memberId.toString());
                break;
            }
            case 8: 
            case 9: {
                int prefix;
                byte[][] addMsk = EnforcedZoneMember.getIpAddressMask(id);
                byte[] address = addMsk[0];
                sb.append(SnmpIpAddress.toString(address));
                if (addMsk[1] == null) break;
                byte[] mask = addMsk[1];
                int n = prefix = address.length == 16 ? SnmpIntList.bytesToInt(mask, 0) : 0;
                sb.append(address.length == 16 ? (prefix < 128 ? "/" + Integer.toString(prefix) : "") : "/" + SnmpIpAddress.toString(mask));
                break;
            }
            case 10: {
                sb.append(memberId);
            }
        }
        if (null != lunId && lunId.length > 0) {
            sb.append(", LUN " + MibVariableFormat.ciscoExtScsiIntrDiscLunNumber(new SnmpString(lunId)));
        }
        return sb;
    }

    public String getLun() {
        if (this.memLunId == null || this.memLunId.length == 0) {
            return null;
        }
        long lunId = EnforcedZoneMember.convertLunToLong(this.memLunId);
        if (EnforcedZoneMember.isLunNumber(lunId)) {
            return Long.toHexString(EnforcedZoneMember.getLunNumber(lunId));
        }
        return SnmpString.toHexString(this.memLunId);
    }

    @Override
    public ZoneMember cloneMember(int index, int parenType, int parentId) {
        return new SmZoneMember(this._vsan, this.zoneVsanId, index, parenType, parentId, this.memFormat, this.memId, this.memLunId, this.afid, this.ivrVsanIndex, this.devType);
    }
}

