/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.merge;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.zm.Zone;
import com.cisco.dcbu.lib.ui.table.MultiRowTableModel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.model.EnforcedZoneMember;
import com.cisco.dcbu.sm.client.zm.common.SmZoneMember;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ZMergeTableModel
extends MultiRowTableModel {
    private boolean[] _editAttrs = new boolean[]{false, false, false, true, false, false};
    private static final String[] LABELS = new String[]{"Zone", "Type", "Members", "Action", "Type", "Members"};
    static final String DEFAULT_ZONE = "$default_zone$";
    public static final int SUCCESS = 0;
    public static final int ZONES_CONFLICT = 1;
    public static final int MEMBERS_CONFLICT = 2;
    public static final int ZONES_MEMBERS_CONFLICT = 3;
    public static final int READ_ONLY_CONFLICT = 4;
    public static final int ZONES_READ_ONLY_CONFLICT = 5;
    public static final int MEMBERS_READ_ONLY_CONFLICT = 6;
    public static final int ZONES_MEMBERS_READ_ONLY_CONFLICT = 7;
    private boolean _zonesDiffer = false;
    private boolean _membersDiffer = false;
    private boolean _readOnlyConflicts = false;
    private int _status = 0;

    public ZMergeTableModel() {
        this.setEditable(this._editAttrs);
    }

    public void setComparisonData(HashMap mapSrc, HashMap mapTarget) {
        this.setHeaders(LABELS);
        this._zonesDiffer = false;
        this._readOnlyConflicts = false;
        this._membersDiffer = false;
        this._status = 0;
        Array responseData = this.getCommon(mapSrc, mapTarget);
        if (this._zonesDiffer) {
            ++this._status;
        }
        if (this._membersDiffer) {
            this._status += 2;
        }
        if (this._readOnlyConflicts) {
            this._status += 4;
        }
        this.setData(responseData);
    }

    private Array getCommon(HashMap source, HashMap target) {
        Array<Object[]> r = new Array<Object[]>();
        Iterator itr = source.entrySet().iterator();
        block0: while (itr.hasNext()) {
            Map.Entry obEntry = itr.next();
            Zone z1 = (Zone)obEntry.getKey();
            String sourceZn = z1.toString();
            ArrayList membersS = (ArrayList)obEntry.getValue();
            Iterator itrT = target.entrySet().iterator();
            while (itrT.hasNext()) {
                Map.Entry obEntryT = itrT.next();
                Zone z2 = (Zone)obEntryT.getKey();
                String targetZn = z2.toString();
                if (sourceZn.equals(targetZn)) {
                    ArrayList mems;
                    ArrayList types;
                    boolean conflict = z1.isReadOnly() ^ z2.isReadOnly();
                    this._readOnlyConflicts = this._readOnlyConflicts || conflict;
                    ArrayList membersT = (ArrayList)obEntryT.getValue();
                    Iterator itrMs = membersS.iterator();
                    while (itrMs.hasNext()) {
                        int index = membersT.indexOf(itrMs.next());
                        if (index == -1) continue;
                        itrMs.remove();
                        membersT.remove(index);
                    }
                    boolean hasSrcDiff = true;
                    boolean hasTgtDiff = true;
                    if (membersT.size() == 0) {
                        itrT.remove();
                        hasTgtDiff = false;
                    }
                    if (membersS.size() == 0) {
                        itr.remove();
                        hasSrcDiff = false;
                    }
                    if (!hasSrcDiff && !hasTgtDiff) continue block0;
                    if (!this._membersDiffer) {
                        // empty if block
                    }
                    this._membersDiffer = true;
                    Object[] row = new Object[this._editAttrs.length + 1];
                    row[0] = z1;
                    if (hasSrcDiff) {
                        types = new ArrayList();
                        mems = new ArrayList();
                        this.updateMemberLists(types, mems, membersS);
                        row[1] = types;
                        row[2] = mems;
                    }
                    if (hasSrcDiff && hasTgtDiff) {
                        row[3] = "+";
                    } else if (hasSrcDiff) {
                        row[3] = "<";
                    } else if (hasTgtDiff) {
                        row[3] = ">";
                    }
                    if (hasTgtDiff) {
                        types = new ArrayList();
                        mems = new ArrayList();
                        this.updateMemberLists(types, mems, membersT);
                        row[4] = types;
                        row[5] = mems;
                    }
                    r.addElement(row);
                    continue block0;
                }
                if (!this._zonesDiffer) {
                    // empty if block
                }
                this._zonesDiffer = true;
            }
        }
        return r;
    }

    private void updateMemberLists(ArrayList listType, ArrayList listMembers, ArrayList membersS) {
        for (int i = 0; i < membersS.size(); ++i) {
            SmZoneMember mem = (SmZoneMember)membersS.get(i);
            listType.add(EnforcedZoneMember.getConType(mem.getMemFormat()));
            listMembers.add(mem);
        }
    }

    public boolean canMerge() {
        return this._status == 0 || this._status == 1;
    }

    public int getStatus() {
        return this._status;
    }

    @Override
    public Class getColumnClass(int row, int column) {
        Class klass = null;
        Class<String> string = String.class;
        Class<ArrayList> array = ArrayList.class;
        switch (column) {
            case 0: {
                klass = string;
                break;
            }
            case 1: {
                klass = array;
                break;
            }
            case 2: {
                klass = array;
                break;
            }
            case 3: {
                klass = string;
                break;
            }
            case 4: {
                klass = array;
                break;
            }
            case 5: {
                klass = array;
                break;
            }
            default: {
                klass = string;
            }
        }
        array = null;
        string = null;
        return klass;
    }

    public static void debugArray(String str, ArrayList list) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Object obj = list.get(i);
                DefaultLogger._DefLogger.debug((Object)(obj + " , "));
            }
        } else {
            DefaultLogger._DefLogger.debug((Object)"Array list is null");
        }
    }

    public static void debugHash(String str, HashMap map) {
        DefaultLogger._DefLogger.debug((Object)("Hash Map : " + str));
        if (map != null) {
            Object[] keys = map.keySet().toArray();
            for (int i = 0; i < keys.length; ++i) {
                Object key = keys[i];
                ArrayList list = (ArrayList)map.get(key);
                DefaultLogger._DefLogger.debug((Object)("[" + key + "]="));
                ZMergeTableModel.debugArray("", list);
                DefaultLogger._DefLogger.debug((Object)"");
            }
        } else {
            DefaultLogger._DefLogger.debug((Object)"Hash Map is null");
        }
    }
}

