/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.migrate.panels;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.script.AbstractWorker;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.sm.client.zm.migrate.panels.ZoneSetPanel;
import com.cisco.dcbu.sm.client.zm.migrate.transfer.Alias;
import com.cisco.dcbu.sm.client.zm.migrate.transfer.ReadOtherSwitch;
import com.cisco.dcbu.sm.client.zm.migrate.transfer.ZoneSet;
import com.cisco.dcbu.sm.client.zm.migrate.transfer.ZonesetList;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class TranslatePanel
extends WizardPanel {
    private String _workingDir = null;
    private JPanel _core = new JPanel();
    private BoxLayout _layout = new BoxLayout(this._core, 1);
    private ZonesetList _list = null;
    private ZoneSet[] _zoneSets = null;
    private ZoneSetPanel[] _zsp = null;
    private Alias[] _aliases = null;
    private String _desc = "Choose the new MDS fabric domain ids to be translated.";
    public static final ImageIcon ICON = Util.loadIcon("icons/zonemigrate.gif");
    private AbstractWorker worker = null;

    public TranslatePanel(String workingDir) {
        super("Step 2 of 5: Translate Port-Based Zones", "", ICON);
        super.setDescription(this._desc);
        this._workingDir = workingDir;
        this._core.setLayout(this._layout);
        this._core.setPreferredSize(new Dimension(500, 300));
        this.add((Component)this._core, "Center");
    }

    @Override
    public boolean refresh() {
        int i;
        ZonesetList l;
        this._list = l = (ZonesetList)this.getModelValue("LoginPanel.output");
        ArrayList mds = (ArrayList)this.getModelValue("LoginPanel.mds");
        this._core.removeAll();
        if (this._list == null || (this._zoneSets = this._list.getZonesetList()) == null || this._zoneSets.length == 0) {
            String msg = "\nThere are no domain-port based zones on this switch.\nPlease 'Next' to continue.\n";
            JTextArea text = new JTextArea(msg);
            text.setBackground(super.getBackground());
            text.setForeground(super.getForeground());
            this._core.removeAll();
            this._core.add(text);
            return true;
        }
        this._aliases = this._list.getAliasList();
        if (this._zoneSets.length > 0) {
            this._zsp = new ZoneSetPanel[this._zoneSets.length];
        }
        if (this._aliases != null && this._aliases.length > 0) {
            this._zsp = new ZoneSetPanel[this._aliases.length + this._zoneSets.length];
        }
        for (i = 0; i < this._zoneSets.length; ++i) {
            ZoneSet zoneSet = this._zoneSets[i];
            if (zoneSet == null) continue;
            this._zsp[i] = new ZoneSetPanel(true, mds);
            this._zsp[i].doInitialize(zoneSet);
            this._core.add(this._zsp[i]);
        }
        for (i = this._zoneSets.length; i < this._aliases.length + this._zoneSets.length; ++i) {
            Alias alias = this._aliases[i - this._zoneSets.length];
            if (alias == null) continue;
            this._zsp[i] = new ZoneSetPanel(true, mds);
            this._zsp[i].doInitialize(alias);
            this._core.add(this._zsp[i]);
        }
        return false;
    }

    @Override
    public void doNext() {
        final HashMap map = new HashMap();
        String temp = (String)this.getModelValue("LoginPanel.MigrateFrom");
        int type = -1;
        if (temp != null) {
            type = Integer.parseInt(temp);
        }
        this.setDataValid(false);
        final int which = type;
        this.worker = new AbstractWorker(){
            private boolean proceed = false;
            private String message = "";
            private JWizard wizard = TranslatePanel.this.getWizard();

            @Override
            public Object construct() {
                try {
                    this.wizard.setStatus("");
                    this.wizard.setCursor(Cursor.getPredefinedCursor(3));
                    this.wizard.getNavigator().getNextBtn().setEnabled(false);
                    this.wizard.getNavigator().getBackBtn().setEnabled(false);
                    if (TranslatePanel.this._zsp != null) {
                        for (int i = 0; i < TranslatePanel.this._zsp.length; ++i) {
                            if (TranslatePanel.this._zsp[i] == null) continue;
                            TranslatePanel.this._zsp[i].getZoneSetContext(map);
                        }
                    }
                    ReadOtherSwitch readConfiguration = (ReadOtherSwitch)TranslatePanel.this.getModelValue("LoginPanel.configuration");
                    readConfiguration.putDecodedInfo(TranslatePanel.this._list, which);
                    ZonesetList data = readConfiguration.getWWNUnDecoded(which);
                    TranslatePanel.this.setModelValue("TranslatePanel.output", data);
                    TranslatePanel.this.setModelValue("TranslatePanel.userSelectedDomains", map.keySet());
                    this.proceed = true;
                }
                catch (Exception ex) {
                    this.proceed = false;
                    this.message = ex.getMessage();
                    DefaultLogger._DefLogger.error((Object)ex.getMessage(), (Throwable)ex);
                }
                return null;
            }

            @Override
            public void finished() {
                this.wizard.getNavigator().getNextBtn().setEnabled(true);
                this.wizard.getNavigator().getBackBtn().setEnabled(true);
                this.wizard.setStatus(this.message);
                if (this.proceed) {
                    TranslatePanel.this.goNext();
                }
                this.wizard.setCursor(Cursor.getDefaultCursor());
            }
        };
        this.worker.start();
    }

    private void goNext() {
        super.doNext();
    }
}

