/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.migrate.panels;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.script.AbstractWorker;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.sm.client.zm.migrate.panels.ZoneSetPanel;
import com.cisco.dcbu.sm.client.zm.migrate.transfer.Alias;
import com.cisco.dcbu.sm.client.zm.migrate.transfer.ReadOtherSwitch;
import com.cisco.dcbu.sm.client.zm.migrate.transfer.ZoneSet;
import com.cisco.dcbu.sm.client.zm.migrate.transfer.ZonesetList;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class WWNPanel
extends WizardPanel {
    private JPanel _core = new JPanel();
    private BoxLayout _layout = new BoxLayout(this._core, 1);
    private ZonesetList _list = null;
    private Alias[] _aliases = null;
    private ZoneSet[] _zoneSets = null;
    private ZoneSetPanel[] _zsp = null;
    private String _desc = "Unable to resolve the types of following zone members. Please select the appropriate member type.";
    public static final ImageIcon ICON = Util.loadIcon("icons/zonemigrate.gif");
    private AbstractWorker worker = null;

    public WWNPanel(String workingDir) {
        super("Step 3 of 5: Resolve Zone Members", "", ICON);
        super.setDescription(this._desc);
        this._core.setLayout(this._layout);
        this._core.setPreferredSize(new Dimension(500, 300));
        this.add((Component)this._core, "Center");
    }

    @Override
    public boolean refresh() {
        Object zoneSet;
        int i;
        ZonesetList l;
        this._list = l = (ZonesetList)this.getModelValue("TranslatePanel.output");
        ArrayList mds = (ArrayList)this.getModelValue("LoginPanel.mds");
        if (this._list == null || (this._zoneSets = this._list.getZonesetList()) == null || this._zoneSets.length == 0) {
            String msg = "\nThe system has resolved all the zone member types.\nPlease click on \"Next\" button to continue.\n";
            JTextArea text = new JTextArea(msg);
            text.setBackground(super.getBackground());
            text.setForeground(super.getForeground());
            this._core.removeAll();
            this._core.add(text);
            return true;
        }
        this._aliases = this._list.getAliasList();
        this._zsp = this._aliases != null && this._aliases.length > 0 ? new ZoneSetPanel[this._zoneSets.length + this._aliases.length] : new ZoneSetPanel[this._zoneSets.length];
        this._core.removeAll();
        if (this._zoneSets != null) {
            for (i = 0; i < this._zoneSets.length; ++i) {
                zoneSet = this._zoneSets[i];
                this._zsp[i] = new ZoneSetPanel(false, mds);
                this._zsp[i].doInitialize((ZoneSet)zoneSet);
                this._core.add(this._zsp[i]);
            }
        }
        if (this._aliases != null) {
            for (i = this._zoneSets.length; i < this._zoneSets.length + this._aliases.length; ++i) {
                zoneSet = this._aliases[i - this._zoneSets.length];
                this._zsp[i] = new ZoneSetPanel(false, mds);
                this._zsp[i].doInitialize((Alias)zoneSet);
                this._core.add(this._zsp[i]);
            }
        }
        return false;
    }

    @Override
    public void doNext() {
        String temp = (String)this.getModelValue("LoginPanel.MigrateFrom");
        int type = -1;
        if (temp != null) {
            type = Integer.parseInt(temp);
        }
        final int which = type;
        this.worker = new AbstractWorker(){
            boolean proceed = false;
            String message = "";
            JWizard wizard = WWNPanel.this.getWizard();

            @Override
            public Object construct() {
                try {
                    this.wizard.setStatus("");
                    this.wizard.setCursor(Cursor.getPredefinedCursor(3));
                    this.wizard.getNavigator().getNextBtn().setEnabled(false);
                    this.wizard.getNavigator().getBackBtn().setEnabled(false);
                    if (WWNPanel.this._zsp != null) {
                        for (int i = 0; i < WWNPanel.this._zsp.length; ++i) {
                            if (WWNPanel.this._zsp[i] == null) continue;
                            WWNPanel.this._zsp[i].getZoneSetContext(null);
                        }
                    }
                    ReadOtherSwitch readConfiguration = (ReadOtherSwitch)WWNPanel.this.getModelValue("LoginPanel.configuration");
                    readConfiguration.putDecodedInfo(WWNPanel.this._list, which);
                    StringBuffer data = readConfiguration.getCLI(which);
                    WWNPanel.this.setModelValue("WWNPanel.output", data);
                    WWNPanel.this.setModelValue("Execute.Script", data.toString());
                    WWNPanel.this.setDataValid(false);
                    this.proceed = true;
                }
                catch (Exception ex) {
                    this.proceed = false;
                    this.message = ex.getMessage();
                    DefaultLogger._DefLogger.error((Object)ex.getMessage(), (Throwable)ex);
                }
                return null;
            }

            @Override
            public void finished() {
                this.wizard.setStatus(this.message);
                this.wizard.getNavigator().getNextBtn().setEnabled(true);
                this.wizard.getNavigator().getBackBtn().setEnabled(true);
                if (this.proceed) {
                    WWNPanel.this.goNext();
                }
                this.wizard.setCursor(Cursor.getDefaultCursor());
            }
        };
        this.worker.start();
    }

    private void goNext() {
        super.doNext();
    }
}

