/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.zoneconfig;

import com.cisco.dcbu.lib.mds.zm.CopyFullZoneAction;
import com.cisco.dcbu.lib.mds.zm.IvrZoneSwitch;
import com.cisco.dcbu.lib.mds.zm.PollerManager;
import com.cisco.dcbu.lib.mds.zm.StatusIf;
import com.cisco.dcbu.lib.mds.zm.VersionPeer;
import com.cisco.dcbu.lib.mds.zm.ZoneCommitAction;
import com.cisco.dcbu.lib.mds.zm.ZoneMode;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.common.SmIvrZoneSwitch;
import com.cisco.dcbu.sm.client.zm.common.SmZoneUtil;
import com.cisco.dcbu.sm.client.zm.zoneconfig.CopyDialogBase;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.InetAddress;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class CopyIvrZoneDialog
extends CopyDialogBase
implements ItemListener {
    private JComboBox _sourceSwitchCb;
    private JComboBox _destinationSwitchCb;

    public CopyIvrZoneDialog(JFrame parent) throws SnmpException {
        super(parent, null);
    }

    public CopyIvrZoneDialog(JDialog parent) throws SnmpException {
        super(parent, null);
    }

    @Override
    JLabel[] getNames() {
        return DialogUtil.buildLabels(new String[]{"Copy IVR Database:", "Source Switch:", "Destination Switch:"});
    }

    @Override
    JComponent[] getNameComps() {
        return new JComponent[]{this._select, this._sourceSwitchCb, this._destinationSwitchCb};
    }

    @Override
    void buildUI(JFrame parent, Vsan v) throws SnmpException {
        this.setTitle("Copy Full Zone Database" + ClientController.getInstance().getDialogFabricTitlePostfix());
        ArrayList znSw = SmIvrZoneSwitch.discoverSwitchProperties(ClientController.getInstance().getFabric());
        ArrayList ivrEnabledPeers = IvrZoneSwitch.getIvrPeers(znSw, true);
        if (ivrEnabledPeers.size() == 0) {
            throw new SnmpException("There are no IVR enabled switches in this fabric.");
        }
        VersionPeer[] arrayVerPeer = ivrEnabledPeers.toArray(new VersionPeer[0]);
        this._sourceSwitchCb = new JComboBox<SnmpPeer>(SmZoneUtil.getSnmpPeersFromVersionPeers(arrayVerPeer));
        this._destinationSwitchCb = new JComboBox<SnmpPeer>(SmZoneUtil.getSnmpPeersFromVersionPeers(arrayVerPeer));
        super.buildUI(parent, v);
    }

    void setDestinationPeer(SnmpPeer peer) {
        this._destinationSwitchCb.setSelectedItem(peer);
    }

    void updateSourcePeerAndAction(SnmpPeer peer, int action) {
        this._sourceSwitchCb.setSelectedItem(peer);
        super.upDateAction(action);
    }

    @Override
    void setDestinationControls() {
        this._sourceSwitchCb.setEnabled(this._select.getButton(1).isSelected());
        if (this._select.getButton(0).isSelected()) {
            this._sourceSwitchCb.setSelectedItem(this._destinationSwitchCb.getSelectedItem());
        }
    }

    @Override
    CopyDialogBase.CopyThread copyAction() throws SnmpException {
        if (JOptionPane.showOptionDialog(this, "The local full configuration will be overwritten.\nDo you want to continue?", this.getTitle(), 0, 2, null, new String[]{"Yes", "No"}, "No") != 0) {
            return null;
        }
        SnmpPeer destPeer = (SnmpPeer)this._destinationSwitchCb.getSelectedItem();
        ZoneMode destMode = this.getOperationMode(null, destPeer);
        if (destMode.isCommitPending()) {
            Switch sw = null;
            try {
                ClientController.getInstance();
                sw = ClientController.findFabricSwitchByIpAddress(InetAddress.getByAddress(destMode.getLockingSwitch()));
            }
            catch (Exception ex) {
                // empty catch block
            }
            Util.errorMessage((Component)this, "There are pending commits for IVR on switch " + (sw != null ? sw : destPeer) + ".");
            return null;
        }
        PollerManager[] manager = null;
        if (destMode.isEnhanced()) {
            Switch destSwitch = SmZoneUtil.getSwitch(destPeer);
            manager = new PollerManager[]{new PollerManager(this, SmZoneUtil.getSwitchPeer(destSwitch))};
            ZoneCommitAction.createAction(SmZoneUtil.buildVersionnPeer(destSwitch), -1, manager[0], this);
        }
        if (this._select.getSelected() == 1) {
            if (this._sourceSwitchCb.getSelectedItem().toString().equals(this._destinationSwitchCb.getSelectedItem().toString())) {
                Util.errorMessage((Component)this, "Cannot copy full zone database on same switch.\nPlease choose a different destination switch.");
                return null;
            }
            CopyDialogBase.CopyThread cpTh = new CopyDialogBase.CopyThread(this, new CopyFullZoneAction(null, (StatusIf)this, SmZoneUtil.buildVersionnPeer(SmZoneUtil.getSwitch((SnmpPeer)this._sourceSwitchCb.getSelectedItem())), SmZoneUtil.buildVersionnPeer(SmZoneUtil.getSwitch((SnmpPeer)this._destinationSwitchCb.getSelectedItem())), -1, -1));
            if (destMode.isEnhanced()) {
                cpTh.setCommitAction(manager[0]);
            }
            return cpTh;
        }
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.addVar(new SnmpOID(MibNode.get("civrZoneCopyZoneSetEnforcdToFull").getOid(), 0), new SnmpInt(1));
        ((SnmpPeer)this._destinationSwitchCb.getSelectedItem()).set(pdu);
        this._status.setText("Success");
        if (destMode.isEnhanced()) {
            CopyDialogBase.CopyThread cpTh = new CopyDialogBase.CopyThread(this, null);
            cpTh.setCommitAction(manager[0]);
            return cpTh;
        }
        return null;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1 && e.getSource() == this._sourceSwitchCb && this._select.getButton(0).isSelected()) {
            this._destinationSwitchCb.setSelectedItem(this._sourceSwitchCb.getSelectedItem());
        }
    }
}

