/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.zoneconfig;

import com.cisco.dcbu.lib.mds.zm.Zone;
import com.cisco.dcbu.lib.mds.zm.ZoneAlias;
import com.cisco.dcbu.lib.ui.table.MultiRowTableModel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.model.EnforcedZoneMember;
import com.cisco.dcbu.sm.client.zm.common.SmZoneMember;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class ZoneComparisonTableModel
extends MultiRowTableModel {
    static final String[] LABELS = new String[]{"Zone", "Type", "Action", "Members", "Switch Interface"};
    static final String[] IVR_LABELS = new String[]{"Zone", "Type", "VSAN ID", "Action", "Members", "Switch Interface"};
    private static final String ADD = "Add";
    private static final String REMOVE = "Remove";
    private boolean _isIvr;

    ZoneComparisonTableModel(boolean isIvr) {
        if (isIvr) {
            this.setHeaders(IVR_LABELS);
        } else {
            this.setHeaders(LABELS);
        }
        this._isIvr = isIvr;
    }

    void updateData(HashMap source, HashMap target) {
        Array responseData = new Array();
        this.addData(source, responseData, Boolean.TRUE);
        this.addData(target, responseData, Boolean.FALSE);
        this.setData(responseData);
    }

    private void addData(HashMap source, Array responseData, Boolean type) {
        for (Map.Entry obEntry : source.entrySet()) {
            Zone sourceZn = (Zone)obEntry.getKey();
            if (sourceZn.getZoneName().equals("$default_zone$")) continue;
            ArrayList membersS = (ArrayList)obEntry.getValue();
            Object[] o = new Object[this.getHeaders().length + 1];
            o[0] = sourceZn;
            ArrayList listType = new ArrayList();
            ArrayList listMembers = new ArrayList();
            ArrayList listVsan = new ArrayList();
            ArrayList listAction = new ArrayList();
            ArrayList listSwInterfaces = new ArrayList();
            this.updateMemberLists(listType, listMembers, listVsan, membersS, type, listAction, listSwInterfaces);
            o[1] = listType;
            if (this._isIvr) {
                o[2] = listVsan;
                o[3] = listAction;
                o[4] = listMembers;
                o[5] = listSwInterfaces;
            } else {
                o[2] = listAction;
                o[3] = listMembers;
                o[4] = listSwInterfaces;
            }
            responseData.addElement(o);
        }
    }

    private void updateMemberLists(ArrayList listType, ArrayList listMembers, ArrayList listVsan, ArrayList membersS, Boolean missing, ArrayList listAction, ArrayList listSwInterfaces) {
        for (int i = 0; i < membersS.size(); ++i) {
            Object memOb = membersS.get(i);
            if (memOb instanceof SmZoneMember) {
                SmZoneMember mem = (SmZoneMember)memOb;
                if (this._isIvr) {
                    listVsan.add(new Integer(mem.getIvrVsanIndex()));
                }
                listType.add(EnforcedZoneMember.getConType(mem.getMemFormat()));
                listMembers.add(mem);
                if (mem.getMemFormat() == 2 || mem.getMemFormat() == 7 || mem.getMemFormat() == 6 || mem.getMemFormat() == 4) {
                    listSwInterfaces.add("");
                } else {
                    String swPort = mem.getSwitchPort(mem.getEndPort());
                    listSwInterfaces.add(swPort == null ? "" : swPort);
                }
            } else if (memOb instanceof ZoneAlias) {
                listType.add("Alias");
                listMembers.add(memOb);
            } else {
                listMembers.add(memOb);
            }
            listAction.add(missing != false ? ADD : REMOVE);
        }
    }
}

