/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.zoneconfig;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.zm.AbstractZone;
import com.cisco.dcbu.lib.mds.zm.IvrZoneSwitch;
import com.cisco.dcbu.lib.mds.zm.MdsCommandHandler;
import com.cisco.dcbu.lib.mds.zm.StatusIf;
import com.cisco.dcbu.lib.mds.zm.VersionPeer;
import com.cisco.dcbu.lib.mds.zm.Zone;
import com.cisco.dcbu.lib.mds.zm.ZoneAlias;
import com.cisco.dcbu.lib.mds.zm.ZoneCapability;
import com.cisco.dcbu.lib.mds.zm.ZoneMode;
import com.cisco.dcbu.lib.mds.zm.ZoneSet;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.ToolBarSeparator;
import com.cisco.dcbu.lib.ui.UITransferHandler;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.ui.tree.DndTreeNode;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.map.actions.HighlightAction;
import com.cisco.dcbu.sm.client.map.actions.SelectionAction;
import com.cisco.dcbu.sm.client.map.actions.VsanHighlightAction;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.common.DeviceAliasTableModel;
import com.cisco.dcbu.sm.client.zm.common.DragTableModel;
import com.cisco.dcbu.sm.client.zm.common.EndPortsTableModel;
import com.cisco.dcbu.sm.client.zm.common.HostStorageRenderer;
import com.cisco.dcbu.sm.client.zm.common.SmZoneMember;
import com.cisco.dcbu.sm.client.zm.common.SmZoneUtil;
import com.cisco.dcbu.sm.client.zm.common.ZoneDragTable;
import com.cisco.dcbu.sm.client.zm.zoneconfig.AliasTableModel;
import com.cisco.dcbu.sm.client.zm.zoneconfig.AvailablePortsTable;
import com.cisco.dcbu.sm.client.zm.zoneconfig.CommitDialog;
import com.cisco.dcbu.sm.client.zm.zoneconfig.ZoneControls;
import com.cisco.dcbu.sm.client.zm.zoneconfig.ZoneDialogAction;
import com.cisco.dcbu.sm.client.zm.zoneconfig.ZoneMemberTable;
import com.cisco.dcbu.sm.client.zm.zoneconfig.ZoneMembersTableModel;
import com.cisco.dcbu.sm.client.zm.zoneconfig.ZoneSetTableModel;
import com.cisco.dcbu.sm.client.zm.zoneconfig.ZoneTableModel;
import com.cisco.dcbu.sm.client.zm.zoneconfig.ZoneTree;
import com.cisco.dcbu.sm.client.zm.zoneconfig.ZoneTreeCellRenderer;
import com.cisco.dcbu.sm.client.zm.zoneconfig.ZonesetTableCellRenderer;
import com.jidesoft.action.CommandBar;
import com.jidesoft.action.CommandMenuBar;
import com.jidesoft.action.DefaultDockableBarManager;
import com.jidesoft.action.DockableBar;
import com.jidesoft.action.DockableBarHolder;
import com.jidesoft.action.DockableBarManager;
import com.jidesoft.docking.DefaultDockingManager;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockableHolder;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.swing.ContentContainer;
import com.jidesoft.swing.LayoutPersistence;
import com.jidesoft.swing.LayoutPersistenceManager;
import com.jidesoft.tree.QuickTreeFilterField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ZoneDialog
extends JDialog
implements ActionListener,
ItemListener,
TreeSelectionListener,
ListSelectionListener,
StatusIf,
TableModelListener,
DockableHolder,
DockableBarHolder {
    private static final int SMALL = 12;
    static final int ZONESET_TABLE = 1;
    static final int ZONE_TABLE = 2;
    static final int ZONE_MEMBER_TABLE = 3;
    static final int ZONE_ALIAS_TABLE = 4;
    static final int END_PORT_TAB = 0;
    public static Dimension _preferredSize = new Dimension(1030, 550);
    Dimension leftPanelDim = new Dimension((int)_preferredSize.getWidth() / 4, (int)_preferredSize.getHeight() / 2);
    Dimension rightPanelDim = new Dimension((int)(_preferredSize.getWidth() / 4.0) * 3, (int)_preferredSize.getHeight() / 2);
    private static final String DEFAULT_PROFILE_KEY = "CISCO FM JIDE PROFILE";
    private String fileLocation = ClientCache.getDir() + File.separator + "ZONE_JIDE_PROFILE";
    private Vsan _vsan;
    private Integer _selRegion;
    private Switch _sw;
    private JPanel _dataView;
    private JComboBox _switchCb;
    private JComboBox _regionCb;
    private JComboBox _vsanCb;
    private JButton _zoneTableFilterBtn;
    private KTextField _zoneTableFilterFl;
    private JButton _endDevTableFilterBtn;
    private KTextField _endDevTableFilterFl;
    private JComboBox _endDevTableFilterCb;
    private HostStorageRenderer hostStrRenderer;
    private JPanel _radioPanel;
    private ZoneTreeCellRenderer _treeRend;
    private ArrayList selectedContextNode = new ArrayList();
    private JLabel _status;
    private ZoneTree _zonesetTree;
    private ZoneControls _controls;
    private ZoneDialogAction _zoneAction;
    private JLabel _tableHeading;
    private ZoneMemberTable _memberTable;
    private AvailablePortsTable _availablePortTable;
    AliasTableModel _availableAliasTableModel;
    private ZoneMembersTableModel _memberTableModel;
    private ZoneTableModel _zoneTableModel;
    private ZoneSetTableModel _zoneSetTableModel;
    private EndPortsTableModel _endPortsTableModel;
    private DeviceAliasTableModel _devAliasTableModel;
    private DndTreeNode _root;
    private JScrollPane _treeScroller = new JScrollPane();
    private DndTreeNode _zoneRoot;
    private ZoneTree _zoneTree;
    private JScrollPane _zoneTreeScroller = new JScrollPane();
    private JScrollPane _memberScroller = new JScrollPane();
    private JScrollPane _portScroller = new JScrollPane();
    private JFrame _parent;
    private JButton _AddToZoneOrAlias;
    private boolean _discoveringAll;
    private boolean _externallyDiscovered;
    private RadioButtonPanel _select;
    private JComboBox _filterCb;
    private JComboBox _treeSortCb;
    private LogDialog _logDialog;
    private Switch _lockingSwitch;
    private ArrayList modeList;
    private boolean dataLoaded = false;
    private DefaultDockingManager _dockingManager;
    private DockableBarManager _dockableBarManager;
    private JPanel _dockableArea;
    private JButton _treeOrderBtn;
    private LayoutPersistenceManager _layoutPersistence;
    private static final String[] FILTER_DEVICE_ENTRIES = new String[]{"All", "Unzoned Hosts", "Unzoned Targets", "Unzoned Devices", "All Hosts", "All Targets"};
    private static int ZONE_BY_DEV_ALIAS = 1;
    private static final String ADD_TO_ZONE = "Add to Zone";
    private static final String ADD_TO_ALIAS = "Add to Alias";
    private QuickTreeFilterField zoneSetTreeFilter = new QuickTreeFilterField();
    private QuickTreeFilterField zoneTreeFilter = new QuickTreeFilterField();

    private DockableFrame buildDockableFrame(Component cmp, String id, int docSide, int initIndex) {
        DockableFrame logicalDF = new DockableFrame(id, null);
        logicalDF.setInitMode(4);
        logicalDF.setInitSide(docSide);
        logicalDF.setInitIndex(initIndex);
        logicalDF.add(cmp);
        logicalDF.setDockable(false);
        logicalDF.setRearrangable(false);
        return logicalDF;
    }

    public void setRegionID(int regionID) {
        if (this._regionCb != null) {
            this._regionCb.setSelectedItem(regionID);
        }
        this._selRegion = regionID;
    }

    public ZoneDialog(JFrame parent, Vsan v, ArrayList ivrSwLst) throws SnmpException {
        super(parent);
        this._parent = parent;
        UITransferHandler dndTransferData = new UITransferHandler();
        this._vsan = v;
        this._zoneAction = new ZoneDialogAction(this, ivrSwLst, -1);
        this._controls = new ZoneControls(this._zoneAction, v == null);
        this._tableHeading = new JLabel("          ");
        this._tableHeading.setFont(new Font(ChangedCellRenderer.getNormalFont().getName(), 1, 12));
        CommandBar buttonPanel = this._controls.getButtonPanel();
        this._switchCb = this.buildComboBox("s");
        buttonPanel.add((Component)new ToolBarSeparator());
        if (this._vsan != null) {
            this._vsanCb = this.buildComboBox("v");
            buttonPanel.add((Component)new JLabel("VSAN:"));
            buttonPanel.add((Component)this._vsanCb);
        } else {
            this._regionCb = this.buildComboBox("e");
            if (this._regionCb.getPreferredSize().width < 60) {
                this._regionCb.setPreferredSize(new Dimension(60, this._regionCb.getHeight()));
            }
            this._regionCb.setRenderer(new RegionListCellRenderer());
            buttonPanel.add((Component)new JLabel(" Region ID:"));
            buttonPanel.add((Component)this._regionCb);
        }
        buttonPanel.add((Component)new JLabel(" Switch:"));
        buttonPanel.add((Component)this._switchCb);
        buttonPanel.add((Component)new ToolBarSeparator());
        this._root = new DndTreeNode(this._vsan, true, 0L);
        this._treeRend = new ZoneTreeCellRenderer(this._zoneAction);
        this._zonesetTree = new ZoneTree(this._root, this._zoneAction, dndTransferData, this._controls, this._treeRend);
        this._zoneRoot = new DndTreeNode(this._vsan, true, 0L);
        this._zoneTree = new ZoneTree(this._zoneRoot, this._zoneAction, dndTransferData, this._controls, this._treeRend);
        this.updateZoneUI();
        this._zonesetTree.getSelectionModel().addTreeSelectionListener(this);
        this._zoneTree.getSelectionModel().addTreeSelectionListener(this);
        JPanel pnlSort = new JPanel(new FlowLayout(0, 6, 3));
        this._treeOrderBtn = new JButton("", DndTreeNode.isAscendingCompareMode() ? HeaderListener.getUpImage() : HeaderListener.getDownImage());
        this._treeOrderBtn.setMargin(new Insets(4, 0, 4, 0));
        this._treeOrderBtn.setActionCommand("U");
        this._treeOrderBtn.addActionListener(this);
        this._treeSortCb = new JComboBox<String>(DndTreeNode.TREE_SORT_ENTRIES);
        this._treeSortCb.addActionListener(this);
        this._treeSortCb.setActionCommand("D");
        this._treeSortCb.setSelectedIndex(DndTreeNode.getCompareTypeIndex());
        pnlSort.add(DialogUtil.buildLabels(new String[]{"Sort:"})[0]);
        pnlSort.add(this._treeSortCb);
        pnlSort.add(this._treeOrderBtn);
        this.zoneSetTreeFilter = new QuickTreeFilterField(this._zonesetTree.getModel());
        this.zoneTreeFilter = new QuickTreeFilterField(this._zoneTree.getModel());
        this._zonesetTree.setModel((TreeModel)this.zoneSetTreeFilter.getDisplayTreeModel());
        this._zoneTree.setModel((TreeModel)this.zoneTreeFilter.getDisplayTreeModel());
        this.zoneSetTreeFilter.setHintText("Type here to filter Zonesets");
        this.zoneSetTreeFilter.setHideEmptyParentNode(true);
        this.zoneSetTreeFilter.isMatchesLeafNodeOnly();
        this.zoneSetTreeFilter.setTree((JTree)this._zonesetTree);
        this.zoneTreeFilter.setHintText("Type here to filter Zones/FC-Aliases");
        this.zoneTreeFilter.setHideEmptyParentNode(true);
        this.zoneTreeFilter.isMatchesLeafNodeOnly();
        this.zoneTreeFilter.setTree((JTree)this._zoneTree);
        this._treeScroller.setViewportView(this._zonesetTree);
        JPanel zoneSetPanel = new JPanel(new BorderLayout());
        JPanel zoneSetFilterPanel = new JPanel(new BorderLayout());
        zoneSetFilterPanel.add("North", pnlSort);
        zoneSetFilterPanel.add("South", (Component)this.zoneSetTreeFilter);
        zoneSetPanel.add("North", zoneSetFilterPanel);
        zoneSetPanel.add("Center", this._treeScroller);
        this._zoneTreeScroller.setViewportView(this._zoneTree);
        JPanel zonePanel = new JPanel(new BorderLayout());
        JPanel zoneFilterPanel = new JPanel(new BorderLayout());
        zoneFilterPanel.add("North", (Component)this.zoneTreeFilter);
        zonePanel.add("North", zoneFilterPanel);
        zonePanel.add("Center", this._zoneTreeScroller);
        this._dockableArea = new JPanel();
        this._dockingManager = new DefaultDockingManager((RootPaneContainer)this, (Container)this._dockableArea);
        this._dockingManager.setShowWorkspace(false);
        this._dockingManager.setShowTitleBar(false);
        this._dockingManager.setHidable(false);
        this._dockingManager.setFloatable(false);
        this._dockingManager.setAutohidable(false);
        DockableFrame znstTree = this.buildDockableFrame(zoneSetPanel, "Zonesets", 8, 0);
        znstTree.setPreferredSize(this.leftPanelDim);
        this._dockingManager.addFrame(znstTree);
        this._dockingManager.getFrame("Zonesets").setShowTitleBar(false);
        DockableFrame znTree = this.buildDockableFrame(zonePanel, "Zones/FcAliases", 8, 1);
        znTree.setPreferredSize(this.leftPanelDim);
        this._dockingManager.addFrame(znTree);
        this.buildTabbedPane(dndTransferData);
        this._zoneAction.setComponents(this._zonesetTree, this._zoneTree, this._memberTable);
        this._status = new JLabel(" ");
        this._status.setFont((Font)UIManager.getDefaults().get("Table.font"));
        this._status.setBorder(null);
        JPanel lowerPnl = DialogUtil.buildStatusPanel(this._controls.getActivationButtons(), this._status);
        this.setDefaultCloseOperation(2);
        ContentContainer dockableToolbarArea = new ContentContainer();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)dockableToolbarArea, "Center");
        this._dockableBarManager = new DefaultDockableBarManager((RootPaneContainer)this, (Container)dockableToolbarArea);
        this._dockableBarManager.setHidable(false);
        this._dockableBarManager.setFloatable(false);
        this._dockableBarManager.setShowContextMenu(false);
        this._dockableBarManager.getMainContainer().setLayout((LayoutManager)new BorderLayout());
        CommandMenuBar menuBar = this._controls.getZoneMenuBar();
        menuBar.setMenuBar(false);
        menuBar.setKey("ZMMenuBar");
        buttonPanel.add("East", (Component)this._tableHeading);
        this._dockableBarManager.addDockableBar((DockableBar)menuBar);
        buttonPanel.setMenuBar(false);
        buttonPanel.setKey("ZMButtonPanel");
        this._dockableBarManager.addDockableBar((DockableBar)buttonPanel);
        this._dockableBarManager.getMainContainer().add((Component)lowerPnl, (Object)"Last");
        this._dockableBarManager.getMainContainer().add((Component)this._dockableArea, (Object)"Center");
        this._layoutPersistence = new LayoutPersistenceManager();
        this._layoutPersistence.setProfileKey(DEFAULT_PROFILE_KEY);
        this._layoutPersistence.setUsePref(false);
        File fileLoc = new File(this.fileLocation);
        if (!fileLoc.exists()) {
            fileLoc.mkdirs();
            this._zonesetTree.setPreferredSize(new Dimension(this._zonesetTree.getPreferredSize().width, 150));
        }
        this._layoutPersistence.setLayoutDirectory(this.fileLocation);
        this._layoutPersistence.addLayoutPersistence((LayoutPersistence)this._dockableBarManager);
        this._layoutPersistence.addLayoutPersistence((LayoutPersistence)this._dockingManager);
        this.setLocationRelativeTo(this._parent);
        this._zonesetTree.registerKeyboardAction(this, "i", KeyStroke.getKeyStroke(155, 0), 0);
        this._zonesetTree.registerKeyboardAction(this, "d", KeyStroke.getKeyStroke(127, 0), 0);
        this._zoneTree.registerKeyboardAction(this, "i", KeyStroke.getKeyStroke(155, 0), 0);
        this._zoneTree.registerKeyboardAction(this, "d", KeyStroke.getKeyStroke(127, 0), 0);
        this._memberTable.registerKeyboardAction(this, "d", KeyStroke.getKeyStroke(68, 0), 0);
        this._memberTable.registerKeyboardAction(this, "R", KeyStroke.getKeyStroke(82, 0), 0);
        this._memberTable.registerKeyboardAction(this, "L", KeyStroke.getKeyStroke(76, 0), 0);
        this._controls.updateDiscard();
        this.setResizable(true);
        this.setLocationRelativeTo(parent);
        this.setPreferredSize(new Dimension(180, 350));
        this.setSize(new Dimension(380, 350));
    }

    public LayoutPersistence getLayoutPersistence() {
        return this._layoutPersistence;
    }

    public void saveJIDELayout() {
        this.getLayoutPersistence().saveLayoutData();
    }

    public void loadJIDELayout() {
        this.getLayoutPersistence().loadLayoutData();
    }

    public void reloadJIDELayout() {
        this.getLayoutPersistence().loadLayoutData();
    }

    private JComboBox buildComboBox(String command) {
        JComboBox cb = new JComboBox();
        cb.setActionCommand(command);
        cb.addActionListener(this);
        return cb;
    }

    private void updateIVRRegionComboBox() throws SnmpException {
        Object[] regions = null;
        if (this._vsan == null) {
            regions = IvrZoneSwitch.getIvrRegions(this._zoneAction.getAllIvrSwitchesInfo());
            if (regions == null || regions.length == 0) {
                regions = new Integer[]{0};
            }
            Arrays.sort(regions);
            this._regionCb.setModel(new DefaultComboBoxModel<Object>(regions));
            if (this._selRegion != null) {
                this._regionCb.setSelectedItem(this._selRegion);
            }
            if (this._zoneAction != null) {
                this._zoneAction.setIvrRegionID((Integer)this._regionCb.getSelectedItem());
            }
        }
    }

    private void updateSwitchComboBox() throws SnmpException {
        Object[] peers = null;
        if (this._vsan != null) {
            peers = this._vsan.getSnmpPeers(true, true, true);
        } else {
            Integer selRegion = this._regionCb.getSelectedItem() != null ? (Integer)this._regionCb.getSelectedItem() : null;
            ArrayList ivrEnabledPeers = VersionPeer.getSnmpPeersFromVerPeers(IvrZoneSwitch.getIvrPeers(this._zoneAction.getIvrSwitchesInfo(selRegion != null ? selRegion : -1), true));
            peers = ivrEnabledPeers.toArray(new SnmpPeer[ivrEnabledPeers.size()]);
        }
        if (peers == null || peers.length == 0) {
            if (this._switchCb.getModel().getSize() > 0) {
                this._switchCb.setModel(new DefaultComboBoxModel());
            }
            throw new SnmpException(this._vsan == null ? "No IVR enabled switches are available." : "No manageble switches are available");
        }
        Arrays.sort(peers);
        this._switchCb.setModel(new DefaultComboBoxModel<Object>(peers));
        this._switchCb.setPreferredSize(new Dimension(this._switchCb.getPreferredSize().width + 10, this._switchCb.getPreferredSize().height));
    }

    private void updateVsanComboBox() throws SnmpException {
        if (this._vsan != null) {
            Object[] vsans = this._vsan.getFabric().getVsans();
            Arrays.sort(vsans);
            this._vsanCb.setModel(new DefaultComboBoxModel<Object>(vsans));
            this._vsanCb.setSelectedItem(this._vsan);
        }
    }

    private byte[] findPendingConfigSwitch() {
        int peerNum = ((DefaultComboBoxModel)this._switchCb.getModel()).getSize();
        DefaultComboBoxModel model = (DefaultComboBoxModel)this._switchCb.getModel();
        ArrayList<SnmpPeer> peersList = new ArrayList<SnmpPeer>();
        SnmpPeer[] peers = null;
        for (int k = 0; k < peerNum; ++k) {
            SnmpPeer thePeer = (SnmpPeer)model.getElementAt(k);
            ClientController.getInstance();
            Switch swPr = ClientController.findFabricSwitchByIpAddress(thePeer.getAddress());
            if (swPr == null || !swPr.isMDS()) continue;
            peersList.add(thePeer);
        }
        if (peersList.size() > 0) {
            peers = peersList.toArray(new SnmpPeer[0]);
        }
        byte[] lockingSwitch = null;
        if (peers == null) {
            return lockingSwitch;
        }
        try {
            this.modeList = MdsCommandHandler.getZoneModeInfo(peers, this._vsan != null ? (int)this._vsan.getId() : -1);
            for (int k = 0; k < this.modeList.size(); ++k) {
                ZoneMode theMode;
                Object[] modeData = (Object[])this.modeList.get(k);
                if (modeData[1] == null || !(theMode = (ZoneMode)modeData[1]).isCommitPending()) continue;
                if (this._vsan != null) {
                    lockingSwitch = ((InetAddress)modeData[0]).getAddress();
                    if (!NetUtil.isLocalHost(theMode.getOwner())) continue;
                } else {
                    if (theMode.getLockingSwitch() == null || theMode.getLockingSwitch().length <= 0) continue;
                    lockingSwitch = theMode.getLockingSwitch();
                }
                break;
            }
        }
        catch (SnmpException ex) {
            // empty catch block
        }
        return lockingSwitch;
    }

    private void setSeedSwitch() {
        byte[] lockingSwitch;
        if (this._sw == null || this._sw.getPeer() == null || ((DefaultComboBoxModel)this._switchCb.getModel()).getIndexOf(this._sw.getPeer()) == -1) {
            lockingSwitch = this.findPendingConfigSwitch();
            this._lockingSwitch = null;
            if (lockingSwitch != null) {
                try {
                    ClientController.getInstance();
                    this._sw = this._lockingSwitch = ClientController.findFabricSwitchByIpAddress(InetAddress.getByAddress(lockingSwitch));
                }
                catch (UnknownHostException uhEx) {}
            } else if (this._vsan != null) {
                SnmpPeer ivrLstWWNPeer = this._vsan.getIVREnabledSwitchPeerWtLowestWWN();
                if (ivrLstWWNPeer != null) {
                    ClientController.getInstance();
                    this._sw = ClientController.findFabricSwitchByIpAddress(ivrLstWWNPeer.getAddress());
                }
                if (this._sw == null) {
                    this._sw = this._vsan.getPrincipalSwitch() != null && this._vsan.getPrincipalSwitch().isMDS() && this._vsan.getPrincipalSwitch().isManageable() ? this._vsan.getPrincipalSwitch() : (this._vsan.getSeedSwitch() != null && this._vsan.getSeedSwitch().isMDS() && this._vsan.getSeedSwitch().isManageable() ? this._vsan.getSeedSwitch() : null);
                }
            } else {
                Integer regionSel = (Integer)this._regionCb.getSelectedItem();
                this._sw = this._selRegion == null ? ClientController.getInstance().getFabric().getIvrSeedSwitch() : ClientController.getInstance().getFabric().getIvrSeedSwitch(regionSel);
            }
        } else {
            lockingSwitch = this.findPendingConfigSwitch();
            this._lockingSwitch = null;
            if (lockingSwitch != null && lockingSwitch.length != 0) {
                try {
                    ClientController.getInstance();
                    this._lockingSwitch = ClientController.findFabricSwitchByIpAddress(InetAddress.getByAddress(lockingSwitch));
                }
                catch (UnknownHostException uhEx) {
                    // empty catch block
                }
            }
        }
        if (this._sw != null && this._sw.getPeer() != null) {
            Comparable<SnmpPeer> tempSw = null;
            for (int it = 0; it < this._switchCb.getModel().getSize(); ++it) {
                if (!this._sw.getPeer().equals(this._switchCb.getItemAt(it))) continue;
                tempSw = this._sw;
            }
            tempSw = tempSw == null ? this._switchCb.getItemAt(0) : this._sw.getPeer();
            this._switchCb.setSelectedItem(tempSw);
        } else {
            this._sw = ClientController.getInstance().getFabric().findSwitchByIpAddress(((SnmpPeer)this._switchCb.getSelectedItem()).getAddress());
        }
    }

    private void updateZoneUI() throws SnmpException {
        this.updateVsanComboBox();
        this.updateIVRRegionComboBox();
        this.updateSwitchComboBox();
        this.setSeedSwitch();
        if (this._vsan == null) {
            this._root.setUserObject("Inter VSAN Zones");
            this._zoneRoot.setUserObject("Inter VSAN Zones");
        } else {
            this._root.setUserObject(this._vsan);
            this._zoneRoot.setUserObject(this._vsan);
        }
    }

    @Override
    public void dispose() {
        if (this.isVisible()) {
            this._zoneAction.closeAction();
        } else {
            super.dispose();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        char cmd = e.getActionCommand().charAt(0);
        try {
            switch (cmd) {
                case 's': {
                    Object swComboSelection = this._switchCb.getSelectedItem();
                    if (swComboSelection == this._sw.getPeer()) break;
                    this._sw = ClientController.getInstance().getFabric().findSwitchByIpAddress(((SnmpPeer)swComboSelection).getAddress());
                    if (this._vsan == null) {
                        this._root.setUserObject("Inter VSAN Zones ");
                        this._zoneRoot.setUserObject("Inter VSAN Zones ");
                    }
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    new Thread(new refreshData(this)).start();
                    break;
                }
                case 'v': {
                    Object vsanComboSelection = this._vsanCb.getSelectedItem();
                    if (this._vsan.equals(vsanComboSelection)) break;
                    this._vsan = (Vsan)vsanComboSelection;
                    this._sw = null;
                    this.updateZoneUI();
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    new Thread(new refreshData(this)).start();
                    break;
                }
                case 'e': {
                    Integer regionSel = (Integer)this._regionCb.getSelectedItem();
                    if (this._selRegion != null && this._selRegion.equals(regionSel)) break;
                    this._selRegion = regionSel;
                    this._sw = null;
                    this.updateZoneUI();
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    new Thread(new refreshData(this)).start();
                    break;
                }
                case 'd': 
                case 'i': {
                    this._controls.handleKeyCode(cmd);
                    break;
                }
                case 'F': {
                    this.filterEndDevices(true);
                    break;
                }
                case 'A': {
                    int[] rows = this._availablePortTable.getSelectedRows();
                    if (rows == null || rows.length == 0) {
                        Util.errorMessage((Component)this, "Please select an End Device to add.");
                        return;
                    }
                    Object[] ob = new Object[rows.length];
                    DragTableModel model = (DragTableModel)this._availablePortTable.getModel();
                    for (int i = 0; i < rows.length; ++i) {
                        ob[i] = model.getDragObject(rows[i]);
                    }
                    long timeStamp = 0L;
                    if (this._memberTable.getParentZone() instanceof AbstractZone) {
                        timeStamp = ((AbstractZone)this._memberTable.getParentZone()).getLastModifiedAsLong();
                    }
                    this._zoneAction.insertMembers(new DndTreeNode(this._memberTable.getParentZone(), false, false, timeStamp), ob, true);
                    this._zoneAction.showTreeNodeMembers(this._memberTable.getParentZone());
                    break;
                }
                case 'L': 
                case 'l': {
                    DragTableModel demodel = (DragTableModel)this._memberTable.getModel();
                    int detailsRows = demodel.getRowCount();
                    int detailsCol = this._memberTable.getDetailsSupportedColumn();
                    char curMode = this._memberTable.getDetailsMode(0);
                    for (int i = 0; i < detailsRows; ++i) {
                        this._memberTable.showDetails(i, detailsCol, curMode);
                    }
                    this._memberTable.calcRowColSize();
                    break;
                }
                case 'R': 
                case 'r': {
                    int selRow = this._memberTable.getSelectedRow();
                    if (selRow < 0) break;
                    this._memberTable.showDetails(selRow, this._memberTable.getDetailsSupportedColumn(), this._memberTable.getDetailsMode(selRow));
                    this._memberTable.calcRowColSize();
                    break;
                }
                case 'G': {
                    String filtrFld = this._zoneTableFilterFl.getText().trim();
                    this._zoneAction.showTreeNodeMembers(this._memberTable.getParentZone(), filtrFld);
                    ((DragTableModel)this._memberTable.getModel()).setFilter(null);
                    break;
                }
                case 'O': {
                    String epfiltrFld = this._endDevTableFilterFl.getText().trim();
                    if (this._select.getSelected() == ZONE_BY_DEV_ALIAS) {
                        this.updateDeviceAliasTableModel(epfiltrFld, this._endDevTableFilterCb.getSelectedIndex() + 1);
                    } else {
                        this.updateEndPortsTableModel(epfiltrFld, this._endDevTableFilterCb.getSelectedIndex() + 2);
                    }
                    this._availablePortTable.setModel(this._select.getSelected() == ZONE_BY_DEV_ALIAS ? this._devAliasTableModel : this._endPortsTableModel);
                    this._availablePortTable.calcPreferredSize();
                    break;
                }
                case 'D': 
                case 'U': {
                    if (!this.isVisible()) break;
                    if (cmd == 'U') {
                        this._treeOrderBtn.setIcon(this._treeOrderBtn.getIcon() == HeaderListener.getUpImage() ? HeaderListener.getDownImage() : HeaderListener.getUpImage());
                    }
                    DndTreeNode.setCompareMode(this._treeSortCb.getSelectedItem(), this._treeOrderBtn.getIcon() == HeaderListener.getUpImage());
                    this._zonesetTree.resortChildNode((DndTreeNode)this._zonesetTree.getRootNode().getChildAt(0));
                    this._zoneTree.resortChildNode((DndTreeNode)this._zoneTree.getRootNode().getChildAt(0));
                    if (this._vsan == null) break;
                    this._zoneTree.resortChildNode((DndTreeNode)this._zoneTree.getRootNode().getChildAt(1));
                }
            }
        }
        catch (SnmpException ex) {
            if (SnmpSession.isTrace()) {
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            Util.errorMessage((Component)this, ex.getMessage());
        }
    }

    public void resetPatterFilter() {
        this._zoneTableFilterFl.setText("");
    }

    void updateCommit() {
        this._controls.updateCommitButton();
        this._controls.updateDiscard();
    }

    private Object[] refresh() throws SnmpException {
        this._zoneAction.setVsanSwitch(this._sw, this._vsan);
        this._controls.enableApply(false);
        Object[] data = this._zoneAction.update();
        this._status.setText("Zone Discovery Finished");
        this._controls.updateEnhancedMode();
        this.updateCommit();
        this._zoneTableModel.setZoneCapability(this._zoneAction.getZoneCapability());
        this._memberTableModel.setZoneCapability(this._zoneAction.getZoneCapability());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ZoneDialog.this._select.setSelected(0);
                ZoneDialog.this._filterCb.setSelectedIndex(0);
                if (ZoneDialog.this._radioPanel != null) {
                    ZoneDialog.this._radioPanel.setVisible(ZoneDialog.this._zoneAction.isEnhancedDeviceAliaseEnabled());
                }
                ZoneDialog.this.setTitle((ZoneDialog.this._vsan != null ? "Edit Local Full Zone Database" : "Edit IVR Local Full Zone Database") + (ZoneDialog.this._zoneAction.isEnhanced() ? " (Enhanced Mode)" : "") + (ZoneDialog.this._zoneAction.isCommitRequired() ? "Locked" : "") + ClientController.getInstance().getDialogFabricTitlePostfix());
                ZoneDialog.this.updateAvailableData();
                ZoneDialog.this._zoneSetTableModel.setEditMode(false);
                ZoneDialog.this._availableAliasTableModel.setEditMode(false);
                ZoneDialog.this._controls.updateDiscard();
                ZoneDialog.this.selectedContextNode.clear();
                if (ZoneDialog.this.isVisible()) {
                    ZoneDialog.this.getDockingManager().loadLayoutData();
                    ZoneDialog.this.loadJIDELayout();
                }
                if (ZoneDialog.this._zoneAction.isCommitRequired() && ZoneDialog.this._lockingSwitch != null) {
                    if (ZoneDialog.this._vsan != null) {
                        String lockOwner = ZoneDialog.this._zoneAction.getLockOwner();
                        int ownerType = ZoneDialog.this._zoneAction.getLockOwnerType();
                        if (ownerType == 5 && lockOwner != null && lockOwner.equals(ZoneDialog.this._lockingSwitch.getPeer().getUserName())) {
                            return;
                        }
                    }
                    String userTypeName = ZoneDialog.this._vsan != null ? ZoneMode.getSnmpUserTypeName(ZoneDialog.this._zoneAction.getLockOwnerType()) : null;
                    String messege = "The Fabric is locked by " + (userTypeName != null ? userTypeName + ":" : "") + ZoneDialog.this._zoneAction.getLockOwner() + (ZoneDialog.this._lockingSwitch != null ? " at " + ZoneDialog.this._lockingSwitch : "");
                    JOptionPane.showMessageDialog(ZoneDialog.this._zoneAction.getDialog(), messege, "Locked Fabric" + ClientController.getInstance().getDialogFabricTitlePostfix(), 2);
                }
            }
        });
        return data;
    }

    public Object[] refreshAll() throws SnmpException {
        this.updateSwitchComboBox();
        this.setSeedSwitch();
        Object[] data = this.refresh();
        return data;
    }

    void updateEndPortsTableModel(String filterStr, int filterType) {
        if (this._endPortsTableModel != null) {
            this._endPortsTableModel.setFilter(ZoneDialogAction.replaceStarWDotStarIgnoreCase(filterStr));
            this._endPortsTableModel.setFilterType(filterType);
            this._endPortsTableModel.setVsan(this._vsan);
            this._endPortsTableModel.setShowAfid(this._zoneAction.getZoneCapability().isNatAutoTopoAfidSupported());
            this._endPortsTableModel.updateModelData(this._zoneAction.getAfidMap());
            this._endPortsTableModel.fireTableDataChanged();
        }
    }

    void updateDeviceAliasTableModel(String filterStr, int filterType) {
        if (this._devAliasTableModel != null) {
            this._devAliasTableModel.setFilter(ZoneDialogAction.replaceStarWDotStarIgnoreCase(filterStr));
            this._devAliasTableModel.setFilterType(filterType);
            this._devAliasTableModel.updateData(ClientController.getInstance().getFabric().getDeviceAliases(), this._vsan);
            this._devAliasTableModel.fireTableDataChanged();
        }
    }

    void updateAvailableData() {
        this._endDevTableFilterFl.setText("    ");
        this.updateEndPortsTableModel(null, -1);
        this.updateDeviceAliasTableModel(null, -1);
        this._availablePortTable.setModel(this._select.getSelected() == ZONE_BY_DEV_ALIAS ? this._devAliasTableModel : this._endPortsTableModel);
        this._availablePortTable.calcPreferredSize();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        ZoneTree deselTree;
        ZoneTree selTree;
        ZoneTree zoneTree = e.getSource() == this._zonesetTree.getSelectionModel() ? this._zonesetTree : (selTree = e.getSource() == this._zoneTree.getSelectionModel() ? this._zoneTree : null);
        ZoneTree zoneTree2 = e.getSource() == this._zonesetTree.getSelectionModel() ? this._zoneTree : (deselTree = e.getSource() == this._zoneTree.getSelectionModel() ? this._zonesetTree : null);
        if (selTree != null) {
            TreePath[] paths = selTree.getSelectionPaths();
            if (paths != null && paths.length > 0) {
                for (int kk = 0; kk < this.selectedContextNode.size(); ++kk) {
                    DndTreeNode ndTree = (DndTreeNode)this.selectedContextNode.get(kk);
                    ndTree.setNodeSelectedInContext(false);
                }
                this.selectedContextNode.clear();
                this._memberTable.getSelectionModel().clearSelection();
                this._availablePortTable.getSelectionModel().clearSelection();
                selTree.repaint();
            }
            if (deselTree != null && e.getNewLeadSelectionPath() != null) {
                deselTree.setSelectionPath(null);
                deselTree.repaint();
            }
            if (e.getNewLeadSelectionPath() != null) {
                this.setTreeContextControls(paths);
            }
        }
    }

    private void setTreeContextControls(TreePath[] paths) {
        Object[] data = null;
        Object[] parent = null;
        if (paths != null) {
            if (paths.length == 1) {
                this.buildTableHeading(paths[0]);
            }
            data = new Object[paths.length];
            parent = new Object[paths.length];
            for (int k = 0; k < paths.length; ++k) {
                DndTreeNode nd = (DndTreeNode)paths[k].getLastPathComponent();
                data[k] = nd.getUserObject();
                parent[k] = ((DndTreeNode)nd.getParent()).getUserObject();
            }
        }
        try {
            this.setControls(data, parent);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private void setControls(Object[] data, Object[] parent) {
        Object parentObject;
        this._controls.enableCompareZoneSet(false);
        this._controls.enableRenameZone(false);
        this._controls.enableRefresh(true);
        if (data == null) {
            this._controls.enableControls(false, false, false, false, false, false, false, false, this._zoneAction.getZoneCapability() == null ? false : this._zoneAction.getZoneCapability().isDistributeSupported(), false);
            return;
        }
        if (data.length > 1) {
            this._controls.enableControls(false, true, true, false, false, false, false, false, this._zoneAction.getZoneCapability().isDistributeSupported(), false);
            return;
        }
        Object userObject = data[0];
        Object object = parentObject = parent != null && parent.length >= 1 ? parent[0] : null;
        if (userObject instanceof AbstractZone) {
            AbstractZone az = (AbstractZone)userObject;
            this._controls.enableRenameZone(az.isZone() || !az.isZoneMember() && this._zoneAction.getZoneCapability().isZoneRenameupported());
            if (az.isZone() || az.isAlias()) {
                boolean canClone = true;
                if (parentObject != null && parentObject instanceof AbstractZone) {
                    canClone = false;
                }
                this._controls.enableControls(true, true, false, canClone, this._zoneAction.getZoneCapability().isSwitchPortWWNSupported(), this._zoneAction.isEnhancedDeviceAliaseEnabled(), false, false, this._zoneAction.getZoneCapability().isDistributeSupported(), false);
                this._AddToZoneOrAlias.setText(az.isAlias() ? ADD_TO_ALIAS : ADD_TO_ZONE);
            } else if (az.isZoneset()) {
                boolean isActive = this._zoneAction.getActiveZoneSet() != null && this._zoneAction.getActiveZoneSet().getZoneName().equals(az.getZoneName());
                this._controls.enableCompareZoneSet(true);
                this._controls.enableControls(true, true, true, true, this._zoneAction.getZoneCapability().isSwitchPortWWNSupported(), this._zoneAction.isEnhancedDeviceAliaseEnabled(), true, isActive, this._zoneAction.getZoneCapability().isDistributeSupported(), this._zoneAction.getZoneCapability().isZonesetValidationSupported());
            }
        } else {
            this._controls.enableControls(userObject == "Zones" || userObject == "Zonesets" || userObject == "FC-Aliases", false, false, false, false, false, false, false, this._zoneAction.getZoneCapability().isDistributeSupported(), false);
        }
        this._controls.enableApply(false);
    }

    private void manageTreeControlOnTableSelection(ZoneTree selTree) {
        if (selTree.getSelectionCount() > 0) {
            TreePath[] paths = selTree.getSelectionPaths();
            for (int k = 0; k < paths.length; ++k) {
                DndTreeNode nd = (DndTreeNode)paths[k].getLastPathComponent();
                if (!this._memberTable.getParentZone().equals(nd.getUserObject())) continue;
                nd.setNodeSelectedInContext(true);
                this.selectedContextNode.add(nd);
            }
            selTree.clearSelection();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object src = e.getSource();
        ZoneDragTable selTable = null;
        String status = " ";
        if (src == this._availablePortTable.getSelectionModel()) {
            selTable = this._availablePortTable;
            status = "Add to zone by dragging to zone folder or zone table header.";
        } else if (src == this._memberTable.getSelectionModel()) {
            selTable = this._memberTable;
            status = this._memberTable.getModel() == this._memberTableModel ? "Add to zone by dragging to zone folder." : " ";
        }
        int selRows = selTable != null ? selTable.getSelectedRowCount() : 0;
        this._status.setText(selRows > 0 ? status : " ");
        if (selRows > 0) {
            if (selTable != this._availablePortTable) {
                this._availablePortTable.getSelectionModel().clearSelection();
            }
            if (selTable != this._memberTable) {
                this._memberTable.getSelectionModel().clearSelection();
            }
            this.manageTreeControlOnTableSelection(this._zonesetTree);
            this.manageTreeControlOnTableSelection(this._zoneTree);
        }
        this._AddToZoneOrAlias.setEnabled((this._memberTable.getParentZone() instanceof Zone || this._memberTable.getParentZone() instanceof ZoneAlias) && selTable == this._availablePortTable && selRows > 0);
        if (e.getValueIsAdjusting()) {
            return;
        }
        this._controls.enableRenameZone(selRows > 0 && selTable == this._memberTable && (this._memberTable.getSelectedMembers() != null && this._memberTable.getSelectedMembers()[0].isZone() || this._zoneAction.getZoneCapability().isZoneRenameupported() && !this._memberTable.getSelectedMembers()[0].isZoneMember()));
        this._controls.enableControls(selRows > 0 && selTable != this._availablePortTable, this.canDelete(), false, false, false, false, false, false, this._zoneAction.getZoneCapability().isDistributeSupported(), false);
        AbstractZone[] zn = this._memberTable.getSelectedMembers();
        if (zn != null && zn.length > 0) {
            if (zn[0].isZone()) {
                ZoneDialog.markZoneMembers(this._vsan, this._zoneAction.getTranslatedZoneMembers((Zone)zn[0]));
            } else if (zn[0].isZoneMember()) {
                EndPort port;
                ArrayList<Comparable> members = new ArrayList<Comparable>();
                ArrayList attPortList = ((SmZoneMember)zn[0]).getAttachedEndPorts();
                if (null != attPortList) {
                    members.addAll(attPortList);
                }
                if ((port = ((SmZoneMember)zn[0]).getEndPort()) != null) {
                    members.add(port);
                }
                members.add(zn[0]);
                SelectionAction.getInstance().setObjects(members, null);
                SelectionAction.getInstance().execute();
            } else if (zn[0].isAlias()) {
                ZoneDialog.markZoneMembers(this._vsan, this._zoneAction.getTranslatedZoneAliasMembers((ZoneAlias)zn[0]));
            }
            return;
        }
        if (this._availablePortTable != null) {
            ZoneDialog.markEndPorts(this._vsan, this._availablePortTable.getSelectedEndPorts());
        }
    }

    private void buildTableHeading(TreePath path) {
        String pathName = "";
        for (int i = 1; i < path.getPathCount(); ++i) {
            if (i > 1) {
                pathName = pathName + "/";
            }
            pathName = pathName + path.getPathComponent(i).toString();
        }
        this._tableHeading.setText(pathName);
    }

    @Override
    public void setVisible(boolean b) {
        try {
            if (!b) {
                this._zoneAction.stopPolling();
                this._zoneAction.cleanUp();
                this.saveJIDELayout();
            } else if (!this.dataLoaded) {
                this.dataLoaded = true;
                this.getDockingManager().loadLayoutData();
                this.getDockableBarManager().loadLayoutData();
                this.setSize(new Dimension(1080, 550));
                if (this._parent != null) {
                    this.setLocationRelativeTo(this._parent);
                }
                if (!this._externallyDiscovered) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    new Thread(new refreshData(this, true)).start();
                } else {
                    this._externallyDiscovered = false;
                }
                this.loadJIDELayout();
            }
        }
        catch (Exception ex) {
            if (SnmpSession.isTrace()) {
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            Util.errorMessage((Component)this, ex.getMessage());
        }
        super.setVisible(b);
    }

    public void refreshAndCalcSize() throws SnmpException {
        this.refresh();
        this._externallyDiscovered = true;
        this.calcTablesSize();
    }

    private void calcTablesSize() {
        this._memberTable.calcPreferredSize();
        this._availablePortTable.calcPreferredSize();
    }

    private void buildTabbedPane(UITransferHandler dndTransferData) {
        VersionPeer verPeer = SmZoneUtil.buildVersionnPeer(this._sw);
        ZoneCapability cap = this._vsan == null ? verPeer.getIvrCapability() : verPeer.getNonIvrCapability();
        this._memberTableModel = new ZoneMembersTableModel(this._vsan == null, cap);
        this._memberTableModel.addTableModelListener(this);
        this._zoneTableModel = new ZoneTableModel(cap);
        this._zoneTableModel.addTableModelListener(this);
        this._zoneSetTableModel = new ZoneSetTableModel(cap.isZoneSetRenameSupported());
        this._zoneSetTableModel.addTableModelListener(this);
        ZonesetTableCellRenderer tableRend = new ZonesetTableCellRenderer(this._zoneAction);
        this._memberTable = new ZoneMemberTable(this._memberTableModel, dndTransferData, tableRend, this._zoneAction, this._controls);
        this._memberTableModel.setZoneCapability(cap);
        this._endPortsTableModel = new EndPortsTableModel(this._vsan, null, true);
        this._endPortsTableModel.updateModelData(this._zoneAction.getAfidMap());
        this._availablePortTable = new AvailablePortsTable(this._endPortsTableModel, dndTransferData, this._zoneAction);
        this._devAliasTableModel = new DeviceAliasTableModel();
        this._devAliasTableModel.updateData(ClientController.getInstance().getFabric().getDeviceAliases(), this._vsan);
        this.hostStrRenderer = new HostStorageRenderer();
        this._availablePortTable.getColumnModel().getColumn(0).setCellRenderer(this.hostStrRenderer);
        if (this._availablePortTable.getColumnCount() > 0) {
            this._availablePortTable.getColumnModel().getColumn(0).setMaxWidth(45);
        }
        this._availableAliasTableModel = new AliasTableModel(cap.isAliasRenameSupported());
        this._availableAliasTableModel.addTableModelListener(this);
        this._memberScroller.setViewportView(this._memberTable);
        new DropTarget(this._memberScroller.getViewport(), 3, this._memberTable);
        this._portScroller.setViewportView(this._availablePortTable);
        this._AddToZoneOrAlias = DialogUtil.buildButtons(new String[]{ADD_TO_ZONE}, (ActionListener)this)[0];
        this._AddToZoneOrAlias.setIcon(HeaderListener.getUpImage());
        this._AddToZoneOrAlias.setEnabled(false);
        this._select = new RadioButtonPanel(new String[]{"WWN", "Device Alias"});
        this._select.addChangeListener(this);
        this._filterCb = new JComboBox<String>(FILTER_DEVICE_ENTRIES);
        this._filterCb.setActionCommand("Filter");
        this._filterCb.addActionListener(this);
        this._radioPanel = DialogUtil.buildPanel(DialogUtil.buildLabels(new String[]{"Zoned By:"}), new JComponent[]{this._select});
        this._endDevTableFilterBtn = DialogUtil.buildButtons(new String[]{"Filter"}, (ActionListener)this)[0];
        this._endDevTableFilterBtn.setActionCommand("O");
        this._endDevTableFilterFl = new KTextField(18);
        this._endDevTableFilterCb = new JComboBox<String>(new String[]{"Name", "WWN", "FCID"});
        this._dataView = this.createPanel(new Component[]{DialogUtil.buildPanel(DialogUtil.buildLabels(new String[]{"Show:"}), new JComponent[]{this._filterCb}), new JLabel("With:"), this._endDevTableFilterCb, this._endDevTableFilterFl, this._endDevTableFilterBtn, new ToolBarSeparator(), this._radioPanel}, this._portScroller, this._AddToZoneOrAlias);
        JLabel lba = DialogUtil.buildLabels(new String[]{"Members"})[0];
        lba.setHorizontalAlignment(2);
        this._zoneTableFilterFl = new KTextField(18);
        this._zoneTableFilterBtn = DialogUtil.buildButtons(new String[]{"Filter"}, (ActionListener)this)[0];
        this._zoneTableFilterBtn.setActionCommand("G");
        JPanel paneA = this.createPanel(new Component[]{new JLabel("Show Name:"), this._zoneTableFilterFl, this._zoneTableFilterBtn}, this._memberScroller, null);
        DockableFrame memPnl = this.buildDockableFrame(paneA, "Members", 4, 0);
        memPnl.setPreferredSize(this.rightPanelDim);
        this._dockingManager.addFrame(memPnl);
        DockableFrame dataVw = this.buildDockableFrame(this._dataView, "End Devices", 4, 1);
        dataVw.setPreferredSize(this.rightPanelDim);
        this._dockingManager.addFrame(dataVw);
        this._memberTable.setDragListener(this._zonesetTree);
        this._availablePortTable.setDragListener(this._zonesetTree);
        this._memberTable.setDragListener(this._zoneTree);
        this._availablePortTable.setDragListener(this._zoneTree);
        this._memberTable.getSelectionModel().addListSelectionListener(this);
        this._availablePortTable.getSelectionModel().addListSelectionListener(this);
        this._memberTable.setChangeListener(this._controls.getApplyButton());
    }

    private JPanel createPanel(Component[] cmp, JScrollPane pane, JComponent btn) {
        JPanel panel = new JPanel(new BorderLayout());
        if (cmp != null) {
            JPanel pnlInside = new JPanel(new BorderLayout());
            JPanel pnlLeft = new JPanel(new FlowLayout(2, 6, 3));
            for (int k = 0; k < cmp.length; ++k) {
                pnlLeft.add(cmp[k]);
            }
            pnlInside.add((Component)pnlLeft, "West");
            if (btn != null) {
                pnlInside.add((Component)btn, "East");
            }
            panel.add((Component)pnlInside, "North");
        }
        if (pane != null) {
            panel.add((Component)pane, "Center");
        }
        return panel;
    }

    void addTableRowSelectionListener(ListSelectionListener l) {
        this._memberTable.getSelectionModel().addListSelectionListener(l);
        this._availablePortTable.getSelectionModel().addListSelectionListener(l);
    }

    boolean canActive() {
        return this._memberTable.getModel() == this._zoneSetTableModel && this._memberTable.getSelectedRows().length == 1;
    }

    boolean canDelete() {
        return this._memberTable.getSelectedRows().length > 0;
    }

    boolean canDeactive() {
        ZoneSet zs = this._memberTable.getSelectedZoneset();
        if (zs != null) {
            return zs.isActive(this._vsan.getEnforcedZoneSetName());
        }
        return false;
    }

    DragTableModel getTableModel(int tableType) {
        switch (tableType) {
            case 3: {
                return this._memberTableModel;
            }
            case 1: {
                return this._zoneSetTableModel;
            }
            case 2: {
                return this._zoneTableModel;
            }
            case 4: {
                return this._availableAliasTableModel;
            }
        }
        return null;
    }

    void selectMembersTable() {
        this.setStatus(this._memberTable.getRowCount() + " members");
    }

    static void markVsan(Vsan v) {
        VsanHighlightAction.getInstance().setVsan(v);
        VsanHighlightAction.getInstance().execute();
    }

    static void markZoneMembers(Vsan vsan, ArrayList zoneMembers) {
        if (vsan != null) {
            ZoneDialog.markVsan(vsan);
        }
        HighlightAction.getInstance().setObjects(zoneMembers, null);
        HighlightAction.getInstance().execute();
    }

    static void markEndPorts(Vsan vsan, EndPort[] ePs) {
        if (vsan != null) {
            ZoneDialog.markVsan(vsan);
        }
        ArrayList<EndPort> ePorts = new ArrayList<EndPort>();
        if (ePs != null) {
            for (int i = 0; i < ePs.length; ++i) {
                if (ePs[i] == null) continue;
                ePorts.add(ePs[i]);
            }
        }
        HighlightAction.getInstance().setObjects(ePorts, null);
        HighlightAction.getInstance().execute();
    }

    private void setTreeBasedContext() {
        this.setTreeContextControls(null);
        TreePath[] znstTrPath = this._zonesetTree.getSelectionPaths();
        TreePath[] znTrPath = this._zonesetTree.getSelectionPaths();
        if (znstTrPath != null && znstTrPath.length > 0) {
            this.setTreeContextControls(this._zonesetTree.getSelectionPaths());
        } else {
            this.setTreeContextControls(this._zoneTree.getSelectionPaths());
        }
    }

    @Override
    public void actionFinished() {
        this._zonesetTree.repaint();
        this._zoneTree.repaint();
        this._controls.resetActivationControls();
        this.setTreeBasedContext();
    }

    @Override
    public void handleError(Exception[] ex) {
        Util.errorMessage((Component)this, SmZoneUtil.buildErrorMessage(ex).toString());
        this._controls.resetActivationControls();
        this.setTreeBasedContext();
    }

    @Override
    public void setStatus(String status) {
        if (this._status != null) {
            this._status.setText(status);
        }
        this.setTreeBasedContext();
        if (this._logDialog != null) {
            this._logDialog.log(status);
        }
    }

    void filterEndDevices(boolean force) {
        int filterVal = this._filterCb.getSelectedIndex();
        if (force || filterVal != 0) {
            if (this._select.getSelected() != ZONE_BY_DEV_ALIAS) {
                this._endPortsTableModel.setZonedPorts(this._zoneAction.getPwwnZonedPorts(filterVal), filterVal);
                this._endPortsTableModel.updateModelData(this._zoneAction.getAfidMap());
                this._endPortsTableModel.fireTableDataChanged();
            } else {
                this._devAliasTableModel.setZonedPorts(this._zoneAction.getZonedDeviceAliases(filterVal), filterVal);
                this._devAliasTableModel.updateData(ClientController.getInstance().getFabric().getDeviceAliases(), this._vsan);
                this._devAliasTableModel.fireTableDataChanged();
            }
        }
    }

    public Vsan getVsan() {
        return this._vsan;
    }

    public Switch getSwitch() {
        return this._sw;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e != null && e.getType() == 0) {
            KTableModel model = (KTableModel)e.getSource();
            this._controls.enableApply(model.isChanged());
        }
    }

    Object getContext() {
        TreePath[] tpt = this._zonesetTree.getSelectionPaths();
        TreePath[] zonetpt = this._zoneTree.getSelectionPaths();
        if (tpt != null && tpt.length > 0) {
            return this._zonesetTree;
        }
        if (zonetpt != null && zonetpt.length > 0) {
            return this._zoneTree;
        }
        if (this._memberTable.getSelectedRowCount() > 0) {
            return this._memberTable;
        }
        return null;
    }

    public static Switch getConfigSwitch(Vsan v) {
        Switch principalSw = v.getPrincipalSwitch();
        return principalSw != null ? (principalSw.isMDS() ? principalSw : v.getSeedSwitch()) : null;
    }

    public static Object launchNewZoneDialog(JFrame parent, ArrayList selEndPorts, Vsan v) throws SnmpException {
        String zoneName = null;
        for (int i = 0; i < selEndPorts.size(); ++i) {
            EndPort ep = (EndPort)selEndPorts.get(i);
            if (ep.isTarget()) continue;
            String alias = ep.getAlias();
            zoneName = !ep.isISCSI() && alias != null && alias.length() > 0 ? alias : "Zn_" + ZoneDialog.toHexStringWoColon(ep.getPortWwn().getValue());
            break;
        }
        if (zoneName == null) {
            zoneName = "Zn_" + ZoneDialog.toHexStringWoColon(((EndPort)selEndPorts.get(0)).getPortWwn().getValue());
        }
        return JOptionPane.showInputDialog(parent, "Add selected port(s) to local enforced zoneset on\n" + ZoneDialog.getConfigSwitch(v) + " for VSAN " + v + ".\nPlease Specify Zone Name:", "Create Zone" + ClientController.getInstance().getDialogFabricTitlePostfix(), 3, null, null, zoneName);
    }

    public Zone createZoneZoneset(ArrayList selectedPorts, Object zone) throws SnmpException {
        return this._zoneAction.createZoneZoneset(selectedPorts, zone);
    }

    public void showZone(Object zone) {
        if (zone != null && zone instanceof Zone) {
            this._zoneAction.selectAndShowZone((Zone)zone);
        }
    }

    public static String toHexStringWoColon(byte[] b) {
        if (b == null || b.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer(b.length * 3);
        for (int i = 0; i < b.length; ++i) {
            int n = b[i] & 0xFF;
            sb.append(SnmpString.HEX_DIGIT[n >> 4 & 0xF]);
            sb.append(SnmpString.HEX_DIGIT[n & 0xF]);
        }
        return sb.toString();
    }

    void disableControlsForRefresh() {
        this._controls.enableControls(false, false, false, false, false, false, false, false, false, false);
        this._controls.enableRefresh(false);
        this._controls.enableDiscard(false);
    }

    void enableControlsAfterRefresh() {
        this._controls.enableRefresh(true);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        this.filterEndDevices(true);
        String epfiltrFld = this._endDevTableFilterFl.getText().trim();
        if (this._select.getSelected() == ZONE_BY_DEV_ALIAS) {
            this.updateDeviceAliasTableModel(epfiltrFld, this._endDevTableFilterCb.getSelectedIndex() + 1);
        } else {
            this.updateEndPortsTableModel(epfiltrFld, this._endDevTableFilterCb.getSelectedIndex() + 2);
        }
        this._availablePortTable.setModel(this._select.getSelected() == ZONE_BY_DEV_ALIAS ? this._devAliasTableModel : this._endPortsTableModel);
        this._availablePortTable.getColumnModel().getColumn(0).setCellRenderer(this.hostStrRenderer);
        this._availablePortTable.calcPreferredSize();
    }

    public boolean canEditNonIVRZones() {
        if (this._zoneAction != null && this._vsan != null) {
            String lockOwner = this._zoneAction.getLockOwner();
            int ownerType = this._zoneAction.getLockOwnerType();
            return ownerType == 5 && lockOwner != null && lockOwner.equals(this._lockingSwitch.getPeer().getUserName()) || lockOwner == null || lockOwner.trim().length() == 0 || ownerType == -1;
        }
        return true;
    }

    void startLog() {
        if (this._logDialog != null) {
            this._logDialog.dispose();
        }
        this._logDialog = new LogDialog(this);
        this._logDialog.setVisible(true);
    }

    public CommitDialog getCommitDlg(VersionPeer swVesionrPeer) {
        return new CommitDialog(this, this._vsan != null ? (int)this._vsan.getId() : -1, swVesionrPeer, this._controls, this._zoneAction);
    }

    public DockingManager getDockingManager() {
        return this._dockingManager;
    }

    public DockableBarManager getDockableBarManager() {
        return this._dockableBarManager;
    }

    public ArrayList getModeList() {
        return this.modeList;
    }

    class RegionListCellRenderer
    extends DefaultListCellRenderer {
        RegionListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null && (Integer)value <= 0) {
                return new JLabel("default");
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    class LogDialog
    extends JDialog
    implements ActionListener {
        JTextArea outputTextArea;

        LogDialog(JDialog parent) {
            super(parent);
            this.outputTextArea = new JTextArea();
            this.outputTextArea.setOpaque(true);
            this.outputTextArea.setEditable(false);
            this.setDefaultCloseOperation(2);
            this.setTitle((ZoneDialog.this._vsan == null ? "IVR" : "") + " Zone Log" + ClientController.getInstance().getDialogFabricTitlePostfix());
            DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)new JScrollPane(this.outputTextArea), (AbstractButton[])DialogUtil.buildButtons(new String[]{"Close"}, (ActionListener)this));
            this.setResizable(true);
            this.setSize(500, 450);
            this.setDefaultCloseOperation(1);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.dispose();
            ZoneDialog.this._logDialog = null;
        }

        public void log(String str) {
            this.outputTextArea.append(str + "\n");
            this.outputTextArea.setCaretPosition(this.outputTextArea.getDocument().getLength() - 1);
        }
    }

    class refreshData
    implements Runnable {
        ZoneDialog _dialog;
        boolean _calcTableSize;

        refreshData(ZoneDialog dialog) {
            this._dialog = dialog;
        }

        refreshData(ZoneDialog dialog, boolean calc) {
            this._dialog = dialog;
            this._calcTableSize = calc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (ZoneDialog.this._discoveringAll && ZoneDialog.this._zoneAction.getCmdHandler() != null) {
                    ZoneDialog.this._zoneAction.getCmdHandler().stopDiscovery();
                }
                refreshData refreshData2 = this;
                synchronized (refreshData2) {
                    ZoneDialog.this._discoveringAll = true;
                    this._dialog.setStatus("Discovering zones, Please wait...");
                    ZoneDialog.this.disableControlsForRefresh();
                    this._dialog.refresh();
                    if (this._calcTableSize) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                refreshData.this._dialog.calcTablesSize();
                                refreshData.this._dialog.setStatus("Discovery success");
                            }
                        });
                    }
                    ZoneDialog.this._discoveringAll = false;
                }
            }
            catch (SnmpException ex) {
                Util.errorMessage((Component)this._dialog, ex.getMessage());
                this._dialog.setStatus("Discovery failed");
            }
            this._dialog.filterEndDevices(true);
            this._dialog.setStatus("Discovery success");
            this._dialog.setCursor(Cursor.getDefaultCursor());
            ZoneDialog.this._treeRend.setPreferredSize(new Dimension(1000, ((ZoneDialog)ZoneDialog.this)._treeRend.getPreferredSize().height));
        }
    }
}

