/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.zoneconfig;

import com.cisco.dcbu.lib.mds.zm.Zone;
import com.cisco.dcbu.lib.mds.zm.ZoneCapability;
import com.cisco.dcbu.lib.mds.zm.ZoneQosPriority;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.zm.common.DragTableModel;
import java.util.ArrayList;

class ZoneTableModel
extends DragTableModel {
    static final String NAME_LABEL = "Name";
    static final String RONLY_LABEL = "Read Only";
    static final String QOS_LABEL = "QoS";
    static final String QOS_PRIORITY_LABEL = "QoS Priority";
    static final String BROADCAST_LABEL = "Broadcast";
    static final String SMARTZONE_LABEL = "Smart Zone";
    static final String MEMBER_LABEL = "Members";
    static final String ZN_TIMESTAMP_LABEL = "Creation/Mod Time";
    static final String[] NEW_LABELS = new String[]{"Name", "Read Only", "QoS", "QoS Priority", "Broadcast", "Smart Zone", "Members", "Creation/Mod Time"};
    static final int COL_LENGTH = 8;
    static final int NAME = 0;
    static final int READONLY = 1;
    static final int QOS = 2;
    static final int PRIORITY = 3;
    static final int BROADCAST = 4;
    static final int SMARTZONE = 5;
    static final int MEMBERS = 6;
    static final int ZONE_TIMESTAMP = 7;
    private ZoneCapability _capability;
    private ArrayList<String> _labelList;

    ZoneTableModel(ZoneCapability capability) {
        this.setZoneCapability(capability);
    }

    private void setNewHeaders() {
        boolean[] editable;
        if (this._capability.isROSupported() && this._capability.isQosSupported() && this._capability.isBroadcastSupported()) {
            editable = new boolean[]{this._capability.isZoneRenameupported(), true, true, true, true, this._capability.isSmartZoningSupported(), false, false};
        } else if (this._capability.isROSupported() && !this._capability.isQosSupported() && !this._capability.isBroadcastSupported()) {
            this._labelList.remove(QOS_LABEL);
            this._labelList.remove(QOS_PRIORITY_LABEL);
            this._labelList.remove(BROADCAST_LABEL);
            editable = new boolean[]{this._capability.isZoneRenameupported(), true, false, false, false, this._capability.isSmartZoningSupported()};
        } else if (!this._capability.isROSupported() && this._capability.isQosSupported() && !this._capability.isBroadcastSupported()) {
            editable = new boolean[]{this._capability.isZoneRenameupported(), true, true, false, false, this._capability.isSmartZoningSupported()};
            this._labelList.remove(RONLY_LABEL);
            this._labelList.remove(BROADCAST_LABEL);
        } else if (this._capability.isROSupported() && this._capability.isQosSupported() && !this._capability.isBroadcastSupported()) {
            editable = new boolean[]{this._capability.isZoneRenameupported(), true, true, true, false, this._capability.isSmartZoningSupported(), false};
            this._labelList.remove(BROADCAST_LABEL);
        } else {
            editable = new boolean[]{this._capability.isZoneRenameupported(), false};
            this._labelList.remove(RONLY_LABEL);
            this._labelList.remove(QOS_LABEL);
            this._labelList.remove(QOS_PRIORITY_LABEL);
            this._labelList.remove(BROADCAST_LABEL);
        }
        if (!this._capability.isSmartZoningSupported()) {
            this._labelList.remove(SMARTZONE_LABEL);
        }
        String[] labels = this._labelList.toArray(new String[0]);
        this.setHeaders(labels);
        this.setEditable(editable);
    }

    void setZoneCapability(ZoneCapability capability) {
        this._labelList = new ArrayList();
        for (int i = 0; i < NEW_LABELS.length; ++i) {
            this._labelList.add(NEW_LABELS[i]);
        }
        this._capability = capability;
        this.setNewHeaders();
        this.setData(new Array());
        this.fireTableStructureChanged();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this._capability.isQosSupported()) {
            Object[] data;
            int roOffset;
            int n = roOffset = this._capability.isROSupported() ? 0 : 1;
            if (col == 3 - roOffset && (data = (Object[])this.getData().elementAt(row)) != null && data.length > 0) {
                return (Boolean)data[2 - roOffset];
            }
        }
        return super.isCellEditable(row, col);
    }

    private int getMemberColOffSet() {
        return 8 - this.getHeaders().length;
    }

    @Override
    public void updateData(ArrayList memberList) {
        int roOffset;
        Array<Object[]> responseData = new Array<Object[]>();
        int offset = this.getMemberColOffSet();
        int n = roOffset = this._capability.isROSupported() ? 0 : 1;
        if (memberList != null) {
            for (int i = 0; i < memberList.size(); ++i) {
                Object listNode = memberList.get(i);
                Object[] o = new Object[this.getHeaders().length + 3];
                Zone zmem = (Zone)listNode;
                if (this.filterStr != null && this.filterStr.length() > 0 && !zmem.getZoneName().matches(this.filterStr)) continue;
                o[0] = zmem.toString();
                if (this._capability.isROSupported()) {
                    o[1] = zmem.isReadOnly();
                }
                if (this._capability.isQosSupported()) {
                    o[2 - roOffset] = zmem.isQos();
                    o[3 - roOffset] = new ZoneQosPriority(zmem.getQosPriority());
                }
                if (this._capability.isBroadcastSupported()) {
                    o[4 - roOffset] = zmem.isBroadcast();
                }
                o[9 - offset] = zmem;
                o[6 - offset] = this._defaultDetailsList;
                o[7 - offset] = zmem.getLastModifiedAsLong();
                if (this._capability.isSmartZoningSupported()) {
                    o[5 - offset] = zmem.isSmartZone();
                }
                responseData.addElement(o);
            }
        }
        this.setData(responseData);
        this.sort(0, true);
    }

    @Override
    public boolean isInfoColumn(int clmn) {
        return clmn == 6 - this.getMemberColOffSet();
    }

    @Override
    public Object getDragObject(int row) {
        if (row >= this.getRowCount()) {
            return null;
        }
        return ((Object[])this.getData().elementAt(row))[9 - this.getMemberColOffSet()];
    }

    @Override
    public ArrayList getChangedZoneProperties() {
        int roOffset;
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        int n = roOffset = this._capability.isROSupported() ? 0 : 1;
        if (this.isChanged()) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                boolean changed = false;
                for (int k = 0; k < this.getColumnCount(); ++k) {
                    if (!this.isChanged(i, k)) continue;
                    changed = true;
                    break;
                }
                if (!changed) continue;
                Object[] obb = new Object[NEW_LABELS.length];
                Object[] row = (Object[])this.getData().elementAt(i);
                obb[0] = row[row.length - 2];
                obb[1] = row[0];
                obb[2] = this._capability.isROSupported() ? row[1] : Boolean.FALSE;
                obb[3] = this._capability.isQosSupported() ? row[2 - roOffset] : Boolean.FALSE;
                obb[4] = this._capability.isQosSupported() ? row[3 - roOffset] : Boolean.FALSE;
                obb[5] = this._capability.isBroadcastSupported() ? row[4 - roOffset] : Boolean.FALSE;
                obb[6] = this._capability.isSmartZoningSupported() ? row[5 - roOffset] : Boolean.FALSE;
                list.add(obb);
            }
        }
        return list;
    }

    @Override
    public int getTimeStampColumn() {
        return 7 - this.getMemberColOffSet();
    }
}

