/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.zonewizard;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.zm.common.IvrEndPort;
import com.cisco.dcbu.sm.client.zm.common.SmZoneUtil;
import java.util.ArrayList;
import java.util.HashMap;

public class FabricBinding {
    static final int[] SWITCH_WWN_OID = MibNode.get("cpsmFabricBindSwitchWwn").getOid();
    static final int[] SWITCH_DID = MibNode.get("cpsmFabricBindDomIdRev1").getOid();
    static final int[] SWITCH_FB_ROW_STATUS = MibNode.get("cpsmFabricBindRowStatus").getOid();

    public ArrayList getFabricBindingDB(Switch sw) throws SnmpException {
        VarBindList vbLst = new VarBindList();
        vbLst.add(SWITCH_WWN_OID);
        vbLst.add(SWITCH_DID);
        SnmpPeer thePeer = SmZoneUtil.getSwitchPeer(sw);
        VarBindList response = SnmpFetch.getBulk(thePeer, vbLst).getVariables();
        ArrayList<FabricBindingEntry> fbList = new ArrayList<FabricBindingEntry>();
        for (int k = 0; k < response.size(); k += 2) {
            FabricBindingEntry ent = new FabricBindingEntry();
            int[] oid = response.getVb(k).getOid().getValue();
            ent.index = oid[oid.length - 1];
            ent.vsanId = oid[oid.length - 2];
            ent.type = oid[oid.length - 3];
            ent.wwn = response.byteValue(k);
            ent.domainId = response.intValue(k + 1);
            fbList.add(ent);
        }
        return fbList;
    }

    public static Object[] getVirtualSwitchWWN(Switch sw, int vsan) {
        byte[] wwn = sw.getWwn().getValue();
        byte[] vsanWWN = new byte[wwn.length];
        System.arraycopy(wwn, 0, vsanWWN, 0, wwn.length);
        vsanWWN[1] = (byte)vsan;
        vsanWWN[0] = (byte)(vsanWWN[0] | vsan >> 8 & 0xF);
        int n = vsanWWN.length - 1;
        vsanWWN[n] = (byte)(vsanWWN[n] + 1);
        return new Object[]{new Integer(vsan), vsanWWN, sw};
    }

    void getVirtualSwitchWWN(byte[] wwn, int vsanId) {
        ArrayList virtualSw = new ArrayList();
        byte[] vsanWWN = new byte[wwn.length];
        System.arraycopy(wwn, 0, vsanWWN, 0, wwn.length);
        vsanWWN[1] = (byte)vsanId;
        vsanWWN[0] = (byte)(vsanWWN[0] | vsanId >> 8 & 0xF);
        int n = vsanWWN.length - 1;
        vsanWWN[n] = (byte)(vsanWWN[n] + 1);
        DefaultLogger._DefLogger.debug((Object)("Virtual Switch WWN:" + SnmpString.toHexString(vsanWWN)));
    }

    public static VarBindList buildFabricBindingVBL(ArrayList fbList, ArrayList existingEntries, StringBuffer switchConfiguration) throws SnmpException {
        StringBuffer buf = new StringBuffer();
        VarBindList vbLst = new VarBindList();
        int index = 0;
        int offset = 0;
        int destinationVsanPrev = 0;
        for (int k = 0; k < fbList.size(); ++k) {
            Object[] ob = (Object[])fbList.get(k);
            int[] data = (int[])ob[2];
            int destinationV = data[2];
            if (destinationVsanPrev != destinationV) {
                offset = 0;
                destinationVsanPrev = destinationV;
            }
            byte[] wwn = (byte[])ob[0];
            short did = (short)data[3];
            boolean entryExists = false;
            boolean holeFound = false;
            index = 1;
            for (int i = 0; i < existingEntries.size(); ++i) {
                FabricBindingEntry ent = (FabricBindingEntry)existingEntries.get(i);
                Object[] obSwVsan = ent.getSwitchAndVsanID();
                if (ent.vsanId == destinationV) {
                    if (SnmpString.equals(ent.wwn, wwn)) {
                        DefaultLogger._DefLogger.debug((Object)("Skipping, as Entry exists on Vsan " + ent.vsanId + " for" + (obSwVsan[1] != null ? " virtual " : " ") + "Switch " + obSwVsan[0] + (obSwVsan[1] != null ? "(Vsan " + obSwVsan[1] + ")" : "")));
                        entryExists = true;
                        if (ent.domainId == did) break;
                        DefaultLogger._DefLogger.debug((Object)("Conflict, as Entry exists on Vsan " + ent.vsanId + " for " + (obSwVsan[1] != null ? "virtual" : "") + " Switch" + obSwVsan[0] + (obSwVsan[1] != null ? "(Vsan " + obSwVsan[1] + ")" : "") + " with configured domain ID:" + ent.domainId + " New domainID:" + did));
                        throw new SnmpException("Conflict, as Entry exists on Vsan " + ent.vsanId + " for " + (obSwVsan[1] == null ? "virtual" : "") + " Switch" + obSwVsan[0] + (obSwVsan[1] == null ? "(Vsan " + obSwVsan[1] + ")" : "") + " with configured domain ID:" + ent.domainId + " Switch domainID:" + did + "\nPlease resolve the conflict & restart the wizard.");
                    }
                    if (holeFound) continue;
                    if (ent.index - index - offset > 1) {
                        holeFound = true;
                        continue;
                    }
                    index = ent.index;
                    continue;
                }
                if (ent.vsanId > destinationV) break;
                if (ent.vsanId >= destinationV) continue;
            }
            if (entryExists) continue;
            index = index + 1 + offset;
            ++offset;
            int[] snmpIndex = new int[]{1, destinationV, index};
            vbLst.add(SWITCH_FB_ROW_STATUS, snmpIndex, (SnmpVar)new SnmpInt(4));
            vbLst.add(SWITCH_WWN_OID, snmpIndex, (SnmpVar)new SnmpString(wwn));
            vbLst.add(SWITCH_DID, snmpIndex, (SnmpVar)new SnmpInt(did));
            buf.append("  Configure WWN:" + SnmpString.toHexString(wwn) + "  Domain ID:" + did + " on VSAN:" + destinationV + "\n");
        }
        if (buf.length() == 0) {
            switchConfiguration.append("No Changes\n");
        } else {
            switchConfiguration.append(buf);
        }
        return vbLst;
    }

    public static int[] getEmptyIndices(ArrayList bindings, int vsanid, int number) {
        int[] indicelist = new int[number];
        int index = 0;
        int indices = 0;
        for (int i = 0; i < bindings.size(); ++i) {
            FabricBindingEntry ent = (FabricBindingEntry)bindings.get(i);
            if (ent.vsanId < vsanid) continue;
            if (ent.vsanId > vsanid) {
                indicelist[indices++] = ++index;
            } else if (ent.index - index > 1) {
                indicelist[indices++] = ++index;
            } else {
                index = ent.index;
            }
            if (indices >= number) break;
        }
        return indicelist;
    }

    public static HashMap buildFabricBindingActVsanListAndCreateConfigEntries(Integer transitVsan, Array selected, ArrayList transitSwitches, ArrayList vsanListForFBActivation, StringBuffer info) throws SnmpException {
        HashMap swVsanMap = new HashMap();
        vsanListForFBActivation.clear();
        ArrayList<Switch> tSwitches = new ArrayList<Switch>();
        tSwitches.addAll(transitSwitches);
        for (int k = 0; k < selected.size(); ++k) {
            ArrayList<Short> vsanList;
            IvrEndPort epIvr = (IvrEndPort)selected.elementAt(k);
            EndPort prt = epIvr.getEndPort();
            Switch sw = prt.getSwitch();
            Short vsanInt = new Short((short)epIvr.getIvrVsan());
            if (!vsanListForFBActivation.contains(vsanInt)) {
                vsanListForFBActivation.add(vsanInt);
            }
            if ((vsanList = (ArrayList<Short>)swVsanMap.get(sw)) == null) {
                vsanList = new ArrayList<Short>();
            }
            if (!vsanList.contains(vsanInt)) {
                vsanList.add(vsanInt);
            }
            swVsanMap.put(sw, vsanList);
            if (tSwitches.contains(sw)) continue;
            tSwitches.add(sw);
        }
        ArrayList<Object[]> tws = new ArrayList<Object[]>();
        info.append("Fabric Binding:\n");
        int tVsan = transitVsan;
        info.append("Configuration for all switches for Transit Vsans \n");
        for (int i = 0; i < tSwitches.size(); ++i) {
            Switch sww = (Switch)tSwitches.get(i);
            short did = sww.getDomainId(transitVsan);
            tws.add(new Object[]{sww.getWwn().getValue(), sww, new int[]{0, tVsan, tVsan, did}});
            info.append("  Local Switch:" + sww + " WWN:" + sww.getWwn() + " \n   Domain ID:" + did + " For Vsan:" + tVsan + "\n");
            DefaultLogger._DefLogger.debug((Object)("  Local Switch:" + sww + " WWN:" + sww.getWwn() + " \n   Domain ID:" + did + " For Vsan:" + tVsan + "\n"));
        }
        FabricBinding fb = new FabricBinding();
        info.append("Configuration for all switches for Transit Vsans Virtual Switches\n");
        for (int i = 0; i < tSwitches.size(); ++i) {
            Switch sww = (Switch)tSwitches.get(i);
            ArrayList swVsans = (ArrayList)swVsanMap.get(sww);
            for (int swv = 0; swv < swVsans.size(); ++swv) {
                short swVsan = (Short)swVsans.get(swv);
                if (swVsan == tVsan) continue;
                Object[] virSws = FabricBinding.getVirtualSwitchWWN(sww, swVsan);
                short did = sww.getDomainId(swVsan);
                tws.add(new Object[]{(byte[])virSws[1], sww, new int[]{1, swVsan, tVsan, did}});
                info.append("  Virtual Switch:" + sww + " WWN:" + SnmpString.toHexString((byte[])virSws[1]) + " Domain ID:" + did + "\n   on VSAN " + swVsan + " Configured on Vsan:" + tVsan + "\n");
                DefaultLogger._DefLogger.debug((Object)("  Virtual Switch:" + sww + " WWN:" + SnmpString.toHexString((byte[])virSws[1]) + " Domain ID:" + did + "\n   on VSAN " + swVsan + " Configured on Vsan:" + tVsan + "\n"));
            }
        }
        HashMap<Switch, VarBindList> swVarBindMap = new HashMap<Switch, VarBindList>();
        StringBuffer switchConfiguration = new StringBuffer("\nFabric Binding Configuration that will be set on Switch:\n");
        for (int i = 0; i < tSwitches.size(); ++i) {
            Switch sww = (Switch)tSwitches.get(i);
            info.append("Configuration for switch " + sww + "\n");
            DefaultLogger._DefLogger.debug((Object)("Configuration for switch " + sww + "\n"));
            ArrayList swVsans = (ArrayList)swVsanMap.get(sww);
            ArrayList<Object[]> swWWNFb = new ArrayList<Object[]>();
            for (int swv = 0; swv < swVsans.size(); ++swv) {
                short swVsan = (Short)swVsans.get(swv);
                if (swVsan == tVsan) continue;
                short selfDid = sww.getDomainId(swVsan);
                swWWNFb.add(new Object[]{sww.getWwn().getValue(), sww, new int[]{0, swVsan, swVsan, selfDid}});
                info.append("  Local Switch:" + sww + " WWN:" + sww.getWwn() + "\n   Domain ID:" + selfDid + " For Vsan:" + swVsan + "\n");
                DefaultLogger._DefLogger.debug((Object)("  Local Switch:" + sww + " WWN:" + sww.getWwn() + "\n   Domain ID:" + selfDid + " For Vsan:" + swVsan + "\n"));
                for (int t = 0; t < tSwitches.size(); ++t) {
                    Switch tsw = (Switch)tSwitches.get(t);
                    ArrayList vVs = (ArrayList)swVsanMap.get(tsw);
                    for (int vv = 0; vv < vVs.size(); ++vv) {
                        short vT = (Short)vVs.get(vv);
                        if (vT == swVsan) continue;
                        Object[] virSws = FabricBinding.getVirtualSwitchWWN(tsw, vT);
                        short tDid = tsw.getDomainId(vT);
                        swWWNFb.add(new Object[]{(byte[])virSws[1], tsw, new int[]{0, vT, swVsan, tDid}});
                        info.append("  Virtual Switch:" + tsw + " WWN:" + SnmpString.toHexString((byte[])virSws[1]) + " Domain ID:" + tDid + "\n   on VSAN " + vT + " Configured on Vsan:" + swVsan + "\n");
                        DefaultLogger._DefLogger.debug((Object)("  Virtual Switch:" + tsw + " WWN:" + SnmpString.toHexString((byte[])virSws[1]) + " Domain ID:" + tDid + "\n   on VSAN " + vT + " Configured on Vsan:" + swVsan + "\n"));
                    }
                }
            }
            swWWNFb.addAll(tws);
            ArrayList fbDb = fb.getFabricBindingDB(sww);
            switchConfiguration.append("Switch:" + sww + "\n");
            VarBindList vbl = FabricBinding.buildFabricBindingVBL(swWWNFb, fbDb, switchConfiguration);
            swVarBindMap.put(sww, vbl);
        }
        if (!vsanListForFBActivation.contains(transitVsan)) {
            vsanListForFBActivation.add(new Short((short)transitVsan.intValue()));
        }
        info.append(switchConfiguration);
        return swVarBindMap;
    }

    public static void main(String[] args) {
        new FabricBinding().getVirtualSwitchWWN(new byte[]{32, 0, 0, 5, 48, 1, 34, 66}, 3000);
    }

    class FabricBindingEntry {
        int type;
        int vsanId;
        int index;
        byte[] wwn;
        int domainId;

        FabricBindingEntry() {
        }

        FabricBindingEntry findFabricBinding(ArrayList bindings, byte[] swWWN, int vsanId) {
            for (int i = 0; i < bindings.size(); ++i) {
                FabricBindingEntry ent = (FabricBindingEntry)bindings.get(i);
                if (ent.vsanId != vsanId || !SnmpString.equals(ent.wwn, swWWN)) continue;
                return ent;
            }
            return null;
        }

        Object[] getSwitchAndVsanID() {
            byte[] swWWN = new byte[this.wwn.length];
            System.arraycopy(this.wwn, 0, swWWN, 0, this.wwn.length);
            int vsanIndex = (swWWN[0] & 0xF) << 12 | swWWN[1];
            if (vsanIndex > 0) {
                swWWN[1] = 0;
                swWWN[0] = (byte)(swWWN[0] & 0xF0);
                int n = swWWN.length - 1;
                swWWN[n] = (byte)(swWWN[n] - 1);
            }
            ClientController.getInstance();
            Switch sw = ClientController.findFabricSwitchByWwn(new Wwn(swWWN));
            return new Object[]{sw, vsanIndex > 0 ? new Integer(vsanIndex) : null};
        }
    }
}

