/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.zonewizard;

import com.cisco.dcbu.lib.ui.AddRemoveListPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.zonewizard.IvrZoneWizardController;
import com.cisco.dcbu.sm.client.zm.zonewizard.ZoneMemWizard;
import java.awt.Component;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JList;

public class IvrVsanSelPanel
extends WizardPanel {
    private AddRemoveListPanel _pnl;
    private JList _avlVsan;
    private JList _selVsan;
    private Array _preSelectedVsans;

    public IvrVsanSelPanel() {
        this((JWizard)null);
    }

    public IvrVsanSelPanel(JWizard wiz) {
        super("", "Select VSANs which will participate in Inter VSAN Zoning.", wiz, IvrZoneWizardController.IMAGE_ZONE);
        this.setTitle(((ZoneMemWizard)this.getWizard()).getStepTitle(2) + "Select VSANs ");
        this._avlVsan = new JList(new DefaultComboBoxModel());
        this._selVsan = new JList(new DefaultComboBoxModel());
        this._pnl = new AddRemoveListPanel(this._avlVsan, this._selVsan);
        this.add((Component)this._pnl, "Center");
    }

    public IvrVsanSelPanel(JWizard wiz, Array selectedVsans) {
        this(wiz);
        this._preSelectedVsans = selectedVsans;
        this.refresh();
        Object[] selected = null;
        DefaultComboBoxModel avlModel = (DefaultComboBoxModel)this._avlVsan.getModel();
        if (this._preSelectedVsans != null) {
            selected = new Vsan[this._preSelectedVsans.size()];
            for (int i = 0; i < this._preSelectedVsans.size(); ++i) {
                selected[i] = (Vsan)this._preSelectedVsans.elementAt(i);
                avlModel.removeElement(this._preSelectedVsans.elementAt(i));
            }
            Arrays.sort(selected);
        }
        if (selected != null) {
            this._selVsan.setModel(new DefaultComboBoxModel<Vsan>(selected));
        }
        this.setModelValue("IVR_VSANS", this._preSelectedVsans);
        this._preSelectedVsans = null;
        this.setDataValid(true);
    }

    @Override
    public boolean refresh() {
        Object[] vsans = ((Fabric)this.getModelValue("IVR_SELECTED_FABRIC")).getVsans();
        if (vsans == null || vsans.length <= 0) {
            return false;
        }
        Arrays.sort(vsans);
        DefaultComboBoxModel<Object> avlModel = new DefaultComboBoxModel<Object>(vsans);
        this._avlVsan.setModel(avlModel);
        this._selVsan.setModel(new DefaultComboBoxModel());
        return true;
    }

    @Override
    public void doNext() {
        Array arSel = this._pnl.getSelectedMembers();
        if (arSel.size() < 2) {
            Util.errorMessage((Component)this, "Please select at least two VSANs for IVR zoning.");
        } else {
            Array arOld = (Array)this.getModelValue("IVR_VSANS");
            if (null == arOld || arOld.size() != arSel.size()) {
                this.setDataValid(false);
            } else {
                int MAXI = arOld.size();
                for (int i = 0; i < MAXI; ++i) {
                    if (-1 != arSel.findEquals(arOld.elementAt(i))) continue;
                    this.setDataValid(false);
                    break;
                }
            }
            this.setModelValue("IVR_VSANS", arSel);
            super.doNext();
        }
    }
}

