/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.zonewizard;

import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.common.EndPortsAddRemoveTable;
import com.cisco.dcbu.sm.client.zm.common.EndPortsTableModel;
import com.cisco.dcbu.sm.client.zm.common.HostStorageRenderer;
import com.cisco.dcbu.sm.client.zm.common.IvrEndPort;
import com.cisco.dcbu.sm.client.zm.common.SmZoneUtil;
import com.cisco.dcbu.sm.client.zm.common.ZoneDragTable;
import com.cisco.dcbu.sm.client.zm.zonewizard.Ivr1Results;
import com.cisco.dcbu.sm.client.zm.zonewizard.IvrResultsPanelActionsTable;
import com.cisco.dcbu.sm.client.zm.zonewizard.IvrZoneWizardController;
import com.cisco.dcbu.sm.client.zm.zonewizard.WizardCopyTopologyAction;
import com.cisco.dcbu.sm.client.zm.zonewizard.ZoneMemWizard;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;

public class NxPortsPanel
extends WizardPanel {
    private EndPortsAddRemoveTable _pnl;
    private ZoneDragTable _portsTable = new ZoneDragTable((KTableModel)new EndPortsTableModel(null, null, false, true), null);
    private ZoneDragTable _selPortsTable;
    static final String TITLE = " Select End Devices ";

    public NxPortsPanel() {
        this((JWizard)null);
    }

    public NxPortsPanel(JWizard wiz) {
        super("", "", wiz, IvrZoneWizardController.IMAGE_ZONE);
        HostStorageRenderer hsRend = new HostStorageRenderer();
        this._portsTable.getColumnModel().getColumn(0).setCellRenderer(hsRend);
        this._portsTable.setAutoResizeMode(4);
        this._selPortsTable = new ZoneDragTable((KTableModel)new EndPortsTableModel(null, null, false, true), null);
        this._selPortsTable.getColumnModel().getColumn(0).setCellRenderer(hsRend);
        this._selPortsTable.setAutoResizeMode(4);
        this._pnl = new EndPortsAddRemoveTable(this._portsTable, this._selPortsTable);
        this.add((Component)this._pnl, "Center");
    }

    public NxPortsPanel(JWizard wiz, ArrayList selectedPorts) {
        this(wiz);
        this.refresh();
        this.setDataValid(true);
        if (selectedPorts != null && selectedPorts.size() > 0) {
            for (int i = 0; i < selectedPorts.size(); ++i) {
                Object rowObject = ((EndPortsTableModel)this._portsTable.getModel()).getRowObjectForEndPort((EndPort)selectedPorts.get(i));
                if (rowObject == null) continue;
                ((EndPortsTableModel)this._portsTable.getModel()).getData().removeElement(rowObject);
                ((EndPortsTableModel)this._selPortsTable.getModel()).getData().addElement(rowObject);
            }
            ((EndPortsTableModel)this._portsTable.getModel()).fireTableDataChanged();
            ((EndPortsTableModel)this._selPortsTable.getModel()).fireTableDataChanged();
            this._selPortsTable.calcPreferredSize();
            this.setModelValue("NXPORTS", this._pnl.getSelectedMembers());
        }
    }

    @Override
    public boolean refresh() {
        Array vsanList = (Array)this.getModelValue("IVR_VSANS");
        this.setDescription("Please select end devices from selected VSANs. These will be added to a new zone and activated.\nNOTE: iSCSI hosts are excluded as they can have multiple VSAN memberships");
        this.setTitle(((ZoneMemWizard)this.getWizard()).getStepTitle(3) + TITLE);
        EndPortsTableModel model = new EndPortsTableModel(null, vsanList, false, true);
        model.updateModelData(null);
        this._portsTable.setModel(model);
        model.fireTableStructureChanged();
        HostStorageRenderer hsRend = new HostStorageRenderer();
        this._portsTable.getColumnModel().getColumn(0).setCellRenderer(hsRend);
        EndPortsTableModel sePortModel = new EndPortsTableModel(null, null, false, true);
        sePortModel.setData(new Array());
        this._selPortsTable.setModel(sePortModel);
        sePortModel.fireTableStructureChanged();
        this._selPortsTable.getColumnModel().getColumn(0).setCellRenderer(hsRend);
        this._portsTable.getColumnModel().getColumn(0).setMaxWidth(30);
        this._selPortsTable.getColumnModel().getColumn(0).setMaxWidth(30);
        this._pnl.updateTables();
        this.setModelValue("NXPORTS", null);
        try {
            Switch sw = ((Fabric)this.getModelValue("IVR_SELECTED_FABRIC")).getFirstIvrSeedSwitch();
            VarBindList activeTopology = new VarBindList();
            if (sw != null && sw.isManageable() && sw.isMDS()) {
                activeTopology = WizardCopyTopologyAction.buildActiveTopology(SmZoneUtil.getSwitchPeer(sw));
            }
            this.setModelValue("IVR_ACTIVE_TOPOLOGY_VBL", activeTopology);
        }
        catch (SnmpException ex) {
            this.doPrevious();
            Util.errorMessage((Component)this.getWizard(), ex);
            return false;
        }
        return true;
    }

    private boolean validateActiveZonesetsAndDomains(Array arSel) throws SnmpException {
        ArrayList vsans = new ArrayList();
        int portState = ZoneMemWizard.getSelectePortVsans(arSel, vsans);
        this.setModelValue("PORT_TYPE", new Integer(portState));
        if (portState == 0) {
            Util.errorMessage((Component)this.getWizard(), "Please select all FICON or non FICON ports.\nIVR will not work with a mix of FICON and non FICON ports.");
            return false;
        }
        Integer mode = (Integer)this.getModelValue("IVR_OPER_MODE");
        if (portState != 1 && mode != IvrZoneWizardController.IVR_1_MODE) {
            Util.errorMessage((Component)this.getWizard(), "IVR is supported only in non NAT & no AutoTopology mode for FICON enabled ports.\nPlease disable NAT & Autotopology and restart the wizard");
            return false;
        }
        if (vsans.size() == 1) {
            Util.errorMessage((Component)this.getWizard(), "Please select End Ports from different VSANs for IVR zoning.");
            return false;
        }
        if (!this.validateInteropNonMDSSwitches(arSel)) {
            return false;
        }
        EndPort portOne = ((IvrEndPort)arSel.elementAt(0)).getEndPort();
        if (this.getModelValue("IVR_OPER_MODE") == IvrZoneWizardController.IVR_2_MODE) {
            return true;
        }
        HashMap map = Ivr1Results.getConflictingDids(vsans);
        if (map.size() > 0) {
            StringBuffer buf = new StringBuffer();
            buf.append("The following switches do not have unique domain Ids. \n");
            for (Map.Entry obEntry : map.entrySet()) {
                Integer did = (Integer)obEntry.getKey();
                ArrayList vsanList = (ArrayList)obEntry.getValue();
                for (int k = 0; k < vsanList.size(); ++k) {
                    Vsan v = (Vsan)vsanList.get(k);
                    Switch sw = portOne.getFabric().findSwitchByVsanDomainId(v.getId(), did);
                    buf.append((sw != null ? sw.toString() : "Unknown Switch") + ": Domain Id 0x" + Integer.toHexString(did) + " in " + v + "\n");
                }
            }
            buf.append("IVR zone configuration cannot succeed.\n");
            buf.append("You can assign unique domain ids to switches from \nlogicatree/Vsan/Domain Manager.");
            Util.errorMessage((Component)this.getWizard(), buf.toString());
        }
        return map.size() == 0;
    }

    private boolean validateInteropNonMDSSwitches(Array arSel) {
        StringBuffer allNonMdsSw = new StringBuffer();
        StringBuffer nonInteropSw = new StringBuffer();
        HashMap swToVSAN = new HashMap();
        ArrayList<Vsan> ivrVsanList = new ArrayList<Vsan>();
        for (int i = 0; i < arSel.size(); ++i) {
            IvrEndPort ivrEp = (IvrEndPort)arSel.elementAt(i);
            EndPort thePort = ivrEp.getEndPort();
            Vsan vvv = ivrEp.getVsan();
            Switch sww = thePort.getSwitch();
            ArrayList<Vsan> vsanList = (ArrayList<Vsan>)swToVSAN.get(sww);
            if (vsanList == null) {
                vsanList = new ArrayList<Vsan>();
            }
            if (!vsanList.contains(vvv)) {
                vsanList.add(vvv);
            }
            if (!ivrVsanList.contains(vvv)) {
                ivrVsanList.add(vvv);
            }
            swToVSAN.put(sww, vsanList);
        }
        for (Map.Entry obEntry : swToVSAN.entrySet()) {
            Switch sw = (Switch)obEntry.getKey();
            ArrayList vsanList = (ArrayList)obEntry.getValue();
            for (int v = 0; v < vsanList.size(); ++v) {
                Vsan vv = (Vsan)vsanList.get(v);
                if (vv.getInterOperMode() == 0) continue;
                if (nonInteropSw.length() > 0) {
                    if (v % 5 == 0) {
                        nonInteropSw.append(",\n");
                    } else {
                        nonInteropSw.append(", ");
                    }
                }
                nonInteropSw.append("VSAN:" + vsanList.get(v) + " " + sw);
            }
        }
        for (int i = 0; i < ivrVsanList.size(); ++i) {
            Vsan vvv = (Vsan)ivrVsanList.get(i);
            Switch[] vsanSwitches = vvv.getSwitches();
            StringBuffer nonMdsSw = new StringBuffer();
            if (vsanSwitches != null) {
                for (int k = 0; k < vsanSwitches.length; ++k) {
                    if (vsanSwitches[k].isIvrCapable() || vsanSwitches[k].isMDS()) continue;
                    if (nonMdsSw.length() > 0) {
                        if (k % 5 == 0) {
                            nonMdsSw.append(",\n");
                        } else {
                            nonMdsSw.append(", ");
                        }
                    }
                    nonMdsSw.append(vsanSwitches[k]);
                }
            }
            if (nonMdsSw.length() <= 0) continue;
            if (allNonMdsSw.length() > 0) {
                allNonMdsSw.append(", ");
            }
            allNonMdsSw.append(nonMdsSw.toString());
        }
        StringBuffer warningMessage = new StringBuffer();
        if (nonInteropSw.length() > 0) {
            warningMessage.append("Following VSANs are configured for Interop mode.\nIt may be necessary to manually configure Domain IDs for Switch in these VSAN.\n" + nonInteropSw.toString() + "\n");
        }
        if (allNonMdsSw.length() > 0) {
            warningMessage.append("Following Switches cannot be configured for IVR.\nIt may be necessary to manually configure Domain IDs for these Switches.\n" + allNonMdsSw.toString());
        }
        if (warningMessage.length() > 0) {
            warningMessage.append("  Continue?");
            return JOptionPane.showConfirmDialog(this, warningMessage.toString(), "Domain ID Configuration" + ClientController.getInstance().getDialogFabricTitlePostfix(), 0, 2) == 0;
        }
        return true;
    }

    @Override
    public void doNext() {
        try {
            Array arSel = this._pnl.getSelectedMembers();
            if (arSel.size() == 0) {
                Util.errorMessage((Component)this, "Please select at least two End Ports.");
            } else {
                if (!this.validateActiveZonesetsAndDomains(arSel)) {
                    return;
                }
                Array arOld = (Array)this.getModelValue("NXPORTS");
                if (arOld != null) {
                    for (int i = 0; i < arSel.size(); ++i) {
                        if (-1 != arOld.findEquals(arSel.elementAt(i))) continue;
                        this.setDataValid(false);
                        break;
                    }
                }
                this.setModelValue("NXPORTS", arSel);
                super.doNext();
            }
        }
        catch (SnmpException ex) {
            Util.errorMessage((Component)this.getWizard(), ex.getMessage());
        }
    }

    boolean validateLunDiscovery() {
        Fabric fabric = (Fabric)this.getModelValue("IVR_SELECTED_FABRIC");
        long lastscanTime = fabric.getLastLunScanTime();
        if (lastscanTime == 0L || fabric.isLunInfoAgedOut()) {
            Util.errorMessage((Component)this.getWizard(), "Please discover the LUNs from File/Discover LUNs menu.");
            return false;
        }
        return true;
    }

    protected boolean validateActiveTopologyForAfid() {
        StringBuffer errBuf = new StringBuffer();
        ArrayList swZones = (ArrayList)this.getModelValue("IVR_ZONE_SWITCH_OBJECT_LIST");
        boolean b = IvrResultsPanelActionsTable.validateActiveTopologyForAfid((VarBindList)this.getModelValue("IVR_ACTIVE_TOPOLOGY_VBL"), errBuf, swZones);
        if (!b) {
            Util.errorMessage((Component)this.getWizard(), "The AFID within following VSANs are different.\nPlease correct this problem from DCNM-SAN AFID tables\nand restart the Wizard.\n" + errBuf.toString());
        }
        return b;
    }
}

