/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.zonewizard;

import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.Vsan;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class SegVsanAfid
extends JDialog
implements ActionListener {
    private FieldPanel[] _afidFd;
    private Vsan[] _vsanForLabels;
    private HashMap _segVsansMap;
    private boolean _cancelled = true;

    public SegVsanAfid(JDialog parent, HashMap segVsansMap) {
        super(parent);
        this._segVsansMap = segVsansMap;
        JTextArea notes = new JTextArea();
        notes.setWrapStyleWord(true);
        notes.setEditable(false);
        notes.setLineWrap(true);
        notes.setOpaque(false);
        notes.setFont((Font)UIManager.getDefaults().get("Table.font"));
        notes.append("Please select Autonomous Fabric Id to be assigned to following segmented VSANs.\nNOTE: The IVR may not work correctly if AFID is not properly configured.");
        String[] vsanNames = new String[segVsansMap.size()];
        this._vsanForLabels = new Vsan[segVsansMap.size()];
        this._afidFd = new FieldPanel[segVsansMap.size()];
        int k = 0;
        for (Map.Entry obEntry : segVsansMap.entrySet()) {
            vsanNames[k] = ((Vsan)obEntry.getKey()).getName();
            this._vsanForLabels[k] = (Vsan)obEntry.getKey();
            HashMap map = (HashMap)obEntry.getValue();
            int afidVal = this.assignNonConflictingAfid(this._vsanForLabels[k], map);
            this._afidFd[k] = new FieldPanel(15, afidVal, 1, 64);
            ++k;
        }
        JComponent[] labels = DialogUtil.buildLabels(vsanNames);
        JPanel mainPnl = new JPanel(new BorderLayout());
        JPanel pnl = DialogUtil.buildPanel(labels, this._afidFd);
        mainPnl.add((Component)notes, "North");
        mainPnl.add((Component)pnl, "Center");
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)mainPnl, (AbstractButton[])DialogUtil.buildButtons(new String[]{"OK", "Cancel"}, (ActionListener)this));
        this.setDefaultCloseOperation(2);
        this.setTitle("Select AFID" + ClientController.getInstance().getDialogFabricTitlePostfix());
        this.setSize(this.getWidth(), this.getHeight() + 45);
        this.setResizable(true);
        this.setModal(true);
    }

    private int assignNonConflictingAfid(Vsan v, HashMap vsanAfidMap) {
        boolean needsNewAfid = false;
        Integer refVsan = (Integer)vsanAfidMap.get(v);
        ArrayList<Integer> afidLst = new ArrayList<Integer>();
        for (Map.Entry obEntry : vsanAfidMap.entrySet()) {
            Vsan vv = (Vsan)obEntry.getKey();
            Integer vsanAfId = (Integer)obEntry.getValue();
            afidLst.add(vsanAfId);
            if (v.equals(vv) || vsanAfId.intValue() != refVsan.intValue()) continue;
            needsNewAfid = true;
        }
        if (needsNewAfid) {
            int newafid = this.getUnusedId(afidLst);
            vsanAfidMap.put(v, new Integer(newafid));
            return newafid;
        }
        return refVsan;
    }

    private int getUnusedId(ArrayList vals) {
        Collections.sort(vals);
        int id = 0;
        for (int i = 0; i < vals.size(); ++i) {
            int newVal = (Integer)vals.get(i);
            if (newVal - id > 1) {
                return newVal + 1;
            }
            id = newVal;
        }
        return id + 1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        char cmd = e.getActionCommand().charAt(0);
        switch (cmd) {
            case 'O': {
                if (!this.validateAfid()) break;
                this._cancelled = false;
                this.updateVsanMap(this._segVsansMap);
                this.dispose();
                break;
            }
            case 'C': {
                this._cancelled = true;
                this.dispose();
            }
        }
    }

    private boolean validateAfid() {
        HashMap copyMap = (HashMap)this._segVsansMap.clone();
        for (Map.Entry obEntry : this._segVsansMap.entrySet()) {
            Vsan vv = (Vsan)obEntry.getKey();
            HashMap map = (HashMap)obEntry.getValue();
            copyMap.put(vv, map.clone());
        }
        this.updateVsanMap(copyMap);
        for (int k = 0; k < this._afidFd.length; ++k) {
            int newAfid = this._afidFd[k].getInt();
            for (Map.Entry obEntry : copyMap.entrySet()) {
                Vsan vv = (Vsan)obEntry.getKey();
                HashMap map = (HashMap)obEntry.getValue();
                if (!this._vsanForLabels[k].equals(vv)) continue;
                for (Map.Entry obEntry1 : map.entrySet()) {
                    Integer vsanAfId;
                    Vsan vMap = (Vsan)obEntry1.getKey();
                    if (vMap.equals(vv) || (vsanAfId = (Integer)obEntry1.getValue()) != newAfid) continue;
                    Util.errorMessage((Component)this, "VSAN " + vv + " VSAN " + vMap + " have identical AFID.\n" + "Please specify a unique AFID.");
                    return false;
                }
            }
        }
        return true;
    }

    private boolean updateVsanMap(HashMap refMap) {
        int k;
        int newAfid = 0;
        try {
            for (k = 0; k < this._afidFd.length; ++k) {
                newAfid = this._afidFd[k].getInt();
                block3: for (Map.Entry obEntry : refMap.entrySet()) {
                    HashMap map = (HashMap)obEntry.getValue();
                    for (Map.Entry obEntry1 : map.entrySet()) {
                        Vsan vMap = (Vsan)obEntry1.getKey();
                        if (!vMap.equals(this._vsanForLabels[k])) continue;
                        map.put(vMap, new Integer(newAfid));
                        continue block3;
                    }
                }
            }
        }
        catch (NumberFormatException ex) {
            Util.errorMessage((Component)this, "Invalid AFID " + this._afidFd[k].getField().getText() + ".");
        }
        return true;
    }

    boolean isCancelled() {
        return this._cancelled;
    }
}

