/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.zonewizard;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.cat.Search;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.NpvLink;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.common.IvrEndPort;
import java.util.ArrayList;
import java.util.HashMap;

public class TVsan {
    static final int MAX_TPOINTS = 10;
    short _vsanId;
    Vsan _vsan;
    TPoint[] _tPts = new TPoint[10];
    int _numTPts;
    ArrayList _path = new ArrayList();
    private static final TVsan[] EMPTY = new TVsan[0];

    public TVsan(short vsan) {
        this._vsanId = vsan;
    }

    public TVsan(Vsan vsan) {
        this._vsan = vsan;
        this._vsanId = vsan.getId();
    }

    public ArrayList getPath() {
        return this._path;
    }

    public String check(Array nports, int allowedSwitchHops) {
        if (nports.size() == 0) {
            return null;
        }
        IvrEndPort np = (IvrEndPort)nports.elementAt(0);
        Fabric f = np.getEndPort().getFabric();
        Isl[] isls = f.getIsls();
        HashMap map = Search.buildNbrMap(isls);
        for (int i = 0; i < nports.size() - 1; ++i) {
            IvrEndPort np1 = (IvrEndPort)nports.elementAt(i);
            if (np1.getEndPort().getSwitch() == null) continue;
            for (int j = i + 1; j < nports.size(); ++j) {
                String result;
                IvrEndPort np2 = (IvrEndPort)nports.elementAt(j);
                if (np2.getEndPort().getSwitch() == null || np1.getIvrVsan() == np2.getIvrVsan() || (result = np1.getEndPort().getSwitch() == np2.getEndPort().getSwitch() ? this.check(np1, np2, np1.getEndPort().getSwitch()) : this.check(np1, np2, map, allowedSwitchHops)) == null) continue;
                return result;
            }
        }
        return null;
    }

    private String check(IvrEndPort np1, IvrEndPort np2, Switch sw) {
        if (TVsan.ivrOk(sw)) {
            this.addTPointTo(np1.getEndPort().getSwitch(), np1.getVsan());
            this.addTPointFrom(np1.getEndPort().getSwitch(), np2.getVsan());
            return null;
        }
        return sw + " is not IVR capable.";
    }

    private String check(IvrEndPort np1, IvrEndPort np2, HashMap map, int allowedSwitchHops) {
        ArrayList[] paths = Search.sortPaths(Search.search(np1.getEndPort().getSwitch(), np2.getEndPort().getSwitch(), map));
        if (paths.length == 0) {
            return "No path between " + np1 + " and " + np2;
        }
        boolean minHopsAvailable = true;
        for (int i = 0; i < paths.length; ++i) {
            String result = this.check(paths[i], np1, np2);
            if (result != null) continue;
            if (allowedSwitchHops >= paths[i].size() + 1) {
                return result;
            }
            minHopsAvailable = false;
        }
        String errorMessageMinHops = "The number of switches to be traversed for IVR exceeds minimum allowed hops " + allowedSwitchHops + ".";
        String errorMessage = "Cannot verify that VSAN " + this._vsanId + " can pass from " + np1 + " to " + np2 + ".\n Check ISLs to make sure trunking is turned on.\n" + "Check to make sure the transition switches are IVR capable.\n" + "Check that the VSAN can be created on all hops between transition points.";
        return minHopsAvailable ? errorMessage : errorMessageMinHops;
    }

    private String check(ArrayList path, int pathIndex, Vsan v1, Vsan v2, Switch currSw, int state) {
        String errMsg = null;
        if (pathIndex == path.size()) {
            if (state != 2) {
                if (!TVsan.ivrOk(currSw)) {
                    TVsan.trace(currSw + " is not IVR capable, bail");
                    errMsg = currSw + " is not IVR capable, bail";
                } else if (state == 0) {
                    this.addTPointTo(currSw, v1);
                    this.addTPointFrom(currSw, v2);
                } else if (state == 1) {
                    this.addTPointFrom(currSw, v2);
                }
            }
            return errMsg;
        }
        Isl isl = (Isl)path.get(path.size() - pathIndex - 1);
        Switch nbrSw = isl.getNbrSwitch(currSw);
        errMsg = "";
        switch (state) {
            case 0: {
                if (TVsan.isMemberOfVsan(isl, v1)) {
                    errMsg = this.check(path, pathIndex + 1, v1, v2, nbrSw, 0);
                }
                if (errMsg != null && TVsan.isMemberOfVsan(isl, v2)) {
                    if (!TVsan.ivrOk(currSw)) {
                        TVsan.trace(currSw + " is not IVR capable, bail");
                        errMsg = currSw + " is not IVR capable, bail";
                    } else {
                        errMsg = this.check(path, pathIndex + 1, v1, v2, nbrSw, 2);
                        if (errMsg == null) {
                            state = 2;
                            this.addTPointTo(currSw, v1);
                            this.addTPointFrom(currSw, v2);
                        }
                    }
                }
                if (errMsg == null) break;
                if (!TVsan.ivrOk(currSw)) {
                    TVsan.trace(currSw + " is not IVR capable, bail");
                    errMsg = currSw + " is not IVR capable, bail";
                    break;
                }
                if (isl.isTrunk()) {
                    errMsg = this.check(path, pathIndex + 1, v1, v2, nbrSw, 1);
                    if (errMsg != null) break;
                    state = 1;
                    this.addTPointTo(currSw, v1);
                    break;
                }
                TVsan.trace(isl + " is not in trunking mode");
                errMsg = isl + " is not in trunking mode";
                break;
            }
            case 1: {
                if (TVsan.isMemberOfVsan(isl, v2)) {
                    if (!TVsan.ivrOk(currSw)) {
                        TVsan.trace(currSw + " is not IVR capable, bail.");
                        errMsg = currSw + " is not IVR capable, bail.";
                    } else {
                        errMsg = this.check(path, pathIndex + 1, v1, v2, nbrSw, 2);
                        if (errMsg == null) {
                            state = 2;
                            this.addTPointFrom(currSw, v2);
                        }
                    }
                }
                if (errMsg == null) break;
                if (isl.isTrunk()) {
                    errMsg = this.check(path, pathIndex + 1, v1, v2, nbrSw, 1);
                    break;
                }
                TVsan.trace(isl + " is not in trunking mode");
                errMsg = isl + " is not in trunking mode";
                break;
            }
            case 2: {
                if (!TVsan.isMemberOfVsan(isl, v2)) {
                    TVsan.trace("Got case of SRC -> TVSAN -> DEST -> !DEST, bail");
                    errMsg = "Couldn't find a single common VSAN";
                    break;
                }
                errMsg = this.check(path, pathIndex + 1, v1, v2, nbrSw, 2);
            }
        }
        return errMsg;
    }

    private String check(ArrayList path, IvrEndPort np1, IvrEndPort np2) {
        Vsan v1 = np1.getVsan();
        Vsan v2 = np2.getVsan();
        Switch start = np1.getEndPort().getSwitch();
        return this.check(path, 0, v1, v2, start, 0);
    }

    public short getVsanId() {
        return this._vsanId;
    }

    public Vsan getVsan() {
        return this._vsan;
    }

    public int getNumTPoints() {
        return this._numTPts;
    }

    private TPoint getTPoint(int i) {
        return this._tPts[i];
    }

    public Switch getTPointSwitch(int i) {
        return this._tPts[i]._s;
    }

    public Vsan getTPointInVsan(int i) {
        return this._tPts[i]._inVsan;
    }

    public short getTPointInVsanId(int i) {
        if (this._tPts[i]._inVsan == null) {
            return this._tPts[i]._inVsanId;
        }
        return (short)this._tPts[i]._inVsan.getVsanId();
    }

    public Vsan getTPointOutVsan(int i) {
        return this._tPts[i]._outVsan;
    }

    public short getTPointOutVsanId(int i) {
        if (this._tPts[i]._outVsan == null) {
            return this._tPts[i]._outVsanId;
        }
        return (short)this._tPts[i]._outVsan.getVsanId();
    }

    private void addTPointTo(Switch s, Vsan v) {
        if (this._vsan == null) {
            this.addTPoint(s, v, this._vsanId);
        } else {
            this.addTPoint(s, v, this._vsan);
        }
    }

    private void addTPointTo(Switch s, short v) {
        if (this._vsan == null) {
            this.addTPoint(s, v, this._vsanId);
        } else {
            this.addTPoint(s, v, this._vsan);
        }
    }

    private void addTPointFrom(Switch s, Vsan v) {
        if (this._vsan == null) {
            this.addTPoint(s, this._vsanId, v);
        } else {
            this.addTPoint(s, this._vsan, v);
        }
    }

    private void addTPointFrom(Switch s, short v) {
        if (this._vsan == null) {
            this.addTPoint(s, this._vsanId, v);
        } else {
            this.addTPoint(s, this._vsan, v);
        }
    }

    private void addTPoint(Switch s, Vsan inv, Vsan outv) {
        if (inv == outv) {
            return;
        }
        TPoint tpt = new TPoint(s);
        if (inv.getVsanId() > outv.getVsanId()) {
            Vsan tmp = inv;
            inv = outv;
            outv = tmp;
        }
        tpt._inVsan = inv;
        tpt._outVsan = outv;
        this.addTPoint(tpt);
    }

    private void addTPoint(Switch s, short inv, Vsan outv) {
        if (inv == outv.getVsanId()) {
            return;
        }
        TPoint tpt = new TPoint(s);
        if (inv > outv.getVsanId()) {
            tpt._inVsan = outv;
            tpt._outVsanId = inv;
        } else {
            tpt._inVsanId = inv;
            tpt._outVsan = outv;
        }
        this.addTPoint(tpt);
    }

    private void addTPoint(Switch s, Vsan inv, short outv) {
        if (outv == inv.getVsanId()) {
            return;
        }
        TPoint tpt = new TPoint(s);
        if (inv.getVsanId() > outv) {
            tpt._inVsanId = outv;
            tpt._outVsan = inv;
        } else {
            tpt._inVsan = inv;
            tpt._outVsanId = outv;
        }
        this.addTPoint(tpt);
    }

    private void addTPoint(Switch s, short inv, short outv) {
        if (inv == outv) {
            return;
        }
        if (inv > outv) {
            short tmp = inv;
            inv = outv;
            outv = tmp;
        }
        TPoint tpt = new TPoint(s);
        tpt._inVsanId = inv;
        tpt._outVsanId = outv;
        this.addTPoint(tpt);
    }

    private void addTPoint(TPoint tpt) {
        for (int i = 0; i < this._numTPts; ++i) {
            if (!TVsan.same(this._tPts[i], tpt)) continue;
            return;
        }
        if (this._numTPts == this._tPts.length) {
            TPoint[] newTpts = new TPoint[this._tPts.length + 10];
            System.arraycopy(this._tPts, 0, newTpts, 0, this._tPts.length);
            this._tPts = newTpts;
        }
        this._tPts[this._numTPts++] = tpt;
    }

    private void addTPoints(TVsan tv) {
        for (int i = 0; i < tv.getNumTPoints(); ++i) {
            boolean dup = false;
            Switch s = tv.getTPointSwitch(i);
            for (int j = 0; j < this.getNumTPoints(); ++j) {
                if (!TVsan.same(this.getTPoint(j), tv.getTPoint(i))) continue;
                dup = true;
                break;
            }
            if (dup) continue;
            if (this._vsan != null) {
                if (tv.getTPointInVsan(i) != null) {
                    if (this._vsan != tv.getTPointInVsan(i)) {
                        this.addTPointTo(s, tv.getTPointInVsan(i));
                        continue;
                    }
                    this.addTPointFrom(s, tv.getTPointInVsan(i));
                    continue;
                }
                if (this._vsan.getVsanId() != tv.getTPointInVsanId(i)) {
                    this.addTPointTo(s, tv.getTPointInVsanId(i));
                    continue;
                }
                this.addTPointFrom(s, tv.getTPointInVsanId(i));
                continue;
            }
            if (tv.getTPointInVsan(i) != null) {
                if (this._vsanId != tv.getTPointInVsan(i).getVsanId()) {
                    this.addTPointTo(s, tv.getTPointInVsan(i));
                    continue;
                }
                this.addTPointFrom(s, tv.getTPointInVsan(i));
                continue;
            }
            if (this._vsanId != tv.getTPointInVsanId(i)) {
                this.addTPointTo(s, tv.getTPointInVsanId(i));
                continue;
            }
            this.addTPointFrom(s, tv.getTPointInVsanId(i));
        }
    }

    private static boolean same(TPoint t1, TPoint t2) {
        if (t1._s == t2._s) {
            boolean b1 = false;
            boolean b2 = false;
            if (t1._inVsan != null && t2._inVsan != null) {
                b1 = t1._inVsan == t2._inVsan;
            } else if (t1._inVsan == null && t2._inVsan == null) {
                b1 = t1._inVsanId == t2._inVsanId;
            } else if (t1._inVsan == null) {
                b1 = t1._inVsanId == t2._inVsan.getVsanId();
            } else {
                boolean bl = b1 = t1._inVsan.getVsanId() == t2._inVsanId;
            }
            if (t1._outVsan != null && t2._outVsan != null) {
                b2 = t1._outVsan == t2._outVsan;
            } else if (t1._outVsan == null && t2._outVsan == null) {
                b2 = t1._outVsanId == t2._outVsanId;
            } else if (t1._outVsan == null) {
                b2 = t1._outVsanId == t2._outVsan.getVsanId();
            } else {
                boolean bl = b2 = t1._outVsan.getVsanId() == t2._outVsanId;
            }
            if (b1 && b2) {
                return true;
            }
        }
        return false;
    }

    public static TVsan[] getTVsans(Array nports) {
        TVsan[] tvs = null;
        if (nports.size() == 0) {
            return EMPTY;
        }
        IvrEndPort np = (IvrEndPort)nports.elementAt(0);
        Fabric f = np.getEndPort().getFabric();
        Isl[] isls = f.getIsls();
        NpvLink[] npvLinks = f.getNpvLinks();
        HashMap map = Search.buildNbrMap(isls);
        Search.buildNpvNbrMap(map, npvLinks);
        for (int i = 0; i < nports.size() - 1; ++i) {
            IvrEndPort np1 = (IvrEndPort)nports.elementAt(i);
            if (np1.getEndPort().getSwitch() == null) continue;
            for (int j = i + 1; j < nports.size(); ++j) {
                TVsan[] pathTvs;
                IvrEndPort np2 = (IvrEndPort)nports.elementAt(j);
                if (np2.getEndPort().getSwitch() == null || np1.getVsan() == np2.getVsan()) continue;
                if (np1.getEndPort().getSwitch() == np2.getEndPort().getSwitch()) {
                    if (!TVsan.ivrOk(np1.getEndPort().getSwitch())) {
                        TVsan.trace(np1.getEndPort().getSwitch() + " not IVR capable.");
                        pathTvs = EMPTY;
                    } else {
                        pathTvs = TVsan.getTVsans(np1.getEndPort().getSwitch(), np1.getVsan(), np2.getVsan());
                    }
                } else {
                    pathTvs = TVsan.getTVsans(np1.getEndPort().getSwitch(), np2.getEndPort().getSwitch(), np1.getVsan(), np2.getVsan(), map);
                }
                TVsan.trace("Pair - " + np1 + " and " + np2);
                TVsan.trace("Got " + pathTvs.length + " transition VSANs.");
                tvs = tvs == null ? pathTvs : TVsan.intersect(tvs, pathTvs);
                if (tvs.length != 0) continue;
                return tvs;
            }
        }
        if (tvs == null) {
            return EMPTY;
        }
        return tvs;
    }

    private static void trace(String msg) {
        System.out.println(msg);
        DefaultLogger._DefLogger.error((Object)msg);
    }

    private static TVsan[] getTVsans(Switch s, Vsan v1, Vsan v2) {
        Fabric f = s.getFabric();
        Vsan[] vsans = s.getVsans();
        int len = s.getNumVsans();
        TVsan[] tvs = new TVsan[len];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            if (vsans[i] == null || !vsans[i].isUp()) continue;
            tvs[j] = new TVsan(vsans[i]);
            if (vsans[i].equals(v1) || vsans[i].equals(v2)) {
                tvs[j].addTPoint(s, v1, v2);
            } else {
                tvs[j].addTPointTo(s, v1);
                tvs[j].addTPointFrom(s, v2);
            }
            ++j;
        }
        TVsan[] retTvs = new TVsan[j];
        System.arraycopy(tvs, 0, retTvs, 0, j);
        return retTvs;
    }

    private static TVsan[] getTVsans(Switch s1, Switch s2, Vsan v1, Vsan v2, HashMap map) {
        ArrayList[] paths = Search.sortPaths(Search.search(s1, s2, map));
        TVsan[] tvs = new TVsan[]{};
        for (int i = 0; i < paths.length; ++i) {
            TVsan[] ptvs = TVsan.getTVsans(paths[i], s1, s2, v1, v2);
            tvs = TVsan.union(tvs, ptvs);
        }
        return tvs;
    }

    private static TVsan[] getTVsans(ArrayList path, int pathIndex, Vsan v1, Vsan v2, Switch currSw, int state, TVsan[] tvs) {
        TVsan[] retTvs = EMPTY;
        if (pathIndex == path.size()) {
            if (state == 2) {
                retTvs = tvs;
            } else if (!TVsan.ivrOk(currSw)) {
                TVsan.trace(currSw + " is not IVR capable, bail");
                retTvs = EMPTY;
            } else if (state == 0) {
                retTvs = TVsan.getTVsans(currSw, v1, v2);
            } else if (state == 1) {
                for (int i = 0; i < tvs.length; ++i) {
                    tvs[i].addTPointFrom(currSw, v2);
                }
                retTvs = tvs;
            }
            return retTvs;
        }
        Object linkOb = path.get(path.size() - pathIndex - 1);
        boolean isNpv = linkOb instanceof NpvLink;
        Switch nbrSw = isNpv ? ((NpvLink)linkOb).getNbrSwitch(currSw) : ((Isl)linkOb).getNbrSwitch(currSw);
        Vsan[] vs = isNpv ? ((NpvLink)linkOb).getVsans() : ((Isl)linkOb).getVsans();
        switch (state) {
            case 0: {
                if (TVsan.isMemberOfVsan(linkOb, v1)) {
                    retTvs = TVsan.getTVsans(path, pathIndex + 1, v1, v2, nbrSw, 0, tvs);
                }
                if (retTvs.length == 0 && TVsan.isMemberOfVsan(linkOb, v2)) {
                    if (!TVsan.ivrOk(currSw)) {
                        TVsan.trace(currSw + " is not IVR capable, bail");
                        retTvs = EMPTY;
                    } else {
                        tvs = TVsan.getTVsans(currSw, v1, v2);
                        retTvs = TVsan.getTVsans(path, pathIndex + 1, v1, v2, nbrSw, 2, tvs);
                        state = 2;
                    }
                }
                if (retTvs.length != 0) break;
                if (!TVsan.ivrOk(currSw)) {
                    TVsan.trace(currSw + " is not IVR capable, bail");
                    retTvs = EMPTY;
                    break;
                }
                int k = 0;
                tvs = new TVsan[vs.length];
                for (int j = 0; j < vs.length; ++j) {
                    if (vs[j] == v1 || vs[j] == v2) continue;
                    tvs[k] = new TVsan(vs[j]);
                    tvs[k]._path = path;
                    tvs[k++].addTPointTo(currSw, v1);
                }
                tvs = TVsan.compact(tvs, k);
                retTvs = TVsan.getTVsans(path, pathIndex + 1, v1, v2, nbrSw, 1, tvs);
                state = 1;
                break;
            }
            case 1: {
                if (TVsan.isMemberOfVsan(linkOb, v2)) {
                    if (!TVsan.ivrOk(currSw)) {
                        TVsan.trace(currSw + " is not IVR capable, bail");
                        retTvs = EMPTY;
                    } else {
                        retTvs = TVsan.getTVsans(path, pathIndex + 1, v1, v2, nbrSw, 2, tvs);
                        if (retTvs.length != 0) {
                            for (int j = 0; j < tvs.length; ++j) {
                                tvs[j].addTPointFrom(currSw, v2);
                            }
                            state = 2;
                        }
                    }
                }
                if (retTvs.length != 0) break;
                retTvs = TVsan.getTVsans(path, pathIndex + 1, v1, v2, nbrSw, 1, TVsan.intersect(tvs, vs));
                break;
            }
            case 2: {
                retTvs = !TVsan.isMemberOfVsan(linkOb, v2) ? EMPTY : TVsan.getTVsans(path, pathIndex + 1, v1, v2, nbrSw, 2, tvs);
            }
        }
        return retTvs;
    }

    private static TVsan[] getTVsans(ArrayList path, Switch s1, Switch s2, Vsan v1, Vsan v2) {
        TVsan.trace("Switch " + s1 + "/" + v1 + " " + s2 + "/" + v2);
        return TVsan.getTVsans(path, 0, v1, v2, s1, 0, EMPTY);
    }

    private static final short[] compact(short[] elems, int len) {
        short[] ret = new short[len];
        System.arraycopy(elems, 0, ret, 0, len);
        return ret;
    }

    private static int[] compact(int[] elems, int len) {
        int[] ret = new int[len];
        System.arraycopy(elems, 0, ret, 0, len);
        return ret;
    }

    private static final TVsan[] compact(TVsan[] elems, int len) {
        TVsan[] ret = new TVsan[len];
        System.arraycopy(elems, 0, ret, 0, len);
        return ret;
    }

    private static TVsan[] union(TVsan[] tv1, TVsan[] tv2) {
        int i = tv2.length;
        TVsan[] rtv = new TVsan[tv1.length + tv2.length];
        System.arraycopy(tv2, 0, rtv, 0, tv2.length);
        for (int j = 0; j < tv1.length; ++j) {
            boolean repeat = false;
            for (int k = 0; k < tv2.length; ++k) {
                if (tv1[j].getVsanId() != tv2[k].getVsanId()) continue;
                if (tv1[j]._path.size() > tv2[k]._path.size()) {
                    tv1[j].addTPoints(tv2[k]);
                } else {
                    tv2[k].addTPoints(tv1[j]);
                    tv2[k]._path = tv1[j]._path;
                }
                repeat = true;
                break;
            }
            if (repeat) continue;
            rtv[i++] = tv1[j];
        }
        return TVsan.compact(rtv, i);
    }

    private static TVsan[] intersect(TVsan[] tv1, TVsan[] tv2) {
        int i = 0;
        TVsan[] rtv = new TVsan[tv1.length];
        block0: for (int j = 0; j < tv1.length; ++j) {
            for (int k = 0; k < tv2.length; ++k) {
                if (tv1[j].getVsanId() != tv2[k].getVsanId()) continue;
                tv1[j].addTPoints(tv2[k]);
                rtv[i++] = tv1[j];
                continue block0;
            }
        }
        return TVsan.compact(rtv, i);
    }

    private static TVsan[] intersect(TVsan[] tv, short[] vs) {
        int i = 0;
        TVsan[] rtv = new TVsan[tv.length];
        block0: for (int j = 0; j < tv.length; ++j) {
            for (int k = 0; k < vs.length; ++k) {
                if (tv[j].getVsanId() != vs[k]) continue;
                rtv[i++] = tv[j];
                continue block0;
            }
        }
        return TVsan.compact(rtv, i);
    }

    private static TVsan[] intersect(TVsan[] tv, Vsan[] vs) {
        int i = 0;
        TVsan[] rtv = new TVsan[tv.length];
        block0: for (int j = 0; j < tv.length; ++j) {
            for (int k = 0; k < vs.length; ++k) {
                if ((tv[j].getVsan() == null || tv[j].getVsan() != vs[k]) && tv[j].getVsanId() != vs[k].getVsanId()) continue;
                rtv[i++] = tv[j];
                continue block0;
            }
        }
        return TVsan.compact(rtv, i);
    }

    private static int[] intersect(int[] elems1, int[] elems2) {
        int[] elems = new int[elems1.length];
        int len = 0;
        for (int i = 0; i < elems1.length; ++i) {
            boolean b = false;
            for (int j = 0; j < elems2.length; ++j) {
                b = b || elems1[i] == elems2[j];
            }
            if (!b) continue;
            elems[len++] = elems1[i];
        }
        return TVsan.compact(elems, len);
    }

    private static int[] union(int[] elems1, int[] elems2) {
        int[] elems = new int[elems1.length + elems2.length];
        System.arraycopy(elems1, 0, elems, 0, elems1.length);
        int len = elems1.length;
        for (int i = 0; i < elems2.length; ++i) {
            boolean b = false;
            for (int j = 0; j < elems1.length; ++j) {
                b = b || elems2[i] == elems1[j];
            }
            if (b) continue;
            elems[len++] = elems2[i];
        }
        return TVsan.compact(elems, len);
    }

    private static boolean ivrOk(Switch s) {
        return s != null && s.isManageable() && s.isIvrCapable();
    }

    private static boolean isMemberOfVsan(Object isl, Vsan v) {
        boolean isNpv = isl instanceof NpvLink;
        return isNpv ? ((NpvLink)isl).isMemberOfVsan(v.getVsanId()) : ((Isl)isl).isMemberOfVsan(v.getVsanId());
    }

    class TPoint {
        Switch _s;
        Vsan _inVsan;
        Vsan _outVsan;
        short _inVsanId;
        short _outVsanId;

        TPoint(Switch s) {
            this._s = s;
        }
    }
}

