/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.zonewizard;

import com.cisco.dcbu.lib.mds.zm.IvrZoneSwitch;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.zonewizard.IvrZoneWizardController;
import com.cisco.dcbu.sm.client.zm.zonewizard.ZoneMemWizard;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

class VsanPeerPanel
extends WizardPanel
implements ItemListener {
    private static final String VSAN_ZONE_HEADING = "Select Zoning Type";
    private JComboBox _switchCb;
    private JComboBox _vsanCb;
    private Vsan _preSelectedVsan;

    VsanPeerPanel(JWizard wiz) {
        super("", "", wiz, IvrZoneWizardController.IMAGE_ZONE);
        this.setTitle(((ZoneMemWizard)this.getWizard()).getStepTitle(1) + VSAN_ZONE_HEADING);
        this.buildControls();
        this.refresh();
        this.setDataValid(true);
    }

    VsanPeerPanel(JWizard wiz, Vsan selectedVsan) {
        super("", "", wiz, IvrZoneWizardController.IMAGE_ZONE);
        this.setTitle(((ZoneMemWizard)this.getWizard()).getStepTitle(1) + VSAN_ZONE_HEADING);
        this.buildControls();
        this._preSelectedVsan = selectedVsan;
        this.refresh();
        this.setDataValid(true);
    }

    private void buildControls() {
        this._vsanCb = new JComboBox();
        this._vsanCb.addItemListener(this);
        this._switchCb = new JComboBox();
        this._switchCb.addItemListener(this);
        JPanel p = new JPanel(new GridBagLayout());
        DialogUtil.buildPanel(p, DialogUtil.buildLabels(new String[]{"VSAN:", "Switch:"}), new JComponent[]{this._vsanCb, this._switchCb});
        this.add((Component)p, "Center");
    }

    @Override
    public boolean refresh() {
        this.updateVsanList((Fabric)this.getModelValue("IVR_SELECTED_FABRIC"));
        this.updateSwitchList();
        return true;
    }

    void updateVsanList(Fabric fa) {
        Object[] vsans = fa.getVsans();
        Arrays.sort(vsans);
        this._vsanCb.setModel(new DefaultComboBoxModel<Object>(vsans));
        if (this._preSelectedVsan != null) {
            this._vsanCb.setSelectedItem(this._preSelectedVsan);
            this._preSelectedVsan = null;
        }
    }

    void updateSwitchList() {
        Vsan v = (Vsan)this._vsanCb.getSelectedItem();
        Switch[] sws = v.getSwitches();
        ArrayList<Switch> swLst = new ArrayList<Switch>();
        if (sws != null) {
            for (int i = 0; i < sws.length; ++i) {
                if (!sws[i].isManageable() || !sws[i].isMDS()) continue;
                swLst.add(sws[i]);
            }
        }
        Object[] sw = swLst.toArray();
        Arrays.sort(sw);
        this._switchCb.setModel(new DefaultComboBoxModel<Object>(sw));
        this._switchCb.setSelectedItem(v.getPrincipalSwitch().isMDS() ? v.getPrincipalSwitch() : v.getSeedSwitch());
    }

    @Override
    public void doNext() {
        ArrayList swLst = (ArrayList)this.getModelValue("IVR_ZONE_SWITCH_OBJECT_LIST");
        if (IvrZoneSwitch.getIvrSwitches(swLst, false).size() == 0) {
            Util.errorMessage((Component)this.getWizard(), "There are no IVR capable switches in fabric.");
            return;
        }
        super.doNext();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        int state = e.getStateChange();
        Object selOb = e.getSource();
        if (state == 1 && selOb == this._vsanCb) {
            this.updateSwitchList();
        }
    }
}

