/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.cfgdiffEngine;

import com.cisco.dcbu.sm.common.cfgdiffEngine.CfgCommand;
import com.cisco.dcbu.sm.common.cfgdiffEngine.CfgCommandInfo;
import com.cisco.dcbu.sm.common.cfgdiffEngine.CfgDiffHelper;
import com.cisco.dcbu.sm.common.cfgdiffEngine.CfgDiffModelHelper;
import com.cisco.dcbu.sm.common.cfgdiffEngine.CommandState;
import com.cisco.dcbu.sm.common.cfgdiffEngine.ConfigFile;
import com.cisco.dcbu.sm.common.cfgdiffEngine.FilterMethods;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CfgDiffEngine {
    private Map<ConfigFile, List<List<CfgCommand>>> resultMap = new HashMap<ConfigFile, List<List<CfgCommand>>>();
    private Map<String, List<CfgCommandInfo>> modeCmdLookupMap = new ConcurrentHashMap<String, List<CfgCommandInfo>>();
    public static final char SPACE = ' ';
    private boolean throw_exception_on_diff = false;
    private static final String ROLLBACK_CMD_PREFIX = "!#";
    private static final String TEXTUAL_CMD_PREFIX = "!";
    HashMap methodsByName = new HashMap();

    private Integer getInitialSpacesCount(String command) {
        String[] ss = command.split(" ");
        List<String> tokenList = Arrays.asList(ss);
        int count = 0;
        for (String token : tokenList) {
            if (token.length() == 0) {
                ++count;
                continue;
            }
            for (int i = 0; i < token.length(); ++i) {
                if (token.charAt(i) != '\t') continue;
                count += 8;
            }
        }
        return count;
    }

    public CfgDiffEngine() {
        this.methodsByName.clear();
        Method[] methods = FilterMethods.class.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            this.methodsByName.put(methods[i].getName(), methods[i]);
        }
    }

    private CfgCommandInfo getParentCommand(Integer spaces, Map<Integer, CfgCommandInfo> lastIntendedCmds) {
        CfgCommandInfo cmd = lastIntendedCmds.get(spaces - 1);
        if (cmd == null) {
            return this.getParentCommand(spaces - 1, lastIntendedCmds);
        }
        return cmd;
    }

    private Boolean isSubCmd(String line) {
        if (line != null && line.length() > 0 && (line.charAt(0) == ' ' || line.charAt(0) == '\t')) {
            return true;
        }
        return false;
    }

    private boolean isFilteredCommand(CfgCommandInfo cmd, Object[][] key) {
        boolean isFilteredCmd = false;
        if (key != null && key.length >= 1 && key[0] != null && key[0].length >= 2 && key[0][1] != null) {
            block0: for (int i = 0; i < key.length; ++i) {
                Object[] indKey = key[i];
                for (int k = 1; k < indKey.length - 1; ++k) {
                    if (!cmd.getCommand().getCommandLine().trim().startsWith((String)indKey[k])) continue;
                    isFilteredCmd = true;
                    continue block0;
                }
            }
        } else {
            return true;
        }
        return isFilteredCmd;
    }

    public List<CfgCommandInfo> parseConfigFile(InputStream inputStream, ConfigFile fileInfo, Object[][] filter, ArrayList categories) throws Exception {
        ArrayList<CfgCommandInfo> list = new ArrayList<CfgCommandInfo>();
        CfgCommandInfo cmd = null;
        CfgCommandInfo prevCmd = null;
        CfgCommandInfo lastEmptyCmd = null;
        HashMap<Integer, CfgCommandInfo> lastIntendedCmds = new HashMap<Integer, CfgCommandInfo>();
        int count = 1;
        int value = -2;
        StringBuffer cmdBuffer = new StringBuffer();
        while (value != -1) {
            int spaces;
            int temp = inputStream.read();
            if (value == -2 && temp == -1) break;
            value = temp;
            if (value != 10 && value != -1) {
                if (value == 13) continue;
                cmdBuffer.append((char)value);
                continue;
            }
            String line = cmdBuffer.toString();
            String trimmedline = line.trim();
            if (trimmedline.startsWith(ROLLBACK_CMD_PREFIX) || trimmedline.startsWith(TEXTUAL_CMD_PREFIX)) {
                cmdBuffer = new StringBuffer();
                continue;
            }
            if (trimmedline.length() == 0) continue;
            int idx = 0;
            if (trimmedline.length() == 0) {
                cmd = new CfgCommandInfo();
                cmd.setParentCmd(null);
                CfgDiffModelHelper.setCommand(cmd, line);
                cmd.setState(CommandState.EMPTYLINE);
                cmd.setFileInfo(fileInfo);
                if (prevCmd != null && lastEmptyCmd == null) {
                    cmd.setPosition(count++);
                    cmd.setParentCmd(prevCmd);
                    CfgDiffModelHelper.addSubCommand(prevCmd, cmd);
                    prevCmd.setLastCmdPosition(count);
                    lastEmptyCmd = cmd;
                }
                cmdBuffer = new StringBuffer();
                continue;
            }
            lastEmptyCmd = null;
            if (line.charAt(idx) != ' ' && line.charAt(idx) != '\t') {
                String thresholdStringToken;
                if (prevCmd != null && prevCmd.getLastCmdPosition() == -1) {
                    prevCmd.setLastCmdPosition(count);
                }
                cmd = new CfgCommandInfo();
                cmd.setParentCmd(null);
                CfgDiffModelHelper.setCommand(cmd, line);
                if (trimmedline.startsWith("no") || trimmedline.startsWith("default")) {
                    String firstToken = CfgDiffModelHelper.getFirstNonEmptyToken(cmd);
                    if (firstToken.toLowerCase().equals("no")) {
                        cmd.setNoCmd(true);
                        CfgDiffModelHelper.removeToken(cmd, firstToken);
                    } else if (firstToken.toLowerCase().equals("default")) {
                        cmd.setDfltCmd(true);
                        CfgDiffModelHelper.removeToken(cmd, firstToken);
                    }
                }
                if ((thresholdStringToken = CfgDiffModelHelper.getThresholdString(cmd)) != null && thresholdStringToken.length() > 0) {
                    List<CfgCommandInfo> cmdList;
                    if (!categories.contains(thresholdStringToken)) {
                        categories.add(thresholdStringToken);
                    }
                    if ((cmdList = this.modeCmdLookupMap.get(thresholdStringToken)) == null) {
                        cmdList = new ArrayList<CfgCommandInfo>();
                        this.modeCmdLookupMap.put(thresholdStringToken, cmdList);
                    }
                    cmdList.add(cmd);
                }
                cmd.setPosition(count++);
                cmd.setFileInfo(fileInfo);
                list.add(cmd);
                lastIntendedCmds.clear();
                prevCmd = cmd;
            } else if (this.isSubCmd(line).booleanValue()) {
                spaces = this.getInitialSpacesCount(line);
                cmd = this.getParentCommand(spaces, lastIntendedCmds);
                CfgCommandInfo subCmd = new CfgCommandInfo();
                subCmd.setParentCmd(cmd);
                subCmd.setFileInfo(fileInfo);
                CfgDiffModelHelper.setCommand(subCmd, line);
                if (trimmedline.startsWith("no") || trimmedline.startsWith("default")) {
                    String firstToken = CfgDiffModelHelper.getFirstNonEmptyToken(subCmd);
                    if (firstToken.toLowerCase().equals("no")) {
                        subCmd.setNoCmd(true);
                        CfgDiffModelHelper.removeToken(subCmd, firstToken);
                    } else if (firstToken.toLowerCase().equals("default")) {
                        subCmd.setDfltCmd(true);
                        CfgDiffModelHelper.removeToken(subCmd, firstToken);
                    }
                }
                CfgDiffModelHelper.addSubCommand(cmd, subCmd);
                subCmd.setLastCmdPosition(count);
                subCmd.setPosition(count++);
                cmd = subCmd;
            }
            spaces = this.getInitialSpacesCount(CfgDiffModelHelper.getCommand(cmd));
            CfgCommandInfo lastCmd = (CfgCommandInfo)lastIntendedCmds.get(spaces);
            if (lastCmd != null) {
                lastCmd.setLastCmdPosition(count - 1);
            }
            lastIntendedCmds.put(spaces, cmd);
            Set keySet = lastIntendedCmds.keySet();
            if (keySet.size() > 1) {
                ArrayList<Integer> toRemoveList = new ArrayList<Integer>();
                for (Integer space : keySet) {
                    if (space <= spaces) continue;
                    toRemoveList.add(space);
                }
                for (Integer i : toRemoveList) {
                    lastIntendedCmds.remove(i);
                }
            }
            cmdBuffer = new StringBuffer();
        }
        if (prevCmd != null && prevCmd.getLastCmdPosition() == -1) {
            prevCmd.setLastCmdPosition(count);
        }
        return list;
    }

    public List<CfgCommandInfo> parseConfigFile(Reader reader, ConfigFile fileInfo) throws Exception {
        ArrayList<CfgCommandInfo> list = new ArrayList<CfgCommandInfo>();
        CfgCommandInfo cmd = null;
        CfgCommandInfo prevCmd = null;
        Object lastEmptyCmd = null;
        HashMap<Integer, CfgCommandInfo> lastIntendedCmds = new HashMap<Integer, CfgCommandInfo>();
        int count = 1;
        int value = -2;
        StringBuffer cmdBuffer = new StringBuffer();
        while (value != -1) {
            int spaces;
            int temp = reader.read();
            if (value == -2 && temp == -1) break;
            value = temp;
            if (value != 10 && value != -1) {
                cmdBuffer.append((char)value);
                continue;
            }
            String line = cmdBuffer.toString();
            if (line.trim().startsWith(ROLLBACK_CMD_PREFIX) || line.trim().startsWith(TEXTUAL_CMD_PREFIX)) {
                cmdBuffer = new StringBuffer();
                continue;
            }
            if (line.length() == 0) {
                line = " ";
            }
            if (line.endsWith("\r")) {
                line = line.replace("\r", "");
            }
            int idx = 0;
            if (line.trim().length() == 0) {
                cmdBuffer = new StringBuffer();
                continue;
            }
            lastEmptyCmd = null;
            if (line.charAt(idx) != ' ' && line.charAt(idx) != '\t') {
                if (prevCmd != null && prevCmd.getLastCmdPosition() == -1) {
                    prevCmd.setLastCmdPosition(count);
                }
                cmd = new CfgCommandInfo();
                cmd.setParentCmd(null);
                CfgDiffModelHelper.setCommand(cmd, line);
                if (line.trim().startsWith("no") || line.trim().startsWith("default")) {
                    String firstToken = CfgDiffModelHelper.getFirstNonEmptyToken(cmd);
                    if (firstToken.toLowerCase().equals("no")) {
                        cmd.setNoCmd(true);
                        CfgDiffModelHelper.removeToken(cmd, firstToken);
                    } else if (firstToken.toLowerCase().equals("default")) {
                        cmd.setDfltCmd(true);
                        CfgDiffModelHelper.removeToken(cmd, firstToken);
                    }
                }
                String thresholdStringToken = CfgDiffModelHelper.getThresholdString(cmd);
                if (ConfigFile.RIGHT.equals(fileInfo) && thresholdStringToken != null && thresholdStringToken.length() > 0) {
                    List<CfgCommandInfo> cmdList = this.modeCmdLookupMap.get(thresholdStringToken);
                    if (cmdList == null) {
                        cmdList = new ArrayList<CfgCommandInfo>();
                        this.modeCmdLookupMap.put(thresholdStringToken, cmdList);
                    }
                    cmdList.add(cmd);
                }
                cmd.setPosition(count++);
                cmd.setFileInfo(fileInfo);
                list.add(cmd);
                lastIntendedCmds.clear();
                prevCmd = cmd;
            } else if (this.isSubCmd(line).booleanValue()) {
                spaces = this.getInitialSpacesCount(line);
                cmd = this.getParentCommand(spaces, lastIntendedCmds);
                CfgCommandInfo subCmd = new CfgCommandInfo();
                subCmd.setParentCmd(cmd);
                subCmd.setFileInfo(fileInfo);
                CfgDiffModelHelper.setCommand(subCmd, line);
                if (line.trim().startsWith("no") || line.trim().startsWith("default")) {
                    String firstToken = CfgDiffModelHelper.getFirstNonEmptyToken(subCmd);
                    if (firstToken.toLowerCase().equals("no")) {
                        subCmd.setNoCmd(true);
                        CfgDiffModelHelper.removeToken(subCmd, firstToken);
                    } else if (firstToken.toLowerCase().equals("default")) {
                        subCmd.setDfltCmd(true);
                        CfgDiffModelHelper.removeToken(subCmd, firstToken);
                    }
                }
                CfgDiffModelHelper.addSubCommand(cmd, subCmd);
                subCmd.setLastCmdPosition(count);
                subCmd.setPosition(count++);
                cmd = subCmd;
            }
            spaces = this.getInitialSpacesCount(CfgDiffModelHelper.getCommand(cmd));
            CfgCommandInfo lastCmd = (CfgCommandInfo)lastIntendedCmds.get(spaces);
            if (lastCmd != null) {
                lastCmd.setLastCmdPosition(count - 1);
            }
            lastIntendedCmds.put(spaces, cmd);
            Set keySet = lastIntendedCmds.keySet();
            if (keySet.size() > 1) {
                ArrayList<Integer> toRemoveList = new ArrayList<Integer>();
                for (Integer space : keySet) {
                    if (space <= spaces) continue;
                    toRemoveList.add(space);
                }
                for (Integer i : toRemoveList) {
                    lastIntendedCmds.remove(i);
                }
            }
            cmdBuffer = new StringBuffer();
        }
        if (prevCmd != null && prevCmd.getLastCmdPosition() == -1) {
            prevCmd.setLastCmdPosition(count);
        }
        return list;
    }

    private void updateAllSubCmdsState(CfgCommandInfo cfg) {
        for (CfgCommandInfo cfgCmd : cfg.getSubCommandsCol()) {
            cfgCmd.setState(cfg.getState());
            CfgDiffModelHelper.clearAssociations(cfgCmd);
            this.updateAllSubCmdsState(cfgCmd);
        }
    }

    protected void reConcileCmds(List<CfgCommandInfo> cmdsToReconcile) {
        if (cmdsToReconcile.size() <= 0) {
            return;
        }
        for (CfgCommandInfo cfg : cmdsToReconcile) {
            if (cfg.getMappedCmd() != null) continue;
            boolean mapped = false;
            while (!mapped && CfgDiffModelHelper.getBestMatchCommand(cfg) != null) {
                CfgCommandInfo bmc = CfgDiffModelHelper.getBestMatchCommand(cfg);
                if (CfgDiffModelHelper.getBestMatchCommand(bmc) == cfg || CfgDiffModelHelper.getBestMatchCommandTokenCount(cfg) >= CfgDiffModelHelper.getBestMatchCommandTokenCount(bmc)) {
                    if (CommandState.MATCHED == bmc.getState() || CommandState.REORDERED == bmc.getState()) {
                        CfgDiffModelHelper.removeMatchCommand(cfg, bmc);
                        CfgDiffModelHelper.removeMatchCommand(bmc, cfg);
                        mapped = false;
                        cfg.setState(CommandState.NONE);
                    } else {
                        cfg.setState(CommandState.MODIFIED);
                        cfg.setMappedCmd(bmc);
                        bmc.setState(CommandState.MODIFIED);
                        bmc.setMappedCmd(cfg);
                        this.compareSubCommands(cfg, bmc);
                        CfgDiffModelHelper.clearAssociations(bmc);
                        CfgDiffModelHelper.clearAssociations(cfg);
                        mapped = true;
                    }
                }
                CfgDiffModelHelper.removeMatchCommand(cfg, bmc);
            }
            if (mapped) continue;
            if (ConfigFile.LEFT.equals(cfg.getFileInfo())) {
                cfg.setState(CommandState.DELETED);
                CfgDiffModelHelper.clearAssociations(cfg);
                this.updateAllSubCmdsState(cfg);
            }
            if (!ConfigFile.RIGHT.equals(cfg.getFileInfo())) continue;
            cfg.setState(CommandState.ADDED);
            CfgDiffModelHelper.clearAssociations(cfg);
            this.updateAllSubCmdsState(cfg);
        }
    }

    protected void compareCfgCommands(List<CfgCommandInfo> aCfgList, List<CfgCommandInfo> bCfgList) {
        ArrayList<CfgCommandInfo> reconcileCmds = new ArrayList<CfgCommandInfo>();
        for (CfgCommandInfo aCmd : aCfgList) {
            if (CommandState.EMPTYLINE == aCmd.getState()) continue;
            boolean toContinue = false;
            if (bCfgList != null) {
                for (CfgCommandInfo bCmd : bCfgList) {
                    int[] matchInfo;
                    int rank;
                    if (CommandState.MATCHED == bCmd.getState() || CommandState.EMPTYLINE == bCmd.getState() || (rank = (matchInfo = this.getComparableRank(aCmd, bCmd))[0]) == -1) continue;
                    if (rank == 0 && (aCmd.getIsDfltCmd() != bCmd.getIsDfltCmd() || aCmd.getIsNoCmd() != bCmd.getIsNoCmd())) {
                        rank = 1;
                    }
                    if (this.throw_exception_on_diff && rank != 0) {
                        throw new DiffEngineException(DiffErrorInfo.DIFF_EXCEPTION);
                    }
                    if (rank == 0) {
                        aCmd.setState(CommandState.MATCHED);
                        aCmd.setMappedCmd(bCmd);
                        bCmd.setState(CommandState.MATCHED);
                        bCmd.setMappedCmd(aCmd);
                        if (!CfgDiffModelHelper.hasSubCommands(bCmd) || !CfgDiffModelHelper.hasSubCommands(aCmd)) {
                            Set<CfgCommandInfo> cfgCmdSet = CfgDiffModelHelper.getMatchCommands(aCmd);
                            for (CfgCommandInfo cmdToUpdate : cfgCmdSet) {
                                if (!cmdToUpdate.getState().equals(CommandState.MATCHED) && !reconcileCmds.contains(cmdToUpdate)) {
                                    reconcileCmds.add(cmdToUpdate);
                                }
                                CfgDiffModelHelper.removeMatchCommand(cmdToUpdate, aCmd);
                                if (CfgDiffModelHelper.getBestMatchCommand(cmdToUpdate) != null) continue;
                                cmdToUpdate.setState(CommandState.NONE);
                            }
                            cfgCmdSet = CfgDiffModelHelper.getMatchCommands(bCmd);
                            for (CfgCommandInfo cmdToUpdate : cfgCmdSet) {
                                if (!cmdToUpdate.getState().equals(CommandState.MATCHED) && !reconcileCmds.contains(cmdToUpdate)) {
                                    reconcileCmds.add(cmdToUpdate);
                                }
                                CfgDiffModelHelper.removeMatchCommand(cmdToUpdate, bCmd);
                                if (CfgDiffModelHelper.getBestMatchCommand(cmdToUpdate) != null) continue;
                                cmdToUpdate.setState(CommandState.NONE);
                            }
                        }
                        CfgDiffModelHelper.clearAssociations(aCmd);
                        CfgDiffModelHelper.clearAssociations(bCmd);
                        reconcileCmds.remove(aCmd);
                        reconcileCmds.remove(bCmd);
                        this.compareSubCommands(aCmd, bCmd);
                        toContinue = true;
                        break;
                    }
                    if (rank != 1 || CfgDiffModelHelper.hasSubCommands(aCmd) || CfgDiffModelHelper.hasSubCommands(bCmd)) continue;
                    aCmd.setState(CommandState.MODIFIED);
                    bCmd.setState(CommandState.MODIFIED);
                    CfgDiffModelHelper.addMatchPosition(aCmd, bCmd, matchInfo[1]);
                    CfgDiffModelHelper.addMatchPosition(bCmd, aCmd, matchInfo[1]);
                    if (!reconcileCmds.contains(bCmd)) {
                        reconcileCmds.add(bCmd);
                    }
                    toContinue = false;
                }
            }
            if (toContinue || reconcileCmds.contains(aCmd)) continue;
            reconcileCmds.add(aCmd);
        }
        this.reConcileCmds(reconcileCmds);
        for (CfgCommandInfo cfgCmd : aCfgList) {
            if (CommandState.NONE != cfgCmd.getState()) continue;
            if (this.throw_exception_on_diff) {
                throw new DiffEngineException(DiffErrorInfo.DIFF_EXCEPTION);
            }
            cfgCmd.setState(CommandState.DELETED);
            CfgDiffModelHelper.clearAssociations(cfgCmd);
            this.updateAllSubCmdsState(cfgCmd);
        }
        for (CfgCommandInfo cfgCmd : bCfgList) {
            if (CommandState.NONE != cfgCmd.getState()) continue;
            if (this.throw_exception_on_diff) {
                throw new DiffEngineException(DiffErrorInfo.DIFF_EXCEPTION);
            }
            cfgCmd.setState(CommandState.ADDED);
            CfgDiffModelHelper.clearAssociations(cfgCmd);
            this.updateAllSubCmdsState(cfgCmd);
        }
    }

    protected void compareSubCommands(CfgCommandInfo aCmd, CfgCommandInfo bCmd) {
        ArrayList<CfgCommandInfo> cmdsToReconcile = new ArrayList<CfgCommandInfo>();
        block0: for (CfgCommandInfo aCfgCmd : aCmd.getSubCommandsCol()) {
            if (CommandState.EMPTYLINE == aCfgCmd.getState()) continue;
            List<CfgCommandInfo> exactMatchList = CfgDiffModelHelper.getLookupSubCmd(bCmd, CfgDiffModelHelper.getCommand(aCfgCmd));
            List<Object> cmdList = new ArrayList();
            if (exactMatchList == null || exactMatchList.size() == 0) {
                if (CfgDiffModelHelper.hasSubCommands(aCfgCmd)) continue;
                cmdList = bCmd.getSubCommandsCol();
            } else {
                cmdList = exactMatchList;
            }
            for (CfgCommandInfo bCfgCmd : cmdList) {
                if (CommandState.MATCHED == bCfgCmd.getState() || CommandState.EMPTYLINE == bCfgCmd.getState() || (exactMatchList == null || exactMatchList.size() == 0) && CfgDiffModelHelper.hasSubCommands(bCfgCmd)) continue;
                int rank = -1;
                int[] matchInfo = null;
                if (exactMatchList == null || exactMatchList.size() == 0) {
                    matchInfo = this.getComparableRank(aCmd, bCmd);
                    rank = matchInfo[0];
                } else {
                    rank = 0;
                }
                if (rank == -1) continue;
                if (rank == 0 && (aCfgCmd.getIsDfltCmd() != bCfgCmd.getIsDfltCmd() || aCfgCmd.getIsNoCmd() != bCfgCmd.getIsNoCmd())) {
                    rank = 1;
                }
                if (this.throw_exception_on_diff && rank != 0) {
                    throw new DiffEngineException(DiffErrorInfo.DIFF_EXCEPTION);
                }
                if (rank == 0 || rank == 2) {
                    CommandState state = CommandState.REORDERED;
                    if (rank == 0) {
                        state = CommandState.MATCHED;
                        if (!CfgDiffModelHelper.hasSubCommands(bCmd) || !CfgDiffModelHelper.hasSubCommands(aCmd)) {
                            Set<CfgCommandInfo> cfgCmdSet = CfgDiffModelHelper.getMatchCommands(aCmd);
                            for (CfgCommandInfo cmdToUpdate : cfgCmdSet) {
                                if (cmdToUpdate.getState() != CommandState.MATCHED && !cmdsToReconcile.contains(cmdToUpdate)) {
                                    cmdsToReconcile.add(cmdToUpdate);
                                }
                                CfgDiffModelHelper.removeMatchCommand(cmdToUpdate, aCmd);
                                if (CfgDiffModelHelper.getBestMatchCommand(cmdToUpdate) != null) continue;
                                cmdToUpdate.setState(CommandState.NONE);
                            }
                            cfgCmdSet = CfgDiffModelHelper.getMatchCommands(bCmd);
                            for (CfgCommandInfo cmdToUpdate : cfgCmdSet) {
                                if (cmdToUpdate.getState() != CommandState.MATCHED && !cmdsToReconcile.contains(cmdToUpdate)) {
                                    cmdsToReconcile.add(cmdToUpdate);
                                }
                                CfgDiffModelHelper.removeMatchCommand(cmdToUpdate, bCmd);
                                if (CfgDiffModelHelper.getBestMatchCommand(cmdToUpdate) != null) continue;
                                cmdToUpdate.setState(CommandState.NONE);
                            }
                        }
                    }
                    aCfgCmd.setState(state);
                    aCfgCmd.setMappedCmd(bCfgCmd);
                    bCfgCmd.setState(state);
                    bCfgCmd.setMappedCmd(aCfgCmd);
                    this.compareSubCommands(aCfgCmd, bCfgCmd);
                    cmdsToReconcile.remove(aCfgCmd);
                    cmdsToReconcile.remove(bCfgCmd);
                    CfgDiffModelHelper.clearAssociations(aCfgCmd);
                    CfgDiffModelHelper.clearAssociations(bCfgCmd);
                    if (CommandState.MATCHED != state) continue;
                    continue block0;
                }
                if (rank != 1 || CommandState.REORDERED == aCfgCmd.getState() || CfgDiffModelHelper.hasSubCommands(aCfgCmd) && CfgDiffModelHelper.hasSubCommands(bCfgCmd)) continue;
                String[] aTokens = aCfgCmd.getCmdTokens();
                String[] bTokens = bCfgCmd.getCmdTokens();
                boolean maxCountMatch = false;
                aCfgCmd.setState(CommandState.MODIFIED);
                bCfgCmd.setState(CommandState.MODIFIED);
                CfgDiffModelHelper.addMatchPosition(aCfgCmd, bCfgCmd, matchInfo[1]);
                CfgDiffModelHelper.addMatchPosition(bCfgCmd, aCfgCmd, matchInfo[1]);
                if (!cmdsToReconcile.contains(bCfgCmd)) {
                    cmdsToReconcile.add(bCfgCmd);
                }
                if (cmdsToReconcile.contains(aCfgCmd)) continue;
                cmdsToReconcile.add(aCfgCmd);
            }
        }
        if (this.throw_exception_on_diff && cmdsToReconcile.size() > 0) {
            throw new DiffEngineException(DiffErrorInfo.DIFF_EXCEPTION);
        }
        this.reConcileCmds(cmdsToReconcile);
        for (CfgCommandInfo cfgCmd : aCmd.getSubCommandsCol()) {
            if (CommandState.NONE != cfgCmd.getState()) continue;
            if (this.throw_exception_on_diff) {
                throw new DiffEngineException(DiffErrorInfo.DIFF_EXCEPTION);
            }
            cfgCmd.setState(CommandState.DELETED);
            CfgDiffModelHelper.clearAssociations(cfgCmd);
            this.updateAllSubCmdsState(cfgCmd);
        }
        for (CfgCommandInfo cfgCmd : bCmd.getSubCommandsCol()) {
            if (CommandState.NONE != cfgCmd.getState()) continue;
            if (this.throw_exception_on_diff) {
                throw new DiffEngineException(DiffErrorInfo.DIFF_EXCEPTION);
            }
            cfgCmd.setState(CommandState.ADDED);
            CfgDiffModelHelper.clearAssociations(cfgCmd);
            this.updateAllSubCmdsState(cfgCmd);
        }
    }

    protected int[] getComparableRank(CfgCommandInfo aCommand, CfgCommandInfo bCommand) {
        if (aCommand instanceof CfgCommandInfo && bCommand instanceof CfgCommandInfo) {
            CfgCommandInfo aCmd = aCommand;
            String[] aTokens = aCmd.getCmdTokens();
            CfgCommandInfo bCmd = bCommand;
            String[] bTokens = bCmd.getCmdTokens();
            if (CfgDiffModelHelper.getTokenCountToCompare(bCmd) != CfgDiffModelHelper.getTokenCountToCompare(aCmd)) {
                return new int[]{-1, 0};
            }
            boolean shouldFirstTokenOmit = false;
            int tokenIndxToOmit = -1;
            int aTokenNo = -1;
            int bTokenNo = -1;
            if (aCmd.getNonInsertHashCode() == bCmd.getNonInsertHashCode()) {
                return new int[]{0, 0};
            }
            int[] matchInfo = this.runComparisonMethod(this.findFilterCommandName(aCmd), aTokens, bTokens);
            return new int[]{matchInfo[0], matchInfo[1]};
        }
        return new int[]{-1, 0};
    }

    private String findFilterCommandName(CfgCommandInfo aCmd) {
        CfgCommandInfo parentCmd = aCmd;
        while (parentCmd.getParentCmd() != null) {
            parentCmd = parentCmd.getParentCmd();
        }
        for (int i = 0; i < CfgDiffHelper.CONFIGS.length; ++i) {
            String cmdLn = parentCmd.getCommand().getCommandLine().trim();
            for (int k = 1; k < CfgDiffHelper.CONFIGS[i].length - 1; ++k) {
                if (CfgDiffHelper.CONFIGS[i][k] == null || !cmdLn.startsWith(CfgDiffHelper.CONFIGS[i][k])) continue;
                return CfgDiffHelper.CONFIGS[i][k];
            }
        }
        return null;
    }

    private int[] runComparisonMethod(String name, String[] aTokens, String[] bTokens) {
        try {
            Method m = (Method)this.methodsByName.get(name == null ? "TwoTokenCompare" : name);
            if (m != null) {
                Object[] args = new Object[]{aTokens, bTokens};
                return (int[])m.invoke(FilterMethods.class, args);
            }
        }
        catch (Exception ex) {
            System.out.println("Error in runComparisonMehtod:" + ex.getMessage());
        }
        return new int[]{-1, 0};
    }

    public Map<ConfigFile, List<List<CfgCommand>>> compare(InputStream leftStream, InputStream rightStream, Object[][] filter) {
        this.resultMap.clear();
        this.modeCmdLookupMap.clear();
        List<CfgCommandInfo> aCfgList = null;
        ArrayList categories = new ArrayList();
        try {
            aCfgList = this.parseConfigFile(leftStream, ConfigFile.LEFT, filter, categories);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<CfgCommandInfo> bCfgList = null;
        Map<String, List<CfgCommandInfo>> cmdMap1 = this.modeCmdLookupMap;
        this.modeCmdLookupMap = new ConcurrentHashMap<String, List<CfgCommandInfo>>();
        try {
            bCfgList = this.parseConfigFile(rightStream, ConfigFile.RIGHT, filter, categories);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<List> srcCmdCol = new ArrayList<List>();
        ArrayList<List> dstCmdCol = new ArrayList<List>();
        for (int i = 0; i < categories.size(); ++i) {
            ArrayList bList;
            String catSel = (String)categories.get(i);
            ArrayList<CfgCommandInfo> aList = cmdMap1.get(catSel);
            Object[] outLst = this.buildComparisonCmds(aList == null ? new ArrayList<CfgCommandInfo>() : aList, (bList = this.modeCmdLookupMap.get(catSel)) == null ? new ArrayList() : bList);
            if (outLst == null) continue;
            srcCmdCol.add((List)outLst[0]);
            dstCmdCol.add((List)outLst[1]);
        }
        this.resultMap.put(ConfigFile.LEFT, srcCmdCol);
        this.resultMap.put(ConfigFile.RIGHT, dstCmdCol);
        return this.resultMap;
    }

    private Object[] buildComparisonCmds(List<CfgCommandInfo> aCfgList, List<CfgCommandInfo> bCfgList) {
        if (aCfgList != null && bCfgList != null) {
            this.compareCfgCommands(aCfgList, bCfgList);
            ArrayList<CfgCommand> srcCmdCol = new ArrayList<CfgCommand>();
            for (CfgCommandInfo ci : aCfgList) {
                srcCmdCol.add(ci.getCommand());
            }
            ArrayList<CfgCommand> destCmdCol = new ArrayList<CfgCommand>();
            for (CfgCommandInfo ci : bCfgList) {
                destCmdCol.add(ci.getCommand());
            }
            return new Object[]{srcCmdCol, destCmdCol};
        }
        return null;
    }

    private Object[] sortConfigLists(List<CfgCommandInfo> aCfgList, List<CfgCommandInfo> bCfgList) {
        ArrayList<CfgCommandInfo> aCfgListNew = new ArrayList<CfgCommandInfo>();
        ArrayList<CfgCommandInfo> bCfgListNew = new ArrayList<CfgCommandInfo>();
        Iterator<CfgCommandInfo> itr = aCfgList.iterator();
        while (itr.hasNext()) {
            CfgCommandInfo aCmd = itr.next();
            aCfgListNew.add(aCmd);
            String[] token1 = aCmd.getCmdTokens();
            Iterator<CfgCommandInfo> itr2 = bCfgList.iterator();
            while (itr2.hasNext()) {
                CfgCommandInfo bCmd = itr2.next();
                String[] token2 = bCmd.getCmdTokens();
                int matchingTokens = 0;
                for (int i = 0; i < token1.length; ++i) {
                    if (token1[i].trim().length() == 0) continue;
                    if (i >= token2.length || !token1[i].trim().equals(token2[i])) break;
                    ++matchingTokens;
                }
                if (matchingTokens <= 0) continue;
                bCfgListNew.add(bCmd);
                itr2.remove();
            }
            itr.remove();
        }
        if (aCfgList.size() > 0) {
            aCfgListNew.addAll(aCfgList);
        }
        if (bCfgList.size() > 0) {
            bCfgListNew.addAll(bCfgList);
        }
        return new Object[]{aCfgListNew, bCfgListNew};
    }

    static class DiffEngineException
    extends RuntimeException {
        DiffErrorInfo info = null;

        public DiffEngineException(DiffErrorInfo info) {
            this.info = info;
        }

        @Override
        public String getMessage() {
            return this.info.getMessage();
        }
    }

    static enum DiffErrorInfo {
        DIFF_EXCEPTION("Found diff");

        String message;

        private DiffErrorInfo(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

