/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.cfgdiffEngine;

import com.cisco.dcbu.sm.common.cfgdiffEngine.CfgCommandInfo;
import com.cisco.dcbu.sm.common.cfgdiffEngine.CommandState;
import com.cisco.dcbu.sm.common.cfgdiffEngine.ConfigFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CfgDiffModelHelper {
    public static void addMatchPosition(CfgCommandInfo aCmd, CfgCommandInfo bCmd, Integer tokenCount) {
        aCmd.getAffinityCmdMap().put(bCmd, tokenCount);
    }

    public static void addSubCommand(CfgCommandInfo aCmd, CfgCommandInfo subCmd) {
        aCmd.getSubCommandsCol().add(subCmd);
        aCmd.getCommand().getSubCommandsCol().add(subCmd.getCommand());
        if (subCmd.getFileInfo().equals(ConfigFile.RIGHT)) {
            String cmdName = CfgDiffModelHelper.toString(subCmd, false);
            List<CfgCommandInfo> cmdList = aCmd.getSubCmdLookUpMap().get(cmdName);
            if (cmdList == null) {
                cmdList = new ArrayList<CfgCommandInfo>();
                aCmd.getSubCmdLookUpMap().put(cmdName, cmdList);
            }
            cmdList.add(subCmd);
        }
    }

    public static void clearAssociations(CfgCommandInfo aCmd) {
        Set<CfgCommandInfo> keySet = aCmd.getAffinityCmdMap().keySet();
        if (keySet.size() == 0) {
            return;
        }
        for (CfgCommandInfo key : keySet) {
            CfgDiffModelHelper.removeMatchCommand(key, aCmd);
        }
        aCmd.getAffinityCmdMap().clear();
    }

    public static CfgCommandInfo getBestMatchCommand(CfgCommandInfo aCmd) {
        CfgCommandInfo bestMatchingCmd = null;
        int maxCount = 0;
        if (aCmd != null) {
            Set<CfgCommandInfo> keySet = aCmd.getAffinityCmdMap().keySet();
            Iterator<CfgCommandInfo> keyiter = keySet.iterator();
            int nearestCmd = -1;
            while (keyiter.hasNext()) {
                CfgCommandInfo key = keyiter.next();
                Integer value = aCmd.getAffinityCmdMap().get(key);
                if (value < maxCount || value == maxCount && nearestCmd < key.getPosition()) continue;
                nearestCmd = key.getPosition();
                maxCount = value;
                bestMatchingCmd = key;
            }
        }
        return bestMatchingCmd;
    }

    public static Integer getBestMatchCommandTokenCount(CfgCommandInfo aCmd) {
        int maxCount = 0;
        Set<CfgCommandInfo> keySet = aCmd.getAffinityCmdMap().keySet();
        for (CfgCommandInfo key : keySet) {
            Integer value = aCmd.getAffinityCmdMap().get(key);
            if (value <= maxCount) continue;
            maxCount = value;
        }
        return maxCount;
    }

    public static String getCommand(CfgCommandInfo aCmd) {
        return CfgDiffModelHelper.toString(aCmd, false);
    }

    public static String getFullCmdLine(CfgCommandInfo aCmd) {
        return CfgDiffModelHelper.toString(aCmd, true);
    }

    public static String getFirstNonEmptyToken(CfgCommandInfo aCmd) {
        String[] tokens = aCmd.getCmdTokens();
        int i = -1;
        for (String token : tokens) {
            ++i;
            if ("".equals(token.trim())) continue;
            aCmd.setOmtdTknIndx(i);
            return token.trim();
        }
        return "";
    }

    public static Integer getHierarchialPosition(CfgCommandInfo aCmd) {
        int i = 0;
        CfgCommandInfo temp = aCmd.getParentCmd();
        while (temp != null) {
            temp = temp.getParentCmd();
            ++i;
        }
        return i;
    }

    public static Integer getLastCmdPosition(CfgCommandInfo aCmd) {
        if (aCmd.getLastCmdPosition() == -1) {
            boolean found = false;
            CfgCommandInfo curCmd = aCmd;
            while (!found) {
                int subCmdCount = curCmd.getSubCommandsCol().size();
                if (subCmdCount > 0) {
                    curCmd = curCmd.getSubCommandsCol().get(subCmdCount - 1);
                    continue;
                }
                aCmd.setLastCmdPosition(curCmd.getPosition());
                found = true;
            }
            aCmd.setLastCmdPosition(curCmd.getLastCmdPosition());
        }
        return aCmd.getLastCmdPosition();
    }

    public static String getThresholdString(CfgCommandInfo aCmd) {
        return aCmd.getThresholdString();
    }

    public static List<CfgCommandInfo> getLookupSubCmd(CfgCommandInfo aCmd, String equivalityCmd) {
        return aCmd.getSubCmdLookUpMap().get(equivalityCmd);
    }

    public static Set<CfgCommandInfo> getMatchCommands(CfgCommandInfo aCmd) {
        return aCmd.getAffinityCmdMap().keySet();
    }

    public static Integer getMaxMatchTokenCount(CfgCommandInfo aCmd) {
        int maxCount = 0;
        Set<CfgCommandInfo> keySet = aCmd.getAffinityCmdMap().keySet();
        for (CfgCommandInfo key : keySet) {
            Integer value = aCmd.getAffinityCmdMap().get(key);
            if (value <= maxCount) continue;
            maxCount = value;
        }
        return maxCount;
    }

    public static Integer getTokenCountToCompare(CfgCommandInfo aCmd) {
        return aCmd.getThreshCnt();
    }

    public static boolean hasSubCommands(CfgCommandInfo aCmd) {
        boolean hasSubCommands;
        boolean bl = hasSubCommands = aCmd.getSubCommandsCol().size() > 0;
        if (hasSubCommands) {
            boolean hasNonEmptyCommands = false;
            for (CfgCommandInfo info : aCmd.getSubCommandsCol()) {
                if (CommandState.EMPTYLINE.equals(info.getCommand().getState())) continue;
                hasNonEmptyCommands = true;
                break;
            }
            if (!hasNonEmptyCommands) {
                return false;
            }
        }
        return hasSubCommands;
    }

    public static Boolean isModeCmd(CfgCommandInfo aCmd) {
        return aCmd.getParentCmd() == null;
    }

    public static void removeMatchCommand(CfgCommandInfo bCmd, CfgCommandInfo aCmd) {
        bCmd.getAffinityCmdMap().remove(aCmd);
    }

    public static void removeToken(CfgCommandInfo aCmd, String token) {
        List<String> tokensCol = Arrays.asList(aCmd.getCmdTokens());
        ArrayList<String> updatedCol = new ArrayList<String>();
        boolean frstTimeTokenFound = false;
        for (String tkn : tokensCol) {
            if (!frstTimeTokenFound) {
                if (!tkn.equalsIgnoreCase(token)) {
                    updatedCol.add(tkn);
                    continue;
                }
                frstTimeTokenFound = true;
                continue;
            }
            updatedCol.add(tkn);
        }
        String[] newCmdsS = updatedCol.toArray(new String[updatedCol.size()]);
        aCmd.setCmdTokens(newCmdsS, CfgDiffModelHelper.toString(newCmdsS, false).hashCode());
        if (updatedCol.size() > 2) {
            aCmd.setThreshCnt(2);
        } else {
            aCmd.setThreshCnt(1);
        }
    }

    public static void setCommand(CfgCommandInfo aCmd, String cmd) {
        aCmd.getCommand().setCommandLine(cmd);
        String[] newCmdsS = CfgDiffModelHelper.toArray(cmd);
        aCmd.setCmdTokens(newCmdsS, CfgDiffModelHelper.toString(newCmdsS, false).hashCode());
        if (aCmd.getCmdTokens().length > 2) {
            aCmd.setThreshCnt(2);
        } else {
            aCmd.setThreshCnt(1);
        }
    }

    public static String[] toArray(String value) {
        return value.split(" ");
    }

    public static String toString(CfgCommandInfo cfgCmd, boolean fullCmd) {
        String[] values = cfgCmd.getCmdTokens();
        Integer tokenToOmit = cfgCmd.getOmtdTknIndx();
        String toInsert = "";
        if (fullCmd) {
            if (cfgCmd.getIsDfltCmd()) {
                toInsert = "default";
            } else if (cfgCmd.getIsNoCmd()) {
                toInsert = "no";
            }
        }
        String newValue = "";
        int i = -1;
        for (String value : values) {
            newValue = !"".equals(toInsert) && ++i == tokenToOmit ? newValue + toInsert + " " + value + " " : newValue + value + " ";
        }
        if ("".equals(newValue)) {
            return "";
        }
        return newValue.substring(0, newValue.length() - 1);
    }

    public static String toString(String[] values, boolean fullCmd) {
        String toInsert = "";
        Integer tokenToOmit = 0;
        StringBuffer newValue = new StringBuffer();
        int i = -1;
        for (String value : values) {
            if (toInsert.length() > 0 && ++i == tokenToOmit) {
                newValue.append(toInsert + " " + value + " ");
                continue;
            }
            newValue.append(value + " ");
        }
        if (newValue.length() == 0) {
            return newValue.toString();
        }
        return newValue.toString();
    }
}

