/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.cfgdiffEngine;

import com.cisco.dcbu.sm.common.cfgdiffEngine.ClassHelper;
import java.io.Serializable;

public final class Pair<F, S>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private F first;
    private S second;

    public Pair() {
    }

    public Pair(F f, S s) {
        this.first = f;
        this.second = s;
    }

    public static <F, S> Pair<F, S> of(F f, S s) {
        return new Pair<F, S>(f, s);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Pair) {
            Pair p = (Pair)o;
            return ClassHelper.equals(this.first, p.getFirst()) & ClassHelper.equals(this.second, p.getSecond());
        }
        return false;
    }

    public boolean unorderedEquals(Object o) {
        if (this.equals(o)) {
            return true;
        }
        return Pair.of(this.second, this.first).equals(o);
    }

    public int hashCode() {
        int firstHashCode = this.first == null ? 0 : this.first.hashCode();
        int secondHashCode = this.second == null ? 0 : this.second.hashCode();
        return firstHashCode + 23 * secondHashCode;
    }

    public F getFirst() {
        return this.first;
    }

    public void setFirst(F aFirst) {
        this.first = aFirst;
    }

    public S getSecond() {
        return this.second;
    }

    public void setSecond(S aSecond) {
        this.second = aSecond;
    }

    public String toString() {
        return "(" + this.first + "," + this.second + ")";
    }
}

