/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.dto;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.sm.common.type.VsanPK;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Comparator;

public final class VsanDomain
implements Serializable,
Comparator,
Comparable {
    static final long serialVersionUID = 1L;
    public final VsanPK _vsanPK;
    public final short _domainId;
    private Wwn _vwwn;
    private InetAddress _vip;

    public VsanDomain(VsanPK vsanPK, short domainId, Wwn vwwn) {
        if (vsanPK == null) {
            throw new IllegalArgumentException("VSAN PK cannot be null");
        }
        this._vsanPK = vsanPK;
        this._domainId = domainId;
        this.setVsanWwn(vwwn);
    }

    public Wwn getVsanWwn() {
        return this._vwwn;
    }

    public void setVsanWwn(Wwn vwwn) {
        if (vwwn == null) {
            throw new IllegalArgumentException("VSAN WWN cannot be null");
        }
        this._vwwn = vwwn;
    }

    public InetAddress getVsanIp() {
        return this._vip;
    }

    public void setVsanIp(InetAddress ip) {
        this._vip = ip;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof VsanDomain)) {
            return false;
        }
        VsanDomain otherKey = (VsanDomain)obj;
        return otherKey._vsanPK.equals(this._vsanPK) && otherKey._domainId == this._domainId;
    }

    public int hashCode() {
        return (this._vsanPK._prinSwwn.getValue()[7] << 24) + (this._vsanPK._id << 8) + this._domainId;
    }

    public String toString() {
        return "VSAN " + this._vsanPK._id + "/" + "Domain " + this._domainId;
    }

    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        VsanDomain key1 = (VsanDomain)o1;
        VsanDomain key2 = (VsanDomain)o2;
        int c = key1._vsanPK.compareTo(key2._vsanPK);
        return c == 0 ? key1._domainId - key2._domainId : c;
    }

    public int compareTo(Object o) {
        return this.compare(this, o);
    }
}

