/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.event;

import com.cisco.dcbu.lib.util.channel.ChannelImpl;
import java.io.Serializable;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class CommunicationObjectSender {
    private static final Logger _logger = LogManager.getLogger(CommunicationObjectSender.class);
    Queue _queue = null;
    static QueueConnection _conn = null;
    static QueueSession _session = null;
    ChannelImpl<Object> _channel = null;
    QueueSender _sender = null;

    public CommunicationObjectSender(Object obj) throws Exception {
        if (obj instanceof ChannelImpl) {
            this._channel = (ChannelImpl)obj;
        } else if (obj instanceof Queue) {
            this._queue = (Queue)obj;
            this.setupPtoP();
        } else {
            throw new IllegalArgumentException("This is not a supported object");
        }
    }

    private void setupPtoP() throws Exception {
        if (_conn == null || _session == null) {
            Integer port = Integer.getInteger("server.port", new Integer(4447));
            String server = System.getProperty("server.bindaddrs", "localhost");
            if (server == null || server.equals("")) {
                server = "localhost";
            }
            Properties properties = new Properties();
            properties.put("java.naming.factory.initial", "org.jboss.naming.remote.client.InitialContextFactory");
            String serverUrl = "remote://" + server + ":" + port;
            properties.put("java.naming.provider.url", serverUrl);
            InitialContext _context = new InitialContext(properties);
            Object tmp = _context.lookup("jms/RemoteConnectionFactory");
            QueueConnectionFactory tcf = (QueueConnectionFactory)tmp;
            _conn = tcf.createQueueConnection();
            _session = _conn.createQueueSession(false, 1);
            _conn.start();
        }
        this._sender = _session.createSender(this._queue);
    }

    public void send(Serializable evtObj) {
        try {
            if (this._channel != null) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("sending message to client - " + evtObj));
                }
                this._channel.queue(evtObj);
            } else if (this._sender != null) {
                ObjectMessage om = _session.createObjectMessage();
                om.setObject(evtObj);
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("sending message to client - " + om));
                }
                this._sender.send((Message)om);
            }
        }
        catch (Exception ex) {
            _logger.error((Object)("can not send message:" + ex.getMessage()));
        }
    }

    public void stop() {
        try {
            if (this._sender != null) {
                this._sender.close();
                this._sender = null;
            }
            this._channel = null;
            this._queue = null;
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void finallize() {
        this.stop();
    }

    public String toString() {
        String strSuper = super.toString();
        StringBuilder str = new StringBuilder(strSuper);
        str.append(" queue - ").append(this._queue);
        str.append(" channel - ").append(this._channel);
        str.append(" sender - ").append(this._sender);
        return str.toString();
    }
}

