/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.event;

import com.cisco.dcbu.sm.common.event.LogEventType;
import com.cisco.dcbu.sm.common.event.Severity;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public final class LogEvent
implements Serializable {
    static final long serialVersionUID = 1L;
    static final String FINDSW = "select id, fabric_id from switch where wwn=?";
    static final String FINDEP = "select fabric_id from end_port where wwn=?";
    static final String FINDFB = "select san_id from fabric where id=?";
    protected Object _source;
    protected WwnKey _switchPK;
    protected long _creationTime;
    protected String _origin;
    protected LogEventType _type;
    protected String _sysType;
    protected Severity _severity;
    protected long _dcId;
    protected long _switchId;
    protected long _srcId;
    protected long _destId;
    protected String _descr;
    protected String _enclosure;
    protected int _isLan;
    protected Set<Integer> _pgGroupIds = new HashSet<Integer>();
    protected long _first_seen;
    protected long _count;
    protected long _groupId;
    protected String _facility = "DCNM";

    public LogEvent(Object source, LogEventType type, Severity severity, String origin, String descr) {
        this(type, severity, origin, descr);
        this._source = source;
    }

    private LogEvent(Object source, LogEventType type, Severity severity, String origin, String descr, WwnKey switchPk) {
        this(type, severity, origin, descr);
        this._source = source;
        this._switchPK = switchPk;
    }

    private LogEvent(LogEventType type, Severity severity, String origin, String descr) {
        this._creationTime = System.currentTimeMillis();
        this._type = type;
        this._severity = severity;
        this._origin = origin;
        this._descr = descr;
    }

    public LogEvent(Object source, LogEventType type, Severity severity, String origin, String descr, long fabricId, long switchId, long creationTime, WwnKey switchPk) {
        this(source, type, severity, origin, descr, fabricId, switchId, creationTime, switchPk, 0);
    }

    public LogEvent(Object source, LogEventType type, Severity severity, String origin, String descr, long fabricId, long switchId, long creationTime, WwnKey switchPk, int islan) {
        this._creationTime = creationTime;
        this._source = source;
        this._type = type;
        this._severity = severity;
        this._origin = origin;
        this._descr = descr;
        this._dcId = fabricId;
        this._switchId = switchId;
        this._switchPK = switchPk;
        this._isLan = islan;
    }

    public LogEvent(Object source, LogEventType type, Severity severity, String origin, String descr, long fabricId, long switchId, long first_seen, long last_seen, long count, WwnKey switchPk, int islan, long groupId, String facility) {
        this(source, type, severity, origin, descr, fabricId, switchId, last_seen, switchPk, islan);
        this._first_seen = first_seen;
        this._count = count;
        this._facility = facility == null || facility.trim().length() == 0 ? this._facility : facility;
        this._groupId = groupId;
    }

    public LogEvent(Object source, LogEventType type, Severity severity, String origin, String descr, long creationTime, InetAddress swIp, int islan) {
        this(type, severity, origin, descr, creationTime, swIp, islan);
        this._source = source;
    }

    public LogEvent(LogEventType type, Severity severity, String origin, String descr, long creationTime, InetAddress swIp, int islan) {
        this._creationTime = creationTime;
        this._type = type;
        this._severity = severity;
        this._origin = origin;
        this._descr = descr;
        this._isLan = islan;
        if (islan == 1) {
            EthSwitchImpl es = DCManager.getInstance().findEthSwitchBySwIp(swIp);
            if (es != null) {
                this._switchId = es.getDBID();
                if (es.getLan() != null) {
                    this._source = es.getLan().getPK();
                    this._dcId = es.getLan().getDBID();
                }
            }
        } else {
            SwitchImpl sw = SanManager.getInstance().findSwitchByIP(swIp);
            if (sw != null) {
                this._switchId = sw.getDBID();
                if (sw.getFabric() != null) {
                    this._source = sw.getFabricPK();
                    this._dcId = sw.getFabric().getDBID();
                }
            }
        }
    }

    public LogEvent(Object source, LogEventType type, Severity severity, String origin, String descr, long fabricId) {
        this(source, type, severity, origin, descr);
        this._dcId = fabricId;
    }

    public LogEvent(Object source, LogEventType type, Severity severity, String origin, String descr, long fabricId, long switchId, WwnKey switchPk) {
        this(source, type, severity, origin, descr, switchPk);
        this._dcId = fabricId;
        this._switchId = switchId;
    }

    public LogEvent(long fabricId, long srcId, long destId, LogEventType type, Severity severity, String origin, String descr) {
        this(type, severity, origin, descr);
        this._dcId = fabricId;
        this._srcId = srcId;
        this._destId = destId;
    }

    public LogEvent(long fabricId, long srcId, long destId, LogEventType type, Severity severity, String origin, String descr, long switchId) {
        this(type, severity, origin, descr);
        this._dcId = fabricId;
        this._srcId = srcId;
        this._destId = destId;
        this._switchId = switchId;
    }

    public LogEvent(Object source, long fabricId, long srcId, long destId, LogEventType type, String facility, String sysType, Severity severity, String origin, String descr, long switchId, long gid, int isLan) {
        this(fabricId, srcId, destId, type, severity, origin, descr, switchId);
        this._source = source;
        this._facility = facility;
        this._sysType = sysType;
        this._groupId = gid;
        this._isLan = isLan;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this._source);
        s.writeLong(this._creationTime);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._source = s.readObject();
        this._creationTime = s.readLong();
    }

    public Object getSource() {
        return this._source;
    }

    public long getTimeStamp() {
        return this._creationTime;
    }

    public long getFirstSeen() {
        return this._first_seen;
    }

    public long getLastSeen() {
        return this._creationTime;
    }

    public long getCount() {
        return this._count;
    }

    public String getFacility() {
        return this._facility;
    }

    public long getGroupId() {
        return this._groupId;
    }

    public LogEventType getType() {
        return this._type;
    }

    public String getSysType() {
        if (this._sysType == null && this._type != null && this._type != LogEventType.SYSLOG) {
            return this._type.toString();
        }
        return this._sysType;
    }

    public Severity getSeverity() {
        return this._severity;
    }

    public String getOrigin() {
        return this._origin;
    }

    public String getDescription() {
        return this._descr;
    }

    public long getDCId() {
        return this._dcId;
    }

    public long getSwitchId() {
        return this._switchId;
    }

    public final void setSwitchId(long switchId) {
        this._switchId = switchId;
    }

    public long getSrcId() {
        return this._srcId;
    }

    public void setSrcId(long srcId) {
        this._srcId = srcId;
    }

    public long getDestId() {
        return this._destId;
    }

    public WwnKey getSwitchPk() {
        return this._switchPK;
    }

    public String getEnclosure() {
        return this._enclosure;
    }

    public void setEnclosure(String _enclosure) {
        this._enclosure = _enclosure;
    }

    public int getDCType() {
        return this._isLan;
    }

    public void setDCType(int _isLan) {
        this._isLan = _isLan;
    }

    public Set<Integer> get_pgGroupIds() {
        return this._pgGroupIds;
    }

    public void set_pgGroupIds(Set<Integer> _pgGroupIds) {
        if (_pgGroupIds != null && _pgGroupIds.size() > 0) {
            this._pgGroupIds.addAll(_pgGroupIds);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" Time: ").append(new Date(this._creationTime)).append(", Type: ").append(this._type).append(", Severity: ").append((Object)this._severity).append(", Source: ").append(this._origin).append(", Descr: ").append(this._descr);
        sb.append(", origin:" + this._origin + ", fabricId:" + this._dcId);
        return sb.toString();
    }

    public String toRecord() {
        StringBuffer sb = new StringBuffer();
        sb.append(new Date(this._creationTime)).append(" \t").append((Object)this._severity).append(" \t").append(this._type).append(" \t").append(this._origin).append(" \t").append(this._descr);
        return sb.toString();
    }

    public void setSource(Object source) {
        this._source = source;
    }
}

