/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.event.smis;

public enum FRUPowerOperStatusType {
    OTHER(1, "Off due to Unknown Reasons"),
    ON(2, "On"),
    OFF_ADMIN(3, "Administratively Off"),
    OFF_DENIED(4, "Off due to Insufficient Power"),
    OFF_ENV_POWER(5, "Off due to Power Problem"),
    OFF_ENV_TEMP(6, "Off due to Temperature Problems"),
    OFF_ENV_FAN(7, "Off due to Fan Problems"),
    FAILED(8, "FRU is in failed state"),
    ON_BUT_FAN_FAIL(9, "On, but fan has failed"),
    OFF_COOLING(10, "Off due to Insufficient cooling"),
    OFF_CONN_RATING(11, "Off due to exceeding System's Connector Ratings"),
    ON_BUT_INLINE_POWER_FAIL(12, "On, but inline power has failed");

    int _value;
    String _status;
    public static final FRUPowerOperStatusType[] _types;

    private FRUPowerOperStatusType(int _value, String _status) {
        this._value = _value;
        this._status = _status;
    }

    public int value() {
        return this._value;
    }

    public String status() {
        return this._status;
    }

    public String toString() {
        return this._status;
    }

    public static FRUPowerOperStatusType getTypeByValue(int value) {
        for (FRUPowerOperStatusType type : _types) {
            if (type._value != value) continue;
            return type;
        }
        return null;
    }

    public static FRUPowerOperStatusType getTypeByName(String name) {
        for (FRUPowerOperStatusType type : _types) {
            if (type._status.indexOf(name) < 0) continue;
            return type;
        }
        return null;
    }

    static {
        _types = FRUPowerOperStatusType.values();
    }
}

