/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model;

import com.cisco.dcbu.lib.jnm.IpUtil;
import com.cisco.dcbu.lib.jnm.SwitchAttrIf;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.model.SwitchIf;
import com.cisco.dcbu.sm.common.model.SwitchLicenseDetails;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.PlatformType;
import com.cisco.dcbu.sm.common.type.SerialNumKey;
import java.net.InetAddress;
import java.util.HashSet;

public abstract class AbstractSwitchBase<E extends PKIf>
extends BaseModelObject
implements SwitchIf,
SwitchAttrIf {
    static final long serialVersionUID = 1L;
    public static final int NUM_FEATURES = Feature.allTypes.length;
    public static final int NUM_FEATURESETS = FeatureSet.allTypes.length;
    protected E _pkey;
    protected SerialNumKey _chassisKey;
    protected boolean _isManageable;
    protected String _unmanageableCause;
    protected InetAddress[] _mgmtAddrs;
    protected InetAddress _mgmtAddrInUse;
    protected HashSet _mgmtAddrSet = new HashSet();
    protected byte[] _sysObjectId;
    protected String _sysName;
    protected String _sysDescr;
    protected String _sysContact;
    protected String _sysLocation;
    protected long _sysUpTime;
    protected long _swUpTime;
    protected int _sysCpuUsage;
    protected int _sysMemoryUsage;
    protected String _version;
    protected String _vendorId;
    protected PlatformType _platformType = PlatformType.UNKNOWN;
    protected String _platformName;
    protected int _type = -1;
    protected String _modelName;
    protected SwitchLicenseDetails _licDetails = null;
    protected String _name;
    protected String _primaryIp;
    protected String _secondaryIp;
    protected int _activeSupPhyIndex = -1;
    protected int _standbySupPhyIndex = -1;
    protected int _activeSupSlot = -1;
    protected int _standbySupSlot = -1;
    protected int _activeSupState = -1;
    protected int _standbySupState = -1;
    protected int _connUnitStatus;
    protected int _cardOffset = 9999;
    protected boolean _isTelnetEnabled = false;
    protected boolean _isSSHEnabled = false;
    protected boolean _isLicenseViolation = false;
    protected boolean _isTrapRegistered = false;
    protected boolean _isSyslogRegistered = false;
    protected boolean _isCdpEnabled = false;
    protected boolean _isFCoECapable = false;
    protected boolean _isDelayLinkEnabled = false;
    protected boolean _isVdc = false;
    protected boolean _isFex = false;
    protected short _fcoeCapability = (short)-1;
    protected final boolean[] _featureFlags = new boolean[NUM_FEATURES];
    protected FeatureStatus _fcoeFeatureSetStatus = FeatureStatus.unknown;
    protected FeatureStatus _fexFeatureSetStatus = FeatureStatus.unknown;
    protected int[] _cardTypes = null;

    protected AbstractSwitchBase(E swPK) {
        this._pkey = swPK;
    }

    protected AbstractSwitchBase(AbstractSwitchBase<E> sw) {
        this(sw.getSwitchPK());
        this.sync(sw);
    }

    public void sync(AbstractSwitchBase<E> sw) {
        super.sync(sw);
        this._isManageable = sw._isManageable;
        this._unmanageableCause = sw._unmanageableCause;
        this._mgmtAddrs = sw._mgmtAddrs;
        this._mgmtAddrSet.clear();
        this._mgmtAddrSet.addAll(sw._mgmtAddrSet);
        this._mgmtAddrInUse = sw._mgmtAddrInUse;
        this._sysObjectId = sw._sysObjectId;
        this._sysName = sw._sysName;
        this._sysDescr = sw._sysDescr;
        this._sysContact = sw._sysContact;
        this._sysLocation = sw._sysLocation;
        this._sysUpTime = sw._sysUpTime;
        this._swUpTime = sw._swUpTime;
        this._sysCpuUsage = sw._sysCpuUsage;
        this._sysMemoryUsage = sw._sysMemoryUsage;
        this._version = sw._version;
        this._chassisKey = sw._chassisKey;
        this._chassisKey = sw._chassisKey;
        this._vendorId = sw._vendorId;
        this._platformType = sw._platformType;
        this._platformName = sw._platformName;
        this._type = sw._type;
        this._modelName = sw._modelName;
        this._licDetails = sw._licDetails;
        this._name = sw._name;
        this._activeSupPhyIndex = sw._activeSupPhyIndex;
        this._standbySupPhyIndex = sw._standbySupPhyIndex;
        this._activeSupSlot = sw._activeSupSlot;
        this._standbySupSlot = sw._standbySupSlot;
        this._activeSupState = sw._activeSupState;
        this._standbySupState = sw._standbySupState;
        this._connUnitStatus = sw._connUnitStatus;
        this._cardOffset = sw._cardOffset;
        this._isTelnetEnabled = sw._isTelnetEnabled;
        this._isSSHEnabled = sw._isSSHEnabled;
        this._isLicenseViolation = sw._isLicenseViolation;
        this._isTrapRegistered = sw._isTrapRegistered;
        this._isSyslogRegistered = sw._isSyslogRegistered;
        this._isCdpEnabled = sw._isCdpEnabled;
        this._isFCoECapable = sw._isFCoECapable;
        this._isDelayLinkEnabled = sw._isDelayLinkEnabled;
        this._isVdc = sw._isVdc;
        this._fcoeCapability = sw._fcoeCapability;
        System.arraycopy(sw._featureFlags, 0, this._featureFlags, 0, NUM_FEATURES);
        this._fcoeFeatureSetStatus = sw._fcoeFeatureSetStatus;
        this._fexFeatureSetStatus = sw._fexFeatureSetStatus;
        if (sw._cardTypes == null) {
            this._cardTypes = null;
        } else {
            this._cardTypes = new int[sw._cardTypes.length];
            System.arraycopy(this._cardTypes, 0, sw._cardTypes, 0, this._cardTypes.length);
        }
    }

    @Override
    public InetAddress[] getManagementAddresses() {
        return this._mgmtAddrs;
    }

    public void setManagementAddresses(InetAddress[] addrs) {
        this._mgmtAddrs = addrs;
        this._mgmtAddrSet.clear();
        if (this._mgmtAddrs != null) {
            for (InetAddress addr : this._mgmtAddrs) {
                this._mgmtAddrSet.add(addr);
            }
        }
    }

    public boolean containsMgmtAddr(InetAddress addr) {
        if (addr == null) {
            return false;
        }
        return this._mgmtAddrSet.contains(addr);
    }

    public int getNumOfMgmtAddrs() {
        return this._mgmtAddrSet.size();
    }

    @Override
    public String getIpAddress() {
        return this._mgmtAddrInUse != null ? this._mgmtAddrInUse.getHostAddress() : null;
    }

    @Override
    public InetAddress getInetAddress() {
        return this._mgmtAddrInUse;
    }

    public void setManagementAddressInUse(InetAddress addr) {
        this._mgmtAddrInUse = addr;
    }

    public InetAddress getManagementAddressInUse() {
        return this._mgmtAddrInUse;
    }

    public byte[] getSysObjectId() {
        return this._sysObjectId;
    }

    public void setSysObjectId(byte[] objectId) {
        this._sysObjectId = objectId;
    }

    public String getSysName() {
        return this._sysName;
    }

    public void setSysName(String newName) {
        this._sysName = newName;
    }

    public String getSysDescr() {
        return this._sysDescr;
    }

    public void setSysDescr(String newDescr) {
        this._sysDescr = newDescr;
    }

    public String getSysLocation() {
        return this._sysLocation;
    }

    public void setSysLocation(String newLocation) {
        this._sysLocation = newLocation;
    }

    public String getSysContact() {
        return this._sysContact;
    }

    public void setSysContact(String newContact) {
        this._sysContact = newContact;
    }

    @Override
    public long getSysUpTime() {
        return this._sysUpTime;
    }

    public void setSysUpTime(long sysUpTime) {
        this._sysUpTime = sysUpTime;
    }

    public long getSwitchUpTime() {
        return this._swUpTime;
    }

    public void setSwitchUpTime(long swUpTime) {
        this._swUpTime = swUpTime;
    }

    public int getSysCpuUsage() {
        return this._sysCpuUsage;
    }

    public void setSysCpuUsage(int usage) {
        this._sysCpuUsage = usage;
    }

    public int getSysMemoryUsage() {
        return this._sysMemoryUsage;
    }

    public void setSysMemoryUsage(int usage) {
        this._sysMemoryUsage = usage;
    }

    public String getSerialNumber() {
        if (this._chassisKey == null) {
            return null;
        }
        return this._chassisKey._serialNum;
    }

    public void setSerialNumber(String serialNum) {
        if (!(serialNum == null || serialNum.length() <= 0 || this._chassisKey != null && serialNum.equals(this._chassisKey._serialNum))) {
            this._chassisKey = new SerialNumKey(serialNum);
        }
    }

    public void setChassisKey(SerialNumKey snKey) {
        if (snKey != null) {
            this._chassisKey = snKey;
        }
    }

    @Override
    public SerialNumKey getChassisKey() {
        return this._chassisKey;
    }

    public boolean isManageable() {
        return this._isManageable;
    }

    public void setManageable(boolean isManageable) {
        this._isManageable = isManageable;
    }

    public String getUnmanageableCause() {
        return this._unmanageableCause;
    }

    public void setUnmanageableCause(String cause) {
        this._unmanageableCause = cause;
    }

    public boolean isTelnetEnabled() {
        return this._isTelnetEnabled;
    }

    public void setTelnetEnabled(boolean b) {
        this._isTelnetEnabled = b;
    }

    public boolean isDelayLinkEnabled() {
        return this._isDelayLinkEnabled;
    }

    public void setDelayLinkEnabled(boolean b) {
        this._isDelayLinkEnabled = b;
    }

    public boolean isSSHEnabled() {
        return this._isSSHEnabled;
    }

    public void setSSHEnabled(boolean b) {
        this._isSSHEnabled = b;
    }

    @Override
    public boolean isCdpEnabled() {
        return this._isCdpEnabled;
    }

    public void setCdpEnabled(boolean enabled) {
        this._isCdpEnabled = enabled;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    @Override
    public int getFCIPMaxBWDefault(int ifHighSpeed) {
        if (ifHighSpeed == 1000) {
            return 1000000;
        }
        if (ifHighSpeed == 10000) {
            return 5000000;
        }
        return 0;
    }

    @Override
    public int getFCIPMinAvailBWDefault(int portSpeed) {
        if (portSpeed == 1000) {
            return 15000;
        }
        if (portSpeed == 10000) {
            return 4000000;
        }
        return 0;
    }

    @Override
    public String getVersion() {
        return this._version;
    }

    public void setVersion(String newVersion) {
        this._version = newVersion;
    }

    public String getPlatformName() {
        return this._platformName;
    }

    public void setPlatformName(String name) {
        if (name != this._platformName) {
            this._platformType = PlatformType.getTypeByDeviceKey(name);
        }
        this._platformName = name;
    }

    public PlatformType getPlatformType() {
        return this._platformType;
    }

    public void setPlatformType(PlatformType type) {
        this._platformType = type;
    }

    public int getModelType() {
        return this._type;
    }

    public void setModelType(int type) {
        this._type = type;
    }

    public String getModelName() {
        return this._modelName;
    }

    public void setModelName(String newModel) {
        this._modelName = newModel;
    }

    public String getVendor() {
        return this._vendorId;
    }

    public void setVendor(String vendorId) {
        this._vendorId = vendorId;
    }

    public void setLicenseViolation(boolean violation) {
        this._isLicenseViolation = violation;
    }

    public boolean isLicenseViolation() {
        return this._isLicenseViolation;
    }

    public boolean isTrapRegistered() {
        return this._isTrapRegistered;
    }

    @Override
    public void setTrapRegistered(boolean b) {
        this._isTrapRegistered = b;
    }

    public boolean isSyslogRegistered() {
        return this._isSyslogRegistered;
    }

    public void setSyslogRegistered(boolean b) {
        this._isSyslogRegistered = b;
    }

    public int getActiveSupPhysicalIndex() {
        return this._activeSupPhyIndex;
    }

    public void setActiveSupPhysicalIndex(int activeSupPhyIndex) {
        this._activeSupPhyIndex = activeSupPhyIndex;
    }

    public int getStandbySupPhysicalIndex() {
        return this._standbySupPhyIndex;
    }

    public void setStandbySupPhysicalIndex(int standbySupPhyIndex) {
        this._standbySupPhyIndex = standbySupPhyIndex;
    }

    public int getActiveSupState() {
        return this._activeSupState;
    }

    public int setActiveSupState(int newState) {
        int oldState = this._activeSupState;
        this._activeSupState = newState;
        return oldState;
    }

    public int getStandbySupState() {
        return this._standbySupState;
    }

    public int setStandbySupState(int newState) {
        int oldState = this._standbySupState;
        this._standbySupState = newState;
        return oldState;
    }

    public boolean isHotStandby() {
        return this._standbySupState == 9;
    }

    public int getActiveSupSlot() {
        if (this._activeSupSlot != -1) {
            return this._activeSupSlot;
        }
        if (this._activeSupPhyIndex == -1) {
            return this._activeSupPhyIndex;
        }
        return this._activeSupPhyIndex - this.getModuleIndexOffset();
    }

    public void setActiveSupSlot(int slot) {
        this._activeSupSlot = slot;
    }

    public int getStandbySupSlot() {
        if (this._standbySupSlot != -1) {
            return this._standbySupSlot;
        }
        if (this._standbySupPhyIndex == -1) {
            return this._standbySupPhyIndex;
        }
        return this._standbySupPhyIndex - this.getModuleIndexOffset();
    }

    public void setStandbySupSlot(int slot) {
        this._standbySupSlot = slot;
    }

    @Override
    public int getModuleIndexOffset() {
        return this._cardOffset != 9999 ? this._cardOffset : (this.isCAT() ? 999 : 21);
    }

    public void setModuleIndexOffset(int offset) {
        this._cardOffset = offset;
    }

    public int getConnUnitStatus() {
        return this._connUnitStatus;
    }

    public int setConnUnitStatus(int status) {
        int oldStatus = this._connUnitStatus;
        this._connUnitStatus = status;
        return oldStatus;
    }

    public SwitchLicenseDetails getLicenseDetails() {
        return this._licDetails;
    }

    public void setLicenseDetails(SwitchLicenseDetails licDetails) {
        this._licDetails = licDetails;
    }

    public boolean isLicensed() {
        if (this._licDetails == null) {
            return false;
        }
        return this._licDetails.isLicensed();
    }

    @Override
    public E getSwitchPK() {
        return this._pkey;
    }

    @Override
    public PKIf getPK() {
        return this._pkey;
    }

    public boolean isChassis() {
        return true;
    }

    @Override
    public int[] getCardTypeInSlots() {
        return this._cardTypes;
    }

    @Override
    public void setCardTypeInSlots(int[] cardTypes) {
        this._cardTypes = cardTypes;
    }

    public String getPrimaryIp() {
        return this._primaryIp;
    }

    public void setPrimaryIp(String _primaryIp) {
        this._primaryIp = _primaryIp;
    }

    public final String getSecondaryIp() {
        return this._secondaryIp;
    }

    public final void setSecondaryIp(String secondaryIp) {
        this._secondaryIp = secondaryIp;
    }

    public boolean[] getFeatureFlags() {
        boolean[] featureFlagsCopy = new boolean[NUM_FEATURES];
        System.arraycopy(this._featureFlags, 0, featureFlagsCopy, 0, NUM_FEATURES);
        return featureFlagsCopy;
    }

    public void setFeatureFlags(boolean[] flags) {
        if (flags != null && flags.length == NUM_FEATURES) {
            System.arraycopy(flags, 0, this._featureFlags, 0, NUM_FEATURES);
        }
    }

    public boolean isFeatureEnabled(String featureName) {
        Feature feature = Feature.getFeature(featureName);
        if (feature != null) {
            return this.isFeatureEnabled(feature);
        }
        return false;
    }

    public static String getFeatureString(boolean[] flags) {
        if (flags == null) {
            return "";
        }
        int len = Math.min(NUM_FEATURES, flags.length);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            if (!flags[i]) continue;
            sb.append(Feature.allTypes[i].toString()).append(", ");
        }
        if (sb.length() > 2) {
            sb.setLength(sb.length() - 2);
        }
        return sb.toString();
    }

    public String getFeatureString() {
        return AbstractSwitchBase.getFeatureString(this._featureFlags);
    }

    public boolean isFeatureEnabled(Feature feature) {
        return this._featureFlags[feature.flag()];
    }

    public boolean isFeatureEnabled(int featureFlag) {
        return this._featureFlags[featureFlag];
    }

    public void setFeatureFlag(Feature feature, boolean value) {
        this._featureFlags[feature.flag()] = value;
    }

    public void setFeatureFlag(int flag, boolean value) {
        this._featureFlags[flag] = value;
    }

    public String getFeatureFlagsDB() {
        String dbRepStr = new String();
        for (boolean b : this._featureFlags) {
            dbRepStr = b ? dbRepStr + "1" : dbRepStr + "0";
        }
        return dbRepStr;
    }

    public void setFeatureFlagsDB(String dbRepStr) {
        if (dbRepStr == null) {
            return;
        }
        if (dbRepStr.length() != NUM_FEATURES) {
            return;
        }
        for (int i = 0; i < NUM_FEATURES; ++i) {
            char c = dbRepStr.charAt(i);
            this._featureFlags[i] = c == '1';
        }
    }

    public boolean isAnyFeatureEnabled() {
        for (int i = 0; i < NUM_FEATURES; ++i) {
            if (!this._featureFlags[i]) continue;
            return true;
        }
        return false;
    }

    public void setFCoECapable(boolean capable) {
        this._isFCoECapable = capable;
    }

    public boolean isFCoECapable() {
        return this._isFCoECapable;
    }

    public boolean isFCoECapableVersion() {
        if (this._platformType != PlatformType.UNKNOWN) {
            return FRUConstants.isFCoECapableVersion(this._platformType, this._version);
        }
        if (this._type != -1) {
            return FRUConstants.isFCoECapableVersion(this._type, this._version);
        }
        return false;
    }

    public void setFCoEFeatureSetStatus(int value) {
        this._fcoeFeatureSetStatus = FeatureStatus.getStatus(value);
    }

    public FeatureStatus getFCoFeatureSetStatus() {
        return this._fcoeFeatureSetStatus;
    }

    public boolean hasFCoEInstalled() {
        if (this.isCAT()) {
            return false;
        }
        if (this.isNuovaFamily()) {
            return true;
        }
        if (this._fcoeFeatureSetStatus == null) {
            return false;
        }
        return this._fcoeFeatureSetStatus == FeatureStatus.installed || this._fcoeFeatureSetStatus == FeatureStatus.enabled || this._fcoeFeatureSetStatus == FeatureStatus.disabled;
    }

    public void setVdc(boolean vdc) {
        this._isVdc = vdc;
    }

    public boolean isVdc() {
        return this._isVdc;
    }

    public boolean isDefaultVdc() {
        return false;
    }

    public short getFCoECapability() {
        return this._fcoeCapability;
    }

    public void setFCoECapability(short capability) {
        this._fcoeCapability = capability;
    }

    public boolean isVdcCapableVersion() {
        if (this._platformType != PlatformType.UNKNOWN) {
            return FRUConstants.isVdcCapableVersion(this._platformType, this._version);
        }
        if (this._type != -1) {
            return FRUConstants.isVdcCapableVersion(this._type, this._version);
        }
        return false;
    }

    public void setDeviceId(String id) {
    }

    public String getDeviceId() {
        return "";
    }

    public void setGlobalDeviceId(String id) {
    }

    public String getGlobalDeviceId() {
        return "";
    }

    public void setVtpMgmtDomain(byte[] vtpDomain) {
    }

    public byte[] getVtpMgmtDomain() {
        return null;
    }

    public void setNumEthPorts(int num) {
    }

    public boolean isFex() {
        return this._isFex;
    }

    public void setFexFeatureSetStatus(int value) {
        this._fexFeatureSetStatus = FeatureStatus.getStatus(value);
    }

    public FeatureStatus getFexFeatureSetStatus() {
        return this._fexFeatureSetStatus;
    }

    public boolean hasFexInstalled() {
        if (this.isCAT()) {
            return false;
        }
        if (this.isNuovaFamily()) {
            return true;
        }
        if (this._fexFeatureSetStatus == null) {
            return false;
        }
        return this._fexFeatureSetStatus == FeatureStatus.installed || this._fexFeatureSetStatus == FeatureStatus.enabled || this._fexFeatureSetStatus == FeatureStatus.disabled;
    }

    public boolean isFexCapableVersion() {
        if (this._platformType != PlatformType.UNKNOWN) {
            return FRUConstants.isFexCapableVersion(this._platformType, this._version);
        }
        if (this._type != -1) {
            return FRUConstants.isFexCapableVersion(this._type, this._version);
        }
        return false;
    }

    public abstract String getModel();

    public abstract boolean isBrocade();

    public abstract boolean isCisco();

    public abstract boolean isMdsDirector();

    @Override
    public abstract boolean isQuail();

    public abstract boolean isParadise();

    public abstract boolean isSabre();

    @Override
    public abstract boolean isMDS();

    public abstract void setMDS(boolean var1);

    public abstract boolean isCAT();

    public abstract boolean isN4K();

    @Override
    public abstract boolean isN5K();

    public abstract boolean isN6K();

    public abstract boolean isUCS();

    @Override
    public abstract boolean isN7K();

    public abstract boolean isN9K();

    public abstract boolean allowDiscoverMoreOnFC();

    public abstract boolean allowDiscoverMoreOnCDP();

    @Override
    public abstract boolean isVersionGreaterThan(String var1);

    @Override
    public abstract boolean isVersionGreaterThanEqual(String var1);

    public abstract boolean isVersionLessThan(String var1);

    public abstract boolean isVersionLessThanEqual(String var1);

    public abstract boolean isVersion1_0();

    public abstract int getNumPorts();

    public abstract int getNumSlots();

    public abstract int getNumFcPorts();

    public abstract int getNumEthPorts();

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        AbstractSwitchBase sw1 = (AbstractSwitchBase)o1;
        AbstractSwitchBase sw2 = (AbstractSwitchBase)o2;
        if (sw1 == null) {
            return -1;
        }
        if (sw2 == null) {
            return 1;
        }
        int ret = IpUtil.compare(sw1.getInetAddress(), sw2.getInetAddress());
        if (ret != 0) {
            return ret;
        }
        if (sw1.getPK() == sw2.getPK()) {
            return 0;
        }
        if (sw1.getPK() == null && sw2.getPK() != null) {
            return -1;
        }
        if (sw1.getPK().getClass() == sw2.getPK().getClass()) {
            return sw1.getPK().compare(sw1.getPK(), sw2.getPK());
        }
        return sw1.getPK().toString().compareTo(String.valueOf(sw2.getPK()));
    }

    @Override
    public int compareTo(Object o) {
        return this.compare(this, o);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public static enum FeatureStatus {
        unknown(1),
        enabled(2),
        disabled(3),
        installed(4),
        uninstalled(5);

        public static final FeatureStatus[] _statuses;
        private int _value;

        private FeatureStatus(int value) {
            this._value = value;
        }

        public int value() {
            return this._value;
        }

        public static FeatureStatus getStatus(int value) {
            for (FeatureStatus status : _statuses) {
                if (status.value() != value) continue;
                return status;
            }
            return unknown;
        }

        static {
            _statuses = FeatureStatus.values();
        }
    }

    public static enum FeatureSet {
        FCOE(1, "FCOE"),
        L2MP(2, "FABRICPATH"),
        FEX(3, "FEX"),
        MPLS(4, "MPLS");

        public static FeatureSet[] allTypes;
        private int _mibIndex;
        private String _name;

        private FeatureSet(int mibIndex, String name) {
            this._mibIndex = mibIndex;
            this._name = name;
        }

        public String toString() {
            return this._name;
        }

        public int mibIndex() {
            return this._mibIndex;
        }

        public static FeatureSet getFeatureSetByMib(int mibIndex) {
            return FeatureSet.getFeatureSetByFlag(mibIndex - 1);
        }

        public static FeatureSet getFeatureSetByFlag(int flag) {
            if (flag >= 0 && flag < allTypes.length) {
                return allTypes[flag];
            }
            return null;
        }

        public static FeatureSet getFeatureSet(String name) {
            for (FeatureSet f : allTypes) {
                if (!f._name.equalsIgnoreCase(name)) continue;
                return f;
            }
            return null;
        }

        static {
            allTypes = FeatureSet.values();
        }
    }

    public static enum Feature {
        IVR(1, "IVR"),
        FCIP(2, "FCIP"),
        FCSP(3, "FCSP"),
        FICON(4, "FICON"),
        ISCSI(5, "iSCSI"),
        TACACS(6, "TACACS"),
        QOS(7, "Qos"),
        PORTSEC(8, "Port Security"),
        FABRICBIND(9, "Fabric Binding"),
        ISCSIIFVSAN(10, "iSCSI Interface Vsan Membership"),
        IKE(11, "IKE"),
        ISNS(12, "iSNS"),
        IPSEC(13, "IPSec"),
        PORTTRACKER(14, "Port Tracker"),
        SCHEDULER(15, "Scheduler"),
        NPIV(16, "NPIV"),
        SANEXTTUNER(17, "SAN Extension Tuner"),
        DPVM(18, "DPVM"),
        EXTCREDIT(19, "Extended Credit"),
        CLOUDDISC(20, "Cloud Discovery"),
        ISIS(21, "IS-IS"),
        OSPF(22, "OSPF"),
        OSPFV(23, "OSPFv3"),
        RIP(24, "RIP"),
        BGP(25, "BGP"),
        PIM(26, "PIM"),
        IGM(27, "IGMP"),
        MSDP(28, "MSDP"),
        PIM6(29, "PIM6"),
        EIGRP(30, "EIGRP"),
        SDV(31, "SDV"),
        CLUSTER(32, "CLUSTER"),
        SME(33, "SME"),
        LACP(34, "LACP"),
        AMT(35, "AMT"),
        DOT1X(36, "DOT1X"),
        NPV(37, "NPV"),
        L2NAC(38, "L2NAC"),
        GLBP(39, "GLBP"),
        DHCPSNOOP(40, "DHCPSnoop"),
        HSRP(41, "HSRP"),
        SVI(42, "SVI"),
        VMM(43, "VMM"),
        PVLAN(44, "PLVLAN"),
        TM(45, "tunnelManager"),
        ETHPORTSEC(46, "ethPortSec"),
        LISP(47, "LISP"),
        CTS(48, "CTS"),
        COPP(49, "COPP"),
        UDLD(50, "UDLD"),
        MCECM(51, "MCECM"),
        PBR(52, "PBR"),
        NFM(53, "NFM"),
        ISAPI(54, "ISAPI"),
        VRRP(55, "VRRP"),
        NETSIFT(56, "NETSIFT"),
        ISISL2(57, "ISISL2"),
        CIMSVR(58, "CIM_SERVER"),
        OTV(59, "OTV"),
        SANTAP(60, "SAN_TAP"),
        NASB(61, "NASB"),
        DMM(62, "DMM"),
        U2RIB(63, "U2RIB"),
        ISISOTV(64, "isisOtv"),
        ORIB(65, "ORIB"),
        FCOE(66, "FCOE"),
        SIASERVICEBROKER(67, "siaServiceBorker"),
        EVFP(68, "Fport channel trunk"),
        VTP(69, "VTP"),
        SPLITTER(70, "SPITTER"),
        SFM(71, "SFM"),
        IOA(72, "IOA"),
        TELNET(73, "TELNET_SERVER"),
        SSH(74, "SSH_SERVER"),
        HTTP(75, "HTTP_SERVER"),
        WCCP(76, "WCCP"),
        SIASVE(77, "SIASVE"),
        XCVRFREQ(78, "XCVRFREQ"),
        ASSOCMGR(79, "ASSOCMGR"),
        LLDP(80, "LLDP"),
        RSVP(81, "RSVP"),
        LDP(82, "LDP"),
        TE(83, "TE"),
        MPLSOAM(84, "MPLSOAM"),
        L2VPN(85, "L2VPN"),
        DRAP(86, "DRAP"),
        BFD(87, "BFD"),
        BFDAPP(88, "BFD_APP"),
        FEX(89, "FEX"),
        PONG(90, "PONG"),
        PTP(91, "PTP"),
        LDAP(92, "LDAP"),
        PRIVILEGE(93, "PRIVILEGE"),
        OIM(94, "OIM"),
        MPLSMGR(95, "MPLSMGR"),
        ULIB(96, "ULIB"),
        SCP(97, "SCP"),
        SFTP(98, "SFTP"),
        L3VPN(99, "L3VPN"),
        L2VPNIP(100, "L2VPN"),
        MVPN(101, "MVPN"),
        IPPOOL(102, "IPPOOL"),
        UUFB(103, "UUFB"),
        UMFB(104, "UMFB"),
        FCOENPV(105, "FCOE_NPV"),
        WCCP_CLIENT(106, "WCCP_CLIENT"),
        SCADAGW(107, "SCADAGW"),
        POE(108, "POE"),
        FLEXLINK(109, "FLEXLINK"),
        NIV(110, "NIV"),
        VEM(111, "VEM"),
        EWISE(112, "EWISE"),
        ONEP(113, "ONEP"),
        SLAS(114, "SLA_SENDER"),
        SLAR(115, "SLA_RECEIVER"),
        RISE(116, "RISE"),
        PPPMGR(117, "PPP_MANAGER"),
        ITRON_MCASTAGENT(118, "ITRON_MCAST_AGENT"),
        VSM_AGGREGATION(119, "VSM_AGGREGATION"),
        SEGMENTATION(120, "SEGMENTATION"),
        VRRPV3(121, "VRRPV3"),
        VTRACKER(122, "VTRACKER"),
        FDMI(123, "FDMI"),
        CMM(124, "CMM"),
        NTP(125, "NTP"),
        FABRICMGR(126, "FABRICMGR"),
        NAT(127, "NAT"),
        VLAN_VNSEG(128, "VLAN_VNSEG"),
        BULK_STAT(129, "BULK_STAT"),
        BBU(130, "BBU"),
        VN_SEGMENT(131, "VN_SEGMENT"),
        EVB(132, "EVB"),
        L2MP(133, "FABRICPATH"),
        NG_MVPN(134, "NG_MVPN"),
        HMM(135, "HMM"),
        VX_LAN(136, "VX_LAN"),
        MVRP(137, "MVRP"),
        EVMED(138, "EVMED"),
        NSE_MGR(139, "NETWORK_SEGMENTATION"),
        POAP(200, "POAP");

        public static Feature[] allTypes;
        private int _mibIndex;
        private String _name;

        private Feature(int mibIndex, String name) {
            this._mibIndex = mibIndex;
            this._name = name;
        }

        public String toString() {
            return this._name;
        }

        public int mibIndex() {
            return this._mibIndex;
        }

        public int flag() {
            return this._mibIndex - 1;
        }

        public static Feature getFeatureByMib(int mibIndex) {
            return Feature.getFeatureByFlag(mibIndex - 1);
        }

        public static Feature getFeatureByFlag(int flag) {
            if (flag >= 0 && flag < allTypes.length) {
                return allTypes[flag];
            }
            return null;
        }

        public static Feature getFeature(String name) {
            for (Feature f : allTypes) {
                if (!f._name.equalsIgnoreCase(name)) continue;
                return f;
            }
            return null;
        }

        static {
            allTypes = Feature.values();
        }
    }
}

