/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model;

import com.cisco.dcbu.lib.jnm.IpUtil;
import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.model.DumpIf;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.type.DiscStateType;
import com.cisco.dcbu.sm.common.type.DiscStatusType;
import com.cisco.dcbu.sm.common.type.DiscTaskType;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.PlatformType;
import com.cisco.dcbu.sm.common.type.TaskKey;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CdpSeedBase
extends BaseModelObject
implements DumpIf {
    static final long serialVersionUID = 1L;
    public static final String Cdp_Prop_MaxHops = "cdp.maxhops";
    public static final String Cdp_Prop_IncDevices = "cdp.incDevices";
    public static final String Cdp_Prop_PollInterval = "cdp.poll.interval";
    public static final String Cdp_Prop_RediscvInterval = "cdp.rediscover.interval";
    public static final short CDPSEED_ATTR = 3328;
    public static final short ATTR_NAME = 3329;
    public static final short ATTR_TASKPK = 3330;
    public static final short ATTR_DISCETHSWS = 3331;
    public static final String[] _Attrs = new String[]{"cdpSeedName", "taskPK", "discEthSws"};
    public static final int Cdp_Default_MaxHops = 5;
    public static final PlatformType[] Cdp_Default_IncDevices = new PlatformType[]{PlatformType.N5K, PlatformType.N6K, PlatformType.N7K, PlatformType.CAT};
    public static final int Cdp_Default_PollInterval = 600;
    public static final int Cdp_Default_RediscvInterval = 5;
    public static final int SeedType_Default = 1;
    public static final int SeedType_FcImport = 2;
    public static int Cdp_System_MaxHops = Integer.getInteger("cdp.maxhops", 5);
    private TaskKey _pk = null;
    private DiscTaskType _taskType = null;
    private final HashSet<InetAddress> _seedIPs = new HashSet();
    private SnmpUserOpt _snmpUser = null;
    private SnmpUser _credential = null;
    private String _enablePwd = null;
    private String _ipRangeStr = null;
    private String _maskStr = null;
    private String _subnetStr = null;
    private String _dcnmUser = null;
    private int _maxHop = 5;
    private long _groupDBID = 1L;
    private long _createTime = 0L;
    private long _deepTaskId = -1L;
    private long _deepUpdateTime = 0L;
    private boolean _manageable = true;
    private boolean _fwsm = false;
    private boolean _deepDisc = false;
    private int _peerTimeout;
    private int _peerRetries;
    private long _initTime = 0L;
    private DiscStateType _discState = DiscStateType.UNMANAGE;
    private DiscStatusType _discStatus = DiscStatusType.INIT;
    private DiscStatusType _deepDiscStatus = DiscStatusType.UNMANAGED;
    private final Set<PKIf> _discEthSwitchPKs = Collections.synchronizedSet(new HashSet());
    private PKIf _seedSwPK = null;
    private String _deepDiscDescription;

    private CdpSeedBase(TaskKey key) {
    }

    public CdpSeedBase(TaskKey pk, InetAddress seedIP, int maxHop, SnmpUserOpt snmpUser, String enablePwd, long groupDBID, long createTime, String dcnmUser, boolean deepDisc) {
        this._pk = pk;
        this._seedIPs.clear();
        this._seedIPs.add(seedIP);
        this._maxHop = maxHop;
        this._snmpUser = snmpUser;
        if (this._snmpUser != null) {
            this._credential = SnmpUserOpt.convertToSnmpUser(snmpUser);
        }
        this._enablePwd = enablePwd;
        this._taskType = DiscTaskType.LAN_MAXHOP;
        this._groupDBID = groupDBID;
        this._createTime = createTime;
        this._dcnmUser = dcnmUser;
        this._deepDisc = deepDisc;
    }

    public CdpSeedBase(TaskKey pk, List<InetAddress> seedIPs, int maxHop, SnmpUserOpt snmpUser, String enablePwd, long groupDBID, long createTime, String dcnmUser, boolean deepDisc) {
        this._pk = pk;
        this._seedIPs.clear();
        this._seedIPs.addAll(seedIPs);
        this._maxHop = maxHop;
        this._snmpUser = snmpUser;
        if (this._snmpUser != null) {
            this._enablePwd = enablePwd;
        }
        this._credential = SnmpUserOpt.convertToSnmpUser(snmpUser);
        this._taskType = DiscTaskType.LAN_IPLIST;
        this._groupDBID = groupDBID;
        this._createTime = createTime;
        this._dcnmUser = dcnmUser;
        this._deepDisc = deepDisc;
    }

    public CdpSeedBase(TaskKey pk, List<InetAddress> seedIPs, SnmpUserOpt snmpUser, String enablePwd, long groupDBID, long createTime, String dcnmUser, boolean deepDisc) {
        this(pk, seedIPs, 1, snmpUser, enablePwd, groupDBID, createTime, dcnmUser, deepDisc);
    }

    public void sync(CdpSeedBase task) {
        super.sync(task);
        this._seedIPs.clear();
        this._seedIPs.addAll(task._seedIPs);
        this._maxHop = task._maxHop;
        this._snmpUser = task._snmpUser;
        this._credential = task._credential;
        this._enablePwd = task._enablePwd;
        this._groupDBID = task._groupDBID;
        this._createTime = task._createTime;
        this._peerTimeout = task._peerTimeout;
        this._peerRetries = task._peerRetries;
        this._initTime = task._initTime;
        this._discState = task._discState;
        this._discStatus = task._discStatus;
        this._discEthSwitchPKs.clear();
        this._discEthSwitchPKs.addAll(task._discEthSwitchPKs);
        this._deepTaskId = task._deepTaskId;
        this._deepUpdateTime = task._deepUpdateTime;
    }

    @Override
    public PKIf getPK() {
        return this._pk;
    }

    public TaskKey getTaskKey() {
        return this._pk;
    }

    public String getSeedIpAddress() {
        List<InetAddress> ipList = this.getSeedIPs();
        if (ipList == null || ipList.size() == 0) {
            return null;
        }
        return ipList.get(0).getHostAddress();
    }

    public InetAddress getSeedIp() {
        List<InetAddress> ipList = this.getSeedIPs();
        if (ipList == null || ipList.size() == 0) {
            return null;
        }
        return ipList.get(0);
    }

    public InetAddress setSeedIp(InetAddress seedIP) {
        InetAddress oldIp = this.getSeedIp();
        if (seedIP != null && this.isMaxHopTask()) {
            this._seedIPs.clear();
            this._seedIPs.add(seedIP);
        }
        return oldIp;
    }

    public void addSeedIp(InetAddress seedIP) {
        if (seedIP != null && this.isIPListTask()) {
            this._seedIPs.add(seedIP);
        }
    }

    public void removeSeedIp(InetAddress seedIP) {
        if (seedIP != null) {
            this._seedIPs.remove(seedIP);
        }
    }

    public PKIf getSeedSwPK() {
        return this._seedSwPK;
    }

    public void setSeedSwPK(PKIf swPK) {
        this._seedSwPK = swPK;
    }

    public String getSubnetStr() {
        return this._subnetStr;
    }

    public void setSubnetStr(String subnetStr) {
        this._subnetStr = subnetStr;
    }

    public String getIpRangeStr() {
        return this._ipRangeStr;
    }

    public void setIpRangeStr(String ipRangeStr) {
        this._ipRangeStr = ipRangeStr;
    }

    public String getMaskStr() {
        return this._maskStr;
    }

    public void setMaskStr(String maskStr) {
        this._maskStr = maskStr;
    }

    public String getDcnmUser() {
        return this._dcnmUser;
    }

    public void setDcnmUser(String dcnmUser) {
        this._dcnmUser = dcnmUser;
    }

    public List<InetAddress> getSeedIPs() {
        ArrayList<InetAddress> ret = new ArrayList<InetAddress>(this._seedIPs);
        Collections.sort(ret, IpUtil.IPComparator);
        return ret;
    }

    public int getMaxHop() {
        return this._maxHop;
    }

    public void setMaxHop(int maxHop) {
        this._maxHop = maxHop;
    }

    public SnmpUser getCredential() {
        return this._credential;
    }

    public void setCredential(SnmpUser credential) {
        this._credential = credential;
        this._snmpUser = this._credential == null ? null : SnmpUserOpt.convertToSnmpUserOpt(this._credential);
    }

    public SnmpUserOpt getSnmpUserOpt() {
        return this._snmpUser;
    }

    public void setSnmpUserOpt(SnmpUserOpt snmpUser) {
        this._snmpUser = snmpUser;
        this._credential = this._snmpUser == null ? null : SnmpUserOpt.convertToSnmpUser(this._snmpUser);
    }

    public String getUser() {
        return this._snmpUser == null ? null : this._snmpUser.getUsername();
    }

    public String getPassword() {
        return this._snmpUser == null ? null : this._snmpUser.getPassword();
    }

    public int getSnmpAuthType() {
        return this._snmpUser == null ? 0 : this._snmpUser.getSnmpV3Security();
    }

    public boolean isSnmpV3() {
        return this._snmpUser == null ? false : this._snmpUser.isV3();
    }

    public String getEnablePwd() {
        return this._enablePwd;
    }

    public void setEnablePwd(String enablePwd) {
        this._enablePwd = enablePwd;
    }

    public long getGroup() {
        return this._groupDBID;
    }

    public void setGroup(long group) {
        this._groupDBID = group;
    }

    public int getPeerTimeout() {
        return this._peerTimeout;
    }

    public void setPeerTimeout(int timeout) {
        this._peerTimeout = timeout;
    }

    public int getPeerRetries() {
        return this._peerRetries;
    }

    public void setPeerRetries(int retries) {
        this._peerRetries = retries;
    }

    public DiscTaskType getTaskType() {
        return this._taskType;
    }

    public boolean isMaxHopTask() {
        return this._taskType == DiscTaskType.LAN_MAXHOP;
    }

    public boolean isIPListTask() {
        return this._taskType == DiscTaskType.LAN_IPLIST;
    }

    public boolean isFcImportTask() {
        return this._taskType == DiscTaskType.LAN_FCIMPORT;
    }

    public boolean isDeepLanTask() {
        return this._taskType == DiscTaskType.LAN_FCIMPORT;
    }

    public void setInitTime(long time) {
        this._initTime = time;
    }

    public long getInitTime() {
        return this._initTime;
    }

    public DiscStateType getDiscState() {
        return this._discState;
    }

    public void setDiscState(DiscStateType state) {
        this._discState = state;
    }

    public DiscStatusType getDiscStatus() {
        return this._discStatus;
    }

    public void setDiscStatus(DiscStatusType status) {
        this._discStatus = status;
    }

    public DiscStatusType getDeepDiscStatus() {
        return this._deepDiscStatus;
    }

    public void setDeepDiscStatus(DiscStatusType status) {
        this._deepDiscStatus = status;
    }

    public long getCreateTime() {
        return this._createTime;
    }

    public long getDeepTaskId() {
        return this._deepTaskId;
    }

    public void setDeepTaskId(long deepTaskId) {
        this._deepTaskId = deepTaskId;
    }

    public boolean haveDeepTask() {
        return this._deepTaskId > 0L;
    }

    public long getDeepUpdateTime() {
        return this._deepUpdateTime;
    }

    public void setDeepUpdateTime(long deepUpdateTime) {
        this._deepUpdateTime = deepUpdateTime;
    }

    public boolean isManageable() {
        return this._manageable;
    }

    public void setManageable(boolean manageable) {
        this._manageable = manageable;
    }

    public boolean isFwsm() {
        return this._fwsm;
    }

    public void setFwsm(boolean fwsm) {
        this._fwsm = fwsm;
    }

    public boolean isDeepDisc() {
        return this._deepDisc;
    }

    public void setDeepDisc(boolean deepDisc) {
        this._deepDisc = deepDisc;
    }

    public String getDeepDiscDescription() {
        return this._deepDiscDescription;
    }

    public void setDeepDiscDescription(String _deepDiscDescription) {
        this._deepDiscDescription = _deepDiscDescription;
    }

    public int getNumEthSwitches() {
        return this._discEthSwitchPKs.size();
    }

    public boolean addEthSwitch(PKIf swPK) {
        return this._discEthSwitchPKs.add(swPK);
    }

    public boolean removeEthSwitch(PKIf swPK) {
        return this._discEthSwitchPKs.remove(swPK);
    }

    public boolean containsEthSwitch(PKIf swPK) {
        return this._discEthSwitchPKs.contains(swPK);
    }

    public List<PKIf> getEthSwitches() {
        ArrayList<PKIf> list = new ArrayList<PKIf>();
        list.addAll(this._discEthSwitchPKs);
        return list;
    }

    public void clearEthSwitches() {
        this._discEthSwitchPKs.clear();
    }

    @Override
    public boolean isEthObject() {
        return true;
    }

    @Override
    public boolean isFcObject() {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof CdpSeedBase) {
            CdpSeedBase that = (CdpSeedBase)obj;
            return this._pk.equals(that._pk);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this._pk.hashCode();
    }

    @Override
    public int compare(Object obj1, Object obj2) {
        CdpSeedBase o1 = null;
        CdpSeedBase o2 = null;
        if (obj1 instanceof CdpSeedBase) {
            o1 = (CdpSeedBase)obj1;
        }
        if (obj1 instanceof CdpSeedBase) {
            o2 = (CdpSeedBase)obj2;
        }
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1._pk.getClass().equals(o2._pk.getClass())) {
            return o1._pk.compare(o1._pk, o2._pk);
        }
        return o1._pk.toString().compareTo(o2._pk.toString());
    }

    public int compareTo(CdpSeedBase o) {
        return this.compare(this, o);
    }

    @Override
    public String indent(int level) {
        if (level < 0) {
            return LIL[0];
        }
        if (level >= LIL.length) {
            return LIL[LIL.length - 1];
        }
        return LIL[level];
    }

    @Override
    public String dump(boolean inDetail, int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.indent(level)).append("DiscTask: ").append(this.getPK()).append(this.indent(level + 1)).append("Type: ").append((Object)this._taskType).append(this.indent(level + 1)).append("Manageable: ").append(this._manageable).append(this.indent(level + 1)).append("Max Hop: ").append(this._maxHop).append(this.indent(level + 1)).append("Seeds: ").append(this._seedIPs);
        if (inDetail) {
            sb.append(this.indent(level + 1)).append("LastScanTime: ").append(new Date(this.getLastScanTime())).append(", Created Time: ").append(new Date(this.getCreateTime())).append(", Init Time: ").append(new Date(this.getInitTime())).append(this.indent(level + 1)).append("Group: ").append(this._groupDBID).append(this.indent(level + 1)).append("State: ").append((Object)this._discState).append(this.indent(level + 1)).append("Status: ").append((Object)this._discStatus).append(this.indent(level + 1)).append("deepTaskId: ").append(this._deepTaskId).append("deepUpdateTime: ").append(new Date(this.getDeepUpdateTime())).append(this.indent(level + 1)).append("Num of Discovered Switches: ").append(this._discEthSwitchPKs.size());
        }
        return sb.toString();
    }

    @Override
    public String print(boolean inDetail, boolean withDecor) {
        StringBuilder sb = new StringBuilder();
        sb.append("DiscTask").append("-").append(this.getTaskKey().getId()).append(withDecor ? "[" : "").append("Type=").append((Object)this._taskType).append(", MaxHop=").append(this._maxHop).append(", Seeds=").append(this._seedIPs);
        if (inDetail) {
            sb.append(", Group=").append(this._groupDBID).append(", State=").append((Object)this._discState).append(", Status=").append((Object)this._discStatus).append(", DeepTaskId=").append(this._deepTaskId).append(" deepUpdate=").append(new Date(this._deepUpdateTime)).append(" LastScan=").append(new Date(this._lastScanTime)).append(" Created=").append(new Date(this._createTime)).append(" Init=").append(new Date(this._initTime)).append(", discoveredSwitchPKs=").append(this._discEthSwitchPKs);
        }
        if (withDecor) {
            sb.append("]");
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.print(false, true);
    }

    public CdpSeedBase clone() {
        CdpSeedBase newOne = new CdpSeedBase(this._pk);
        newOne.sync(this);
        return newOne;
    }
}

