/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model;

import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.model.ClusterInterfBase;
import com.cisco.dcbu.sm.common.model.ClusterMemberBase;
import com.cisco.dcbu.sm.common.type.ClusterPK;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.PKIf;
import java.net.InetAddress;

public class ClusterBase
extends BaseModelObject {
    static final long serialVersionUID = 1L;
    public static final short CLUSTER_ATTR = 2560;
    public static final short ATTR_ISPRESENT = 2561;
    public static final short ATTR_FABRICPK = 2562;
    public static final short ATTR_STATUS = 2563;
    public static final short ATTR_MASTERINETTYPE = 2564;
    public static final short ATTR_MASTERINETADDR = 2565;
    public static final short ATTR_CINTERFS = 2566;
    public static final short ATTR_CMEMBERS = 2567;
    public static final short ATTR_TYPE = 2568;
    public static final String[] _Attrs = new String[]{"isPresent", "fabric", "status", "masterInetAddrType", "masterInetAddr", "clusterInterface", "clusterMember", "type"};
    protected FabricPK _fabricPK;
    protected final ClusterPK _clusterPK;
    private short _type;
    private short _status;
    private short _masterInetAddrType;
    private String _masterInetAddr;
    private String _masterIPAddr;
    private ClusterInterfBase[] _cInts;
    private ClusterMemberBase[] _cMembers;

    public ClusterBase(ClusterPK pk) {
        this._clusterPK = pk;
    }

    public ClusterBase(ClusterPK pk, short type, short status, short masterInetAddrType, String masterInetAddr) {
        this._type = type;
        this._clusterPK = pk;
        this._status = status;
        this._masterInetAddrType = masterInetAddrType;
        this._masterInetAddr = masterInetAddr;
    }

    @Override
    public String toString() {
        return this._clusterPK.getName();
    }

    public String getMasterInetAddr() {
        return this._masterInetAddr;
    }

    public void setMasterInetAddr(String masterInetAddr) {
        this.setModified(this._masterInetAddr == null ? masterInetAddr != null : !this._masterInetAddr.equals(masterInetAddr));
        this._masterInetAddr = masterInetAddr;
    }

    public short getMasterInetAddrType() {
        return this._masterInetAddrType;
    }

    public void setMasterInetAddrType(short masterInetAddrType) {
        this.setModified(this._masterInetAddrType != masterInetAddrType);
        this._masterInetAddrType = masterInetAddrType;
    }

    public String getClusterId() {
        return this._clusterPK.getCid();
    }

    public String getName() {
        return this._clusterPK.getName();
    }

    public void setName(String name) {
        if (this._clusterPK != null && !this._clusterPK.getName().equals(name)) {
            this.setModified(true);
        }
        this._clusterPK.setName(name);
    }

    public short getState() {
        return this._status;
    }

    public void setState(short status) {
        this.setModified(this._status != status);
        this._status = status;
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        return 1;
    }

    public FabricPK getFabricPK() {
        return this._fabricPK;
    }

    public void setFabricPK(FabricPK _fabricpk) {
        this.setModified(this._fabricPK == null ? _fabricpk != null : !this._fabricPK.equals(_fabricpk));
        this._fabricPK = _fabricpk;
    }

    public ClusterInterfBase[] getClusterInterfs() {
        return this._cInts;
    }

    public void setClusterInterfs(ClusterInterfBase[] cInts) {
        this._cInts = cInts;
    }

    public ClusterMemberBase[] getClusterMembers() {
        return this._cMembers;
    }

    public void setClusterMembers(ClusterMemberBase[] cMembers) {
        this._cMembers = cMembers;
    }

    @Override
    public PKIf getPK() {
        return this._clusterPK;
    }

    public String convertInetAddr2IPAddr() {
        try {
            InetAddress masterInet = InetAddress.getByName(this._masterInetAddr);
            return masterInet.getHostAddress();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getMasterIPAddr() {
        return this._masterIPAddr;
    }

    public void setMasterIPAddr(String addr) {
        this.setModified(this._masterIPAddr == null ? addr != null : !this._masterIPAddr.equals(addr));
        this._masterIPAddr = addr;
    }

    public short getType() {
        return this._type;
    }

    public void setType(short type) {
        this.setModified(this._type != type);
        this._type = type;
    }
}

