/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.mds.NexusEntityMibHelper;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.model.EthSwitchBase;
import com.cisco.dcbu.sm.common.model.SwitchLicenseDetails;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.SerialNumKey;
import com.cisco.dcbu.sm.server.inventory.InventoryManager;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class FexBase
extends EthSwitchBase<SerialNumKey> {
    static final long serialVersionUID = 1L;
    static final String UNMGMT_REASON = "Not a manageable device";
    private int _fexId;
    private int _numUplPort = 0;
    private int _numHifPort = 0;

    public FexBase(SerialNumKey fexPK, int fexId) {
        super(fexPK, null);
        this._fexId = fexId;
    }

    public void sync(FexBase fex) {
        super.sync(fex);
        this._fexId = fex._fexId;
    }

    public SerialNumKey getFexPK() {
        return (SerialNumKey)this._pkey;
    }

    public int getFexId() {
        return this._fexId;
    }

    public void setFexId(int fexId) {
        this._fexId = fexId;
    }

    @Override
    public SerialNumKey getSwitchPK() {
        return (SerialNumKey)this._pkey;
    }

    @Override
    public PKIf getPK() {
        return this._pkey;
    }

    @Override
    public boolean isChassis() {
        return false;
    }

    @Override
    public InetAddress[] getManagementAddresses() {
        return null;
    }

    @Override
    public void setManagementAddresses(InetAddress[] addrs) {
    }

    @Override
    public boolean containsMgmtAddr(InetAddress addr) {
        return false;
    }

    @Override
    public int getNumOfMgmtAddrs() {
        return 0;
    }

    @Override
    public String getIpAddress() {
        return null;
    }

    @Override
    public InetAddress getInetAddress() {
        return null;
    }

    @Override
    public void setManagementAddressInUse(InetAddress addr) {
    }

    public void updateNumPorts(int[] vendor) {
        if (vendor == null) {
            return;
        }
        int moduleType = FRUConstants.getModuleType(vendor);
        this._numHifPort = FRUConstants.getNumEthPorts(moduleType);
        this._numUplPort = FRUConstants.getNumUplPorts(moduleType);
        this._numEthPorts = this._numHifPort + this._numUplPort;
    }

    @Override
    public String getSysName() {
        if (this._sysName == null) {
            this._sysName = "fex-" + this._fexId;
        }
        return this._sysName;
    }

    @Override
    public String getSerialNumber() {
        return ((SerialNumKey)this._pkey)._serialNum;
    }

    @Override
    public void setSerialNumber(String serialNum) {
    }

    @Override
    public boolean isManageable() {
        return true;
    }

    @Override
    public void setManageable(boolean isManageable) {
    }

    @Override
    public String getUnmanageableCause() {
        return "";
    }

    @Override
    public void setUnmanageableCause(String cause) {
    }

    @Override
    public boolean isTelnetEnabled() {
        return false;
    }

    @Override
    public void setTelnetEnabled(boolean b) {
    }

    @Override
    public boolean isDelayLinkEnabled() {
        return false;
    }

    @Override
    public void setDelayLinkEnabled(boolean b) {
    }

    @Override
    public boolean isSSHEnabled() {
        return false;
    }

    @Override
    public void setSSHEnabled(boolean b) {
    }

    @Override
    public boolean isCdpEnabled() {
        return false;
    }

    @Override
    public void setCdpEnabled(boolean enabled) {
    }

    @Override
    public String getName() {
        if (this._name != null && this._name.length() > 0) {
            return this._name;
        }
        return this.getModelName();
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public String getVersion() {
        return this._version;
    }

    @Override
    public void setVersion(String newVersion) {
        super.setVersion(newVersion);
        this._trimmedVersion = newVersion;
    }

    @Override
    public boolean isTrapRegistered() {
        return false;
    }

    @Override
    public void setTrapRegistered(boolean b) {
    }

    @Override
    public boolean isSyslogRegistered() {
        return false;
    }

    @Override
    public void setSyslogRegistered(boolean b) {
    }

    @Override
    public int getActiveSupPhysicalIndex() {
        return -1;
    }

    @Override
    public void setActiveSupPhysicalIndex(int activeSupPhyIndex) {
    }

    @Override
    public int getStandbySupPhysicalIndex() {
        return -1;
    }

    @Override
    public void setStandbySupPhysicalIndex(int standbySupPhyIndex) {
    }

    @Override
    public int getActiveSupState() {
        return -1;
    }

    @Override
    public int setActiveSupState(int newState) {
        return -1;
    }

    @Override
    public int getStandbySupState() {
        return -1;
    }

    @Override
    public int setStandbySupState(int newState) {
        return -1;
    }

    @Override
    public boolean isHotStandby() {
        return false;
    }

    @Override
    public int getActiveSupSlot() {
        return -1;
    }

    @Override
    public void setActiveSupSlot(int slot) {
    }

    @Override
    public int getStandbySupSlot() {
        return -1;
    }

    @Override
    public void setStandbySupSlot(int slot) {
    }

    @Override
    public int getModuleIndexOffset() {
        return NexusEntityMibHelper.getFexChassisPhyIndex(this._fexId);
    }

    @Override
    public void setModuleIndexOffset(int offset) {
    }

    @Override
    public int getConnUnitStatus() {
        return -1;
    }

    @Override
    public int setConnUnitStatus(int status) {
        return -1;
    }

    @Override
    public SwitchLicenseDetails getLicenseDetails() {
        return null;
    }

    @Override
    public void setLicenseDetails(SwitchLicenseDetails licDetails) {
    }

    @Override
    public boolean isFex() {
        return true;
    }

    @Override
    public void setVdc(boolean vdc) {
    }

    @Override
    public boolean isVdc() {
        return false;
    }

    @Override
    public boolean isDefaultVdc() {
        return false;
    }

    @Override
    public short getFCoECapability() {
        return -1;
    }

    @Override
    public void setFCoECapability(short capability) {
    }

    @Override
    public boolean isVdcCapableVersion() {
        return false;
    }

    @Override
    public boolean isBrocade() {
        return false;
    }

    @Override
    public boolean isCisco() {
        return true;
    }

    @Override
    public boolean isMDS() {
        return false;
    }

    @Override
    public void setMDS(boolean mds) {
    }

    @Override
    public boolean isCAT() {
        return false;
    }

    @Override
    public boolean isN5K() {
        return false;
    }

    @Override
    public boolean isN6K() {
        return false;
    }

    @Override
    public boolean isUCS() {
        return false;
    }

    @Override
    public boolean isN7K() {
        return false;
    }

    @Override
    public boolean allowDiscoverMoreOnFC() {
        return false;
    }

    @Override
    public boolean allowDiscoverMoreOnCDP() {
        return false;
    }

    @Override
    public int getNumPorts() {
        return this.getNumEthPorts();
    }

    public int getNumSatEthPort() {
        return this._numHifPort;
    }

    public int getNumUplEthPort() {
        return this._numUplPort;
    }

    @Override
    public int getNumSlots() {
        return 1;
    }

    @Override
    public int getNumFcPorts() {
        return 0;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public int ifIndex2Card(int uplinkIfindex) {
        return 0;
    }

    @Override
    public int ifIndex2Port(int uplinkIfindex) {
        return IfIndexUtil.ifIndex2Subif(uplinkIfindex);
    }

    @Override
    public String ifIndexToName(int uplinkIfindex) {
        return IfIndexUtil.fmIfIndex2IfName(uplinkIfindex);
    }

    @Override
    public String ifTypeToifName(int ifType) {
        return IfIndexUtil.ifTypeToifName(ifType);
    }

    @Override
    public int getType(int uplinkIfindex) {
        return IfIndexUtil.getType(uplinkIfindex);
    }

    @Override
    public int getActualType(int type) {
        return type;
    }

    @Override
    public boolean isPortRangeSupport() {
        return true;
    }

    @Override
    public int nameToIfIndex(int card, int port, int type) {
        return IfIndexUtil.fmIfName2IfIndex(IfIndexUtil.IfType.FMFEX, 0, 0, port);
    }

    @Override
    public int nameToIfIndex(String ifName) {
        return IfIndexUtil.fmIfName2IfIndex(ifName);
    }

    public int uplIfNameToIfIndex(int uplPort) {
        return IfIndexUtil.fmIfName2IfIndex(IfIndexUtil.IfType.FMFEX, 0, this._fexId, uplPort);
    }

    @Override
    public String indent(int level) {
        if (level < 0) {
            return LIL[0];
        }
        if (level >= LIL.length) {
            return LIL[LIL.length - 1];
        }
        return LIL[level];
    }

    @Override
    public String dump(boolean inDetail, int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.indent(level)).append("Fex: ").append(this.getPK()).append(this.indent(level + 1)).append("Status: ").append(this.isPresent() ? "up" : "down").append(", LastScanTime=" + new Date(this.getLastScanTime()));
        sb.append(this.indent(level + 1)).append("Manageable: ").append(this.isManageable()).append(this.isManageable() ? "" : " Reason: " + this.getUnmanageableCause()).append(this.indent(level + 1)).append("Device Id: ").append(this.getDeviceId() == null ? "n/a" : this.getDeviceId()).append(this.indent(level + 1)).append("Model: ").append(this.getModel() == null ? this.getVendor() : this.getModel()).append(this.indent(level + 1)).append("Version: ").append(this.getVersion() == null ? "n/a" : this.getVersion()).append(this.indent(level + 1)).append("SerialNo: ").append(this.getSerialNumber() == null ? "n/a" : this.getSerialNumber()).append(this.indent(level + 1)).append("Enabled Feature(s): ").append(this.getFeatureString());
        if (inDetail) {
            sb.append(this.indent(level + 1)).append("Num of Slots: ").append(FRUConstants.getNumSlots(this.getModelType())).append(this.indent(level + 1)).append("Num of Cards: ");
            List<Card> cards = InventoryManager.getInstance().findCards(this.getPK());
            if (cards.size() == 0) {
                sb.append("n/a");
            } else {
                sb.append(cards.size());
                Collections.sort(cards);
                for (Card card : cards) {
                    sb.append(this.indent(level + 2)).append("Slot: ").append(card.getSlotId()).append(", Type: ").append(card.getModelName()).append(", ").append(card.getType()).append(", Name: ").append(card.getName()).append(", Descr: ").append(card.getPhysicalDescr()).append(", HwRev: ").append(card.getHardwareRevision()).append(", SwRev: ").append(card.getSoftwareRevision()).append(", SerialNo: ").append(card.getSerialNumber()).append(", AssetID: ").append(card.getAssetId()).append(", Power OperStatus: ").append(card.getPowerOperStatus()).append(", OperStatus: ").append(card.getOperStatus() == 2 ? "up" : String.valueOf(card.getOperStatus())).append(card.isSupervisor() && card.isActive() ? " (active)" : "");
                }
            }
        }
        return sb.toString();
    }

    @Override
    public void printDetails(StringBuilder sb) {
        sb.append(", Status: ").append(this.isPresent() ? "up" : "down").append(", LastScanTime=").append(new Date(this.getLastScanTime())).append(", Manageable=").append(this.isManageable()).append(" ").append(this.getUnmanageableCause()).append(", serialNum=").append(this.getChassisKey()).append(", fcoeCapable=").append(this.isFCoECapable()).append(", versionFCoE=").append(this.isFCoECapableVersion()).append(", featureSetFCoE=").append((Object)this.getFCoFeatureSetStatus()).append(", fcoeEnabled=").append(this.isFcoeEnabled()).append(", modelName=").append(this._modelName).append(", platforme=").append(this._platformName).append(", platformType=").append((Object)this._platformType);
    }

    @Override
    public String print(boolean inDetail, boolean withDecor) {
        StringBuilder sb = new StringBuilder();
        if (withDecor) {
            sb.append("Fex").append("@").append(this.getName());
        } else {
            sb.append(this.getName());
        }
        if (inDetail) {
            sb.append("[PK=" + this.getPK());
            this.printDetails(sb);
            sb.append("]");
        }
        return sb.toString();
    }
}

