/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model;

import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.model.GroupMemberBase;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.GroupPK;
import com.cisco.dcbu.sm.common.type.PKIf;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@NamedQueries(value={@NamedQuery(name="queryGroup", query="select g from GroupBase g where g.fabric_id =:fid and g._pkey._name=:name"), @NamedQuery(name="queryGroupByFabricId", query="select g from GroupBase g where g.fabric_id=:fid"), @NamedQuery(name="queryGroupByGroupId", query="select g from GroupBase g where g._dbid=:gid")})
@Table(name="GROUPS")
public class GroupBase
extends BaseModelObject {
    @Transient
    static final long serialVersionUID = 1L;
    @Transient
    public static final short TYPE_SWITCHES = 1;
    @Transient
    public static final short TYPE_ENDPORTS = 2;
    @Transient
    public static final short GROUP_ATTR = 2304;
    @Transient
    public static final short ATTR_NAME = 2305;
    @Transient
    public static final short ATTR_MEMBERS_ADDED = 2306;
    @Transient
    public static final short ATTR_MEMBERS_REMOVED = 2307;
    @Transient
    public static final short ATTR_FABRIC_PKS = 2308;
    @Transient
    public static final String[] _Attrs = new String[]{"groupName", "membersAdded", "membersRemoved"};
    @Id
    @Column(name="ID")
    protected long _dbid;
    @Embedded
    @AttributeOverride(name="_name", column=@Column(name="NAME"))
    protected GroupPK _pkey;
    @Transient
    protected ArrayList<PKIf> _memberPKs = new ArrayList(5);
    @Transient
    protected ArrayList<GroupMemberBase> members = new ArrayList();
    @Column(name="TYPE")
    protected short _type;
    @Column(name="LAST_UPDATE_TIME")
    private Timestamp lastUpdateTime;
    @Column(name="FABRIC_ID")
    private long fabric_id;
    @Transient
    protected boolean _editable = true;

    protected GroupBase() {
    }

    @PreUpdate
    @PrePersist
    public void onUpdate() {
        this.lastUpdateTime = new Timestamp(System.currentTimeMillis());
    }

    public long getFabricId() {
        return this.fabric_id;
    }

    public void setFabricId(long id) {
        this.fabric_id = id;
    }

    public GroupBase(GroupPK pk, short type) {
        this._pkey = pk;
        this._type = type;
    }

    public long getDBID() {
        return this._dbid;
    }

    public void setDBID(long dbid) {
        this._dbid = dbid;
    }

    @Override
    public int compareTo(Object o) {
        return this._pkey.compare(this._pkey, ((GroupBase)o)._pkey);
    }

    @Override
    public boolean equals(Object o) {
        return this._pkey.equals(((GroupBase)o)._pkey);
    }

    public FabricPK getFabricPK() {
        return this._pkey.getFabricPK();
    }

    @Override
    public PKIf getPK() {
        return this._pkey;
    }

    public GroupPK getGroupPK() {
        return this._pkey;
    }

    public short getType() {
        return this._type;
    }

    @Override
    public String toString() {
        return this._pkey.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMember(PKIf memberPK) {
        ArrayList<PKIf> arrayList = this._memberPKs;
        synchronized (arrayList) {
            if (!this._memberPKs.contains(memberPK)) {
                this._memberPKs.add(memberPK);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMember(PKIf memberPK) {
        ArrayList<PKIf> arrayList = this._memberPKs;
        synchronized (arrayList) {
            return this._memberPKs.remove(memberPK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMemebers() {
        ArrayList<PKIf> arrayList = this._memberPKs;
        synchronized (arrayList) {
            this._memberPKs.clear();
        }
    }

    public int numOfMembers() {
        if (this._memberPKs == null) {
            return 0;
        }
        return this._memberPKs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMember(PKIf memberPK) {
        ArrayList<PKIf> arrayList = this._memberPKs;
        synchronized (arrayList) {
            return this._memberPKs.contains(memberPK);
        }
    }

    @Transient
    public ArrayList<PKIf> getMembers() {
        return this._memberPKs;
    }

    @Transient
    public void setMembers(ArrayList<PKIf> memberPKs) {
        this._memberPKs = memberPKs;
    }

    @Transient
    public void setMembers(PKIf[] memberPKs) {
        if (memberPKs == null || memberPKs.length == 0) {
            this.setMembers(new ArrayList<PKIf>());
        } else {
            ArrayList<PKIf> list = new ArrayList<PKIf>(memberPKs.length);
            for (int i = 0; i < memberPKs.length; ++i) {
                if (list.contains(memberPKs[i])) continue;
                list.add(memberPKs[i]);
            }
            this.setMembers(list);
        }
    }

    public boolean isEditable() {
        return this._editable;
    }

    public void setEditable(boolean editable) {
        this._editable = editable;
    }

    public void copy(GroupBase g) {
        this._pkey = g.getGroupPK();
        this._memberPKs = g.getMembers();
        this._type = g.getType();
        this.fabric_id = g.getFabricId();
        this._editable = g.isEditable();
    }
}

