/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model;

import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.common.model.ZoneMemberBase;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;

public class ZoneBase
implements Comparator,
Comparable,
Serializable {
    static final long serialVersionUID = 1L;
    public static final int QOS_PRIORITY_NONE = 1;
    public static final int QOS_PRIORITY_LOW = 2;
    public static final int QOS_PRIORITY_MEDIUM = 3;
    public static final int QOS_PRIORITY_HIGH = 4;
    protected int _index;
    protected String _name;
    protected boolean _readOnly;
    protected boolean _qos;
    protected int _qosPriority;
    protected boolean _broadcast;
    protected boolean _smartzone;
    protected int _cfsRegion;
    protected Array _members = new Array();

    public ZoneBase(int id, String name, boolean readOnly, boolean qos, int qosPriority, boolean broadcast, boolean smtzone) {
        this._index = id;
        this._name = name;
        this._readOnly = readOnly;
        this._qos = qos;
        this._qosPriority = qosPriority;
        this._broadcast = broadcast;
        this._smartzone = smtzone;
        this._cfsRegion = -1;
    }

    public ZoneBase(int id, String name, boolean readOnly, boolean qos, int qosPriority, boolean broadcast) {
        this(id, name, readOnly, qos, qosPriority, broadcast, false);
    }

    public ZoneBase(int id, String name, boolean readOnly, boolean qos, int qosPriority, boolean broadcast, boolean smtzone, int cfsRegion) {
        this._index = id;
        this._name = name;
        this._readOnly = readOnly;
        this._qos = qos;
        this._qosPriority = qosPriority;
        this._broadcast = broadcast;
        this._smartzone = smtzone;
        this._cfsRegion = cfsRegion;
    }

    public ZoneBase(int id, String name, boolean readOnly, boolean qos, int qosPriority, boolean broadcast, int cfsRegion) {
        this(id, name, readOnly, qos, qosPriority, broadcast, false, cfsRegion);
    }

    public ZoneBase(int id, String name, boolean readOnly) {
        this(id, name, readOnly, false, 1, false);
    }

    public ZoneBase(int id, String name, boolean readOnly, int cfsRegion) {
        this(id, name, readOnly, false, 1, false, false, cfsRegion);
    }

    public ZoneBase(int id, String name, boolean readOnly, int qosPriority, boolean broadcast, int cfsRegion) {
        this(id, name, readOnly, qosPriority != 1, qosPriority, broadcast, false, cfsRegion);
    }

    public int getIndex() {
        return this._index;
    }

    public String getName() {
        return this._name;
    }

    public boolean isReadOnly() {
        return this._readOnly;
    }

    public boolean isQosSupported() {
        return this._qos;
    }

    public int getQosPriority() {
        return this._qosPriority;
    }

    public int getCfsRegion() {
        return this._cfsRegion;
    }

    public boolean isBrodcastSupported() {
        return this._broadcast;
    }

    public boolean isSmartZoningSupported() {
        return this._smartzone;
    }

    public Array getMembers() {
        return this._members;
    }

    public void addMember(ZoneMemberBase newMember) {
        this._members.addElement(newMember);
        this._members.sort();
    }

    public void addMembers(Array<ZoneMemberBase> zMembers) {
        if (zMembers != null) {
            for (int i = 0; i < zMembers.size(); ++i) {
                this.addMember(zMembers.elementAt(i));
            }
        }
    }

    public ZoneMemberBase addMember(int idtype, byte[] id, byte[] lunId) {
        ZoneMemberBase zm;
        if (lunId != null && lunId.length > 0) {
            long lunNumber = ZoneMemberBase.convertLunToLong(lunId);
            for (int i = 0; i < this._members.size(); ++i) {
                ZoneMemberBase ezm = (ZoneMemberBase)this._members.elementAt(i);
                if (ezm._type != idtype || !Arrays.equals(ezm._id, id) || ezm._numLunIds <= 0) continue;
                ezm.addLun(lunNumber);
                return null;
            }
            zm = new ZoneMemberBase(this, idtype, id, lunNumber, this._cfsRegion);
        } else {
            zm = new ZoneMemberBase(this, idtype, id, this._cfsRegion);
        }
        this.addMember(zm);
        return zm;
    }

    public void addMember(int idtype, byte[] id, short vid) {
        this.addMember(new ZoneMemberBase(this, idtype, id, vid));
    }

    public void addMember(int idtype, byte[] id, byte[] lunId, short vid, int afid) {
        ZoneMemberBase zm = this.addMember(idtype, id, lunId);
        if (zm != null) {
            zm.setIvrVsan(vid);
            zm.setAfid(afid);
        }
    }

    public byte[] getIfFormatSwitchWwn(byte[] id) {
        byte[] swWwn = null;
        if (id.length == 12) {
            swWwn = new byte[id.length - 4];
            System.arraycopy(id, 4, swWwn, 0, swWwn.length);
        }
        return swWwn;
    }

    @Override
    public boolean equals(Object x) {
        if (x == this) {
            return true;
        }
        if (x == null || !(x instanceof ZoneBase)) {
            return false;
        }
        ZoneBase zb = (ZoneBase)x;
        return zb._index == this._index && zb._name.equals(this._name) && zb._members.size() == this._members.size() && zb._qos == this._qos && zb._qosPriority == this._qosPriority && zb._broadcast == this._broadcast && zb._smartzone == this._smartzone && Arrays.equals(zb._members._elementData, this._members._elementData);
    }

    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        ZoneBase v1 = (ZoneBase)o1;
        ZoneBase v2 = (ZoneBase)o2;
        return v1._name.compareToIgnoreCase(v2._name);
    }

    public int compareTo(Object o) {
        return this.compare(this, o);
    }

    public String toString() {
        return this.getName();
    }

    public static ZoneBase findParent(ZoneBase[] zones, int zoneIndex) {
        if (zones == null || zones.length == 0) {
            return null;
        }
        int hi = zones.length;
        int lo = 0;
        while (hi > lo) {
            int mid = (hi - lo) / 2 + lo;
            if (zones[mid]._index == zoneIndex) {
                return zones[mid];
            }
            if (zones[mid]._index > zoneIndex) {
                hi = mid;
                continue;
            }
            lo = mid + 1;
        }
        return null;
    }
}

