/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model.ioa;

import com.cisco.dcbu.sm.common.type.WwnKey;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class IOALicense
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int LICENSE_NONE = 0;
    public static final int LICENSE_GRACE_EVAL = 1;
    public static final int LICENSE_VALID = 2;
    public static final int LICENSE_PERMANENT = 3;
    public static final int LICENSE_NOT_CHECKED_OUT = 4;
    private WwnKey key;
    private int status = 0;
    private long timeLeft = 0L;
    static Logger _Logger = Logger.getLogger((String)"IOA");

    public IOALicense(WwnKey key, int status, long timeLeft) {
        this.status = status;
        this.key = key;
        this.timeLeft = timeLeft;
    }

    public IOALicense(WwnKey key, int status) {
        this.status = status;
        this.key = key;
    }

    public IOALicense(int status) {
        this.status = status;
    }

    public WwnKey getKey() {
        return this.key;
    }

    public void setKey(WwnKey key) {
        this.key = key;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getStatusString() {
        String res = "no license";
        switch (this.status) {
            case 1: {
                return "eval";
            }
            case 2: {
                return "valid";
            }
            case 3: {
                return "permanent";
            }
        }
        return res;
    }

    public long getTimeLeft() {
        return this.timeLeft;
    }

    public void setTimeLeft(long timeLeft) {
        this.timeLeft = timeLeft;
    }

    private String leftString() {
        if (this.timeLeft <= 0L) {
            return "0 time";
        }
        long left = this.timeLeft / 3600L;
        if (left < 24L) {
            return left + " hours";
        }
        return (left /= 24L) + " days";
    }

    public String toString() {
        String res = "no license";
        switch (this.status) {
            case 1: {
                return "grace period / " + this.leftString() + " remaining";
            }
            case 2: {
                return "demo / " + this.leftString() + " remaining";
            }
            case 3: {
                return "permanent";
            }
            case 4: {
                return "not checked out";
            }
        }
        return res;
    }
}

