/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model.se;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.sm.common.model.EndPortBase;
import com.cisco.dcbu.sm.common.model.se.SETarget;
import java.io.Serializable;

public class SESession
implements Serializable {
    static final long serialVersionUID = 1L;
    private long _id;
    private int _status;
    private byte _progress;
    private SETarget _newLuns;
    private SETarget _existingLuns;
    private EndPortBase _newPort;
    private EndPortBase _existingPort;
    private EndPortBase _host;
    private int _onSSM;
    private int _verifyStatus;
    private long _lastLbaMoved;
    private long _lastLbaVerified;
    private long _avgMbPerSec;
    private int _maxLba;
    private int _blkLen;
    private String estimatedTimeToCompletion = null;
    private long estimatedTimeSeconds = -1L;
    private int vsanId;
    private long sessionId;
    private Wwn targetPort;
    private Wwn viPort;
    private long lunId;
    private long lunSize;
    private int percentComplete;
    private int speed;
    private byte status;
    private String algorithm;
    public static String[] STATUS_STRING = new String[]{"initalizing", "discovering", "erase-special", "no LUN(s) discovered", "erase (stopped)", "erase (resuming)", "erase (stopping)", "discovery-failed", "invalid-LUN", "invalid-Size", "ready", "running", "queued", "queued (stopped)", "queued (resuming)", "complete", "aborted", "pending validation", "re-validating", "erase (failed)"};

    public SESession() {
    }

    public SESession(int vsanId, long sessionId, Wwn targetPort, Wwn viPort, long lunId, long lunSize, int percentComplete, int speed, byte status, String algo) {
        this.vsanId = vsanId;
        this.sessionId = sessionId;
        this.targetPort = targetPort;
        this.viPort = viPort;
        this.lunId = lunId;
        this.lunSize = lunSize;
        this.percentComplete = percentComplete;
        this.speed = speed;
        this.status = status;
        this.algorithm = algo;
    }

    public SETarget getExistingLuns() {
        return this._existingLuns;
    }

    public void setExistingLuns(SETarget existingLuns) {
        this._existingLuns = existingLuns;
    }

    public EndPortBase getExistingPort() {
        return this._existingPort;
    }

    public void setExistingPort(EndPortBase existingPort) {
        this._existingPort = existingPort;
    }

    public long getId() {
        return this._id;
    }

    public void setId(long id) {
        this._id = id;
    }

    public SETarget getNewLuns() {
        return this._newLuns;
    }

    public void setNewLuns(SETarget newLuns) {
        this._newLuns = newLuns;
    }

    public EndPortBase getNewPort() {
        return this._newPort;
    }

    public void setNewPort(EndPortBase newPort) {
        this._newPort = newPort;
    }

    public byte getProgress() {
        return this._progress;
    }

    public void setProgress(byte progress) {
        this._progress = progress;
    }

    public int getStatus() {
        return this.status;
    }

    public String getExistingAsString() {
        return new Long(this._existingLuns.getLuns().get(0).getLunNumber()).toString();
    }

    public String getNewAsString() {
        return new Long(this._newLuns.getLuns().get(0).getLunNumber()).toString();
    }

    public int getOnSSM() {
        return this._onSSM;
    }

    public void setOnSSM(int ssm) {
        this._onSSM = ssm;
    }

    public EndPortBase getHost() {
        return this._host;
    }

    public void setHost(EndPortBase host) {
        this._host = host;
    }

    public long getAvgMbPerSec() {
        return this._avgMbPerSec;
    }

    public void setAvgMbPerSec(long avgMbPerSec) {
        this._avgMbPerSec = avgMbPerSec;
    }

    public int getBlkLen() {
        return this._blkLen;
    }

    public void setBlkLen(int blkLen) {
        this._blkLen = blkLen;
    }

    public int getMaxLba() {
        return this._maxLba;
    }

    public void setMaxLba(int maxLba) {
        this._maxLba = maxLba;
    }

    public int getVerifyStatus() {
        return this._verifyStatus;
    }

    public void setVerifyStatus(int verifyStatus) {
        this._verifyStatus = verifyStatus;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public long getLunId() {
        return this.lunId;
    }

    public long getLunSize() {
        return this.lunSize;
    }

    public int getPercentComplete() {
        return this.percentComplete;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public int getSpeed() {
        return this.speed;
    }

    public int getVsanId() {
        return this.vsanId;
    }

    public Wwn getTargetPort() {
        return this.targetPort;
    }

    public Wwn getViPort() {
        return this.viPort;
    }

    public String getStatusString() {
        if (this.getStatus() < STATUS_STRING.length) {
            return STATUS_STRING[this.getStatus()];
        }
        return "Unkown";
    }
}

