/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.pm;

import com.cisco.dcbu.sm.common.pm.PmErrorDiscardConfig;
import com.cisco.dcbu.sm.server.pm.PMStatistics;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PmConfig
implements Serializable {
    public static final String[] LABELS = new String[]{"Rx", "Tx"};
    public static final String YTITLE = "Rx,Tx Bytes/sec";
    public static final String[] VARS = new String[]{"1.3.6.1.4.1.9.9.284.1.2.1.1.2", "1.3.6.1.4.1.9.9.284.1.2.1.1.6", "1.3.6.1.4.1.9.9.284.1.2.1.1.3", "1.3.6.1.4.1.9.9.284.1.2.1.1.4", "1.3.6.1.4.1.9.9.284.1.2.1.1.5", "1.3.6.1.4.1.9.9.284.1.2.1.1.9"};
    public String _ipAddr;
    public String _rrdFile;
    public String _errRrdFile;
    public String _title;
    public String _yTitle;
    public String[] _vars;
    public String[] _labels;
    public String[] _peakLabels;
    public String _msgStr;
    public String _entityStr;
    public String _ifname;
    public long _maxValuePerSec;
    public String _options;
    public int _flowDataSet;
    public boolean _isDoubleFlow;
    public boolean _hasValidError;
    public String _message;
    public long _incId = -1L;
    public Map<String, String[]> _ipToVarMap = null;
    public ArrayList _errDiscardConfig;
    public double[] _avg;
    public double[] _max;
    public double _both;
    public int _type;
    private String _rrdDsType = null;
    private List<PMStatistics> _stat = null;

    public PmConfig(String rrdFile, String title, String message, int type) {
        this._rrdFile = rrdFile;
        this._title = title;
        this._message = message;
        this._type = type;
        if (type != 5) {
            if (!this._rrdFile.endsWith("_flow.rrd")) {
                this._errRrdFile = this._rrdFile.substring(0, this._rrdFile.length() - 4) + "_err.rrd";
            }
            this._yTitle = YTITLE;
            this._labels = new String[]{"Rx", "Tx"};
            this._peakLabels = new String[]{"Peak Rx", "Peak Tx"};
            this._errDiscardConfig = new ArrayList();
            this._errDiscardConfig.add(new PmErrorDiscardConfig("Total Counts", null, new String[]{"Discard"}));
            this._errDiscardConfig.add(new PmErrorDiscardConfig("Total Counts", null, new String[]{"Error"}));
        } else {
            this._yTitle = title;
            this._labels = new String[]{title};
            this._peakLabels = new String[]{"Peak " + title};
        }
    }

    public PmConfig(String rrd, String ipAddr, String title, String yTitle, String[] vars, String[] labels, String max, int flowDataSet, boolean isDoubleFlow, int type) {
        this(rrd, ipAddr, title, yTitle, vars, labels, max, flowDataSet, type);
        this._isDoubleFlow = isDoubleFlow;
        this._type = type;
        this._peakLabels = new String[]{"Peak Rx", "Peak Tx"};
    }

    public PmConfig(String rrd, String ipAddr, String title, String yTitle, String[] vars, String[] labels, String max, int flowDataSet, int type) {
        this._rrdFile = rrd;
        this._ipAddr = ipAddr;
        this._title = title;
        this._yTitle = yTitle;
        this._vars = vars;
        this._labels = labels;
        this._type = type;
        if (max != null && max.length() > 0) {
            this._maxValuePerSec = Long.parseLong(max);
        }
        this._flowDataSet = flowDataSet;
        this._isDoubleFlow = false;
        this._hasValidError = false;
        this._errDiscardConfig = new ArrayList();
    }

    public PmConfig(String file, String string, String str, int flow, Map<String, String[]> map) {
        this(file, string, str, flow);
        this._ipToVarMap = map;
        this._peakLabels = new String[]{"Peak Rx", "Peak Tx"};
    }

    public void addErrorDiscardConfig(PmErrorDiscardConfig conf) {
        this._errDiscardConfig.add(conf);
        if (this._errRrdFile == null) {
            this._errRrdFile = this._rrdFile.substring(0, this._rrdFile.indexOf(".rrd")) + "_err.rrd";
        }
    }

    public ArrayList getVars() {
        ArrayList vars = new ArrayList();
        this.addVars(vars, this._vars);
        for (int i = 0; i < this._errDiscardConfig.size(); ++i) {
            this.addVars(vars, ((PmErrorDiscardConfig)this._errDiscardConfig.get((int)i))._vars);
        }
        return vars;
    }

    public static String getXmlString(String[] vars) {
        if (vars == null || vars.length == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer(vars[0]);
        for (int i = 1; i < vars.length; ++i) {
            result.append(",");
            result.append(vars[i]);
        }
        return result.toString();
    }

    public String getVarsString() {
        return PmConfig.getXmlString(this._vars);
    }

    public String getLabelsString() {
        return PmConfig.getXmlString(this._labels);
    }

    public void setMsgString(String msgString) {
        this._msgStr = msgString;
    }

    public String getMsgString() {
        return this._msgStr;
    }

    public void setIfname(String ifname) {
        this._ifname = ifname;
    }

    public String getIfname() {
        return this._ifname;
    }

    public void setEntity(String entity) {
        this._entityStr = entity;
    }

    public String getEntity() {
        return this._entityStr;
    }

    void addVars(ArrayList varList, String[] vars) {
        for (int i = 0; i < vars.length; ++i) {
            varList.add(vars[i]);
        }
    }

    public ArrayList getErrorDiscardLabels() {
        ArrayList labels = new ArrayList();
        for (int i = 0; i < this._errDiscardConfig.size(); ++i) {
            this.addLabels(labels, ((PmErrorDiscardConfig)this._errDiscardConfig.get((int)i))._labels);
        }
        return labels;
    }

    public String[] getErrorDiscardLabelStrings() {
        ArrayList labels = this.getErrorDiscardLabels();
        if (labels.size() == 0) {
            return null;
        }
        String[] result = new String[labels.size()];
        for (int i = 0; i < labels.size(); ++i) {
            result[i] = (String)labels.get(i);
        }
        return result;
    }

    void addLabels(ArrayList labelList, String[] labels) {
        for (int i = 0; i < labels.length; ++i) {
            labelList.add(labels[i]);
        }
    }

    public String getErrYTitle() {
        if (this._errDiscardConfig.size() == 0) {
            return null;
        }
        return ((PmErrorDiscardConfig)this._errDiscardConfig.get((int)0))._yTitle;
    }

    public int getType() {
        return this._type;
    }

    public String getRrdDsType() {
        return this._rrdDsType;
    }

    public void setRrdDsType(String dsType) {
        this._rrdDsType = dsType;
    }

    public List<PMStatistics> getStat() {
        return this._stat;
    }

    public void setStat(List<PMStatistics> stat) {
        this._stat = stat;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer(this._title);
        boolean hasStats = this._stat != null;
        ret.append(":" + this._rrdFile + ":" + this._type + ":" + hasStats);
        return ret.toString();
    }

    public Map<String, String[]> get_ipToVarMap() {
        return this._ipToVarMap;
    }

    public long getIncId() {
        return this._incId;
    }

    public void setIncId(long id) {
        this._incId = id;
    }
}

