/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.registry;

import com.cisco.dcbu.sm.common.registry.ContextRegistry;
import com.cisco.dcbu.sm.common.rif.EMRif;
import com.cisco.dcbu.sm.common.rif.EjbRegistryIf;
import com.cisco.dcbu.sm.common.rif.FMServerRif;
import com.cisco.dcbu.sm.common.rif.IndexerRif;
import com.cisco.dcbu.sm.common.rif.IscRif;
import com.cisco.dcbu.sm.common.rif.ModelFacadeRif;
import com.cisco.dcbu.sm.common.rif.PMRif;
import com.cisco.dcbu.sm.common.rif.SanServiceRif;
import com.cisco.dcbu.sm.common.rif.SchedulerRif;
import com.cisco.dcbu.sm.common.rif.TopologyManager;
import com.cisco.dcbu.sm.common.rif.TopologyRemote;
import com.cisco.dcbu.sm.common.rif.WebAnalysisRif;
import com.cisco.dcbu.sm.common.rif.WebZoneRif;
import com.cisco.dcbu.sme.ckmc.ejb.api.CKMCMgr;
import com.cisco.dcbu.sme.ckmc.facade.api.CKMCFacade;
import com.cisco.dcbu.sme.facade.api.SMEFacade;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;

public class EjbRegistry
implements EjbRegistryIf {
    private InitialContext _Context = null;
    private Logger _Log = Logger.getLogger((String)"fms.EjbRegistry");
    private Map<String, String> _InfHash = null;
    public static EjbRegistry _Instance = null;

    public static EjbRegistry getInstance() {
        if (_Instance == null) {
            _Instance = new EjbRegistry();
        }
        return _Instance;
    }

    public void initContext() {
        this._Context = ContextRegistry.getInstance().getLocalContext();
    }

    @Override
    public FMServerRif getFMServer() throws Exception {
        if (this._Context == null) {
            this.initContext();
        }
        return (FMServerRif)this._Context.lookup("java:global/dcm/dcm/FMServerBean!" + FMServerRif.class.getName());
    }

    @Override
    public PMRif getPM() throws Exception {
        if (this._Context == null) {
            this.initContext();
        }
        return (PMRif)this._Context.lookup("java:global/dcm/dcm/PMBean!" + PMRif.class.getName());
    }

    @Override
    public SchedulerRif getScheduler() throws Exception {
        if (this._Context == null) {
            this.initContext();
        }
        return (SchedulerRif)this._Context.lookup("java:global/dcm/dcm/SchedulerManagerBean!" + SchedulerRif.class.getName());
    }

    @Override
    public IndexerRif getIndexer() throws Exception {
        if (this._Context == null) {
            this.initContext();
        }
        return (IndexerRif)this._Context.lookup("java:global/dcm/dcm/IndexerMBean!" + IndexerRif.class.getName());
    }

    @Override
    public TopologyManager getTopologyMgr() throws Exception {
        if (this._Context == null) {
            this.initContext();
        }
        return (TopologyManager)this._Context.lookup("java:global/dcm/dcm/TopologyBean!com.cisco.dcbu.sm.common.rif.TopologyRemote");
    }

    @Override
    public ModelFacadeRif getModelFacade() throws Exception {
        if (this._Context == null) {
            this.initContext();
        }
        return (ModelFacadeRif)this._Context.lookup("java:global/dcm/dcm/ModelFacadeBean!" + ModelFacadeRif.class.getName());
    }

    @Override
    public IscRif getIsc() throws Exception {
        if (this._Context == null) {
            this.initContext();
        }
        return (IscRif)this._Context.lookup("java:global/dcm/dcm/IscBean!" + IscRif.class.getName());
    }

    @Override
    public EMRif getEM() throws Exception {
        if (this._Context == null) {
            this.initContext();
        }
        return (EMRif)this._Context.lookup("java:global/dcm/dcm/EMBean!" + EMRif.class.getName());
    }

    @Override
    public WebAnalysisRif getWebAnalysis() throws Exception {
        if (this._Context == null) {
            this.initContext();
        }
        return (WebAnalysisRif)this._Context.lookup("java:global/dcm/dcm/WebAnalysisBean!" + WebAnalysisRif.class.getName());
    }

    @Override
    public WebZoneRif getWebZone() throws Exception {
        if (this._Context == null) {
            this.initContext();
        }
        return (WebZoneRif)this._Context.lookup("java:global/dcm/dcm/WebZoneBean!" + WebZoneRif.class.getName());
    }

    @Override
    public SMEFacade getSME() throws Exception {
        if (this._Context == null) {
            this.initContext();
        }
        return (SMEFacade)this._Context.lookup("java:global/dcm/dcm/SMEFacadeBean!" + SMEFacade.class.getName());
    }

    @Override
    public CKMCFacade getCKMCFacade() throws Exception {
        if (this._Context == null) {
            this.initContext();
        }
        return (CKMCFacade)this._Context.lookup("java:global/dcm/dcm/CKMCFacadeBean!" + CKMCFacade.class.getName());
    }

    @Override
    public SanServiceRif getSanService() throws Exception {
        if (this._Context == null) {
            this.initContext();
        }
        return (SanServiceRif)this._Context.lookup("java:global/dcm/dcm/SanServiceBean!" + SanServiceRif.class.getName());
    }

    @Override
    public CKMCMgr getCKMCMgr() throws Exception {
        if (this._Context == null) {
            this.initContext();
        }
        return (CKMCMgr)this._Context.lookup("java:global/dcm/dcm/CKMCMgrBean!" + CKMCMgr.class.getName());
    }

    @Override
    public Object getRemoteService(String bindAddr, String port, boolean useSsl, String facilityName, String interfaceName) throws Exception {
        if (this._Context == null) {
            this.initContext();
        }
        Object ret = null;
        Context context = ContextRegistry.getInstance().getContext(bindAddr, port, useSsl);
        if (context != null) {
            String accessor = "";
            if (context.equals(this._Context)) {
                accessor = "java:global/";
            }
            ret = context.lookup(accessor + "dcm/dcm/" + facilityName + "!" + interfaceName);
        } else {
            this._Log.warn((Object)"Remote InitialContext lookup failed.  Returning null Service.");
        }
        return ret;
    }

    @Override
    public Object getRemoteService(String bindAddr, String port, String facilityName, String interfaceName) throws Exception {
        boolean _useSsl = Boolean.getBoolean("server.useSsl");
        return this.getRemoteService(bindAddr, port, _useSsl, facilityName, interfaceName);
    }

    @Override
    public Object getRemoteService(String bindAddr, String facilityName) throws Exception {
        if (this._InfHash == null) {
            this.setInf();
        }
        String infName = this._InfHash.get(facilityName);
        String localAddr = InetAddress.getLocalHost().getHostAddress();
        if (localAddr.contains(bindAddr)) {
            return this.getLocalService(facilityName, infName);
        }
        int port = Integer.getInteger("server.port", 4447);
        return this.getRemoteService(bindAddr, "" + port, facilityName, infName);
    }

    private Object getLocalService(String facilityName, String infName) throws Exception {
        if (this._Context == null) {
            this.initContext();
        }
        return this._Context.lookup("java:global/dcm/dcm/" + facilityName + "!" + infName);
    }

    private void setInf() {
        this._InfHash = new HashMap<String, String>();
        this._InfHash.put("FMServerBean", FMServerRif.class.getName());
        this._InfHash.put("PMBean", PMRif.class.getName());
        this._InfHash.put("EMBean", EMRif.class.getName());
        this._InfHash.put("SchedulerManagerBean", SchedulerRif.class.getName());
        this._InfHash.put("IndexerMBean", IndexerRif.class.getName());
        this._InfHash.put("IscBean", IscRif.class.getName());
        this._InfHash.put("TopologyBean", TopologyRemote.class.getName());
        this._InfHash.put("SMEFacadeBean", SMEFacade.class.getName());
        this._InfHash.put("WebAnalysisBean", WebAnalysisRif.class.getName());
        this._InfHash.put("WebZoneBean", WebZoneRif.class.getName());
    }
}

