/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.topology.dto;

import com.cisco.dcbu.sm.common.model.EndPortBase;
import com.cisco.dcbu.sm.common.model.GroupBase;
import com.cisco.dcbu.sm.common.topology.dto.TopoNodeDto;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.SwitchIntKey;
import com.cisco.dcbu.sm.common.type.WwnKey;
import java.util.ArrayList;
import java.util.ListIterator;

public class TopoHubDto
extends TopoNodeDto {
    private static final long serialVersionUID = 1L;
    protected boolean isCloud = false;
    protected PKIf switchPK = null;
    protected ArrayList members = new ArrayList();
    protected String ifIndexName = null;
    protected String switchName = null;

    public TopoHubDto(WwnKey swPK, int ifIndex) {
        super(null);
        this.setPK(new SwitchIntKey(swPK, ifIndex));
    }

    @Override
    public String getName() {
        return this.switchName + " " + this.ifIndexName;
    }

    public void setSwitchName(String switchName) {
        this.switchName = switchName;
    }

    public void setIfIndexName(String ifIndexName) {
        this.ifIndexName = ifIndexName;
    }

    public boolean isCloud() {
        return this.isCloud;
    }

    public void setCloud(boolean isCloud) {
        this.isCloud = isCloud;
    }

    public ArrayList getMembers() {
        return this.members;
    }

    public void addMember(EndPortBase endPortBase) {
        PKIf nxPortPK;
        if (this.members == null) {
            this.members = new ArrayList();
        }
        if (!this.members.contains(nxPortPK = endPortBase.getPK())) {
            this.members.add(nxPortPK);
            this.addVsanIds(endPortBase.getVsanMembership());
        }
    }

    public boolean isMember(PKIf nxPortPK) {
        if (this.members == null) {
            return false;
        }
        return this.members.contains(nxPortPK);
    }

    public int getIfIndex() {
        return ((SwitchIntKey)this.getPK())._index;
    }

    public PKIf getSwitchPK() {
        return this.switchPK;
    }

    public void setSwitchPK(PKIf switchPK) {
        this.switchPK = switchPK;
    }

    public boolean isMemberOfGroup(GroupBase group) {
        if (group == null) {
            return false;
        }
        if (group.hasMember(this.getSwitchPK())) {
            return true;
        }
        ListIterator it = this.members.listIterator();
        while (it.hasNext()) {
            if (!group.hasMember((PKIf)it.next())) continue;
            return true;
        }
        return false;
    }
}

