/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.topology.layout;

import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.common.topology.layout.ShortestPathLinkIf;
import com.cisco.dcbu.sm.common.topology.layout.ShortestPathNodeIf;
import com.cisco.dcbu.sm.common.type.PKIf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class ShortestPathAlgorithm {
    ArrayList<ShortestPathNodeIf> nodesArrayList = new HashedArrayList<ShortestPathNodeIf>();
    HashMap<PKIf, ShortestPathNodeIf> nodesByPK = new HashMap();
    private HashMap<PKIf, ShortestPathLinkIf> shortestFcLinksHashMap = null;

    public ArrayList<ShortestPathNodeIf> findShortestPath(ShortestPathNodeIf[] nodes, ShortestPathLinkIf[] edges, ShortestPathNodeIf source, ShortestPathNodeIf target) {
        HashedArrayList<ShortestPathNodeIf> candidateSwitches = new HashedArrayList<ShortestPathNodeIf>();
        if (source == null || target == null || nodes == null || nodes.length == 0) {
            return null;
        }
        if (source.equals(target)) {
            ((ArrayList)candidateSwitches).add(source);
            return candidateSwitches;
        }
        for (int i = 0; i < nodes.length; ++i) {
            this.nodesByPK.put(nodes[i].getPK(), nodes[i]);
        }
        this.initializeNodes(nodes, source);
        int[][] distBetween = this.initializeWeight(nodes, edges);
        int[] dist = new int[nodes.length];
        ShortestPathNodeIf[] previous = new ShortestPathNodeIf[nodes.length];
        HashedArrayList<ShortestPathNodeIf> q = new HashedArrayList<ShortestPathNodeIf>();
        for (int i = 0; i < nodes.length; ++i) {
            dist[i] = Integer.MAX_VALUE;
            previous[i] = null;
            ((ArrayList)q).add(nodes[i]);
            this.nodesByPK.put(nodes[i].getPK(), nodes[i]);
        }
        dist[this.nodesArrayList.indexOf((Object)source)] = 0;
        ShortestPathNodeIf u = null;
        while (!q.isEmpty() && (u = this.getVertexWithSmallestDistance(q, dist)) != null && dist[this.nodesArrayList.indexOf(u)] != Integer.MAX_VALUE && !u.equals(target)) {
            ((ArrayList)q).remove(u);
            int distanceBetween = 0;
            int alt = 0;
            for (int j = 0; j < nodes.length; ++j) {
                distanceBetween = distBetween[this.nodesArrayList.indexOf(u)][j];
                if (distanceBetween == Integer.MAX_VALUE || distanceBetween == 0 || (alt = dist[this.nodesArrayList.indexOf(u)] + distanceBetween) >= dist[j]) continue;
                dist[j] = alt;
                previous[j] = u;
            }
        }
        ((ArrayList)candidateSwitches).clear();
        u = target;
        while (previous[this.nodesArrayList.indexOf(u)] != null) {
            ((ArrayList)candidateSwitches).add(0, u);
            u = previous[this.nodesArrayList.indexOf(u)];
        }
        if (candidateSwitches == null || candidateSwitches.size() == 0 || !((ShortestPathNodeIf)candidateSwitches.get(0)).equals(source)) {
            ((ArrayList)candidateSwitches).add(0, source);
        }
        return candidateSwitches;
    }

    private ShortestPathNodeIf getVertexWithSmallestDistance(ArrayList<ShortestPathNodeIf> q, int[] dist) {
        if (q == null) {
            return null;
        }
        int d = Integer.MAX_VALUE;
        ShortestPathNodeIf sw = null;
        for (int i = 0; i < q.size(); ++i) {
            int newD = dist[this.nodesArrayList.indexOf(q.get(i))];
            if (newD >= d) continue;
            d = newD;
            sw = q.get(i);
        }
        return sw;
    }

    private void initializeNodes(ShortestPathNodeIf[] nodes, ShortestPathNodeIf source) {
        int i;
        if (nodes[0] != source) {
            for (i = 0; i < nodes.length; ++i) {
                if (!nodes[i].equals(source)) continue;
                ShortestPathNodeIf temp = nodes[0];
                nodes[0] = nodes[i];
                nodes[i] = temp;
                break;
            }
        }
        for (i = 0; i < nodes.length; ++i) {
            this.nodesArrayList.add(i, nodes[i]);
        }
    }

    private int[][] initializeWeight(ShortestPathNodeIf[] nodes, ShortestPathLinkIf[] edges) {
        HashedArrayList[][] shortestFcLinks = new HashedArrayList[nodes.length][nodes.length];
        int[][] weights = new int[nodes.length][nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            Arrays.fill(weights[i], Integer.MAX_VALUE);
        }
        for (ShortestPathLinkIf e : edges) {
            if (e == null) continue;
            ShortestPathNodeIf a = this.nodesByPK.get(e.getSwitch1PK());
            int x = this.nodesArrayList.indexOf(this.nodesByPK.get(e.getSwitch1PK()));
            ShortestPathNodeIf b = this.nodesByPK.get(e.getSwitch2PK());
            int y = this.nodesArrayList.indexOf(this.nodesByPK.get(e.getSwitch2PK()));
            int newWeight = e.getSpeed() == 0L ? 100 : new Long(Math.round(1.0 / (double)(e.getSpeed() / 1000000000L) * 1000.0)).intValue();
            if (newWeight < weights[x][y]) {
                weights[x][y] = newWeight;
                shortestFcLinks[x][y] = new HashedArrayList();
                ((ArrayList)shortestFcLinks[x][y]).add(e);
            } else if (newWeight == weights[x][y]) {
                ((ArrayList)shortestFcLinks[x][y]).add(e);
            }
            if (newWeight < weights[y][x]) {
                weights[y][x] = newWeight;
                shortestFcLinks[y][x] = new HashedArrayList();
                ((ArrayList)shortestFcLinks[y][x]).add(e);
                continue;
            }
            if (newWeight != weights[y][x]) continue;
            ((ArrayList)shortestFcLinks[y][x]).add(e);
        }
        this.shortestFcLinksHashMap = new HashMap();
        for (int i = 0; i < nodes.length; ++i) {
            for (int j = 0; j < nodes.length; ++j) {
                HashedArrayList arrayList = shortestFcLinks[i][j];
                if (arrayList == null) continue;
                for (int k = 0; k < arrayList.size(); ++k) {
                    ShortestPathLinkIf edge = (ShortestPathLinkIf)arrayList.get(k);
                    if (edge == null) continue;
                    this.shortestFcLinksHashMap.put(edge.getPK(), edge);
                }
            }
        }
        return weights;
    }

    public HashMap<PKIf, ShortestPathLinkIf> getShortestFcLinksHashMap() {
        return this.shortestFcLinksHashMap;
    }
}

