/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.type;

public enum DiscStatusType {
    UNMANAGED(0, "unmanaged"),
    INIT(1, "init"),
    STARTED(2, "started"),
    DISCOVERING(3, "discovering"),
    CDP_DONE(4, "cdp discovery done"),
    DEEP_DONE(5, "deep discovery done"),
    ALLFINISHED(6, "all finished"),
    ABORTED(7, "aborted"),
    TIMEOUT(8, "timeout"),
    INTERRUPTED(9, "interrupted"),
    IDLE(10, "idle"),
    NONEXIST(11, "non exist");

    public static DiscStatusType[] AllTypes;
    private int value;
    private String name;

    private DiscStatusType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int value() {
        return this.value;
    }

    public String toString() {
        return this.name;
    }

    public static DiscStatusType getType(int value) {
        for (DiscStatusType t : AllTypes) {
            if (t.value != value) continue;
            return t;
        }
        System.err.println("DiscStatusType cannot get type from:" + value);
        return UNMANAGED;
    }

    public static DiscStatusType getType(String name) {
        for (DiscStatusType t : AllTypes) {
            if (!t.name.equalsIgnoreCase(name)) continue;
            return t;
        }
        System.err.println("DiscStatusType cannot get type from:" + name);
        return UNMANAGED;
    }

    static {
        AllTypes = DiscStatusType.values();
    }
}

