/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.type;

import com.cisco.dcbu.sm.common.type.IslPKIf;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.SerialNumKey;
import com.cisco.dcbu.sm.common.type.SwitchIntKeyIf;
import com.cisco.dcbu.sm.common.type.SwitchSnIntKey;
import com.cisco.dcbu.sm.common.type.VdcPK;
import com.cisco.dcbu.sm.common.type.VdcSnIntKey;

public class EthIslPK
implements IslPKIf<SwitchIntKeyIf> {
    static final long serialVersionUID = 1L;
    public final SwitchIntKeyIf _p1;
    public final SwitchIntKeyIf _p2;

    public EthIslPK(PKIf sw1PK, PKIf sw2PK, int ifIndex1, int ifIndex2) {
        if (sw1PK == null || sw2PK == null || ifIndex1 == -1 || ifIndex2 == -1) {
            IllegalArgumentException ex = new IllegalArgumentException("Invalid ethIsl PK:" + sw1PK + "," + sw2PK + "," + ifIndex1 + "," + ifIndex2);
            throw ex;
        }
        SwitchIntKeyIf<SerialNumKey> tp1 = null;
        SwitchIntKeyIf<SerialNumKey> tp2 = null;
        if (sw1PK instanceof SerialNumKey) {
            tp1 = new SwitchSnIntKey((SerialNumKey)sw1PK, ifIndex1);
        } else if (sw1PK instanceof VdcPK) {
            tp1 = new VdcSnIntKey((VdcPK)sw1PK, ifIndex1);
        } else {
            throw new IllegalArgumentException("Invalid switch1 key type:" + sw1PK);
        }
        if (sw2PK instanceof SerialNumKey) {
            tp2 = new SwitchSnIntKey((SerialNumKey)sw2PK, ifIndex2);
        } else if (sw2PK instanceof VdcPK) {
            tp2 = new VdcSnIntKey((VdcPK)sw2PK, ifIndex2);
        } else {
            throw new IllegalArgumentException("Invalid switch2 key type:" + sw2PK);
        }
        if (tp1.compareTo(tp2) < 0) {
            this._p1 = tp1;
            this._p2 = tp2;
        } else {
            this._p1 = tp2;
            this._p2 = tp1;
        }
    }

    public EthIslPK(SwitchIntKeyIf snIntKey1, SwitchIntKeyIf snIntKey2) {
        if (snIntKey1 == null || snIntKey2 == null) {
            throw new IllegalArgumentException("Invalid parameters:" + snIntKey1 + "," + snIntKey2);
        }
        if (snIntKey1.compareTo(snIntKey2) < 0) {
            this._p1 = snIntKey1;
            this._p2 = snIntKey2;
        } else {
            this._p1 = snIntKey2;
            this._p2 = snIntKey1;
        }
    }

    @Override
    public SwitchIntKeyIf getSwitchIntKey1() {
        return this._p1;
    }

    @Override
    public SwitchIntKeyIf getSwitchIntKey2() {
        return this._p2;
    }

    public PKIf getSwitch1Key() {
        return this._p1.getSwitchKey();
    }

    public PKIf getSwitch2Key() {
        return this._p2.getSwitchKey();
    }

    public boolean isVdcSwitch1() {
        return this._p1.withinVdc();
    }

    public boolean isVdcSwitch2() {
        return this._p2.withinVdc();
    }

    @Override
    public int getIfIndex1() {
        return this._p1.getIfindex();
    }

    @Override
    public int getIfIndex2() {
        return this._p2.getIfindex();
    }

    @Override
    public boolean equals(Object x) {
        if (x == this) {
            return true;
        }
        if (x == null || !(x instanceof EthIslPK)) {
            return false;
        }
        EthIslPK otherPK = (EthIslPK)x;
        return this._p1.equals(otherPK._p1) && this._p2.equals(otherPK._p2);
    }

    @Override
    public int hashCode() {
        return this._p1.hashCode() ^ this._p2.hashCode();
    }

    @Override
    public String toString() {
        return this._p1.getKeyString() + " <-> " + this._p2.getKeyString();
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        if (!(o1 instanceof EthIslPK)) {
            return -1;
        }
        if (!(o2 instanceof EthIslPK)) {
            return -1;
        }
        EthIslPK islKey1 = (EthIslPK)o1;
        EthIslPK islKey2 = (EthIslPK)o2;
        if (islKey1._p1.equals(islKey2._p1)) {
            return islKey1._p2.compare(islKey1._p2, islKey2._p2);
        }
        return islKey1._p1.compare(islKey1._p1, islKey2._p1);
    }

    @Override
    public int compareTo(Object o) {
        return this.compare(this, o);
    }
}

