/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.type;

import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.common.type.NameKey;

public class SerialNumKey
extends NameKey {
    static final long serialVersionUID = 1L;
    public final String _serialNum;

    public SerialNumKey(String serialNum) {
        super(serialNum);
        if (serialNum == null || serialNum.length() == 0) {
            throw new IllegalArgumentException("Invalid serial number:" + serialNum);
        }
        this._serialNum = serialNum;
    }

    public boolean isFromIP() {
        return Character.isDigit(this._serialNum.charAt(0)) && this._serialNum.indexOf(46) >= 0;
    }

    public boolean isRealSN() {
        return GenUtil.isCiscoSerialNumber(this._serialNum);
    }

    @Override
    public boolean equals(Object x) {
        if (x == this) {
            return true;
        }
        if (x == null || !(x instanceof SerialNumKey)) {
            return false;
        }
        SerialNumKey otherPK = (SerialNumKey)x;
        return otherPK._serialNum.equals(this._serialNum);
    }

    @Override
    public int hashCode() {
        return this._serialNum.hashCode();
    }

    @Override
    public String toString() {
        return this._serialNum;
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        return ((SerialNumKey)o1)._serialNum.compareTo(((SerialNumKey)o2)._serialNum);
    }

    @Override
    public int compareTo(Object o) {
        return this.compare(this, o);
    }
}

