/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.type;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.sm.common.type.SwitchIntKeyIf;
import com.cisco.dcbu.sm.common.type.WwnKey;

public class SwitchIntKey
implements SwitchIntKeyIf<WwnKey> {
    static final long serialVersionUID = 1L;
    public final WwnKey _swPK;
    public final int _index;

    public SwitchIntKey(WwnKey swPK, int ifIndex) {
        if (swPK == null) {
            throw new IllegalArgumentException("switch PK cannot be null");
        }
        this._swPK = swPK;
        this._index = ifIndex;
    }

    @Override
    public WwnKey getSwitchKey() {
        return this._swPK;
    }

    @Override
    public int getIfindex() {
        return this._index;
    }

    @Override
    public boolean withinVdc() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof SwitchIntKey)) {
            return false;
        }
        SwitchIntKey key = (SwitchIntKey)o;
        return this._swPK.equals(key._swPK) && this._index == key._index;
    }

    @Override
    public int hashCode() {
        return this._swPK.hashCode() ^ this._index;
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        SwitchIntKey siKey1 = (SwitchIntKey)o1;
        SwitchIntKey siKey2 = (SwitchIntKey)o2;
        if (siKey1._swPK.equals(siKey2._swPK)) {
            return siKey1._index - siKey2._index;
        }
        return siKey1._swPK.compare(siKey1._swPK, siKey2._swPK);
    }

    @Override
    public int compareTo(Object o) {
        return this.compare(this, o);
    }

    @Override
    public String toString() {
        return this._swPK.toString() + " / " + IfIndexUtil.ifIndexToName(this._index);
    }

    @Override
    public String getFullString() {
        return this._swPK.toString() + "/" + IfIndexUtil.ifIndexToName(this._index) + "(0x" + Integer.toHexString(this._index) + ')';
    }

    @Override
    public String getKeyString() {
        return this._swPK.toString() + ", 0x" + Integer.toHexString(this._index);
    }
}

