/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.util;

import com.cisco.dcbu.sm.common.util.StopWatch;
import com.cisco.dcbu.sm.common.util.TimerTaskListener;

public class TimerTask
implements Runnable {
    private StopWatch _watch = new StopWatch();
    private Thread _thread;
    private String _name;
    private long _timeoutTime;
    private TimerTaskListener _listener;

    public TimerTask(long timeoutTime) {
        this(timeoutTime, null, null);
    }

    public TimerTask(long timeoutTime, TimerTaskListener listener) {
        this(timeoutTime, listener, null);
    }

    public TimerTask(long timeoutTime, TimerTaskListener listener, String name) {
        this._timeoutTime = timeoutTime;
        this._listener = listener;
        this._name = name;
    }

    public synchronized void start() {
        if (this.isRunning()) {
            return;
        }
        this._watch.reset();
        this._watch.start();
        this._thread = new Thread(this);
        this._thread.setPriority(3);
        this._thread.start();
    }

    public synchronized void stop() {
        this._watch.stop();
        if (this._thread != null) {
            this._thread.interrupt();
            this._thread = null;
        }
    }

    public boolean isRunning() {
        return this._watch.isRunning();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTaskStopped() {
        if (this._thread == null) return true;
        if (!this._thread.isAlive()) return true;
        TimerTask timerTask = this;
        if (timerTask._thread.interrupted()) return false;
        return true;
    }

    public void resetTimer(long timeoutTime) {
        this.resetTimer();
        this._timeoutTime = timeoutTime;
    }

    public void resetTimer() {
        this.stop();
        this._watch.reset();
    }

    public TimerTaskListener getListener() {
        return this._listener;
    }

    public String getName() {
        return this._name;
    }

    public long getElapsedTime() {
        return this._watch.getElapsedTime();
    }

    public long getTimeout() {
        return this._timeoutTime;
    }

    @Override
    public void run() {
        while (this._watch.isRunning()) {
            long etime = this._watch.getElapsedTime();
            if (etime >= this._timeoutTime) {
                if (this._listener != null) {
                    this._listener.notifyTimeout(etime, this.getTimeout());
                }
                this.stop();
                continue;
            }
            long stime = this._timeoutTime - etime;
            if (stime <= 0L) continue;
            try {
                Thread.sleep(stime);
            }
            catch (Exception ex) {
                this.stop();
            }
        }
    }

    public static void main(String[] args) {
        TimerTask task = new TimerTask(5000L, new TimerTaskListener(){

            @Override
            public void notifyTimeout(long elapse, long countdown) {
                System.out.println("Used time:" + elapse + " is beyond timeout:" + countdown);
            }
        });
        task.start();
        try {
            Thread.sleep(10000L);
            task.stop();
            System.out.println(task.getElapsedTime());
            System.out.println(task.getTimeout());
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }
}

