/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.util;

import com.cisco.dcbu.sm.common.util.StopWatch;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class TraceLogger {
    public static final String Name = "TraceLogger";
    public Logger _logger;
    public boolean _test = false;
    public boolean _checkMemory = false;
    public boolean _checkTime = false;
    public boolean _traceRoot = true;
    private final ConcurrentHashMap<String, StopWatch> _timers = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Long> _memcheckers = new ConcurrentHashMap();

    public TraceLogger(Logger logger) {
        this(logger, false, false, false, false);
    }

    public TraceLogger(Logger logger, boolean test, boolean checkTime, boolean checkMemory, boolean traceRoot) {
        this._logger = logger;
        this._test = test;
        this._checkTime = checkTime;
        this._checkMemory = checkMemory;
        this._traceRoot = traceRoot;
        if (this._traceRoot) {
            this.traceFuncBegin(this, "ROOT");
        }
    }

    public StopWatch startTimer() {
        StopWatch timer = null;
        timer = new StopWatch();
        timer.start();
        return timer;
    }

    public void stopTimer(StopWatch timer) {
        if (timer != null) {
            timer.stop();
            timer = null;
        }
    }

    public StopWatch startTimer(String label) {
        if (label == null) {
            return null;
        }
        StopWatch timer = this._timers.get(label);
        if (timer == null) {
            timer = new StopWatch();
            this._timers.put(label, timer);
        }
        timer.reset();
        timer.start();
        return timer;
    }

    public StopWatch stopTimer(String label) {
        if (label == null) {
            return null;
        }
        StopWatch timer = this._timers.get(label);
        if (timer != null) {
            timer.stop();
        }
        return timer;
    }

    public StopWatch resumeTimer(String label) {
        if (label == null) {
            return null;
        }
        StopWatch timer = this._timers.get(label);
        if (timer == null) {
            timer = new StopWatch();
            this._timers.put(label, timer);
        }
        timer.start();
        return timer;
    }

    public StopWatch getTimer(String label) {
        if (label == null) {
            return null;
        }
        return this._timers.get(label);
    }

    public void clearTimer(String label) {
        StopWatch timer = this._timers.remove(label);
        this.stopTimer(timer);
    }

    public long checkCurrentMemory() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public long checkCurrentMemory(String label) {
        long used = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        this._memcheckers.put(label, used);
        return used;
    }

    public long getPreviousMemory(String label) {
        Long used = this._memcheckers.get(label);
        if (used != null) {
            return used;
        }
        return 0L;
    }

    public long getDeltaMemory(String label) {
        Long used = this._memcheckers.get(label);
        if (used != null) {
            return this.checkCurrentMemory() - used;
        }
        return 0L;
    }

    public void clearMemoryCheck(String label) {
        this._memcheckers.remove(label);
    }

    public void traceFuncBegin(Object owner, String label) {
        if (this._test || this.isTraceLog()) {
            if (this._checkTime) {
                this.startTimer(owner + label);
            }
            if (this._checkMemory) {
                this.checkCurrentMemory(owner + label);
            }
            this.log(Level.TRACE, String.valueOf(owner) + "--" + label + "--begin trace");
        }
    }

    public void traceFunc(Object owner, String label, String message) {
        if (this._test || this.isTraceLog()) {
            StopWatch timer;
            long usedTime = 0L;
            long usedMemory = 0L;
            if (this._checkTime && (timer = this.getTimer(owner + label)) != null) {
                usedTime = timer.getElapsedTime();
            }
            if (this._checkMemory) {
                usedMemory = this.getPreviousMemory(owner + label);
                usedMemory = this.checkCurrentMemory() - usedMemory;
            }
            this.log(Level.TRACE, String.valueOf(owner) + "--" + label, "--" + message, usedTime, usedMemory);
        }
    }

    public void traceFuncEnd(Object owner, String label, Object ret) {
        if (this._test || this.isTraceLog()) {
            long usedTime = 0L;
            long usedMemory = 0L;
            long pTime = 0L;
            long pMemory = 0L;
            if (this._checkTime) {
                StopWatch timer = this.getTimer(owner + label);
                if (timer != null) {
                    usedTime = timer.getElapsedTime();
                }
                this.clearTimer(owner + label);
            }
            if (this._checkMemory) {
                usedMemory = this.getPreviousMemory(owner + label);
                usedMemory = this.checkCurrentMemory() - usedMemory;
                this.clearMemoryCheck(owner + label);
            }
            this.log(Level.TRACE, String.valueOf(owner) + "--" + label, "--return=" + ret, usedTime, usedMemory);
        }
    }

    public void log(Level level, String prefix, String message, long timeUsageInMs, long memUsageInByte) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append(prefix);
        if (this._checkTime) {
            sb.append("-usedTime(ms)=").append(timeUsageInMs);
        }
        if (this._checkMemory) {
            sb.append("-usedMemory(byte)=").append(memUsageInByte);
        }
        sb.append(message);
        if (this._traceRoot) {
            sb.append("\n").append(this).append("-rootMem=" + this.getDeltaMemory(this + "ROOT")).append("\n-timeHash=").append(this._timers).append("\n-memHash=").append(this._memcheckers);
        }
        sb.append("\n");
        this.log(level, sb.toString());
    }

    public void log(Level level, String message) {
        this.log(level, message, null);
    }

    public void log(Level level, String message, Throwable e) {
        if (this._test) {
            if (e != null) {
                System.err.println(message);
                e.printStackTrace(System.err);
            } else {
                System.out.println(message);
            }
        } else if (level != null && this._logger != null) {
            if (level == Level.DEBUG && !this._logger.isDebugEnabled()) {
                return;
            }
            if (level == Level.TRACE && !this._logger.isTraceEnabled()) {
                return;
            }
            if (e != null) {
                this._logger.log((Priority)level, (Object)message, e);
            } else {
                this._logger.log((Priority)level, (Object)message);
            }
        }
    }

    public void warn(String message) {
        this.log(Level.WARN, message);
    }

    public void warn(String message, Throwable e) {
        this.log(Level.WARN, message, e);
    }

    public void info(String message) {
        this.log(Level.INFO, message);
    }

    public void info(String message, Throwable e) {
        this.log(Level.INFO, message, e);
    }

    public void debug(String message) {
        this.log(Level.DEBUG, message);
    }

    public void debug(String message, Throwable e) {
        this.log(Level.DEBUG, message, e);
    }

    public void trace(String message) {
        this.log(Level.WARN, message);
    }

    public void trace(String message, Throwable e) {
        this.log(Level.WARN, message, e);
    }

    public void reset() {
        for (StopWatch t : this._timers.values()) {
            if (t == null) continue;
            t.stop();
        }
        this._timers.clear();
        this._memcheckers.clear();
    }

    public boolean isTraceable() {
        return this._test || this.isTraceLog();
    }

    public boolean isDebuggable() {
        return this._test || this.isDebugLog();
    }

    private boolean isTraceLog() {
        return this._logger != null && this._logger.isTraceEnabled();
    }

    private boolean isDebugLog() {
        return this._logger != null && this._logger.isDebugEnabled();
    }

    protected void finalized() throws Throwable {
        this.reset();
        super.finalize();
    }
}

