/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ServerObjectCache {
    private static int exIntMin;
    public static final int EXPIRY_TIME_MIN;
    protected static HashMap synReportTypeIdMap;
    public static final int MULTI_PATH_REPORT_TYPE = 1;
    public static final int HOST_2_STORAGE_REPORT_TYPE = 2;
    public static final int STORAGE_2_HOST_REPORT_TYPE = 3;
    public static final int ZONE_DISCREPANCY_REPORT_TYPE = 4;
    public static final int CONFIG_ANALYSIS_REPORT_TYPE = 5;
    public static final int SWITCH_HEALTH_REPORT_TYPE = 6;
    public static final int HOST_2_STORAGE_PING_REPORT_TYPE = 7;
    public static final int WEB_ANALYSIS_REPORT_STATISTICS_TYPE = 8;
    public static final int ZONE_ROUTE_REPORT_TYPE = 9;
    public static final int PORT_SECURITY_CONFIG_TYPE = 10;
    public static final int PORT_SECURITY_AUTOLEARN_TYPE = 11;
    public static final int CONFIG_COMPARE_DIFF_TYPE = 12;
    public static final int CONFIG_COMPARE_RESTORE_TYPE = 13;
    public static final int CONFIG_VERIFY_SERVER_CREDENTIALS = 14;
    public static final int CONFIG_BACKUP_FABRIC = 15;
    public static final int CONFIG_BACKUP_VIEW_CONFIGURTION = 16;
    public static final int CONFIG_CLEAR_HOST_KEY = 17;
    public static final String[] OBJECT_ID_2_NAME;
    public static final String[] reportTypes;

    public ServerObjectCache() {
        String exTime = System.getProperty("SERVER_OBJECT_EXPIRY_TIME", "360");
        try {
            exIntMin = Integer.parseInt(exTime);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Object[] getNewInstanceCachedObject(int reptId) {
        return (Object[])synReportTypeIdMap.get(new Integer(reptId));
    }

    private static int getNextReportKey(int reportType) {
        int srvrId = 0;
        int nextReportNum = 1;
        ArrayList<Integer> reportNums = new ArrayList<Integer>();
        for (Map.Entry obEntry : synReportTypeIdMap.entrySet()) {
            int key = (Integer)obEntry.getKey();
            int cachSrvrId = key >> 24;
            int repType = key >> 16 & 0xFF;
            if (reportType != repType && srvrId != 0 && cachSrvrId != srvrId) continue;
            int reptNum = key & 0xFFFF;
            reportNums.add(new Integer(reptNum));
        }
        Collections.sort(reportNums);
        for (int i = 0; i < reportNums.size(); ++i) {
            int key = (Integer)reportNums.get(i);
            if (key != nextReportNum) continue;
            ++nextReportNum;
        }
        return srvrId << 24 | reportType << 16 | 0xFFFF & nextReportNum;
    }

    public static synchronized int modifyCachedObjectMap(boolean add, int reportType, int reptId, Object data) {
        int reptKey;
        int n = reptKey = add ? ServerObjectCache.getNextReportKey(reportType) : reptId;
        if (add) {
            synReportTypeIdMap.put(reptKey, data);
        } else {
            synReportTypeIdMap.remove(new Integer(reptKey));
        }
        return reptKey;
    }

    public static StringBuffer getAllCachedObject() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        for (Map.Entry obEntry : synReportTypeIdMap.entrySet()) {
            int key = (Integer)obEntry.getKey();
            int cachSrvrId = key >> 24;
            int reportType = key >> 16 & 0xFF;
            int reportID = 0xFFFF & key;
            ++i;
            Object[] data = (Object[])obEntry.getValue();
            Date createTime = data != null && data.length == 2 ? new Date((Long)data[1]) : null;
            buf.append("server:" + cachSrvrId + " Type:" + OBJECT_ID_2_NAME[reportType - 1] + " ID:" + reportID + (createTime != null ? " Created:" + createTime.toString() : "") + "\n");
        }
        return buf;
    }

    public static ArrayList getAllCachedObjects() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        ArrayList<String[]> dataOut = new ArrayList<String[]>();
        if (synReportTypeIdMap != null && synReportTypeIdMap.size() > 0) {
            for (Map.Entry obEntry : synReportTypeIdMap.entrySet()) {
                int key = (Integer)obEntry.getKey();
                int cachSrvrId = key >> 24;
                int reportType = key >> 16 & 0xFF;
                int reportID = 0xFFFF & key;
                Object[] data = (Object[])obEntry.getValue();
                Date createTime = data != null && data.length == 3 ? new Date((Long)data[1]) : null;
                String[] rowData = new String[]{OBJECT_ID_2_NAME[reportType - 1], Integer.toString(key), createTime != null ? createTime.toString() : null, Boolean.FALSE.toString(), data[2].toString(), Integer.toString(cachSrvrId)};
                dataOut.add(rowData);
                ++i;
            }
        }
        return dataOut;
    }

    public static void clearObjects(String type) {
        int obType;
        int n = type.equals("zoneroute") ? 1 : (obType = type.equals("portsecurity") ? 2 : -1);
        if (type.equals("all")) {
            obType = 100;
        }
        if (obType != -1) {
            Iterator itr = synReportTypeIdMap.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry obEntry = itr.next();
                int key = (Integer)obEntry.getKey();
                int reportType = key >> 16;
                if (obType != 100 && (obType != 1 || reportType != 9) && (obType != 2 || reportType != 10 && reportType != 11)) continue;
                itr.remove();
            }
        }
    }

    public static void clearExpiredObjects() {
        Iterator itr = synReportTypeIdMap.entrySet().iterator();
        while (itr.hasNext()) {
            long creationTime;
            long curTime;
            Map.Entry obEntry = itr.next();
            Object[] data = (Object[])obEntry.getValue();
            if (data == null || data.length < 2 || ((curTime = System.currentTimeMillis()) - (creationTime = ((Long)data[1]).longValue())) / 1000L / 60L <= (long)EXPIRY_TIME_MIN) continue;
            itr.remove();
        }
    }

    static {
        EXPIRY_TIME_MIN = exIntMin = 360;
        synReportTypeIdMap = new HashMap();
        OBJECT_ID_2_NAME = new String[]{"Host Multi Path", "Host to Storage Connectivity", "Storage to Host Connectivity", "Zone and Alias Discrepancy", "Config Analysis", "Switch Health", "Host to Storage Ping", "Running Reports", "Trace Path", "Port Security Config", "Port Security AutoLearn", "Compare Configuration", "restore Configuration", "Verify Server Credentials", "Backup Fabric", "View Configuration", "Clear SSH Host Key"};
        reportTypes = new String[]{"Host Multi Path", "Host to Storage Connectivity", "Storage to Host Connectivity", "Zone and Alias Discrepancy", "Config Analysis", "Switch Health", "Host to Storage Ping", "Running Reports", "Trace PAth", "Backup Fabric", "Port Security Config", "Port Security AutoLearn", "Compare Configuration", "restore Configuration", "Verify Server Credentials", "Backup Fabric", "View Configuration", "Clear SSH Host Key"};
    }
}

