/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.bean;

import com.cisco.dcbu.sm.common.model.ddm.DDMJob;
import com.cisco.dcbu.sm.common.rif.DDMCreationRif;
import com.cisco.dcbu.sm.common.rif.DDMServerRif;
import com.cisco.dcbu.sm.common.rif.EMRif;
import com.cisco.dcbu.sm.common.rif.FMServerRif;
import com.cisco.dcbu.sm.common.rif.FlexAtahRif;
import com.cisco.dcbu.sm.common.rif.InventoryServiceRif;
import com.cisco.dcbu.sm.common.rif.ModelFacadeRif;
import com.cisco.dcbu.sm.common.rif.NPVRif;
import com.cisco.dcbu.sm.common.rif.PMRif;
import com.cisco.dcbu.sm.common.rif.SecureEraseRif;
import com.cisco.dcbu.sm.common.rif.SessionRif;
import com.cisco.dcbu.sm.common.rif.SuperSessionRif;
import com.cisco.dcbu.sm.common.rif.TopologyRemote;
import com.cisco.dcbu.sm.common.rif.WebServiceRif;
import com.cisco.dcbu.sm.server.ServerRefIf;
import com.cisco.dcbu.sm.server.bean.SessionHelper;
import com.cisco.dcbu.sm.server.facade.SessionImpl;
import com.cisco.dcbu.sm.server.facade.SuperSessionImpl;
import com.cisco.dcbu.sm.server.security.FMUser;
import java.rmi.RemoteException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ServerBeanHelper
implements ServerRefIf {
    private static ServerBeanHelper _Instance;
    private InitialContext _context;
    static Logger _Logger;

    private ServerBeanHelper() {
        try {
            this._context = new InitialContext();
        }
        catch (NamingException ex) {
            _Logger.error((Object)("can not get initial context " + ex.getMessage()));
        }
    }

    public static ServerBeanHelper getInstance() {
        if (_Instance == null) {
            _Instance = new ServerBeanHelper();
        }
        return _Instance;
    }

    @Override
    public SuperSessionRif createSuperSession(String client, FMUser user) throws RemoteException {
        SuperSessionImpl ret = null;
        try {
            ret = new SuperSessionImpl(true);
            ret.init(client, user);
            SessionHelper.getInstance().registerSession(ret.getLoginSessionId(), ret);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
        return ret;
    }

    @Override
    public SessionRif createSession(String client, FMUser user) throws RemoteException {
        SessionImpl ret = null;
        try {
            ret = new SessionImpl(true);
            ret.init(client, user);
            SessionHelper.getInstance().registerSession(ret.getLoginSessionId(), ret);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
        return ret;
    }

    @Override
    public FMServerRif getFMServerRif() {
        FMServerRif ret = null;
        try {
            ret = (FMServerRif)this._context.lookup("java:app/dcm/FMServerBean!com.cisco.dcbu.sm.common.rif.FMServerRif");
        }
        catch (NamingException ex) {
            _Logger.error((Object)("Can not get to FMServerImpl:" + ex.getMessage()));
        }
        return ret;
    }

    @Override
    public ModelFacadeRif getModelFacade(SessionRif rif) throws RemoteException {
        ModelFacadeRif ret = null;
        try {
            ret = (ModelFacadeRif)this._context.lookup("java:app/dcm/ModelFacadeBean!com.cisco.dcbu.sm.common.rif.ModelFacadeRif");
        }
        catch (NamingException ex) {
            throw new RemoteException(ex.getMessage());
        }
        return ret;
    }

    @Override
    public InventoryServiceRif getInventoryService() throws RemoteException {
        InventoryServiceRif ret = null;
        try {
            ret = (InventoryServiceRif)this._context.lookup("java:app/dcm/InventoryServiceBean!com.cisco.dcbu.sm.common.rif.InventoryServiceRif");
        }
        catch (NamingException ex) {
            throw new RemoteException(ex.getMessage());
        }
        return ret;
    }

    @Override
    public DDMServerRif getDDMServer(SessionRif rif) throws RemoteException {
        DDMServerRif ret = null;
        try {
            ret = (DDMServerRif)this._context.lookup("java:app/dcm/DDMServerBean!com.cisco.dcbu.sm.common.rif.DDMServerRif");
        }
        catch (NamingException ex) {
            throw new RemoteException(ex.getMessage());
        }
        return ret;
    }

    @Override
    public DDMCreationRif getDDMCreation(SessionRif session, DDMJob job, FMUser user, DDMServerRif serverImpl, boolean newJob) throws RemoteException {
        DDMCreationRif ret = null;
        try {
            this._context = new InitialContext();
            ret = (DDMCreationRif)this._context.lookup("java:app/dcm/DDMCreationBean!com.cisco.dcbu.sm.common.rif.DDMCreationRif");
        }
        catch (NamingException ex) {
            throw new RemoteException(ex.getMessage());
        }
        return ret;
    }

    @Override
    public WebServiceRif getWebServiceRif() throws RemoteException {
        WebServiceRif ret = null;
        try {
            ret = (WebServiceRif)this._context.lookup("java:app/dcm/WebServiceBean!com.cisco.dcbu.sm.common.rif.WebServiceRif");
        }
        catch (NamingException ex) {
            _Logger.error((Object)("Can not get WebServiceBean:" + ex.getMessage()));
            throw new RemoteException(ex.getMessage());
        }
        return ret;
    }

    @Override
    public EMRif getEM() throws RemoteException {
        EMRif ret = null;
        try {
            ret = (EMRif)this._context.lookup("java:app/dcm/EMBean!com.cisco.dcbu.sm.common.rif.EMRif");
        }
        catch (NamingException ex) {
            _Logger.error((Object)("Can not get WebServiceBean:" + ex.getMessage()));
            throw new RemoteException(ex.getMessage());
        }
        return ret;
    }

    @Override
    public PMRif getPM() throws RemoteException {
        PMRif ret = null;
        try {
            ret = (PMRif)this._context.lookup("java:app/dcm/PMBean!com.cisco.dcbu.sm.common.rif.PMRif");
        }
        catch (NamingException ex) {
            _Logger.error((Object)("Can not get WebServiceBean:" + ex.getMessage()));
            throw new RemoteException(ex.getMessage());
        }
        return ret;
    }

    @Override
    public TopologyRemote getTopologyServer() throws RemoteException {
        TopologyRemote ret = null;
        try {
            ret = (TopologyRemote)this._context.lookup("java:app/dcm/TopologyBean!com.cisco.dcbu.sm.common.rif.TopologyRemote");
        }
        catch (NamingException ex) {
            throw new RemoteException(ex.getMessage());
        }
        return ret;
    }

    @Override
    public NPVRif getNPVRif() throws RemoteException {
        NPVRif ret = null;
        try {
            ret = (NPVRif)this._context.lookup("java:app/dcm/NPVBean!com.cisco.dcbu.sm.common.rif.NPVRif");
        }
        catch (NamingException ex) {
            _Logger.error((Object)("Can not get NPVBean:" + ex.getMessage()));
            throw new RemoteException(ex.getMessage());
        }
        return ret;
    }

    @Override
    public FlexAtahRif getFlexAtahRif() throws RemoteException {
        FlexAtahRif ret = null;
        try {
            ret = (FlexAtahRif)this._context.lookup("java:app/dcm/FlexAtahBean!com.cisco.dcbu.sm.common.rif.FlexAtahRif");
        }
        catch (NamingException ex) {
            _Logger.error((Object)("Can not get FlexAtahBean:" + ex.getMessage()));
            throw new RemoteException(ex.getMessage());
        }
        return ret;
    }

    @Override
    public SecureEraseRif getSecureErase(SessionRif session) throws RemoteException {
        SecureEraseRif ret = null;
        try {
            ret = (SecureEraseRif)this._context.lookup("java:app/dcm/SecureEraseBean!com.cisco.dcbu.sm.common.rif.SecureEraseRif");
        }
        catch (NamingException ex) {
            throw new RemoteException(ex.getMessage());
        }
        return ret;
    }

    static {
        _Logger = LogManager.getLogger((String)"fms");
    }
}

