/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.cat;

import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.VsanPK;
import com.cisco.dcbu.sm.server.analysis.BaseAnalysisReport;
import com.cisco.dcbu.sm.server.analysis.ReportAnalysis;
import com.cisco.dcbu.sm.server.analysis.ReportProgressTracker;
import com.cisco.dcbu.sm.server.cat.SwitchHealthCheckLogic;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import java.util.ArrayList;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HealthReportAnalysis
extends ReportAnalysis {
    public static Logger _Logger = LogManager.getLogger((String)"FM.WebReport");
    protected static ReportAnalysis repInstance;
    protected SwitchHealthCheckLogic switchHealthCheckLogic = null;

    protected HealthReportAnalysis() {
    }

    public static HealthReportAnalysis getInstance() {
        if (repInstance == null) {
            repInstance = new HealthReportAnalysis();
            _Logger.debug((Object)"Instance of Health Analysis used");
        }
        return (HealthReportAnalysis)repInstance;
    }

    public static HealthReportAnalysis newInstance() {
        return new HealthReportAnalysis();
    }

    @Override
    protected Logger getLogger() {
        return _Logger;
    }

    @Override
    public void generateReportAsynchronously(int fid, String vsanPKString, Object[] param, int reportType, int rptId, long fabricDbID, long vsanDbID) {
        this.reptId = rptId;
        boolean chkIfLink = (Boolean)param[0];
        boolean chkTrunkVsanMatchIsolation = (Boolean)param[1];
        if (this.isReportRunning()) {
            return;
        }
        _Logger.info((Object)("Start Running Report Async FID:" + fid + " vsanPK:" + vsanPKString));
        HealthAnalysisGenerator repGenerator = new HealthAnalysisGenerator(fid, null, true, chkIfLink, chkTrunkVsanMatchIsolation, fabricDbID, vsanDbID);
        this.initNewReport();
        new Thread(repGenerator).start();
    }

    @Override
    public ArrayList generateReportSynchronously(int fid, String vsanPKString, Object[] param, int reportType, long fabricDbID, long vsanDbID) throws Exception {
        _Logger.info((Object)("Start Running Report Async FID:" + fid + " vsanPK:" + vsanPKString));
        boolean chkIfLink = (Boolean)param[0];
        boolean chkTrunkVsanMatchIsolation = (Boolean)param[1];
        HealthAnalysisGenerator repGenerator = new HealthAnalysisGenerator(fid, null, false, chkIfLink, chkTrunkVsanMatchIsolation, fabricDbID, vsanDbID);
        this.initNewReport();
        repGenerator.run();
        if (this.isErrorInProcessing()) {
            throw this.getErrorException();
        }
        return repGenerator.getThReport().getReportData();
    }

    @Override
    public void buildReportSynchronously(VsanPK vPk, FabricPK fPk, ArrayList reportList, Object[] params, ReportProgressTracker prTracker, long fabricDbId, long vsanDbId) throws Exception {
        FabricImpl fImpl;
        boolean chkIfLink = true;
        boolean chkTrunkVsanMatchIsolation = true;
        if (params != null && params.length == 2) {
            chkIfLink = (Boolean)params[0];
            chkTrunkVsanMatchIsolation = (Boolean)params[1];
        }
        if ((fImpl = SanManager.getInstance().findFabric(fPk)) != null) {
            if (this.logUnlicensedFabric(fImpl) && this.logUnopenedFabric(fImpl)) {
                return;
            }
            this.switchHealthCheckLogic = new SwitchHealthCheckLogic();
            try {
                this.switchHealthCheckLogic.runHeathAnalysis(vPk, fPk, reportList, chkIfLink, chkTrunkVsanMatchIsolation, prTracker);
            }
            catch (Exception ex) {
                this.warnings.add(ex.getMessage());
            }
        } else {
            this.warnings.add("Selected Fabric is not monitored ");
            _Logger.info((Object)"Selected Fabric is not monitored ");
        }
    }

    @Override
    public void stopReport() {
        super.stopReport();
        this.switchHealthCheckLogic.setStopped(true);
    }

    @Override
    public void setStopped(boolean isStopped) {
        super.setStopped(isStopped);
        this.switchHealthCheckLogic.setStopped(isStopped);
    }

    @Override
    protected boolean logUnlicensedFabric(FabricImpl fImpl) {
        boolean allowUnLicensedFabrics;
        String allow = System.getProperty("web.allowUnLicensedFabrics");
        boolean bl = allowUnLicensedFabrics = allow != null && Boolean.getBoolean(allow.trim()) == Boolean.TRUE;
        if (!allowUnLicensedFabrics && !fImpl.isLicensed()) {
            if (this.getLogger() != null) {
                this.getLogger().info((Object)("Skipping Unlicensed Fabric " + fImpl));
            } else {
                System.out.println("Skipping Unlicensed Fabric " + fImpl);
            }
            this.warnings.add("Skipping Unlicensed Fabric " + fImpl);
            return true;
        }
        return false;
    }

    @Override
    public boolean logUnopenedFabric(FabricImpl fImpl) {
        if (fImpl.getFarbicStatus() != 2 && fImpl.getFarbicStatus() != 4) {
            if (this.getLogger() != null) {
                this.getLogger().info((Object)("Skipping Unopend Fabric " + fImpl));
            } else {
                System.out.println("Skipping Unopend Fabric " + fImpl);
            }
            return false;
        }
        return true;
    }

    private boolean testIfReportStopped() {
        return this.isStopped();
    }

    class HealthAnalysisGenerator
    extends ReportAnalysis.RunReportThread {
        int faId;
        String vsanPKString;
        int reportType;
        boolean checkIfLink;
        boolean chkTrunkVsanMatchIsolation;
        long fabricDbID;
        long vsanDbID;

        public HealthAnalysisGenerator(int fid, String vsanPKString, boolean asynchronous, boolean chkIfLink, boolean chkTrunkVsanMatchIsolation, long fabricDbID, long vsanDbID) {
            super(asynchronous);
            this.faId = fid;
            this.checkIfLink = chkIfLink;
            this.vsanPKString = vsanPKString;
            this.chkTrunkVsanMatchIsolation = chkTrunkVsanMatchIsolation;
            this.fabricDbID = fabricDbID;
            this.vsanDbID = vsanDbID;
        }

        @Override
        protected BaseAnalysisReport doAction() throws Exception {
            VsanPK[] vPK = ReportAnalysis.getVsanPK(this.vsanPKString);
            ArrayList data = HealthReportAnalysis.this.buildReportSynchronously(this.vsanPKString, this.faId, new Object[]{this.checkIfLink, this.chkTrunkVsanMatchIsolation}, true, this.fabricDbID, this.vsanDbID);
            BaseAnalysisReport znRpt = new BaseAnalysisReport(this.faId, this.vsanPKString, this.reportType);
            HealthReportAnalysis.this.setReportData(znRpt);
            znRpt.setReportData(data);
            return znRpt;
        }
    }
}

