/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.db;

import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.sm.server.db.ClusterMapping;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ClusterSequence
extends Sequence {
    static final String querySQL = "select value from clustersequence where id=? and server_id=?";
    static final String updateSQL = "update clustersequence set value=? where id=? and server_id=?";
    static final String insertSQL = "insert into clustersequence(value, id, server_id) values(?, ?, ?)";
    private static ClusterSequence _instance;
    private int _serverId;
    protected static final int _EventId = 4;
    protected long _eventValue;
    protected long _curEventValue;
    public static Logger _Logger;

    private ClusterSequence() {
        int serverId = 0;
        InetAddress[] locaIPs = NetUtil.getLocalAddresses();
        if (locaIPs != null) {
            for (int i = 0; i < locaIPs.length; ++i) {
                try {
                    serverId = ClusterMapping.getInstance().qSIdFromIP(locaIPs[i]);
                    if (serverId <= 0) continue;
                    break;
                }
                catch (SQLException e) {
                    _Logger.warn((Object)("Can not retrieve server id from DB" + e.getMessage()));
                }
            }
        }
        this._serverId = serverId;
        this._curValue = 10 + this._serverId;
        this._value = 10 + this._serverId;
        this._sanIdValue = 10 + this._serverId;
        this._fabricIdValue = 10 + this._serverId;
        this._curEventValue = 10 + this._serverId;
        this._eventValue = 10 + this._serverId;
    }

    @Override
    public int getID() {
        return 1;
    }

    @Override
    public synchronized long getPK() throws SQLException {
        if (this._curValue >= this._value) {
            try {
                this.refreshFromDB(1);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        this._curValue += 10L;
        return this._curValue - 10L;
    }

    @Override
    public synchronized long getEventPK(Connection conn) throws SQLException {
        if (this._curEventValue >= this._eventValue) {
            try {
                this.refreshFromDB(4, conn);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        this._curEventValue += 10L;
        return this._curEventValue - 10L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClusterSequence getSequence() {
        if (_instance != null) {
            return _instance;
        }
        Class<ClusterSequence> clazz = ClusterSequence.class;
        synchronized (ClusterSequence.class) {
            if (_instance == null) {
                _instance = new ClusterSequence();
                try {
                    _instance.refreshFromDB(1);
                }
                catch (SQLException ex) {
                    _Logger.error((Object)"ClusterSequence init error: ", (Throwable)ex);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClusterSequence getSequence(Connection con) {
        if (_instance != null) {
            return _instance;
        }
        Class<ClusterSequence> clazz = ClusterSequence.class;
        synchronized (ClusterSequence.class) {
            if (_instance == null) {
                _instance = new ClusterSequence();
                try {
                    _instance.refreshFromDB(1, con);
                }
                catch (SQLException ex) {
                    _Logger.error((Object)"ClusterSequence init error: ", (Throwable)ex);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _instance;
        }
    }

    @Override
    protected long queryDB(Connection con, int id) throws SQLException {
        long l;
        PreparedStatement stat = null;
        ResultSet rs = null;
        long result_value = 0L;
        try {
            stat = con.prepareStatement(querySQL);
            stat.setInt(1, id);
            stat.setInt(2, this._serverId);
            rs = stat.executeQuery();
            if (rs.next()) {
                result_value = rs.getLong(1);
            }
            rs.close();
            rs = null;
            stat.close();
            stat = null;
            l = result_value;
        }
        catch (SQLException ex) {
            try {
                _Logger.error((Object)"ClusterSequence.queryDB", (Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(rs);
                throw throwable;
            }
        }
        DbUtil.close(stat);
        DbUtil.close(rs);
        return l;
    }

    @Override
    protected void updateDB(Connection con, boolean insert, int id, long value) throws SQLException {
        PreparedStatement stat = null;
        try {
            stat = con.prepareStatement(insert ? insertSQL : updateSQL);
            stat.setLong(1, value);
            stat.setInt(2, id);
            stat.setInt(3, this._serverId);
            stat.executeUpdate();
            stat.close();
            stat = null;
        }
        catch (SQLException ex) {
            try {
                ex.printStackTrace();
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                throw throwable;
            }
        }
        DbUtil.close(stat);
    }

    @Override
    protected void refreshFromDB(int id, Connection con) throws SQLException {
        boolean insert = true;
        long value = 0L;
        long origValue = 0L;
        value = this.queryDB(con, id);
        if (value != 0L) {
            insert = false;
            switch (id) {
                case 1: {
                    this._curValue = value;
                    value = this._value = this._curValue + 1000L;
                    break;
                }
                case 2: {
                    this._sanIdValue = value += 10L;
                    break;
                }
                case 3: {
                    this._fabricIdValue = value += 10L;
                    break;
                }
                case 4: {
                    this._curEventValue = value;
                    value = this._eventValue = this._curEventValue + 1000L;
                }
            }
        } else {
            switch (id) {
                case 1: {
                    origValue = Sequence.getSimpleSequence().getPK();
                    value = this._value / 10L == 1L ? (long)(1000 + this._serverId) : this._value;
                    this._value = value;
                    if (value >= origValue) break;
                    this._curValue = value = (origValue / 10L + 1L) * 10L + (long)this._serverId;
                    value = this._value = this._curValue + 1000L;
                    break;
                }
                case 2: {
                    origValue = Sequence.getSimpleSequence().getSanPK();
                    value = this._sanIdValue;
                    if (value >= origValue) break;
                    this._sanIdValue = value = (origValue / 10L + 1L) * 10L + (long)this._serverId;
                    break;
                }
                case 3: {
                    origValue = Sequence.getSimpleSequence().getFabricPK();
                    value = this._fabricIdValue;
                    if (value >= origValue) break;
                    this._fabricIdValue = value = (origValue / 10L + 1L) * 10L + (long)this._serverId;
                    break;
                }
                case 4: {
                    origValue = this.getPK();
                    value = this._eventValue / 10L == 1L ? (long)(1000 + this._serverId) : this._eventValue;
                    this._eventValue = value;
                    if (value >= origValue) break;
                    this._curEventValue = value = this.getPK();
                    value = this._eventValue = this._curEventValue + 1000L;
                }
            }
        }
        this.updateDB(con, insert, id, value);
    }

    @Override
    public int getServerId() {
        return this._serverId;
    }

    static {
        _Logger = LogManager.getLogger((String)"fms.ClusterSequence");
    }
}

