/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.db;

import com.cisco.dcbu.sm.server.db.ConnectionManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class DbUtil {
    static Logger _Logger = LogManager.getLogger((String)"fms.db");
    static volatile ArrayList<ConcurrentHashMap<Long, Long>> _Gmaps = new ArrayList();
    private static AtomicBoolean _DirtyFlag = new AtomicBoolean(false);
    public static final int GROUP_MEMBER_TYPE_FABRIC = 0;
    public static final int GROUP_MEMBER_TYPE_LAN = 1;
    public static final int GROUP_MEMBER_TYPE_GROUP = 2;
    public static final int GROUP_MEMBER_TYPE_SAN_SWITCH = 3;
    public static final int GROUP_MEMBER_TYPE_LAN_SWITCH = 4;

    public static void setDirtyFlag() {
        _DirtyFlag.compareAndSet(false, true);
    }

    public static void close(Connection con) {
        if (con != null) {
            try {
                con.setAutoCommit(true);
            }
            catch (Throwable ex) {
                _Logger.log((Priority)Level.WARN, (Object)"Failed to set auto commit", ex);
            }
            try {
                ConnectionManager.returnConnection(con);
            }
            catch (Throwable ex) {
                _Logger.log((Priority)Level.WARN, (Object)"Failed to close connection", ex);
            }
        }
    }

    public static void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Throwable ex) {
                _Logger.log((Priority)Level.DEBUG, (Object)"Failed to close resultset", ex);
            }
        }
    }

    public static void close(Statement stat) {
        if (stat != null) {
            try {
                stat.close();
            }
            catch (Throwable ex) {
                _Logger.log((Priority)Level.DEBUG, (Object)"Failed to close statement", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteFileFromDb(String fileName, String userName) throws Exception {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = ConnectionManager.getConnection();
            String sqlText = "delete from xmlDocs where user_name = ? and document_name = ?";
            stmt = conn.prepareStatement(sqlText);
            stmt.setString(1, userName);
            stmt.setString(2, fileName);
            stmt.execute();
            _Logger.info((Object)("Document: " + fileName + " deleted successfully."));
        }
        catch (Exception ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
            }
            catch (Throwable throwable) {
                DbUtil.close(stmt);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(stmt);
            DbUtil.close(conn);
        }
        DbUtil.close(stmt);
        DbUtil.close(conn);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getNavGroupId(long memId, int type) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            long l;
            block13: {
                while (_Gmaps.isEmpty() || _DirtyFlag.get()) {
                    ArrayList<ConcurrentHashMap<Long, Long>> arrayList = _Gmaps;
                    synchronized (arrayList) {
                        if (_DirtyFlag.get()) {
                            _Gmaps.clear();
                            _DirtyFlag.set(false);
                        }
                        if (_Gmaps.isEmpty()) {
                            for (int i = 0; i < 5; ++i) {
                                _Gmaps.add(new ConcurrentHashMap());
                            }
                        }
                    }
                }
                ConcurrentHashMap<Long, Long> tmp = _Gmaps.get(type);
                if (tmp.containsKey(memId)) {
                    return tmp.get(memId);
                }
                String QUERY_GROUP_ID = "SELECT GROUP_ID FROM NAV_GROUP_MEMBER WHERE MEM_DBID=? and type=?";
                conn = null;
                stmt = null;
                rs = null;
                try {
                    conn = ConnectionManager.getConnection();
                    stmt = conn.prepareStatement("SELECT GROUP_ID FROM NAV_GROUP_MEMBER WHERE MEM_DBID=? and type=?");
                    stmt.setLong(1, memId);
                    stmt.setInt(2, type);
                    rs = stmt.executeQuery();
                    if (rs.next()) {
                        long gid = rs.getLong(1);
                        tmp.put(memId, gid);
                        l = gid;
                        DbUtil.close(rs);
                        break block13;
                    }
                    DbUtil.close(rs);
                    break block14;
                }
                catch (Exception ex) {
                    _Logger.warn((Object)ex.getMessage());
                    return -1L;
                }
            }
            DbUtil.close(stmt);
            DbUtil.close(conn);
            return l;
        }
        DbUtil.close(stmt);
        DbUtil.close(conn);
        return -1L;
        finally {
            DbUtil.close(rs);
            DbUtil.close(stmt);
            DbUtil.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getPostgresPerfStatus() {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        int status;
        block5: {
            status = 0;
            if (ConnectionManager.getDbDriver().indexOf(".postgres") < 0) {
                return status;
            }
            String sql = "select count(*) from end_port";
            conn = null;
            pstmt = null;
            rs = null;
            try {
                String intvStr = System.getProperty("db.postgres.perfTest", "20");
                conn = ConnectionManager.getConnection();
                pstmt = conn.prepareStatement(sql);
                long startTime = System.currentTimeMillis();
                pstmt.executeQuery();
                long endTime = System.currentTimeMillis();
                if (endTime - startTime <= Long.parseLong(intvStr) * 1000L) break block5;
                status = -1;
            }
            catch (Exception ex) {
                try {
                    _Logger.warn((Object)ex.getMessage());
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(pstmt);
                    DbUtil.close(conn);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(pstmt);
                DbUtil.close(conn);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(pstmt);
        DbUtil.close(conn);
        return status;
    }

    public static void main(String[] strArgs) {
        long gid = -1L;
        System.setProperty("db.url", "jdbc:oracle:thin:@localhost:1521:xe");
        System.setProperty("db.user", "mayli");
        System.setProperty("db.password", "mayli");
        gid = DbUtil.getNavGroupId(2240L, 4);
        System.out.println(gid);
        gid = DbUtil.getNavGroupId(2240L, 4);
        System.out.println(gid);
    }
}

