/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.db;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.sm.common.model.GroupBase;
import com.cisco.dcbu.sm.common.model.GroupMemberBase;
import com.cisco.dcbu.sm.common.model.GroupMemberPK;
import com.cisco.dcbu.sm.common.model.UserGroupBase;
import com.cisco.dcbu.sm.common.model.UserGroupPK;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.db.entity.EntityHelper;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.GroupManager;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.security.DCNMUserImpl;
import com.cisco.dcbu.sm.server.security.FMUser;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.RollbackException;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.hibernate.exception.ConstraintViolationException;

public class GroupPersistent {
    EntityManager em = EntityHelper.createEntityManager();
    private String _queryGroupByFIdSQL = "select g.id, g.name, g.type from groups g, fabric f where  g.fabric_id=f.id and f.fid=?";
    private String QuerySQLByNameFabricId = "select id from groups where fabric_id =? and name=?";
    private String _insertGroupSQL = "insert into groups (id, fabric_id, name, type, last_update_time)  values(?,?,?,?,?)";
    private String _updateGroupSQL = "update groups set fabric_id=?, last_update_time=? where id=?";
    private String _purgeGroupSQL = "delete from groups where id=?";
    private String _queryMemberIdBySwitchWwnSQL = "select sw.id from switch sw, group_member_info gm where sw.wwn=? and gm.group_id=? and gm.type=1 and sw.id=gm.member_id";
    private String _queryMemberIdByEndPortWwnSQL = "select ep.id from end_port ep, group_member_info gm where ep.wwn=? and gm.group_id=? and gm.type=2 and ep.id=gm.member_id";
    private String _querySwitchMemberIdSQL = "select id from switch where wwn=?";
    private String _queryEndPortMemberIdSQL = "select id from end_port where wwn=?";
    private String _queryBySwitchMemberSQL = "select sw.wwn from switch sw, group_member_info gm where gm.group_id=? and gm.type=1 and gm.member_id =sw.id";
    private String _queryByEndPortMemberSQL = "select ep.id, ep.wwn from end_port ep, group_member_info gm where gm.group_id=? and gm.type=2 and gm.member_id =ep.id";
    private String _insertMemberSQL = "insert into group_member_info (group_id, member_id, type, last_update_time) values(?,?,?,?)";
    private String _updateMemberSQL = "update group_member_info set type=?, last_update_time=? where group_id=? and  member_id=?";
    private String _purgeMemberSQL = "delete from group_member_info where group_id=?";
    private String _cleanMemberSQL = "delete from group_member_info where group_id=? and last_update_time <?";
    private static GroupPersistent _Instance = null;
    static Logger _Logger = LogManager.getLogger((String)"fms.GroupPersist");

    private GroupPersistent() {
    }

    public static GroupPersistent getInstance() {
        if (_Instance == null) {
            _Instance = new GroupPersistent();
        }
        return _Instance;
    }

    public void persist(GroupBase group) throws Exception {
        if (group == null) {
            return;
        }
        long fabricId = this.getFabricId(group.getFabricPK());
        if (fabricId == 0L) {
            return;
        }
        Connection con = null;
        try {
            con = ConnectionManager.getConnection();
            con.setAutoCommit(false);
            GroupBase[] groups = new GroupBase[]{group};
            this.persistGroups(groups, con, fabricId);
            this.persistGroupMembers(groups, con);
            con.commit();
        }
        catch (Exception ex) {
            if (con != null) {
                con.rollback();
            }
            _Logger.log((Priority)Level.WARN, (Object)"persist", (Throwable)ex);
            throw ex;
        }
        finally {
            DbUtil.close(con);
        }
    }

    public ArrayList reload(FabricImpl fabric) throws Exception {
        ArrayList<GroupBase> i2;
        if (fabric == null) {
            return null;
        }
        Connection con = null;
        Object byFIdStat = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        if (this.em.getTransaction().getRollbackOnly()) {
            this.em.getTransaction().rollback();
        }
        if (!this.em.getTransaction().isActive()) {
            this.em.getTransaction().begin();
        }
        ArrayList<GroupBase> groups = new ArrayList<GroupBase>();
        try {
            List fPks = this.em.createNamedQuery("queryFabricByFid").setParameter("fid", (Object)fabric.getPK()._fid).getResultList();
            if (fPks.size() > 0) {
                FabricPK pk = (FabricPK)fPks.get(0);
                List result = this.em.createNamedQuery("queryGroupByFabricId").setParameter("fid", (Object)pk.id).getResultList();
                for (GroupBase group : result) {
                    group.getGroupPK().setFabricPK(pk);
                    groups.add(group);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
            throw ex;
        }
        PreparedStatement bySwitchMemberStat = null;
        PreparedStatement byEndPortMemberStat = null;
        try {
            con = ConnectionManager.getConnection();
            bySwitchMemberStat = con.prepareStatement(this._queryBySwitchMemberSQL);
            byEndPortMemberStat = con.prepareStatement(this._queryByEndPortMemberSQL);
            for (int i2 = 0; i2 < groups.size(); ++i2) {
                WwnKey pk;
                byte[] wwn;
                GroupBase group = (GroupBase)groups.get(i2);
                ArrayList<WwnKey> members = new ArrayList<WwnKey>();
                if (group.getType() == 1) {
                    stat = bySwitchMemberStat;
                    stat.setLong(1, group.getDBID());
                    rs = stat.executeQuery();
                    while (rs.next()) {
                        wwn = rs.getBytes(1);
                        pk = new WwnKey(new Wwn(wwn));
                        members.add(pk);
                    }
                } else {
                    stat = byEndPortMemberStat;
                    stat.setLong(1, group.getDBID());
                    rs = byEndPortMemberStat.executeQuery();
                    while (rs.next()) {
                        wwn = rs.getBytes(2);
                        pk = new WwnKey(new Wwn(wwn));
                        members.add(pk);
                    }
                }
                if (members.size() > 0) {
                    PKIf[] pks = new PKIf[members.size()];
                    pks = members.toArray(pks);
                    group.setMembers(pks);
                }
                DbUtil.close(rs);
            }
            i2 = groups;
        }
        catch (Exception ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(bySwitchMemberStat);
                DbUtil.close(byEndPortMemberStat);
                DbUtil.close(con);
                if (this.em.getTransaction().isActive()) {
                    this.em.getTransaction().commit();
                }
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(bySwitchMemberStat);
        DbUtil.close(byEndPortMemberStat);
        DbUtil.close(con);
        if (this.em.getTransaction().isActive()) {
            this.em.getTransaction().commit();
        }
        return i2;
    }

    public ArrayList reloadAllGroups() throws Exception {
        ArrayList<GroupBase> i2;
        Connection con = null;
        Object byFIdStat = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        if (this.em.getTransaction().getRollbackOnly()) {
            this.em.getTransaction().rollback();
        }
        if (!this.em.getTransaction().isActive()) {
            this.em.getTransaction().begin();
        }
        ArrayList<GroupBase> groups = new ArrayList<GroupBase>();
        try {
            List fPks = this.em.createNamedQuery("queryAllFabric").getResultList();
            for (FabricPK pk : fPks) {
                List result = this.em.createNamedQuery("queryGroupByFabricId").setParameter("fid", (Object)pk.id).getResultList();
                for (GroupBase group : result) {
                    group.getGroupPK().setFabricPK(pk);
                    groups.add(group);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
            if (!this.em.getTransaction().isActive()) {
                this.em.getTransaction().rollback();
            }
            throw ex;
        }
        PreparedStatement bySwitchMemberStat = null;
        PreparedStatement byEndPortMemberStat = null;
        try {
            con = ConnectionManager.getConnection();
            bySwitchMemberStat = con.prepareStatement(this._queryBySwitchMemberSQL);
            byEndPortMemberStat = con.prepareStatement(this._queryByEndPortMemberSQL);
            for (int i2 = 0; i2 < groups.size(); ++i2) {
                WwnKey pk;
                byte[] wwn;
                GroupBase group = (GroupBase)groups.get(i2);
                ArrayList<WwnKey> members = new ArrayList<WwnKey>();
                if (group.getType() == 1) {
                    stat = bySwitchMemberStat;
                    stat.setLong(1, group.getDBID());
                    rs = stat.executeQuery();
                    while (rs.next()) {
                        wwn = rs.getBytes(1);
                        pk = new WwnKey(new Wwn(wwn));
                        members.add(pk);
                    }
                } else {
                    stat = byEndPortMemberStat;
                    stat.setLong(1, group.getDBID());
                    rs = byEndPortMemberStat.executeQuery();
                    while (rs.next()) {
                        wwn = rs.getBytes(2);
                        pk = new WwnKey(new Wwn(wwn));
                        members.add(pk);
                    }
                }
                if (members.size() > 0) {
                    PKIf[] pks = new PKIf[members.size()];
                    pks = members.toArray(pks);
                    group.setMembers(pks);
                }
                DbUtil.close(rs);
            }
            i2 = groups;
        }
        catch (Exception ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(bySwitchMemberStat);
                DbUtil.close(byEndPortMemberStat);
                DbUtil.close(con);
                if (this.em.getTransaction().isActive()) {
                    this.em.getTransaction().commit();
                }
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(bySwitchMemberStat);
        DbUtil.close(byEndPortMemberStat);
        DbUtil.close(con);
        if (this.em.getTransaction().isActive()) {
            this.em.getTransaction().commit();
        }
        return i2;
    }

    public void reloadUserGroups(ArrayList groupList) throws Exception {
        EntityTransaction tx = null;
        try {
            tx = this.em.getTransaction();
            if (tx.getRollbackOnly()) {
                tx.rollback();
            }
            if (!tx.isActive()) {
                tx.begin();
            }
            List result = this.em.createNamedQuery("queryAllUserGroup").getResultList();
            for (UserGroupBase ugroup : result) {
                FMUser fUser;
                String userName;
                GroupBase g = null;
                for (int i = 0; groupList != null && i < groupList.size(); ++i) {
                    GroupBase gp = (GroupBase)groupList.get(i);
                    if (ugroup.getGroup_id() != gp.getDBID()) continue;
                    g = gp;
                    break;
                }
                String string = userName = (fUser = DCNMUserImpl.loadFromDB(ugroup.getUser_id())) == null ? null : fUser.getUserName();
                if (fUser == null || g == null) continue;
                GroupManager.getInstance().addGroup(userName, g.getGroupPK(), false);
            }
            tx.commit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
            throw ex;
        }
        finally {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
    }

    public void persist(FabricPK fabricPK) throws Exception {
        if (fabricPK == null) {
            return;
        }
        long fabricId = this.getFabricId(fabricPK);
        if (fabricId == 0L) {
            return;
        }
        Connection con = null;
        try {
            con = ConnectionManager.getConnection();
            con.setAutoCommit(false);
            GroupBase[] groups = GroupManager.getInstance().getGroups(fabricPK);
            if (groups != null && groups.length > 0) {
                this.persistGroups(groups, con, fabricId);
                this.persistGroupMembers(groups, con);
            }
            con.commit();
        }
        catch (Exception ex) {
            con.rollback();
            ex.printStackTrace();
            _Logger.log((Priority)Level.WARN, (Object)"persist", (Throwable)ex);
            throw ex;
        }
        finally {
            DbUtil.close(con);
        }
    }

    private void persistGroups(GroupBase[] groups, Connection con, long fabricId) throws Exception {
        if (groups == null || con == null || groups.length == 0) {
            return;
        }
        EntityTransaction tx = null;
        try {
            tx = this.em.getTransaction();
            if (tx.getRollbackOnly()) {
                tx.rollback();
            }
            if (!tx.isActive()) {
                tx.begin();
            }
            for (int i = 0; i < groups.length; ++i) {
                Query query = this.em.createNamedQuery("queryGroup");
                query.setParameter("fid", (Object)fabricId);
                query.setParameter("name", (Object)groups[i].getGroupPK().getName());
                GroupBase g = null;
                try {
                    g = (GroupBase)query.getSingleResult();
                }
                catch (NoResultException re) {
                    _Logger.debug((Object)re.getMessage());
                }
                try {
                    groups[i].setFabricId(fabricId);
                    if (g == null) {
                        if (groups[i].getDBID() == 0L) {
                            groups[i].setDBID(Sequence.getSequence().getPK());
                        }
                        this.em.persist((Object)groups[i]);
                        continue;
                    }
                    g.copy(groups[i]);
                    if (groups[i].getDBID() == 0L) {
                        groups[i].setDBID(g.getDBID());
                    }
                    this.em.merge((Object)g);
                    continue;
                }
                catch (RollbackException rex) {
                    BatchUpdateException be = (BatchUpdateException)((ConstraintViolationException)rex.getCause()).getCause();
                    SQLException ex = be.getNextException();
                    _Logger.log((Priority)Level.WARN, (Object)("persistGroups: " + ex.getMessage()));
                    ex.printStackTrace();
                    throw ex;
                }
            }
            tx.commit();
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
    }

    public void persistUserGroups(GroupBase[] groups, String user) throws Exception {
        if (groups == null || user == null) {
            return;
        }
        Connection con = null;
        try {
            con = ConnectionManager.getConnection();
            con.setAutoCommit(false);
            this.persistUserGroups(groups, user, con);
            con.commit();
        }
        catch (Exception ex) {
            if (con != null) {
                con.rollback();
            }
            _Logger.log((Priority)Level.WARN, (Object)"persist", (Throwable)ex);
            throw ex;
        }
        finally {
            DbUtil.close(con);
        }
    }

    private void persistUserGroups(GroupBase[] groups, String user, Connection con) throws Exception {
        if (groups == null || con == null || groups.length == 0 || user == null) {
            return;
        }
        FMUser fUser = DCNMUserImpl.loadFromDB(user);
        long userId = -1L;
        if (fUser != null) {
            userId = fUser.getUserId();
        }
        EntityTransaction tx = null;
        try {
            tx = this.em.getTransaction();
            if (tx.getRollbackOnly()) {
                tx.rollback();
            }
            if (!tx.isActive()) {
                tx.begin();
            }
            for (int i = 0; i < groups.length; ++i) {
                UserGroupBase g = null;
                try {
                    UserGroupPK key = new UserGroupPK(userId, groups[i].getDBID());
                    g = (UserGroupBase)this.em.find(UserGroupBase.class, (Object)key);
                }
                catch (NoResultException re) {
                    _Logger.debug((Object)re.getMessage());
                }
                try {
                    if (g == null) {
                        g = new UserGroupBase();
                        g.setUser_id(userId);
                        g.setGroup_id(groups[i].getDBID());
                        this.em.persist((Object)g);
                        continue;
                    }
                    g.copy(new UserGroupBase(userId, groups[i].getDBID()));
                    this.em.merge((Object)g);
                    continue;
                }
                catch (RollbackException rex) {
                    BatchUpdateException be = (BatchUpdateException)((ConstraintViolationException)rex.getCause()).getCause();
                    SQLException ex = be.getNextException();
                    _Logger.log((Priority)Level.WARN, (Object)("persistGroups: " + ex.getMessage()));
                    ex.printStackTrace();
                    throw ex;
                }
            }
            tx.commit();
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
    }

    private void persistGroupMembers(GroupBase[] groups, Connection con) throws Exception {
        if (groups == null || con == null || groups.length == 0) {
            return;
        }
        PreparedStatement bySwitchWwnStat = null;
        PreparedStatement byEndPortWwnStat = null;
        PreparedStatement switchMemberStat = null;
        PreparedStatement endPortMemberStat = null;
        PreparedStatement cleanMemberStat = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            bySwitchWwnStat = con.prepareStatement(this._queryMemberIdBySwitchWwnSQL);
            byEndPortWwnStat = con.prepareStatement(this._queryMemberIdByEndPortWwnSQL);
            switchMemberStat = con.prepareStatement(this._querySwitchMemberIdSQL);
            endPortMemberStat = con.prepareStatement(this._queryEndPortMemberIdSQL);
            cleanMemberStat = con.prepareStatement(this._cleanMemberSQL);
            for (int i = 0; i < groups.length; ++i) {
                ArrayList<PKIf> members = groups[i].getMembers();
                long groupId = groups[i].getDBID();
                EntityTransaction tx = this.em.getTransaction();
                if (tx.getRollbackOnly()) {
                    tx.rollback();
                }
                if (!tx.isActive()) {
                    tx.begin();
                }
                List list = this.em.createQuery("from GroupMemberBase m where m.key.group_id = " + groupId).getResultList();
                for (GroupMemberBase delM : list) {
                    this.em.remove((Object)delM);
                }
                tx.commit();
                tx = this.em.getTransaction();
                if (!tx.isActive()) {
                    tx.begin();
                }
                if (members != null && members.size() > 0) {
                    short type = groups[i].getType();
                    for (int j = 0; j < members.size(); ++j) {
                        GroupMemberBase member;
                        GroupMemberPK key;
                        PKIf memberPK = members.get(j);
                        if (!(memberPK instanceof WwnKey)) continue;
                        WwnKey wwnKey = (WwnKey)memberPK;
                        long memberId = 0L;
                        if (type == 1) {
                            stat = bySwitchWwnStat;
                            stat.setBytes(1, wwnKey._wwn.getValue());
                            stat.setLong(2, groupId);
                        } else {
                            stat = byEndPortWwnStat;
                            stat.setBytes(1, wwnKey._wwn.getValue());
                            stat.setLong(2, groupId);
                        }
                        rs = stat.executeQuery();
                        if (rs.next()) {
                            memberId = rs.getLong(1);
                        }
                        DbUtil.close(rs);
                        if (memberId != 0L) {
                            key = new GroupMemberPK(groupId, memberId);
                            GroupMemberBase member2 = (GroupMemberBase)this.em.find(GroupMemberBase.class, (Object)key);
                            if (member2 != null) {
                                member2.setType(type);
                                this.em.merge((Object)member2);
                                continue;
                            }
                            member2 = new GroupMemberBase();
                            member2.setMember_id(memberId);
                            member2.setGroup_id(groupId);
                            member2.setType(type);
                            this.em.persist((Object)member2);
                            continue;
                        }
                        if (type == 1) {
                            stat = switchMemberStat;
                            stat.setBytes(1, wwnKey._wwn.getValue());
                        } else {
                            stat = endPortMemberStat;
                            stat.setBytes(1, wwnKey._wwn.getValue());
                        }
                        rs = stat.executeQuery();
                        if (rs.next()) {
                            memberId = rs.getLong(1);
                        }
                        DbUtil.close(rs);
                        if (memberId == 0L) continue;
                        key = new GroupMemberPK(groupId, memberId);
                        Object rObj = this.em.find(GroupMemberBase.class, (Object)key);
                        GroupMemberBase groupMemberBase = member = rObj == null ? null : (GroupMemberBase)rObj;
                        if (member != null) {
                            member.setType(type);
                            this.em.merge((Object)member);
                            continue;
                        }
                        member = new GroupMemberBase();
                        member.setMember_id(memberId);
                        member.setGroup_id(groupId);
                        member.setType(type);
                        this.em.persist((Object)member);
                    }
                }
                tx.commit();
            }
        }
        catch (Exception ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(bySwitchWwnStat);
                DbUtil.close(byEndPortWwnStat);
                DbUtil.close(switchMemberStat);
                DbUtil.close(endPortMemberStat);
                DbUtil.close(cleanMemberStat);
                if (this.em.getTransaction().isActive()) {
                    this.em.getTransaction().rollback();
                }
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(bySwitchWwnStat);
        DbUtil.close(byEndPortWwnStat);
        DbUtil.close(switchMemberStat);
        DbUtil.close(endPortMemberStat);
        DbUtil.close(cleanMemberStat);
        if (this.em.getTransaction().isActive()) {
            this.em.getTransaction().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPreexistRecord(GroupBase group, Connection con, long fabricId) throws Exception {
        block7: {
            if (group == null || fabricId == 0L) {
                return;
            }
            PreparedStatement stat = null;
            ResultSet rs = null;
            try {
                stat = con.prepareStatement(this.QuerySQLByNameFabricId);
                stat.setLong(1, fabricId);
                stat.setString(2, group.getGroupPK().getName());
                rs = stat.executeQuery();
                if (rs.next()) {
                    group.setDBID(rs.getLong(1));
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                break block7;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
    }

    public void purge(GroupBase group) throws Exception {
        if (group == null || group.getDBID() == 0L) {
            return;
        }
        this.purge(new GroupBase[]{group});
    }

    public void purge(GroupBase[] groups) throws Exception {
        if (groups == null || groups.length == 0) {
            return;
        }
        EntityTransaction tx = null;
        try {
            tx = this.em.getTransaction();
            if (tx.getRollbackOnly()) {
                tx.rollback();
            }
            if (!tx.isActive()) {
                tx.begin();
            }
            for (int i = 0; i < groups.length; ++i) {
                if (groups[i].getDBID() == 0L) continue;
                GroupBase grp = (GroupBase)this.em.find(GroupBase.class, (Object)groups[i].getDBID());
                if (grp != null) {
                    this.em.merge((Object)grp);
                    this.em.remove((Object)grp);
                }
                List members = this.em.createQuery("Select m from " + GroupMemberBase.class.getName() + " m where group_id=" + groups[i].getDBID()).getResultList();
                for (GroupMemberBase member : members) {
                    this.em.merge((Object)member);
                    this.em.remove((Object)member);
                }
            }
            tx.commit();
        }
        catch (Exception ex) {
            _Logger.log((Priority)Level.WARN, (Object)"purge groups:", (Throwable)ex);
            throw ex;
        }
        finally {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
    }

    public void purge(String user) throws Exception {
        if (user == null) {
            return;
        }
        EntityTransaction tx = null;
        try {
            FMUser fUser = DCNMUserImpl.loadFromDB(user);
            long userId = -1L;
            if (fUser != null) {
                userId = fUser.getUserId();
            }
            if ((tx = this.em.getTransaction()).getRollbackOnly()) {
                tx.rollback();
            }
            if (!tx.isActive()) {
                tx.begin();
            }
            List members = this.em.createQuery("from UserGroupBase m where m.key.fmuser_id=" + userId).getResultList();
            for (UserGroupBase member : members) {
                this.em.merge((Object)member);
                this.em.remove((Object)member);
            }
            tx.commit();
        }
        catch (Exception ex) {
            _Logger.log((Priority)Level.WARN, (Object)"purge user groups:", (Throwable)ex);
            throw ex;
        }
        finally {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
    }

    public void purge(String user, GroupBase[] groups) throws Exception {
        if (user == null || groups == null) {
            return;
        }
        EntityTransaction tx = null;
        try {
            FMUser fUser = DCNMUserImpl.loadFromDB(user);
            long userId = -1L;
            if (fUser != null) {
                userId = fUser.getUserId();
            }
            if ((tx = this.em.getTransaction()).getRollbackOnly()) {
                tx.rollback();
            }
            if (!tx.isActive()) {
                tx.begin();
            }
            for (int i = 0; i < groups.length; ++i) {
                UserGroupBase member = (UserGroupBase)this.em.createQuery("from UserGroupBase m where m.key.fmuser_id=" + userId + " and m.key.group_id=" + groups[i].getDBID()).getSingleResult();
                this.em.merge((Object)member);
                this.em.remove((Object)member);
            }
            tx.commit();
        }
        catch (Exception ex) {
            _Logger.log((Priority)Level.WARN, (Object)"purge user groups:", (Throwable)ex);
            throw ex;
        }
        finally {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
    }

    private long getFabricId(FabricPK fabricPK) {
        if (fabricPK == null) {
            return 0L;
        }
        FabricImpl fabric = SanManager.getInstance().findFabric(fabricPK);
        if (fabric == null) {
            return 0L;
        }
        return fabric.getDBID();
    }
}

