/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.discovery;

import com.cisco.dcbu.jaxws.san.wo.AdminShallowDiscoverEdgeDO;
import com.cisco.dcbu.jaxws.san.wo.AdminShallowDiscoverNodeDO;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.UcsClusterBase;
import com.cisco.dcbu.sm.common.type.PlatformType;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.discovery.CdpCacheEntry;
import com.cisco.dcbu.sm.server.discovery.CdpDiscoveryStatusEnum;
import com.cisco.dcbu.sm.server.discovery.CdpHandler;
import com.cisco.dcbu.sm.server.discovery.CdpShallowNeighbors;
import com.cisco.dcbu.sm.server.discovery.CdpSnmpAdapter;
import com.cisco.dcbu.sm.server.discovery.UcsManager;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.LanImpl;
import com.cisco.dcbu.sm.server.model.ServiceUtil;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class CdpShallow
implements CdpHandler {
    CdpDiscoveryStatusEnum status = CdpDiscoveryStatusEnum.None;
    int hopMax = 3;
    int snmptimeout = 3000;
    ExecutorService pool;
    CompletionService<CdpDiscoveryStatusEnum> ecs;
    private final Collection<CdpCacheEntry> processed = Collections.synchronizedSet(new HashSet());
    private final Collection<CdpShallowNeighbors> edges = Collections.synchronizedList(new ArrayList());
    ArrayList<Future<CdpDiscoveryStatusEnum>> futuresList = new ArrayList();
    SnmpUserOpt snmpuser;
    SnmpSession session;
    private boolean multiSeed = false;
    private Logger _Logger = Logger.getLogger((String)"fms.disc");
    static int[][] CdpCacheOids;
    public static final int CdpCache_addr_idx = 0;
    public static final int CdpCache_primMgmtAddr_idx = 1;
    public static final int CdpCache_platf_idx = 2;
    public static final int cdpCache_version_idx = 3;
    public static final int CdpCache_sysName_idx = 4;
    public static final int CdpCache_last_change_idx = 5;
    public static final int CdpCache_deviceId_idx = 6;
    public static final String[] CdpCache_MibCmds;

    public CdpShallow(SnmpUserOpt user, int maxHops, int secTimeout) {
        this.snmpuser = user;
        this.hopMax = maxHops;
        this.status = CdpDiscoveryStatusEnum.Init;
        this.pool = Executors.newFixedThreadPool(16);
        if (secTimeout < 1 || secTimeout > 60) {
            secTimeout = 5;
        }
        this.snmptimeout = secTimeout * 1000;
        this.session = SnmpSession.getInstance("udp");
        try {
            this.session.open();
        }
        catch (IOException e) {
            // empty catch block
        }
        CdpCacheOids = new int[CdpCache_MibCmds.length][];
        for (int i = 0; i < CdpCache_MibCmds.length; ++i) {
            CdpShallow.CdpCacheOids[i] = MibNode.get(CdpCache_MibCmds[i]).getOid();
        }
    }

    public CdpDiscoveryStatusEnum getStatus() {
        if (this.futuresList.isEmpty()) {
            return this.status;
        }
        boolean completed = true;
        for (Future<CdpDiscoveryStatusEnum> f : this.futuresList) {
            if (f.isDone()) continue;
            completed = false;
        }
        if (!completed) {
            return CdpDiscoveryStatusEnum.InProgress;
        }
        return CdpDiscoveryStatusEnum.Complete;
    }

    @Override
    public boolean isMultiSeed() {
        return this.multiSeed;
    }

    public void cleanup() {
        ArrayList<CdpCacheEntry> cleanList = new ArrayList<CdpCacheEntry>();
        ArrayList<CdpCacheEntry> knownList = this.getLanDeviceIds();
        for (CdpCacheEntry e : this.processed) {
            if (cleanList.contains(e)) {
                for (CdpCacheEntry m : cleanList) {
                    if (!m.equals(e)) continue;
                    if (m.getHopCount() > e.getHopCount()) {
                        m.setHopCount(e.getHopCount());
                        continue;
                    }
                    if (e.getPrimary() == null || e.getPrimary().length() <= 0) continue;
                    m.setPrimary(e.getPrimary());
                }
                continue;
            }
            if (knownList.contains(e)) {
                e.setKnown(true);
            }
            if (e.isAuth() && !e.isKnown() && e.isReachable() && e.isValid()) {
                e.setSelectable(true);
                e.setStatusReason("manageable");
            } else if (e.isKnown()) {
                e.setStatusReason("already managed");
            } else if (!e.isReachable()) {
                e.setStatusReason("timeout");
            } else if (!e.isAuth()) {
                if (e.getStatusReason() == null || e.getStatusReason().trim().equals("")) {
                    e.setStatusReason("unknown user/pass");
                }
            } else if (!e.isValid() && (e.getStatusReason() == null || e.getStatusReason().trim().equals(""))) {
                e.setStatusReason("unsupported");
            }
            cleanList.add(e);
        }
        this.processed.clear();
        for (CdpCacheEntry e : cleanList) {
            if (e.getDeviceIndex() == null || e.getDeviceIndex().length() == 0) {
                e.setDeviceIndex(e.getPrimary());
            }
            this.processed.add(e);
        }
        ArrayList<CdpShallowNeighbors> cleanEdges = new ArrayList<CdpShallowNeighbors>();
        for (CdpShallowNeighbors n : this.edges) {
            if (n.getDstId() == null || n.getDstId().length() == 0 || n.getSrcId() == null || n.getSrcId().length() == 0) continue;
            boolean foundSrc = false;
            boolean foundDst = false;
            for (CdpCacheEntry e : this.processed) {
                if (!foundDst && e.getDeviceIndex() != null && e.getDeviceIndex().equals(n.getDstId())) {
                    foundDst = true;
                }
                if (foundSrc || e.getDeviceIndex() == null || !e.getDeviceIndex().equals(n.getSrcId())) continue;
                foundSrc = true;
            }
            if (!foundSrc || !foundDst) continue;
            cleanEdges.add(n);
        }
        this.edges.clear();
        this.edges.addAll(cleanEdges);
    }

    public ArrayList<CdpCacheEntry> getNodes() {
        ArrayList<CdpCacheEntry> nodeList = new ArrayList<CdpCacheEntry>();
        for (CdpCacheEntry e : this.processed) {
            if (!e.isUsed()) continue;
            nodeList.add(e);
        }
        return nodeList;
    }

    public AdminShallowDiscoverNodeDO[] getDisplayNodes() {
        AdminShallowDiscoverNodeDO[] nodeList = new AdminShallowDiscoverNodeDO[this.processed.size()];
        Iterator<CdpCacheEntry> it = this.processed.iterator();
        int i = 0;
        while (it.hasNext()) {
            CdpCacheEntry ce = it.next();
            this._Logger.info((Object)("CDP Scan result for " + ce.toString()));
            AdminShallowDiscoverNodeDO node = new AdminShallowDiscoverNodeDO();
            node.setAuth(ce.isAuth());
            node.setDeviceIndex(ce.getDeviceIndex());
            node.setIpaddr(ce.getPrimary());
            node.setPlatform(ce.getPlatform());
            node.setReachable(ce.isReachable());
            node.setSelectable(ce.isSelectable());
            node.setKnown(ce.isKnown());
            node.setSysName(ce.getSysName());
            node.setVersion(ce.getVersion());
            node.setValid(ce.isValid());
            node.setStatusReason(ce.getStatusReason());
            if (node.getSysName() == null || node.getSysName().length() == 0) {
                node.setSysName(node.getIpaddr());
            }
            if (node.getSysName() == null || node.getSysName().length() == 0 || node.getSysName().equals("0.0.0.0")) {
                node.setSysName(node.getPlatform());
            }
            nodeList[i++] = node;
        }
        return nodeList;
    }

    public ArrayList<CdpShallowNeighbors> getEdges() {
        ArrayList<CdpShallowNeighbors> edgeList = new ArrayList<CdpShallowNeighbors>();
        for (CdpShallowNeighbors e : this.edges) {
            edgeList.add(e);
        }
        return edgeList;
    }

    public AdminShallowDiscoverEdgeDO[] getDisplayEdges() {
        AdminShallowDiscoverEdgeDO[] edgeList = new AdminShallowDiscoverEdgeDO[this.edges.size()];
        Iterator<CdpShallowNeighbors> it = this.edges.iterator();
        int i = 0;
        while (it.hasNext()) {
            CdpShallowNeighbors e = it.next();
            AdminShallowDiscoverEdgeDO edge = new AdminShallowDiscoverEdgeDO();
            edge.setSrcId(e.getSrcId());
            edge.setDstId(e.getDstId());
            edgeList[i++] = edge;
        }
        return edgeList;
    }

    public AdminShallowDiscoverEdgeDO[] getHiddenEdges() {
        ArrayList<AdminShallowDiscoverEdgeDO> hiddenList = new ArrayList<AdminShallowDiscoverEdgeDO>();
        HashMap<String, CdpCacheEntry> nodeMap = new HashMap<String, CdpCacheEntry>();
        HashSet<CdpCacheEntry> freeNodes = new HashSet<CdpCacheEntry>();
        ArrayList graphList = new ArrayList();
        freeNodes.addAll(this.processed);
        HashSet<CdpShallowNeighbors> edgeList = new HashSet<CdpShallowNeighbors>();
        edgeList.addAll(this.edges);
        for (CdpCacheEntry n : this.processed) {
            nodeMap.put(n.getDeviceIndex(), n);
        }
        for (CdpCacheEntry n : this.processed) {
            if (!freeNodes.contains(n)) continue;
            ArrayList<CdpCacheEntry> graph = new ArrayList<CdpCacheEntry>();
            graph.add(n);
            ArrayList<CdpCacheEntry> checkNodes = new ArrayList<CdpCacheEntry>();
            checkNodes.add(n);
            while (!checkNodes.isEmpty()) {
                CdpCacheEntry check = (CdpCacheEntry)checkNodes.remove(0);
                freeNodes.remove(check);
                Iterator edgeIt = edgeList.iterator();
                while (edgeIt.hasNext()) {
                    CdpShallowNeighbors edge = (CdpShallowNeighbors)edgeIt.next();
                    String partner = null;
                    if (edge.getSrcId() == check.getDeviceIndex()) {
                        partner = edge.getDstId();
                    } else if (edge.getDstId() == check.getDeviceIndex()) {
                        partner = edge.getSrcId();
                    }
                    if (partner == null) continue;
                    edgeIt.remove();
                    CdpCacheEntry pNode = (CdpCacheEntry)nodeMap.get(partner);
                    if (graph.contains(pNode)) continue;
                    checkNodes.add(pNode);
                    graph.add(pNode);
                }
            }
            graphList.add(graph);
        }
        if (graphList.size() > 1) {
            CdpCacheEntry root = (CdpCacheEntry)((ArrayList)graphList.get(0)).get(0);
            for (int i = 1; i < graphList.size(); ++i) {
                CdpCacheEntry gRoot = (CdpCacheEntry)((ArrayList)graphList.get(i)).get(0);
                AdminShallowDiscoverEdgeDO hidden = new AdminShallowDiscoverEdgeDO();
                hidden.setSrcId(root.getDeviceIndex());
                hidden.setDstId(gRoot.getDeviceIndex());
                hiddenList.add(hidden);
            }
        }
        return hiddenList.toArray(new AdminShallowDiscoverEdgeDO[hiddenList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ArrayList<CdpCacheEntry> getLanDeviceIds() {
        Connection con;
        PreparedStatement stmt;
        ArrayList<CdpCacheEntry> deviceIds;
        block10: {
            deviceIds = new ArrayList<CdpCacheEntry>();
            String sql = "SELECT GLOBAL_DEVICE_ID, IP_ADDRESS FROM ETHSWITCH";
            stmt = null;
            ResultSet rs = null;
            con = null;
            try {
                con = ConnectionManager.getConnection();
                stmt = con.prepareStatement(sql);
                rs = SQLLoader.execute(stmt);
                while (rs.next()) {
                    String devid = rs.getString(1);
                    byte[] ipAddress = rs.getBytes(2);
                    if (ipAddress == null) continue;
                    String ip = InetAddress.getByAddress(ipAddress).getHostAddress();
                    CdpCacheEntry entry = new CdpCacheEntry();
                    entry.setPrimary(ip);
                    entry.setDeviceIndex(devid);
                    deviceIds.add(entry);
                }
                if (rs == null) break block10;
            }
            catch (Exception e) {
                if (rs != null) {
                    DbUtil.close(rs);
                }
                if (stmt != null) {
                    DbUtil.close(stmt);
                }
                DbUtil.close(con);
                catch (Throwable throwable) {
                    if (rs != null) {
                        DbUtil.close(rs);
                    }
                    if (stmt != null) {
                        DbUtil.close(stmt);
                    }
                    DbUtil.close(con);
                    throw throwable;
                }
            }
            DbUtil.close(rs);
        }
        if (stmt != null) {
            DbUtil.close(stmt);
        }
        DbUtil.close(con);
        return deviceIds;
    }

    public void display() {
        System.out.println("processed size: " + this.processed.size());
        System.out.println("futures size: " + this.futuresList.size());
        for (CdpCacheEntry e : this.processed) {
            System.out.println(e.toString());
        }
        for (Future<CdpDiscoveryStatusEnum> f : this.futuresList) {
            if (f.isCancelled()) {
                System.out.println("Future cancelled");
            }
            if (!f.isDone()) continue;
            System.out.println("Future done");
            try {
                System.out.println("Future done" + f.get().toString());
            }
            catch (InterruptedException e) {
                System.out.println("Future done Interrupted...");
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                System.out.println("Future done" + e.getMessage());
                e.printStackTrace();
            }
        }
        for (CdpShallowNeighbors s : this.edges) {
            System.out.println("edge " + s.getSrcId() + " <-> " + s.getDstId());
        }
    }

    public void discover(ArrayList<String> ipList) {
        this._Logger.info((Object)("Shallow CDP Discovery initated for " + ipList));
        this.status = CdpDiscoveryStatusEnum.InProgress;
        if (ipList.size() > 1) {
            this.multiSeed = true;
        }
        if (ipList.size() == 1 && ipList.get(0).indexOf("10.10.10.") >= 0) {
            this.fakedata(ipList.get(0));
            this.status = CdpDiscoveryStatusEnum.Complete;
            return;
        }
        for (String s : ipList) {
            CdpCacheEntry e = new CdpCacheEntry();
            e.setAddr(s);
            e.setPrimary(s);
            e.setHopCount(0);
            this.addEntry(e);
        }
    }

    public void fakedata(String s) {
        int i;
        String[] sl = s.split("\\.");
        int cnt = Integer.valueOf(sl[sl.length - 1]);
        Random r = new Random();
        for (i = 0; i < cnt; ++i) {
            CdpCacheEntry e = new CdpCacheEntry();
            e.setPrimary("10.10.10." + i);
            e.setHopCount(0);
            e.setAuth(true);
            e.setDeviceIndex("DEV_ID00" + i);
            e.setKnown(false);
            e.setPlatform("N7K");
            e.setReachable(true);
            e.setSelectable(true);
            e.setSysName("CSN-" + i);
            e.setValid(true);
            e.setVersion("6.2.1");
            this.processed.add(e);
        }
        for (i = 0; i < cnt; ++i) {
            boolean found = false;
            String dev = "DEV_ID00" + i;
            for (CdpShallowNeighbors nc : this.edges) {
                if (!nc.getSrcId().equals(dev) && !nc.getDstId().equals(dev)) continue;
                found = true;
                break;
            }
            if (found) continue;
            int ncon = r.nextInt(10);
            if (ncon > 5) {
                ncon = 0;
            }
            if (ncon > 3) {
                ncon = 1;
            }
            for (int j = 0; j <= ncon; ++j) {
                int neb = r.nextInt(cnt);
                if (neb == i && --neb < 0) {
                    neb = cnt - 1;
                }
                CdpShallowNeighbors n = new CdpShallowNeighbors();
                n.setSrcId("DEV_ID00" + i);
                n.setDstId("DEV_ID00" + neb);
                if (this.edges.contains(n)) continue;
                this.edges.add(n);
            }
        }
    }

    public void interrupt() {
        this._Logger.warn((Object)"Shallow CDP Discovery interrupted");
        if (this.status.equals((Object)CdpDiscoveryStatusEnum.Complete)) {
            return;
        }
        this.status = CdpDiscoveryStatusEnum.Interrupted;
        this.pool.shutdown();
        for (Future<CdpDiscoveryStatusEnum> f : this.futuresList) {
            if (f.isDone()) continue;
            f.cancel(true);
        }
    }

    @Override
    public synchronized void addEntry(CdpCacheEntry entry) {
        if (!this.processed.contains(entry)) {
            this._Logger.info((Object)("CDP Scan received add entry for " + entry.getPrimary()));
            this.processed.add(entry);
            Future<CdpDiscoveryStatusEnum> res = this.pool.submit(new SiteScanCallable(this.snmpuser, this.session, entry, this));
            this.futuresList.add(res);
        } else {
            for (CdpCacheEntry ent : this.processed) {
                if (ent.getDeviceIndex() == null || !ent.getDeviceIndex().equals(entry.getDeviceIndex()) || entry.getPrimary() == null) continue;
                ent.setPrimary(entry.getPrimary());
            }
        }
    }

    @Override
    public void addEdge(CdpCacheEntry source, CdpCacheEntry entry) {
        CdpShallowNeighbors n = new CdpShallowNeighbors();
        n.setSrcId(source.getDeviceIndex());
        n.setDstId(entry.getDeviceIndex());
        if (this.edges.contains(n)) {
            return;
        }
        this.edges.add(n);
    }

    private boolean isAlreadyProcessed(String ipAddress) {
        this._Logger.debug((Object)("Inside isAlreadyProcessed(): " + ipAddress));
        for (CdpCacheEntry ent : this.processed) {
            this._Logger.debug((Object)("processed IP: " + ent.getPrimary()));
            if (ent.getPrimary() == null || !ent.getPrimary().equals(ipAddress)) continue;
            this._Logger.debug((Object)("Quick scan already start for the UCS switch: " + ipAddress + ". Returning true!!!"));
            return true;
        }
        return false;
    }

    private void addUCSEntry(CdpCacheEntry source, String ipAddress) {
        this._Logger.debug((Object)("Inside addUcsEntry(): " + ipAddress));
        this._Logger.debug((Object)("Source entry IP: " + source.getPrimary()));
        if (!this.isAlreadyProcessed(ipAddress)) {
            this._Logger.debug((Object)("Starting quick scan for the UCS switch: " + ipAddress));
            CdpCacheEntry e = new CdpCacheEntry();
            e.setAddr(ipAddress);
            e.setPrimary(ipAddress);
            e.setucsClusterDiscovered(true);
            e.setDeviceIndex(ipAddress);
            e.setHopCount(0);
            this.addEntry(e);
            this.addEdge(source, e);
        }
    }

    static {
        CdpCache_MibCmds = new String[]{"cdpCacheAddress", "cdpCachePrimaryMgmtAddr", "cdpCachePlatform", "cdpCacheVersion", "cdpCacheSysName", "cdpCacheLastChange", "cdpCacheDeviceId"};
    }

    public class SiteScanCallable
    implements Callable<CdpDiscoveryStatusEnum> {
        SnmpUserOpt snmpUserOpt;
        CdpCacheEntry cdpentry;
        CdpHandler cdphandler;
        SnmpSession session;
        CdpDiscoveryStatusEnum status = CdpDiscoveryStatusEnum.None;

        public SiteScanCallable(SnmpUserOpt user, SnmpSession snmpsession, CdpCacheEntry entry, CdpHandler handler) {
            this.snmpUserOpt = user;
            this.cdpentry = entry;
            this.cdphandler = handler;
            this.status = CdpDiscoveryStatusEnum.Init;
            this.session = snmpsession;
        }

        public String trim(String s) {
            if (s != null && s.startsWith("/")) {
                return s.substring(1);
            }
            return s;
        }

        @Override
        public CdpDiscoveryStatusEnum call() {
            CdpShallow.this._Logger.debug((Object)(Thread.currentThread().getId() + " starting for " + this.cdpentry.getPrimary()));
            long totalStart = System.currentTimeMillis();
            try {
                Pattern p;
                Matcher m;
                String version;
                PlatformType t;
                String model;
                SnmpVar var;
                SnmpPDU rspPdu;
                SnmpPeer peer;
                block85: {
                    String deviceId;
                    if (Thread.currentThread().isInterrupted()) {
                        return CdpDiscoveryStatusEnum.Interrupted;
                    }
                    InetAddress swIP = null;
                    if (this.cdpentry.getPrimary() != null) {
                        try {
                            swIP = InetAddress.getByName(this.cdpentry.getPrimary());
                            if (swIP.isAnyLocalAddress() || swIP.isLoopbackAddress()) {
                                swIP = null;
                            }
                            if (swIP == null) {
                                this.cdpentry.setValid(false);
                                this.cdpentry.setSelectable(false);
                                this.cdpentry.setReachable(false);
                                this.cdpentry.setAuth(false);
                            }
                        }
                        catch (UnknownHostException e) {
                            swIP = null;
                        }
                    }
                    if (swIP == null) {
                        CdpShallow.this._Logger.debug((Object)("Pruned one entry, no valid ip " + this.cdpentry.getPrimary()));
                        long totalEnd = System.currentTimeMillis();
                        long totalTime = (totalEnd - totalStart) / 1000L;
                        CdpShallow.this._Logger.trace((Object)(Thread.currentThread().getId() + " took " + totalTime + " seconds"));
                        return CdpDiscoveryStatusEnum.Complete;
                    }
                    long start = System.currentTimeMillis();
                    peer = null;
                    try {
                        if (this.snmpUserOpt.isV3()) {
                            int minPasswordLength = Integer.valueOf(System.getProperty("snmp.minPasswordLength", "8"));
                            if (this.snmpUserOpt.getPassword().length() == 0 || this.snmpUserOpt.getPassword().length() < minPasswordLength) {
                                if (minPasswordLength == 0) {
                                    ++minPasswordLength;
                                }
                                CdpShallow.this._Logger.error((Object)("The password must have at least " + minPasswordLength + " charaters"));
                                this.cdpentry.setReachable(true);
                                this.cdpentry.setAuth(false);
                                this.cdpentry.setStatusReason("password less than " + minPasswordLength + " chars");
                                return CdpDiscoveryStatusEnum.ErrorSnmpSession;
                            }
                            peer = ServiceUtil.createSnmpPeer(swIP, this.snmpUserOpt, DCManager.getInstance().getSnmpSession(), SnmpSession._PreferTcp);
                        } else {
                            Boolean v3Only = Boolean.parseBoolean(System.getProperty("snmp.v3only"));
                            if (v3Only.booleanValue()) {
                                CdpShallow.this._Logger.error((Object)"SNMPv2/1 is not supported");
                                this.cdpentry.setReachable(true);
                                this.cdpentry.setAuth(true);
                                this.cdpentry.setValid(false);
                                this.cdpentry.setStatusReason("SNMPv2/1 is not supported");
                                return CdpDiscoveryStatusEnum.ErrorSnmpSession;
                            }
                            peer = new SnmpPeer(swIP, this.snmpUserOpt.getCommunity(), null, SnmpSession.getInstance("udp"));
                        }
                        peer.setTimeout(CdpShallow.this.snmptimeout);
                        peer.setRetries(0);
                    }
                    catch (SnmpException e) {
                        if (!e.isTimeOut()) {
                            this.cdpentry.setReachable(true);
                        }
                        CdpShallow.this._Logger.debug((Object)("Finished for " + this.cdpentry.getPrimary() + " snmp exception " + e.getMessage()));
                        long totalEnd = System.currentTimeMillis();
                        long totalTime = (totalEnd - totalStart) / 1000L;
                        CdpShallow.this._Logger.trace((Object)(Thread.currentThread().getId() + " took " + totalTime + " seconds"));
                        if (peer != null) {
                            peer.close();
                        }
                        return CdpDiscoveryStatusEnum.Complete;
                    }
                    long end = System.currentTimeMillis();
                    long took = (end - start) / 1000L;
                    CdpShallow.this._Logger.debug((Object)("Peer init for " + this.cdpentry.getPrimary() + " took " + took + " seconds"));
                    this.cdpentry.setReachable(true);
                    this.cdpentry.setAuth(true);
                    if (Thread.currentThread().isInterrupted()) {
                        peer.close();
                        CdpShallow.this._Logger.info((Object)("CDP scan is interrupted for " + this.cdpentry.getAddr()));
                        return CdpDiscoveryStatusEnum.Interrupted;
                    }
                    CdpShallow.this._Logger.debug((Object)("Walking " + swIP.getHostAddress()));
                    SnmpOID[] SysVars = new SnmpOID[]{new SnmpOID(MibNode.get("sysName").getOid(), 0), new SnmpOID(MibNode.get("entPhysicalModelName").getOid(), 0), new SnmpOID(MibNode.get("cdpGlobalDeviceId").getOid(), 0), new SnmpOID(MibNode.get("sysObjectID").getOid(), 0), new SnmpOID(MibNode.get("entPhysicalSoftwareRev").getOid(), 0), new SnmpOID(MibNode.get("entPhysicalModelName").getOid(), 10), new SnmpOID(MibNode.get("entPhysicalSoftwareRev").getOid(), 22), new SnmpOID(MibNode.get("entPhysicalModelName").getOid(), 1), new SnmpOID(MibNode.get("entPhysicalModelName").getOid(), 2), new SnmpOID(MibNode.get("entPhysicalSoftwareRev").getOid(), 23), new SnmpOID(MibNode.get("entPhysicalSoftwareRev").getOid(), 30), new SnmpOID(MibNode.get("entPhysicalModelName").getOid(), 22), new SnmpOID(MibNode.get("entPhysicalSoftwareRev").getOid(), 1000), new SnmpOID(MibNode.get("entPhysicalSoftwareRev").getOid(), 25), new SnmpOID(MibNode.get("entPhysicalSoftwareRev").getOid(), 27), new SnmpOID(MibNode.get("entPhysicalSoftwareRev").getOid(), 31), new SnmpOID(MibNode.get("entPhysicalSoftwareRev").getOid(), 24)};
                    SnmpPDU reqPdu = new SnmpPDU(-96, new VarBindList(17));
                    reqPdu.setTimeout(CdpShallow.this.snmptimeout);
                    reqPdu.setRetries(0);
                    reqPdu.setResourceUnavailableRetries(0);
                    reqPdu.addNull(SysVars[0]);
                    reqPdu.addNull(SysVars[1]);
                    reqPdu.addNull(SysVars[2]);
                    reqPdu.addNull(SysVars[3]);
                    reqPdu.addNull(SysVars[4]);
                    reqPdu.addNull(SysVars[5]);
                    reqPdu.addNull(SysVars[6]);
                    reqPdu.addNull(SysVars[7]);
                    reqPdu.addNull(SysVars[8]);
                    reqPdu.addNull(SysVars[9]);
                    reqPdu.addNull(SysVars[10]);
                    reqPdu.addNull(SysVars[11]);
                    reqPdu.addNull(SysVars[12]);
                    reqPdu.addNull(SysVars[13]);
                    reqPdu.addNull(SysVars[14]);
                    reqPdu.addNull(SysVars[15]);
                    reqPdu.addNull(SysVars[16]);
                    peer.setTimeout(CdpShallow.this.snmptimeout);
                    rspPdu = peer.send(reqPdu);
                    var = rspPdu.getVar(0);
                    String sysName = var.toString();
                    if (sysName != null && sysName.length() > 0) {
                        this.cdpentry.setSysName(sysName);
                    }
                    if ((model = (var = rspPdu.getVar(1)).toString()) != null && model.length() > 0 && !model.equals("n/a")) {
                        this.cdpentry.setPlatform(model);
                    }
                    if ((t = CdpSnmpAdapter.getPlatformType(peer)) != null) {
                        boolean valid = LanImpl.isAllowedCdpDevice(t);
                        this.cdpentry.setValid(valid);
                        if (PlatformType.isCATSwitch(t)) {
                            var = rspPdu.getVar(7);
                            model = var.toString();
                            if (model != null && model.length() > 0 && !model.equals("n/a")) {
                                this.cdpentry.setPlatform(model);
                                CdpShallow.this._Logger.debug((Object)("platform " + this.cdpentry.getPlatform()));
                            } else {
                                var = rspPdu.getVar(8);
                                model = var.toString();
                                if (model != null && model.length() > 0 && !model.equals("n/a")) {
                                    this.cdpentry.setPlatform(model);
                                    CdpShallow.this._Logger.debug((Object)("platform " + this.cdpentry.getPlatform()));
                                }
                            }
                        }
                    }
                    if ((deviceId = (var = rspPdu.getVar(2)).toString()) != null && deviceId.length() > 0) {
                        List<String> values = CdpSnmpAdapter.serialNumMap.get(peer.getAddress().getHostAddress());
                        if (values != null) {
                            this.cdpentry.setDeviceIndex(values.get(0));
                        } else {
                            this.cdpentry.setDeviceIndex(deviceId);
                        }
                    }
                    if (PlatformType.isUCS(t) && this.snmpUserOpt.isV3() && Boolean.parseBoolean(System.getProperty("cdp.discoverUcsClusterInfo", "true"))) {
                        try {
                            if (!this.cdpentry.isUcsClusterDiscovered()) {
                                long startTime = System.currentTimeMillis();
                                UcsClusterBase ucsCluster = UcsManager.getInstance().getUcsCluster(this.cdpentry.getPrimary(), this.snmpUserOpt.getUsername(), this.snmpUserOpt.getPassword());
                                long endTime = System.currentTimeMillis();
                                long totalTime = (endTime - startTime) / 1000L;
                                CdpShallow.this._Logger.debug((Object)("ucsCluster took " + totalTime + " seconds"));
                                if (ucsCluster.isCluster()) {
                                    if (this.cdpentry.getPrimary().equals(ucsCluster.getClusterAddress()) || this.cdpentry.getPrimary().equals(ucsCluster.getPrimaryIp())) {
                                        CdpShallow.this.addUCSEntry(this.cdpentry, ucsCluster.getSecondaryIp());
                                    } else {
                                        CdpShallow.this.addUCSEntry(this.cdpentry, ucsCluster.getPrimaryIp());
                                    }
                                }
                                break block85;
                            }
                            for (CdpShallowNeighbors n : CdpShallow.this.edges) {
                                if (n.getDstId() == null || !n.getDstId().equals(this.cdpentry.getPrimary())) continue;
                                n.setDstId(this.cdpentry.getDeviceIndex());
                                break;
                            }
                        }
                        catch (Exception e1) {
                            CdpShallow.this._Logger.error((Object)("Unable to get UCS cluster infor for the IP: " + this.cdpentry.getPrimary() + " " + e1.getMessage()));
                        }
                    }
                }
                if ((version = (var = rspPdu.getVar(4)).toString()) != null && version.length() > 0 && version != null && version.indexOf("Version") >= 0 && (m = (p = Pattern.compile("Version (\\S+)")).matcher(version)).find()) {
                    version = m.group(1);
                    this.cdpentry.setVersion(version);
                }
                if (t != null && t == PlatformType.N1KV && (this.cdpentry.getPlatform() == null || this.cdpentry.getPlatform().length() == 0)) {
                    var = rspPdu.getVar(11);
                    model = var.toString();
                    if (model != null && model.length() > 0 && !model.equals("n/a")) {
                        this.cdpentry.setPlatform(model);
                        CdpShallow.this._Logger.debug((Object)("platform " + this.cdpentry.getPlatform()));
                    }
                } else {
                    var = rspPdu.getVar(5);
                    model = var.toString();
                    if (model != null && model.length() > 0 && !model.equals("n/a")) {
                        this.cdpentry.setPlatform(model);
                        CdpShallow.this._Logger.debug((Object)("platform " + this.cdpentry.getPlatform()));
                    }
                }
                if (t != null && (this.cdpentry.getPlatform() == null || this.cdpentry.getPlatform().length() == 0)) {
                    this.cdpentry.setPlatform(t.getDeviceKey());
                    CdpShallow.this._Logger.debug((Object)("platform " + this.cdpentry.getPlatform()));
                }
                if (this.cdpentry.getVersion() == null && (version = (var = rspPdu.getVar(6)).toString()) != null && version.length() > 0 && !version.equals("n/a")) {
                    this.cdpentry.setVersion(version);
                }
                if (this.cdpentry.getVersion() == null && (version = (var = rspPdu.getVar(9)).toString()) != null && version.length() > 0 && !version.equals("n/a")) {
                    this.cdpentry.setVersion(version);
                }
                if (this.cdpentry.getVersion() == null && (version = (var = rspPdu.getVar(10)).toString()) != null && version.length() > 0 && !version.equals("n/a")) {
                    this.cdpentry.setVersion(version);
                }
                if (this.cdpentry.getVersion() == null && (version = (var = rspPdu.getVar(12)).toString()) != null && version.length() > 0 && !version.equals("n/a")) {
                    this.cdpentry.setVersion(version);
                }
                if (this.cdpentry.getVersion() == null && (version = (var = rspPdu.getVar(13)).toString()) != null && version.length() > 0 && !version.equals("n/a")) {
                    this.cdpentry.setVersion(version);
                }
                if (this.cdpentry.getVersion() == null && (version = (var = rspPdu.getVar(14)).toString()) != null && version.length() > 0 && !version.equals("n/a")) {
                    this.cdpentry.setVersion(version);
                }
                if (this.cdpentry.getVersion() == null && (version = (var = rspPdu.getVar(15)).toString()) != null && version.length() > 0 && !version.equals("n/a")) {
                    this.cdpentry.setVersion(version);
                }
                if (this.cdpentry.getVersion() == null && (version = (var = rspPdu.getVar(16)).toString()) != null && version.length() > 0 && !version.equals("n/a")) {
                    this.cdpentry.setVersion(version);
                }
                if (!this.cdphandler.isMultiSeed() && this.cdpentry.getHopCount() >= CdpShallow.this.hopMax) {
                    CdpShallow.this._Logger.debug((Object)("Reached Max hops, not exploring for " + this.cdpentry.getPrimary()));
                    long totalEnd = System.currentTimeMillis();
                    long totalTime = (totalEnd - totalStart) / 1000L;
                    CdpShallow.this._Logger.trace((Object)(Thread.currentThread().getId() + " took " + totalTime + " seconds"));
                    peer.close();
                    return CdpDiscoveryStatusEnum.Complete;
                }
                CdpShallow.this._Logger.debug((Object)"Entry self discovery finsihed");
                VarBindList vbl = new VarBindList(CdpCacheOids.length);
                for (int i = 0; i < CdpCacheOids.length; ++i) {
                    vbl.add(CdpCacheOids[i]);
                }
                peer.setTimeout(CdpShallow.this.snmptimeout);
                rspPdu = SnmpFetch.getBulk(peer, vbl);
                vbl = rspPdu.getVariables();
                if (vbl.size() < CdpCacheOids.length) {
                    CdpShallow.this._Logger.debug((Object)("Seems incomplete... the resp length only " + vbl.size()));
                }
                this.status = CdpDiscoveryStatusEnum.InProgress;
                int colSize = CdpCacheOids.length;
                int i = 0;
                while (i < vbl.size()) {
                    int[] oidF = vbl.getVb(i).getOid().getValue();
                    CdpCacheEntry cce = new CdpCacheEntry();
                    cce.setHopCount(this.cdpentry.getHopCount() + 1);
                    if (Thread.currentThread().isInterrupted()) {
                        peer.close();
                        CdpShallow.this._Logger.info((Object)("CDP scan is interrupted for " + this.cdpentry.getAddr()));
                        return CdpDiscoveryStatusEnum.Interrupted;
                    }
                    for (int col = 0; col < colSize; ++col) {
                        byte[] addrBytes;
                        InetAddress addr;
                        int[] oid = vbl.getVb(i).getOid().getValue();
                        MibNode node = MibNode.oidToNode(oid);
                        if (MibNode.equals(node.getOid(), MibNode.get(CdpCache_MibCmds[col]).getOid()) != 0) {
                            ++i;
                            continue;
                        }
                        if (oid[oid.length - 2] != oidF[oidF.length - 2] || oid[oid.length - 1] != oidF[oidF.length - 1]) {
                            ++i;
                            continue;
                        }
                        if (col == 0) {
                            addr = null;
                            addrBytes = null;
                            try {
                                addrBytes = vbl.byteValue(i++);
                                if (addrBytes != null && addrBytes.length > 0) {
                                    addr = InetAddress.getByAddress(addrBytes);
                                }
                                cce.setAddr(addr.getHostAddress());
                            }
                            catch (Throwable e) {
                                CdpShallow.this._Logger.warn((Object)("Invalid cdp cached address: " + Arrays.toString(addrBytes)));
                            }
                            continue;
                        }
                        if (col == 1) {
                            addr = null;
                            addrBytes = null;
                            try {
                                addrBytes = vbl.byteValue(i++);
                                if (addrBytes == null || addrBytes.length != 4 && addrBytes.length != 16) continue;
                                addr = InetAddress.getByAddress(addrBytes);
                                if (col != 1) continue;
                                cce.setPrimary(addr.getHostAddress());
                            }
                            catch (Throwable e) {
                                CdpShallow.this._Logger.warn((Object)("Invalid cdp cached primary address: " + Arrays.toString(addrBytes)));
                            }
                            continue;
                        }
                        try {
                            Pattern p2;
                            Matcher m2;
                            String s = vbl.stringValue(i++);
                            if (col == 2) {
                                cce.setPlatform(s);
                                continue;
                            }
                            if (col == 4) {
                                cce.setSysName(s);
                                continue;
                            }
                            if (col == 5) {
                                cce.setLastChange(s);
                                continue;
                            }
                            if (col == 6) {
                                List<String> values = CdpSnmpAdapter.serialNumMap.get(peer.getAddress().getHostAddress());
                                if (values != null) {
                                    cce.setDeviceIndex(values.get(0));
                                    continue;
                                }
                                cce.setDeviceIndex(s);
                                continue;
                            }
                            if (col != 3) continue;
                            if (s != null && s.indexOf("Version") >= 0 && (m2 = (p2 = Pattern.compile("Version (\\S+)")).matcher(s)).find()) {
                                s = m2.group(1);
                            }
                            cce.setVersion(s);
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (cce.getPrimary() == null && cce.getAddr() != null) {
                        cce.setPrimary(cce.getAddr());
                    }
                    if (!cce.isUsed()) continue;
                    boolean exists = false;
                    for (CdpCacheEntry test : CdpShallow.this.processed) {
                        if (test.equals(this.cdpentry)) continue;
                        if (test.getDeviceIndex() == null) {
                            if (test.getPrimary() == null || cce.getPrimary() == null || !cce.getPrimary().equals(test.getPrimary())) continue;
                            test.setDeviceIndex(cce.getDeviceIndex());
                            if (test.getPlatform() == null) {
                                test.setPlatform(cce.getPlatform());
                            }
                            if (test.getVersion() == null) {
                                test.setVersion(cce.getVersion());
                            }
                            if (test.getSysName() == null) {
                                test.setSysName(cce.getSysName());
                            }
                            cce = test;
                            exists = true;
                            break;
                        }
                        if ((cce.getDeviceIndex() == null || !cce.getDeviceIndex().equals(test.getDeviceIndex())) && (cce.getPrimary() == null || test.getPrimary() == null || !cce.getPrimary().equals(test.getPrimary()))) continue;
                        if (test.getPlatform() == null) {
                            test.setPlatform(cce.getPlatform());
                        }
                        if (test.getVersion() == null) {
                            test.setVersion(cce.getVersion());
                        }
                        if (test.getSysName() == null) {
                            test.setSysName(cce.getSysName());
                        }
                        cce = test;
                        exists = true;
                        break;
                    }
                    if (!exists && this.cdpentry.getHopCount() < CdpShallow.this.hopMax) {
                        this.cdphandler.addEntry(cce);
                    }
                    this.cdphandler.addEdge(this.cdpentry, cce);
                }
                if (Thread.currentThread().isInterrupted()) {
                    peer.close();
                    CdpShallow.this._Logger.info((Object)("CDP scan is interrupted for " + this.cdpentry.getAddr()));
                    return CdpDiscoveryStatusEnum.Complete;
                }
                peer.close();
            }
            catch (SnmpException e) {
                CdpShallow.this._Logger.error((Object)e);
                this.cdpentry.setValid(false);
                this.cdpentry.setSelectable(false);
                this.cdpentry.setReachable(false);
                this.cdpentry.setAuth(false);
            }
            long totalEnd = System.currentTimeMillis();
            long totalTime = (totalEnd - totalStart) / 1000L;
            CdpShallow.this._Logger.trace((Object)(Thread.currentThread().getId() + " took " + totalTime + " seconds"));
            CdpShallow.this._Logger.debug((Object)(Thread.currentThread().getId() + " finished for " + this.cdpentry.getPrimary()));
            return CdpDiscoveryStatusEnum.Complete;
        }
    }
}

