/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.discovery;

import com.cisco.dcbu.lib.concurrent.PooledThreadExecutor;
import com.cisco.dcbu.lib.util.Schedule;
import com.cisco.dcbu.lib.util.SchedulerSingleton;
import com.cisco.dcbu.sm.common.dto.DiscoveryState;
import com.cisco.dcbu.sm.common.dto.DiscoveryType;
import com.cisco.dcbu.sm.common.event.DiscoveryEvent;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.LanPK;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.server.discovery.CdpWorker;
import com.cisco.dcbu.sm.server.discovery.DiscoveryEventListenerIf;
import com.cisco.dcbu.sm.server.discovery.DiscoveryException;
import com.cisco.dcbu.sm.server.discovery.FabricWorker;
import com.cisco.dcbu.sm.server.discovery.VsanWorker;
import com.cisco.dcbu.sm.server.inventory.InventoryManager;
import com.cisco.dcbu.sm.server.model.CdpSeedImpl;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.LanImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.model.VirtualCenterImpl;
import com.cisco.dcbu.sm.server.model.VsanImpl;
import com.cisco.dcbu.storage.discovery.StorageImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class DiscoveryManager {
    public static int MAX_WAIT = 75000;
    static Logger _Logger = LogManager.getLogger((String)"fms.disc");
    private static DiscoveryManager _Instance;
    private PooledThreadExecutor _switchPool;
    private PooledThreadExecutor _vsanPool;
    private PooledThreadExecutor _fabricPool;
    private PooledThreadExecutor _ethNodePool;
    private PooledThreadExecutor _cdpPool;
    private PooledThreadExecutor _viPool;
    private PooledThreadExecutor _dcPool;
    private PooledThreadExecutor _vHostPool;
    private PooledThreadExecutor _storagePool;
    private ArrayList<DiscoveryEventListenerIf> _listeners = new ArrayList();

    public static DiscoveryManager getInstance() {
        if (_Instance == null) {
            _Instance = new DiscoveryManager();
        }
        MAX_WAIT = Integer.getInteger("fabric.discovery.worker.timeout", 75) * 1000;
        return _Instance;
    }

    private DiscoveryManager() {
        this._switchPool = new PooledThreadExecutor("SwitchWorkerPool", 3, Short.MAX_VALUE, 30000L);
        int maxVsan = Integer.getInteger("fabric.maxVsanDiscoveryPoolSize", 20);
        this._vsanPool = new PooledThreadExecutor("VsanWorkerPool", 3, maxVsan > 0 ? maxVsan : 20, 30000L);
        int max = Integer.getInteger("fabric.maxConcurrentDiscovery", 3);
        this._fabricPool = new PooledThreadExecutor("FabricWorkerPool", 1, max > 0 ? max : 3, 5000L);
        this._cdpPool = new PooledThreadExecutor("CdpWorkerPool", 1, max > 0 ? max : 3, 5000L);
        this._ethNodePool = new PooledThreadExecutor("EthNodeWorkerPool", 3, Short.MAX_VALUE, 30000L);
        this._viPool = new PooledThreadExecutor("ViWorkerPool", 1, max > 0 ? max : 3, 5000L);
        this._dcPool = new PooledThreadExecutor("DcWorkerPool", 1, max > 0 ? max : 3, 5000L);
        this._vHostPool = new PooledThreadExecutor("VHostWorkerPool", 1, max > 0 ? max : 10, 5000L);
        this._storagePool = new PooledThreadExecutor("StorageWorkerPool", 1, max > 0 ? max : 10, 5000L);
    }

    public void discoverLan(LanImpl lan, DiscoveryType type) {
        lan.getWorker().start(type);
    }

    public void discoverCdpSeed(LanImpl lan, CdpSeedImpl task, List<EthSwitchImpl> ethsws, DiscoveryType type) throws Exception {
        if (type == DiscoveryType.LAN_DEEP_ONLY) {
            lan.getWorker().startLanDeepDiscovery(task, ethsws, type);
        } else {
            _Logger.warn((Object)("discoverCdpSeed : unhandled discovery type " + (Object)((Object)type)));
        }
    }

    public void discoverFabric(FabricImpl fabric, DiscoveryType type) {
        fabric.getWorker().start(type);
    }

    public void discoverVC(VirtualCenterImpl vc, DiscoveryType type) {
        vc.getWorker().start(type);
    }

    public void discoverLun0(FabricImpl fabric) {
        InventoryManager.getInstance().poll(fabric, 256);
    }

    public void discover(FabricPK fabricPK, DiscoveryType type) throws DiscoveryException {
        FabricImpl fabric = SanManager.getInstance().findFabric(fabricPK);
        if (fabric == null) {
            throw new DiscoveryException(fabricPK + " not found");
        }
        this.discoverFabric(fabric, type);
    }

    public void discoverVsan(VsanImpl vsan) throws DiscoveryException {
        SwitchImpl seed = vsan.getSeed();
        if (seed == null) {
            seed = vsan.selectSeed();
        }
        if (seed == null) {
            throw new DiscoveryException("no manageable seed switch to discover VSAN " + vsan.getId());
        }
        HashMap<Short, VsanImpl> vsanById = new HashMap<Short, VsanImpl>(5);
        vsanById.put(vsan.getId(), vsan);
        VsanWorker worker = new VsanWorker(seed, vsanById, null, null);
        try {
            this.getVsanWorkerExecutor().execute(worker);
        }
        catch (Throwable ex) {
            _Logger.warn((Object)("executing " + worker + " failed: " + ex.getMessage()));
        }
    }

    public void discoverVsans(Collection<VsanImpl> vsans) {
        HashMap<SwitchImpl, HashMap<Short, VsanImpl>> vsansBySeed = new HashMap<SwitchImpl, HashMap<Short, VsanImpl>>();
        for (VsanImpl vsanImpl : vsans) {
            SwitchImpl seed = vsanImpl.getSeed();
            if (seed == null) {
                seed = vsanImpl.selectSeed();
            }
            if (seed == null) {
                _Logger.warn((Object)("no manageable seed switch to discover VSAN " + vsanImpl.getId()));
                continue;
            }
            vsanImpl.setSeed(seed);
            HashMap<Short, VsanImpl> vsanById = (HashMap<Short, VsanImpl>)vsansBySeed.get(seed);
            if (vsanById == null) {
                vsanById = new HashMap<Short, VsanImpl>();
                vsansBySeed.put(seed, vsanById);
            }
            vsanById.put(vsanImpl.getId(), vsanImpl);
        }
        for (Map.Entry entry : vsansBySeed.entrySet()) {
            VsanWorker worker = new VsanWorker((SwitchImpl)entry.getKey(), (Map)entry.getValue(), null, null);
            try {
                this.getVsanWorkerExecutor().execute(worker);
            }
            catch (Throwable ex) {
                _Logger.warn((Object)("executing " + worker + " failed: " + ex.getMessage()));
            }
        }
    }

    public void discoverStorage(StorageImpl storage) {
        storage.getWorker().start();
    }

    public void enablePoll(FabricPK pkey, boolean enable) throws Exception {
        FabricImpl fabric = SanManager.getInstance().findFabric(pkey);
        if (fabric != null) {
            this.enablePoll(fabric, enable);
        }
    }

    public void enablePoll(LanPK pkey, boolean enable) throws Exception {
        LanImpl lan = DCManager.getInstance().findLan(pkey);
        if (lan != null) {
            this.enablePoll(lan, enable);
        }
    }

    public void enablePoll(LanImpl lan, boolean enable) {
        lan.enablePolling(enable);
        CdpWorker worker = lan.getWorker();
        if (enable && !SchedulerSingleton.getInstance().isTaskScheduled(worker)) {
            SchedulerSingleton.getInstance().addTask(worker);
        } else if (!enable && SchedulerSingleton.getInstance().isTaskScheduled(worker)) {
            SchedulerSingleton.getInstance().removeTask(worker);
        }
    }

    public void enablePoll(FabricImpl fabric, boolean enable) {
        fabric.enablePolling(enable);
        FabricWorker worker = fabric.getWorker();
        if (enable && !SchedulerSingleton.getInstance().isTaskScheduled(worker)) {
            SchedulerSingleton.getInstance().addTask(worker);
        } else if (!enable && SchedulerSingleton.getInstance().isTaskScheduled(worker)) {
            SchedulerSingleton.getInstance().removeTask(worker);
        }
    }

    public void setPollInterval(FabricPK pkey, int interval) throws Exception {
        FabricImpl fabric = SanManager.getInstance().findFabric(pkey);
        if (fabric != null) {
            this.setPollInterval(fabric, interval);
        }
    }

    public void setPollInterval(LanPK pkey, int interval) throws Exception {
        LanImpl lan = DCManager.getInstance().findLan(pkey);
        if (lan != null) {
            this.setPollInterval(lan, interval);
        }
    }

    public void setPollInterval(LanImpl lan, int interval) {
        if (lan.setPollInterval(interval)) {
            long delay = (long)(interval *= 1000) - System.currentTimeMillis() + lan.getLastScanTime();
            delay = delay > 0L ? delay : (long)interval;
            CdpWorker worker = lan.getWorker();
            try {
                SchedulerSingleton.getInstance().setTaskSchedule(worker, new Schedule(delay, (long)interval, false));
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
        }
    }

    public void setPollInterval(FabricImpl fabric, int interval) {
        if (fabric.setPollInterval(interval)) {
            long delay = (long)(interval *= 1000) - System.currentTimeMillis() + fabric.getLastScanTime();
            delay = delay > 0L ? delay : (long)interval;
            FabricWorker worker = fabric.getWorker();
            try {
                SchedulerSingleton.getInstance().setTaskSchedule(worker, new Schedule(delay, (long)interval, false));
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
        }
    }

    public PooledThreadExecutor getSwitchWorkerExecutor() {
        return this._switchPool;
    }

    public PooledThreadExecutor getVsanWorkerExecutor() {
        return this._vsanPool;
    }

    public PooledThreadExecutor getFabricWorkerExecutor() {
        return this._fabricPool;
    }

    public PooledThreadExecutor getCdpWorkerExecutor() {
        return this._cdpPool;
    }

    public PooledThreadExecutor getEthNodeWorkerExecutor() {
        return this._ethNodePool;
    }

    public PooledThreadExecutor getViWorkerExecutor() {
        return this._viPool;
    }

    public PooledThreadExecutor getDcWorkerExecutor() {
        return this._dcPool;
    }

    public PooledThreadExecutor getVHostWorkerExecutor() {
        return this._vHostPool;
    }

    public PooledThreadExecutor getStorageWorkerExecutor() {
        return this._storagePool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DiscoveryEventListenerIf listener) {
        ArrayList<DiscoveryEventListenerIf> arrayList = this._listeners;
        synchronized (arrayList) {
            this._listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DiscoveryEventListenerIf listener) {
        ArrayList<DiscoveryEventListenerIf> arrayList = this._listeners;
        synchronized (arrayList) {
            this._listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListenersDiscovery(PKIf srcPK, DiscoveryType type, DiscoveryState state, String msg) {
        if (srcPK == null || type == null || state == null) {
            return;
        }
        DiscoveryEvent e = new DiscoveryEvent(srcPK, type, state, msg);
        ArrayList<DiscoveryEventListenerIf> arrayList = this._listeners;
        synchronized (arrayList) {
            for (DiscoveryEventListenerIf lis : this._listeners) {
                try {
                    lis.discoveryEventReceived(e);
                }
                catch (Exception ex) {
                    _Logger.log((Priority)Level.WARN, (Object)"notifyListenersDiscovery", (Throwable)ex);
                }
            }
        }
    }
}

