/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.discovery;

import com.cisco.dcbu.lib.sshexec.CliAdapterFactory;
import com.cisco.dcbu.lib.sshexec.ILldpAdapter;
import com.cisco.dcbu.sm.common.type.PlatformType;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.HostImpl;
import com.cisco.dcbu.sm.server.model.LanHostImpl;
import com.cisco.dcbu.sm.server.model.LanImpl;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.NotSupportedException;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LanHostWorker
implements Runnable {
    static Logger logger = LogManager.getLogger((String)"fms.disc");
    private static AtomicBoolean discovering = new AtomicBoolean();
    private static long startTime = 0L;
    private LanImpl lan = null;
    private List<EthSwitchImpl> switches = null;

    public LanHostWorker() {
    }

    public LanHostWorker(LanImpl lan, List<EthSwitchImpl> switches) {
        this.lan = lan;
        this.switches = switches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block21: {
            Connection con = null;
            try {
                boolean discoverEnabled = Boolean.parseBoolean(System.getProperty("cdp.discoverLanHosts", "true"));
                if (!discoverEnabled) {
                    logger.info((Object)("LAN host discovery is disabled, cdp.discoverLanHosts=" + discoverEnabled));
                    return;
                }
                if (discovering.get()) {
                    logger.info((Object)"LAN host discovery is in progress");
                    return;
                }
                discovering.set(true);
                startTime = System.currentTimeMillis();
                logger.info((Object)("start LAN host discovery at " + new Date(startTime)));
                con = ConnectionManager.getConnection();
                HostImpl.deleteOldLanHosts(con);
                if (this.switches != null) {
                    int count = 0;
                    for (EthSwitchImpl sw : this.switches) {
                        if (this.lan.findEthSwitchByDBID(sw.getDBID()) == null) continue;
                        ArrayList<LanHostImpl> neighbors = new ArrayList<LanHostImpl>();
                        Map<String, String> ipMap = null;
                        if (!PlatformType.isNexusSwitch(sw.getPlatformType())) continue;
                        try {
                            ++count;
                            ILldpAdapter adapter = null;
                            if (sw.getPeer() != null) {
                                adapter = CliAdapterFactory.getLldpAdapter(sw);
                                if (sw.getPlatformType() == PlatformType.N1K || sw.getPlatformType() == PlatformType.N1K1 || sw.getPlatformType() == PlatformType.N1KV) {
                                    neighbors.addAll(adapter.showMacAddressTableXml());
                                } else {
                                    neighbors.addAll(adapter.showMacAddressTable());
                                    neighbors.addAll(adapter.showLldpNeighborsDetail());
                                }
                                ipMap = adapter.showIpArp();
                            }
                        }
                        catch (NotSupportedException e) {
                            logger.log((Priority)Level.WARN, (Object)e.getMessage());
                        }
                        catch (Exception e) {
                            logger.log((Priority)Level.WARN, (Object)("LAN host discovery caught exception for switch '" + sw.getIpAddress() + "'"), (Throwable)e);
                        }
                        if (neighbors == null) continue;
                        ArrayList<LanHostImpl> hosts = new ArrayList<LanHostImpl>();
                        for (LanHostImpl h : neighbors) {
                            long swId;
                            String key = h.getMac() + "-" + h.getVlan();
                            if (ipMap.containsKey(key)) {
                                h.setIpAddress(ipMap.get(key));
                            }
                            if ((swId = sw.getDBID()) <= 0L) continue;
                            h.setEthSwitchId(swId);
                            hosts.add(h);
                        }
                        try {
                            LanHostImpl.persistLanHosts(con, hosts);
                            logger.log((Priority)Level.INFO, (Object)("persisted LAN hosts for switch '" + sw.getIpAddress() + "': " + hosts.size()));
                            LanHostImpl.createHostsFromLanHosts(con, sw.getDBID());
                        }
                        catch (Exception e) {
                            logger.log((Priority)Level.WARN, (Object)"LAN host discovery caught exception", (Throwable)e);
                        }
                    }
                    logger.info((Object)("finished LAN host discovery for " + count + " switches in " + (System.currentTimeMillis() - startTime) + "ms"));
                }
                discovering.set(false);
            }
            catch (Exception e) {
                logger.error((Object)"Failed LAN host discovery", (Throwable)e);
                break block21;
            }
            finally {
                discovering.set(false);
                DbUtil.close(con);
            }
            DbUtil.close(con);
        }
    }
}

