/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.discovery;

import com.cisco.dcbu.lib.jnm.SnmpBitmap;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.SyncedInt;
import com.cisco.dcbu.sm.server.discovery.DiscoveryManager;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.SpanPortImpl;
import com.cisco.dcbu.sm.server.model.SpanSessionImpl;
import com.cisco.dcbu.sm.server.model.SpanSourcePortImpl;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class SpanWorker
implements SnmpCallbackIf {
    private static final String[] SESSION_VAR = new String[]{"cspanSessionDestIfIndex", "cspanSessionOperStatus", "cspanVsanFilterVsans2k", "cspanVsanFilterVsans4k", "cspanSourcesVsans2k", "cspanSourcesVsans4k"};
    private final SyncedInt _numOutstanding;
    FabricImpl _fabric;
    Map<String, SpanPortImpl> _spanBySwitchPort;
    Map<String, SpanSessionImpl> _sessionBySwitchSessionId;
    private boolean _checkSources = false;

    public SpanWorker(FabricImpl fabric) {
        this._fabric = fabric;
        this._numOutstanding = new SyncedInt(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map discoverSpan() throws SnmpException {
        int i;
        SwitchImpl[] sw = this._fabric.getSwitches();
        this._spanBySwitchPort = Collections.synchronizedMap(new HashMap());
        this._sessionBySwitchSessionId = Collections.synchronizedMap(new HashMap());
        VarBindList vbl = new VarBindList();
        for (int i2 = 0; i2 < SESSION_VAR.length; ++i2) {
            vbl.add(MibNode.get(SESSION_VAR[i2]).getOid());
        }
        this._numOutstanding.set(0);
        Object i2 = this._numOutstanding.getLock();
        synchronized (i2) {
            for (i = 0; i < sw.length; ++i) {
                if (!sw[i].isManageable() || !sw[i].isMDS()) continue;
                try {
                    new SnmpFetch().getBulk(sw[i].createPeer(), vbl, (SnmpCallbackIf)this);
                    this._numOutstanding.increment();
                    continue;
                }
                catch (SnmpException se) {
                    // empty catch block
                }
            }
        }
        try {
            i2 = this._numOutstanding;
            synchronized (i2) {
                this._numOutstanding.wait(DiscoveryManager.MAX_WAIT);
            }
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        vbl.clear();
        vbl.add(MibNode.get("cspanSourcesRowStatus").getOid());
        this._checkSources = true;
        this._numOutstanding.set(0);
        Object ex = this._numOutstanding.getLock();
        synchronized (ex) {
            for (i = 0; i < sw.length; ++i) {
                if (!sw[i].isManageable() || !sw[i].isMDS()) continue;
                try {
                    new SnmpFetch().getBulk(sw[i].createPeer(), vbl, (SnmpCallbackIf)this);
                    this._numOutstanding.increment();
                    continue;
                }
                catch (SnmpException se) {
                    // empty catch block
                }
            }
        }
        try {
            ex = this._numOutstanding;
            synchronized (ex) {
                this._numOutstanding.wait(DiscoveryManager.MAX_WAIT);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this._spanBySwitchPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        if (timedOut) {
            System.err.println("SpanWorker " + pdu.getHostAddress() + " timed out");
        } else {
            SwitchImpl sw = this._fabric.findSwitch(pdu.getAddress());
            if (sw == null) {
                System.err.println("SpanWorker " + pdu.getHostAddress() + " unknown ipAddr");
            } else {
                VarBindList vbl = pdu.getVariables();
                if (this._checkSources) {
                    for (int i = 0; i < vbl.size(); ++i) {
                        SnmpVarBind vb = vbl.getVb(i);
                        int[] oid = vb.getOid().getValue();
                        int sessionId = oid[oid.length - 3];
                        int sourceIfIndex = oid[oid.length - 2];
                        int sourceIfIndexDirection = oid[oid.length - 1];
                        SpanSessionImpl ss = this._sessionBySwitchSessionId.get(sw.toString() + new Integer(sessionId));
                        if (ss == null) continue;
                        SpanSourcePortImpl ssp = new SpanSourcePortImpl(sourceIfIndex, sourceIfIndexDirection, ss);
                        ss.addSpanSourcePort(ssp);
                    }
                } else {
                    for (int i = 0; i < vbl.size(); i += SESSION_VAR.length) {
                        SnmpVarBind vb = vbl.getVb(i);
                        int[] oid = vb.getOid().getValue();
                        int sessionId = oid[oid.length - 1];
                        int destIfIndex = vbl.intValue(i);
                        int operStatus = vbl.intValue(i + 1);
                        byte[] filterVsans2k = vbl.byteValue(i + 2);
                        byte[] filterVsans4k = vbl.byteValue(i + 3);
                        byte[] sourceVsans2k = vbl.byteValue(i + 4);
                        byte[] sourceVsans4k = vbl.byteValue(i + 5);
                        String vsanFilter = SnmpBitmap.toString(this.cat(filterVsans2k, filterVsans4k));
                        String vsanSource = SnmpBitmap.toString(this.cat(sourceVsans2k, sourceVsans4k));
                        if (destIfIndex == 0) continue;
                        String spHexKey = SnmpString.toHexString(sw.getWwn().getValue()) + destIfIndex;
                        SpanPortImpl sp = this._spanBySwitchPort.get(spHexKey);
                        if (sp == null) {
                            sp = new SpanPortImpl(sw, destIfIndex);
                            this._spanBySwitchPort.put(spHexKey, sp);
                        }
                        SpanSessionImpl ss = new SpanSessionImpl(sessionId, operStatus, vsanFilter, vsanSource);
                        ss.setSpanPort(sp);
                        this._sessionBySwitchSessionId.put(sw.toString() + new Integer(sessionId), ss);
                    }
                }
            }
        }
        this._numOutstanding.decrement();
        if (this._numOutstanding.get() <= 0) {
            SyncedInt syncedInt = this._numOutstanding;
            synchronized (syncedInt) {
                this._numOutstanding.notify();
            }
        }
    }

    private byte[] cat(byte[] b1, byte[] b2) {
        byte[] b = new byte[512];
        System.arraycopy(b1, 0, b, 0, b1.length);
        System.arraycopy(b2, 0, b, 255, b2.length);
        return b;
    }
}

