/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.discovery;

import com.cisco.dcbu.lib.util.CliUtil;
import com.cisco.dcbu.sm.common.model.UcsClusterBase;
import com.cisco.dcbu.sm.common.model.UcsNetworkElementBase;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class UcsUtil {
    static Logger logger = LogManager.getLogger((String)"fms.disc");

    public static List<UcsNetworkElementBase> getNetworkElements(String in) {
        if (in == null || in.length() == 0) {
            return null;
        }
        ArrayList<UcsNetworkElementBase> results = null;
        List<String> nes = CliUtil.getRecords(in, "networkElement");
        if (nes != null && !nes.isEmpty()) {
            results = new ArrayList<UcsNetworkElementBase>();
            for (String s : nes) {
                String dn = null;
                String id = null;
                String ip = null;
                String model = null;
                if (s.indexOf("dn") >= 0) {
                    dn = CliUtil.getXmlParamValue(s, "dn");
                }
                if (s.indexOf("id") >= 0) {
                    id = CliUtil.getXmlParamValue(s, "id");
                }
                if (s.indexOf("oobIfIp") >= 0) {
                    ip = CliUtil.getXmlParamValue(s, "oobIfIp");
                }
                if (s.indexOf("model") >= 0) {
                    model = CliUtil.getXmlParamValue(s, "model");
                }
                if (dn == null || dn.trim().equals("")) continue;
                UcsNetworkElementBase ne = new UcsNetworkElementBase(dn, id, ip, model);
                results.add(ne);
            }
        }
        return results;
    }

    public static UcsClusterBase getUcsCluster(String in) throws Exception {
        String temp;
        if (in == null || in.length() == 0) {
            return null;
        }
        String dn = null;
        String address = null;
        String name = null;
        boolean clusterMode = false;
        if (in.indexOf("address") >= 0) {
            address = CliUtil.getXmlParamValue(in, "address");
        }
        if (in.indexOf("dn") >= 0) {
            dn = CliUtil.getXmlParamValue(in, "dn");
        }
        if (in.indexOf("name") >= 0) {
            name = CliUtil.getXmlParamValue(in, "name");
        }
        if (in.indexOf("mode") >= 0 && (temp = CliUtil.getXmlParamValue(in, "mode")).trim().equalsIgnoreCase("cluster")) {
            clusterMode = true;
        }
        UcsClusterBase cluster = null;
        if (dn != null && !dn.trim().equals("")) {
            cluster = new UcsClusterBase(dn, address, name, clusterMode);
        }
        return cluster;
    }
}

